/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler.batch;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.sarl.lang.compiler.GeneratorConfig2;
import io.sarl.lang.compiler.IGeneratorConfigProvider2;
import io.sarl.lang.compiler.batch.CancelIndicatorProgressMonitor;
import io.sarl.lang.compiler.batch.CleaningPolicy;
import io.sarl.lang.compiler.batch.CompilerStatus;
import io.sarl.lang.compiler.batch.DefaultIssueComparator;
import io.sarl.lang.compiler.batch.ICompilatedResourceReceiver;
import io.sarl.lang.compiler.batch.IJavaBatchCompiler;
import io.sarl.lang.compiler.batch.InternalXtextLogger;
import io.sarl.lang.compiler.batch.IssueMessageFormatter;
import io.sarl.lang.compiler.batch.IssueMessageListener;
import io.sarl.lang.compiler.batch.Messages;
import io.sarl.lang.compiler.batch.OptimizationLevel;
import io.sarl.lang.compiler.batch.SarlBatchCompilerUtils;
import io.sarl.lang.extralanguage.IExtraLanguageContribution;
import io.sarl.lang.extralanguage.IExtraLanguageContributions;
import io.sarl.lang.validation.IConfigurableIssueSeveritiesProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationAdapter;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.FileProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;

public class SarlBatchCompiler {
    private static final String BINCLASS_FOLDER_PREFIX = "classes";
    private static final String STUB_FOLDER_PREFIX = "stubs";
    private static final String INTERNAL_ERROR_CODE = SarlBatchCompiler.class.getName() + ".internal_error";
    private static final Predicate<IExtraLanguageContribution> DISABLER = it -> false;
    protected Provider<ResourceSet> resourceSetProvider;
    private File outputPath;
    private File classOutputPath;
    private File tempPath;
    private CleaningPolicy cleaningPolicy = CleaningPolicy.getDefault();
    private List<File> classpath;
    private List<File> modulepath;
    private String encoding;
    private boolean writeTraceFiles = true;
    private boolean writeStorageFiles = true;
    private boolean verbose;
    private boolean enableSarlCompilation = true;
    private boolean enableJavaPostCompilation;
    private List<File> sourcePath;
    private boolean useCurrentClassLoaderAsParent;
    private URI baseUri;
    private FileProjectConfig projectConfig;
    private Map<String, OutputConfiguration> outputConfigurations;
    private ClassLoader currentClassLoader;
    private ClassLoader jvmTypesClassLoader;
    private ClassLoader annotationProcessingClassLoader;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private IGeneratorConfigProvider2 generatorConfigProvider2;
    @Inject
    private IOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    private Provider<JavaIoFileSystemAccess> javaIoFileSystemAccessProvider;
    @Inject
    private IndexedJvmTypeAccess indexedJvmTypeAccess;
    @Inject
    private IEncodingProvider.Runtime encodingProvider;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;
    @Inject
    private IStubGenerator stubGenerator;
    @Inject
    private GeneratorDelegate generator;
    @Inject
    private IConfigurableIssueSeveritiesProvider issueSeverityProvider;
    @Inject
    private IExtraLanguageContributions extraLanguageContributions;
    @Inject
    @Named(value="languageName")
    private String languageName;
    private IJavaBatchCompiler javaCompiler;
    private Logger logger;
    private IssueMessageFormatter messageFormatter;
    private Collection<IssueMessageListener> messageListeners = new LinkedList<IssueMessageListener>();
    private Collection<ICompilatedResourceReceiver> resourceReceivers = new LinkedList<ICompilatedResourceReceiver>();
    private final List<File> tempFolders = new ArrayList<File>();
    private Comparator<Issue> issueComparator = new DefaultIssueComparator();
    private GeneratorConfig currentGeneratorConfiguration;
    private GeneratorConfig2 currentGeneratorConfiguration2;
    private String enabledExtraLanguageContributions;
    private boolean reportInternalProblemsAsIssues;
    private boolean reportWarningsAsErrors;
    private OptimizationLevel optimizationLevel;

    @Inject
    public void setJavaCompiler(IJavaBatchCompiler compiler) {
        assert (compiler != null);
        this.javaCompiler = compiler;
    }

    public IJavaBatchCompiler getJavaCompiler() {
        if (this.javaCompiler == null) {
            this.javaCompiler = SarlBatchCompilerUtils.newDefaultJavaBatchCompiler();
        }
        return this.javaCompiler;
    }

    public void setOptimizationLevel(OptimizationLevel level) {
        this.optimizationLevel = level;
    }

    public OptimizationLevel getOptimizationLevel() {
        if (this.optimizationLevel == null) {
            this.optimizationLevel = OptimizationLevel.getDefault();
        }
        return this.optimizationLevel;
    }

    public void setReportInternalProblemsAsIssues(boolean reportAsIssues) {
        this.reportInternalProblemsAsIssues = reportAsIssues;
    }

    public boolean getReportInternalProblemsAsIssues() {
        return this.reportInternalProblemsAsIssues;
    }

    public void setReportWarningsAsErrors(boolean reportAsErrors) {
        this.reportWarningsAsErrors = reportAsErrors;
    }

    public boolean getReportWarningsAsErrors() {
        return this.reportWarningsAsErrors;
    }

    public void setExtraLanguageGenerators(String identifiers) {
        this.enabledExtraLanguageContributions = Strings.emptyIfNull((String)identifiers);
    }

    public String getExtraLanguageGenerators() {
        return this.enabledExtraLanguageContributions;
    }

    public void setIssueComparator(Comparator<Issue> comparator) {
        if (comparator != null) {
            this.issueComparator = comparator;
        }
    }

    public Comparator<Issue> getIssueComparator() {
        return this.issueComparator;
    }

    public boolean isJavaPostCompilationEnable() {
        return this.enableJavaPostCompilation;
    }

    public void setJavaPostCompilationEnable(boolean enable) {
        this.enableJavaPostCompilation = enable;
    }

    public boolean isSarlCompilationEnable() {
        return this.enableSarlCompilation;
    }

    public void setSarlCompilationEnable(boolean enable) {
        this.enableSarlCompilation = enable;
    }

    public IssueMessageFormatter getIssueMessageFormatter() {
        return this.messageFormatter;
    }

    public void setIssueMessageFormatter(IssueMessageFormatter formatter) {
        this.messageFormatter = formatter;
    }

    public void addIssueMessageListener(IssueMessageListener listener) {
        this.messageListeners.add(listener);
    }

    public void removeIssueMessageListener(IssueMessageListener listener) {
        this.messageListeners.remove(listener);
    }

    private void notifiesIssueMessageListeners(Severity concreteSeverity, Issue issue, URI uri, String message) {
        for (IssueMessageListener listener : this.messageListeners) {
            listener.onIssue(concreteSeverity, issue, uri, message);
        }
    }

    public void addCompiledResourceReceiver(ICompilatedResourceReceiver receiver) {
        this.resourceReceivers.add(receiver);
    }

    public void removeCompiledResourceReceiver(ICompilatedResourceReceiver receiver) {
        this.resourceReceivers.remove(receiver);
    }

    private void notifiesCompiledResourceReceiver(Resource resource) {
        for (ICompilatedResourceReceiver receiver : this.resourceReceivers) {
            receiver.receiveCompiledResource(resource);
        }
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.getClass().getName());
        }
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Inject
    public void setResourceSetProvider(Provider<ResourceSet> resourceSetProvider) {
        this.resourceSetProvider = resourceSetProvider;
    }

    private static File normalizeFile(String file) {
        return new File(new File(file).getAbsoluteFile().toURI().normalize());
    }

    public boolean isWriteTraceFiles() {
        return this.writeTraceFiles;
    }

    public void setWriteTraceFiles(boolean writeTraceFiles) {
        this.writeTraceFiles = writeTraceFiles;
    }

    @Pure
    public boolean isWriteStorageFiles() {
        return this.writeStorageFiles;
    }

    public void setWriteStorageFiles(boolean writeStorageFiles) {
        this.writeStorageFiles = writeStorageFiles;
    }

    @Pure
    public boolean isJavaCompilerVerbose() {
        return this.verbose;
    }

    public void setJavaCompilerVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Pure
    public ClassLoader getCurrentClassLoader() {
        if (this.currentClassLoader == null) {
            this.currentClassLoader = this.getClass().getClassLoader();
        }
        return this.currentClassLoader;
    }

    public void setCurrentClassLoader(ClassLoader loader) {
        this.currentClassLoader = null;
    }

    public void setUseCurrentClassLoaderAsParent(boolean useCurrentClassLoaderAsParent) {
        this.useCurrentClassLoaderAsParent = useCurrentClassLoaderAsParent;
    }

    @Pure
    public boolean isUseCurrentClassLoaderAsParent() {
        return this.useCurrentClassLoaderAsParent;
    }

    public void setBasePath(String basePath) {
        this.setBaseURI(UriUtil.createFolderURI((File)SarlBatchCompiler.normalizeFile(basePath)));
    }

    public void setBaseURI(URI basePath) {
        this.baseUri = basePath;
    }

    public void setOutputPath(File path) {
        this.outputPath = path;
    }

    public void setOutputPath(String path) {
        this.setOutputPath(SarlBatchCompiler.normalizeFile(path));
    }

    @Pure
    public File getOutputPath() {
        return this.outputPath;
    }

    @Pure
    public File getClassOutputPath() {
        return this.classOutputPath;
    }

    @Pure
    public void setClassOutputPath(File path) {
        this.classOutputPath = path;
    }

    public void setClassPath(String classpath) {
        this.classpath = new ArrayList<File>();
        for (String path : Strings.split((String)classpath, (String)File.pathSeparator)) {
            this.classpath.add(SarlBatchCompiler.normalizeFile(path));
        }
    }

    public void setClassPath(Collection<File> classpath) {
        this.classpath = new ArrayList<File>(classpath);
    }

    @Pure
    public List<File> getClassPath() {
        if (this.classpath == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.classpath);
    }

    public void setModulePath(String modulepath) {
        this.modulepath = new ArrayList<File>();
        for (String path : Strings.split((String)modulepath, (String)File.pathSeparator)) {
            this.modulepath.add(SarlBatchCompiler.normalizeFile(path));
        }
    }

    public void setModulePath(Collection<File> modulepath) {
        this.modulepath = new ArrayList<File>(modulepath);
    }

    @Pure
    public List<File> getModulePath() {
        if (this.modulepath == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.modulepath);
    }

    public void setTempDirectory(File path) {
        this.tempPath = path;
    }

    public void setTempDirectory(String path) {
        this.setTempDirectory(SarlBatchCompiler.normalizeFile(path));
    }

    @Pure
    public File getTempDirectory() {
        if (this.tempPath == null) {
            this.tempPath = this.createTempDirectory();
        }
        return this.tempPath;
    }

    protected File createTempDirectory() {
        File tmpPath = new File(System.getProperty("java.io.tmpdir"));
        int i = 0;
        File tmp = new File(tmpPath, "sarlc" + i);
        while (tmp.exists()) {
            tmp = new File(tmpPath, "sarlc" + ++i);
        }
        return tmp;
    }

    @Pure
    public CleaningPolicy getCleaningPolicy() {
        return this.cleaningPolicy;
    }

    public void setCleaningPolicy(CleaningPolicy policy) {
        this.cleaningPolicy = policy == null ? CleaningPolicy.getDefault() : policy;
    }

    @Pure
    @Deprecated(forRemoval=true, since="0.10")
    @Inline(value="getCleaningPolicy() != $1.NO_CLEANING", imported={CleaningPolicy.class})
    public boolean isDeleteTempDirectory() {
        return this.getCleaningPolicy() != CleaningPolicy.NO_CLEANING;
    }

    @Deprecated(forRemoval=true, since="0.10")
    @Inline(value="setCleaningPolicy(($1) ? $2.INTERNAL_CLEANING : $2.NO_CLEANING)", imported={CleaningPolicy.class})
    public void setDeleteTempDirectory(boolean delete) {
        this.setCleaningPolicy(delete ? CleaningPolicy.INTERNAL_CLEANING : CleaningPolicy.NO_CLEANING);
    }

    public void setFileEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Pure
    public String getFileEncoding() {
        return this.encoding;
    }

    protected GeneratorConfig getGeneratorConfig() {
        if (this.currentGeneratorConfiguration == null) {
            this.currentGeneratorConfiguration = this.generatorConfigProvider.get(null);
        }
        return this.currentGeneratorConfiguration;
    }

    protected GeneratorConfig2 getGeneratorConfig2() {
        if (this.currentGeneratorConfiguration2 == null) {
            this.currentGeneratorConfiguration2 = this.generatorConfigProvider2.get(null);
        }
        return this.currentGeneratorConfiguration2;
    }

    public void setJavaSourceVersion(String version) {
        JavaVersion javaVersion = JavaVersion.fromQualifier((String)version);
        if (javaVersion == null) {
            ArrayList qualifiers = new ArrayList();
            for (JavaVersion vers : JavaVersion.values()) {
                qualifiers.addAll(vers.getAllQualifiers());
            }
            throw new RuntimeException(MessageFormat.format(Messages.SarlBatchCompiler_0, version, Joiner.on((String)Messages.SarlBatchCompiler_1).join(qualifiers)));
        }
        this.getGeneratorConfig().setJavaSourceVersion(javaVersion);
    }

    @Pure
    public String getJavaSourceVersion() {
        return this.getGeneratorConfig().getJavaSourceVersion().getQualifier();
    }

    @Pure
    public boolean isModularProject() {
        for (File folder : this.getSourcePaths()) {
            File infoFile = new File(folder, "module-info.java");
            if (!infoFile.isFile()) continue;
            return true;
        }
        return false;
    }

    @Pure
    public boolean isGenerateExpressions() {
        return this.getGeneratorConfig().isGenerateExpressions();
    }

    public void setGenerateExpressions(boolean generateExpressions) {
        this.getGeneratorConfig().setGenerateExpressions(generateExpressions);
    }

    @Pure
    public boolean isGenerateSyntheticSuppressWarnings() {
        return this.getGeneratorConfig().isGenerateSyntheticSuppressWarnings();
    }

    public void setGenerateSyntheticSuppressWarnings(boolean generateAnnotations) {
        this.getGeneratorConfig().setGenerateSyntheticSuppressWarnings(generateAnnotations);
    }

    @Pure
    public boolean isGenerateGeneratedAnnotation() {
        return this.getGeneratorConfig().isGenerateGeneratedAnnotation();
    }

    public void setGenerateGeneratedAnnotation(boolean generateAnnotations) {
        this.getGeneratorConfig().setGenerateGeneratedAnnotation(generateAnnotations);
    }

    @Pure
    public boolean isIncludeDateInGeneratedAnnotation() {
        return this.getGeneratorConfig().isIncludeDateInGeneratedAnnotation();
    }

    public void setIncludeDateInGeneratedAnnotation(boolean includeDateInGeneratedAnnotation) {
        this.getGeneratorConfig().setIncludeDateInGeneratedAnnotation(includeDateInGeneratedAnnotation);
    }

    @Pure
    public String getGeneratedAnnotationComment() {
        return this.getGeneratorConfig().getGeneratedAnnotationComment();
    }

    public void setGeneratedAnnotationComment(String comment) {
        this.getGeneratorConfig().setGeneratedAnnotationComment(comment);
    }

    @Pure
    public boolean isGenerateInlineAnnotation() {
        return this.getGeneratorConfig2().isGenerateInlineAnnotation();
    }

    public void setGenerateInlineAnnotation(boolean generateInlineAnnotation) {
        this.getGeneratorConfig2().setGenerateInlineAnnotation(generateInlineAnnotation);
    }

    @Pure
    public boolean isUseExpressionInterpreterForInlineAnnotation() {
        return this.getGeneratorConfig2().isUseExpressionInterpreterForInlineAnnotation();
    }

    public void setUseExpressionInterpreterForInlineAnnotation(boolean generateInlineAnnotation) {
        this.getGeneratorConfig2().setUseExpressionInterpreterForInlineAnnotation(generateInlineAnnotation);
    }

    @Pure
    public boolean isGeneratePureAnnotation() {
        return this.getGeneratorConfig2().isGeneratePureAnnotation();
    }

    public void setGeneratePureAnnotation(boolean generatePureAnnotation) {
        this.getGeneratorConfig2().setGeneratePureAnnotation(generatePureAnnotation);
    }

    @Pure
    public boolean isGenerateEqualityTestFunctions() {
        return this.getGeneratorConfig2().isGenerateEqualityTestFunctions();
    }

    public void setGenerateEqualityTestFunctions(boolean generateFunctions) {
        this.getGeneratorConfig2().setGenerateEqualityTestFunctions(generateFunctions);
    }

    @Pure
    public boolean isGenerateToStringFunctions() {
        return this.getGeneratorConfig2().isGenerateToStringFunctions();
    }

    public void setGenerateToStringFunctions(boolean generateFunctions) {
        this.getGeneratorConfig2().setGenerateToStringFunctions(generateFunctions);
    }

    @Pure
    public boolean isGenerateCloneFunctions() {
        return this.getGeneratorConfig2().isGenerateCloneFunctions();
    }

    public void setGenerateCloneFunctions(boolean generateFunctions) {
        this.getGeneratorConfig2().setGenerateCloneFunctions(generateFunctions);
    }

    @Pure
    public boolean isGenerateSerialNumberFields() {
        return this.getGeneratorConfig2().isGenerateSerialNumberFields();
    }

    public void setGenerateSerialNumberFields(boolean generateFields) {
        this.getGeneratorConfig2().setGenerateSerialNumberFields(generateFields);
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = new ArrayList<File>();
        for (String path : Strings.split((String)sourcePath, (String)File.pathSeparator)) {
            this.sourcePath.add(SarlBatchCompiler.normalizeFile(path));
        }
    }

    public void setSourcePath(Collection<File> sourcePath) {
        this.sourcePath = new ArrayList<File>(sourcePath);
    }

    public void addSourcePath(String sourcePath) {
        if (!Strings.isEmpty((String)sourcePath)) {
            this.addSourcePath(SarlBatchCompiler.normalizeFile(sourcePath));
        }
    }

    public void addSourcePath(File sourcePath) {
        if (this.sourcePath == null) {
            this.sourcePath = new ArrayList<File>();
        }
        this.sourcePath.add(sourcePath);
    }

    @Pure
    public List<File> getSourcePaths() {
        if (this.sourcePath == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.sourcePath);
    }

    private List<String> getSourcePathStrings() {
        if (this.sourcePath == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(this.sourcePath.size());
        for (File input : this.sourcePath) {
            list.add(input.getAbsolutePath());
        }
        return list;
    }

    private void configureExtraLanguageGenerators() {
        String generators = this.getExtraLanguageGenerators();
        if (Strings.isEmpty((String)generators)) {
            this.extraLanguageContributions.setContributionChecker(DISABLER);
        } else {
            String[] identifiers = generators.split("\\s*" + Pattern.quote(File.pathSeparator) + "\\s*");
            this.extraLanguageContributions.setContributionChecker(it -> {
                for (String id : identifiers) {
                    if (!it.isAcceptedIdentifier(id)) continue;
                    return true;
                }
                return false;
            });
        }
    }

    private void unconfigureExtraLanguageGenerators() {
        this.extraLanguageContributions.setContributionChecker(null);
    }

    @Inline(value="compile(($1) null)", imported={IProgressMonitor.class})
    public boolean compile() {
        return this.compile((IProgressMonitor)null);
    }

    public boolean compile(CancelIndicator cancel) {
        return this.compile(cancel != null ? new CancelIndicatorProgressMonitor(cancel) : null);
    }

    /*
     * Exception decompiling
     */
    public boolean compile(IProgressMonitor progress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 34[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void finalizationStage(IProgressMonitor monitor) {
        monitor.subTask(Messages.SarlBatchCompiler_47);
        this.destroyClassLoader(this.jvmTypesClassLoader);
        this.destroyClassLoader(this.annotationProcessingClassLoader);
        switch (this.getCleaningPolicy()) {
            case FULL_CLEANING: {
                if (this.tempPath == null) break;
                this.cleanFolder(this.tempPath, null);
                break;
            }
            case NO_CLEANING: {
                break;
            }
            case INTERNAL_CLEANING: {
                monitor.subTask(Messages.SarlBatchCompiler_48);
                for (File file : this.tempFolders) {
                    this.cleanFolder(file, null);
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.tempPath = null;
        this.tempFolders.clear();
        this.unconfigureExtraLanguageGenerators();
    }

    protected void overrideXtextInternalLoggers() {
        Logger logger = this.getLogger();
        InternalXtextLogger.InternalXtextLoggerFactory factory = new InternalXtextLogger.InternalXtextLoggerFactory(logger);
        org.apache.log4j.Logger internalLogger = org.apache.log4j.Logger.getLogger((String)MessageFormat.format(Messages.SarlBatchCompiler_40, logger.getName()), (LoggerFactory)factory);
        LoggerRepositoryWrapper lr = new LoggerRepositoryWrapper(LogManager.getLoggerRepository());
        lr.registerWrapper("org.eclipse.xtext.xbase.resource.BatchLinkableResourceStorageWritable", internalLogger);
        lr.registerWrapper("org.eclipse.xtext.xbase.resource.BatchLinkableResource", internalLogger);
        lr.registerWrapper("org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider", internalLogger);
        LogManager.setRepositorySelector(() -> lr, SarlBatchCompiler.class);
    }

    protected String createIssueMessage(Severity severity, Issue issue) {
        String message;
        IssueMessageFormatter formatter = this.getIssueMessageFormatter();
        URI uriToProblem = issue.getUriToProblem();
        if (formatter != null && (message = formatter.format(severity, issue, uriToProblem)) != null) {
            return message;
        }
        if (uriToProblem != null) {
            URI resourceUri = uriToProblem.trimFragment();
            return MessageFormat.format(Messages.SarlBatchCompiler_4, severity, resourceUri.lastSegment(), resourceUri.isFile() ? resourceUri.toFileString() : "", issue.getLineNumber(), issue.getColumn(), issue.getCode(), issue.getMessage());
        }
        return MessageFormat.format(Messages.SarlBatchCompiler_5, severity, issue.getLineNumber(), issue.getColumn(), issue.getCode(), issue.getMessage());
    }

    protected boolean reportCompilationIssues(Iterable<Issue> issues) {
        boolean hasError = false;
        for (Issue issue : issues) {
            String issueMessage;
            Severity concreteSeverity;
            switch (issue.getSeverity()) {
                case ERROR: {
                    hasError = true;
                    concreteSeverity = Severity.ERROR;
                    issueMessage = this.createIssueMessage(concreteSeverity, issue);
                    this.getLogger().severe(issueMessage);
                    break;
                }
                case WARNING: {
                    if (this.getReportWarningsAsErrors()) {
                        hasError = true;
                        concreteSeverity = Severity.ERROR;
                        issueMessage = this.createIssueMessage(concreteSeverity, issue);
                        this.getLogger().severe(issueMessage);
                        break;
                    }
                    concreteSeverity = Severity.WARNING;
                    issueMessage = this.createIssueMessage(concreteSeverity, issue);
                    this.getLogger().warning(issueMessage);
                    break;
                }
                case INFO: {
                    concreteSeverity = Severity.INFO;
                    issueMessage = this.createIssueMessage(concreteSeverity, issue);
                    this.getLogger().info(issueMessage);
                    break;
                }
                default: {
                    concreteSeverity = Severity.IGNORE;
                    issueMessage = this.createIssueMessage(concreteSeverity, issue);
                }
            }
            this.notifiesIssueMessageListeners(concreteSeverity, issue, issue.getUriToProblem(), issueMessage);
        }
        return hasError;
    }

    protected void reportInternalWarning(String message) {
        this.getLogger().warning(message);
        if (this.getReportInternalProblemsAsIssues()) {
            URI uri = null;
            Issue.IssueImpl issue = new Issue.IssueImpl();
            issue.setCode(INTERNAL_ERROR_CODE);
            issue.setMessage(message);
            issue.setUriToProblem(uri);
            issue.setSeverity(Severity.WARNING);
            this.notifiesIssueMessageListeners(this.getReportWarningsAsErrors() ? Severity.ERROR : Severity.WARNING, (Issue)issue, uri, message);
        }
    }

    protected void reportInternalWarning(String message, Throwable exception) {
        this.getLogger().log(Level.WARNING, message, exception);
        if (this.getReportInternalProblemsAsIssues()) {
            URI uri = null;
            Issue.IssueImpl issue = new Issue.IssueImpl();
            issue.setCode(INTERNAL_ERROR_CODE);
            issue.setMessage(message);
            issue.setUriToProblem(uri);
            issue.setSeverity(Severity.WARNING);
            this.notifiesIssueMessageListeners(this.getReportWarningsAsErrors() ? Severity.ERROR : Severity.WARNING, (Issue)issue, uri, message);
        }
    }

    protected void reportInternalError(String message, Throwable exception) {
        this.getLogger().log(Level.SEVERE, message, exception);
        if (this.getReportInternalProblemsAsIssues()) {
            URI uri = null;
            Issue.IssueImpl issue = new Issue.IssueImpl();
            issue.setCode(INTERNAL_ERROR_CODE);
            issue.setMessage(message);
            issue.setUriToProblem(uri);
            issue.setSeverity(Severity.ERROR);
            this.notifiesIssueMessageListeners(Severity.ERROR, (Issue)issue, uri, message);
        }
    }

    protected void reportInternalError(String message, Object ... parameters) {
        String msg;
        Throwable error = null;
        if (parameters == null || parameters.length <= 0) {
            msg = message;
        } else {
            try {
                msg = MessageFormat.format(message, parameters);
            }
            catch (Throwable exception) {
                msg = message;
                error = exception;
            }
        }
        if (error != null) {
            this.getLogger().log(Level.SEVERE, msg, error);
        } else {
            this.getLogger().severe(msg);
        }
        if (this.getReportInternalProblemsAsIssues()) {
            URI uri = null;
            Issue.IssueImpl issue = new Issue.IssueImpl();
            issue.setCode(INTERNAL_ERROR_CODE);
            issue.setMessage(msg);
            issue.setUriToProblem(uri);
            issue.setSeverity(Severity.ERROR);
            this.notifiesIssueMessageListeners(Severity.ERROR, (Issue)issue, uri, message);
        }
    }

    protected void reportInternalInfo(String message, Object ... parameters) {
        this.getLogger().info(MessageFormat.format(message, parameters));
    }

    protected void generateJavaFiles(Iterable<Resource> validatedResources, IProgressMonitor progress) {
        assert (progress != null);
        progress.subTask(Messages.SarlBatchCompiler_49);
        this.getLogger().info(MessageFormat.format(Messages.SarlBatchCompiler_28, this.getOutputPath()));
        JavaIoFileSystemAccess javaIoFileSystemAccess = (JavaIoFileSystemAccess)this.javaIoFileSystemAccessProvider.get();
        javaIoFileSystemAccess.setOutputConfigurations(this.outputConfigurations);
        javaIoFileSystemAccess.setWriteTrace(this.isWriteTraceFiles());
        if (progress.isCanceled()) {
            return;
        }
        GeneratorContext context = new GeneratorContext();
        context.setCancelIndicator(() -> progress.isCanceled());
        for (Resource resource : validatedResources) {
            if (progress.isCanceled()) {
                return;
            }
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_23, resource.getURI().lastSegment()));
            }
            if (this.isWriteStorageFiles() && resource instanceof StorageAwareResource) {
                StorageAwareResource storageAwareResource = (StorageAwareResource)resource;
                storageAwareResource.getResourceStorageFacade().saveResource(storageAwareResource, (IFileSystemAccessExtension3)javaIoFileSystemAccess);
            }
            if (progress.isCanceled()) {
                return;
            }
            this.generator.generate(resource, (IFileSystemAccess2)javaIoFileSystemAccess, (IGeneratorContext)context);
            this.notifiesCompiledResourceReceiver(resource);
        }
    }

    protected void generateJvmElements(ResourceSet resourceSet, IProgressMonitor progress) {
        assert (progress != null);
        progress.subTask(Messages.SarlBatchCompiler_21);
        this.getLogger().info(Messages.SarlBatchCompiler_21);
        EList originalResources = resourceSet.getResources();
        ArrayList<Resource> toBeResolved = new ArrayList<Resource>(originalResources.size());
        for (Resource resource : originalResources) {
            if (progress.isCanceled()) {
                return;
            }
            if (!this.isSourceFile(resource)) continue;
            toBeResolved.add(resource);
        }
        for (Resource resource : toBeResolved) {
            if (progress.isCanceled()) {
                return;
            }
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_26, resource.getURI().lastSegment()));
            }
            EcoreUtil.resolveAll((Resource)resource);
            EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
        }
    }

    protected List<Issue> validate(ResourceSet resourceSet, Collection<Resource> validResources, IProgressMonitor progress) {
        assert (progress != null);
        progress.subTask(Messages.SarlBatchCompiler_38);
        this.getLogger().info(Messages.SarlBatchCompiler_38);
        LinkedList resources = new LinkedList(resourceSet.getResources());
        ArrayList<Issue> issuesToReturn = new ArrayList<Issue>();
        for (Resource resource : resources) {
            IResourceServiceProvider resourceServiceProvider;
            if (progress.isCanceled()) {
                return issuesToReturn;
            }
            if (!this.isSourceFile(resource)) continue;
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_22, resource.getURI().lastSegment()));
            }
            if ((resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(resource.getURI())) == null) continue;
            IResourceValidator resourceValidator = resourceServiceProvider.getResourceValidator();
            List result = resourceValidator.validate(resource, CheckMode.ALL, null);
            if (progress.isCanceled()) {
                return issuesToReturn;
            }
            TreeSet<Issue> issues = new TreeSet<Issue>(this.getIssueComparator());
            boolean hasValidationError = false;
            for (Issue issue : result) {
                if (progress.isCanceled()) {
                    return issuesToReturn;
                }
                if (issue.isSyntaxError() || issue.getSeverity() == Severity.ERROR) {
                    hasValidationError = true;
                }
                issues.add(issue);
            }
            if (!hasValidationError) {
                if (!issues.isEmpty()) {
                    if (this.getLogger().isLoggable(Level.FINEST)) {
                        this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_39, resource.getURI().lastSegment()));
                    }
                    issuesToReturn.addAll(issues);
                }
                validResources.add(resource);
                continue;
            }
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_39, resource.getURI().lastSegment()));
            }
            issuesToReturn.addAll(issues);
        }
        return issuesToReturn;
    }

    protected boolean isSourceFile(Resource resource) {
        if (resource instanceof BatchLinkableResource) {
            BatchLinkableResource bres = (BatchLinkableResource)resource;
            return !bres.isLoadedFromStorage();
        }
        return false;
    }

    protected CompilerStatus preCompileStubs(File sourceDirectory, File classDirectory, IProgressMonitor progress) {
        assert (progress != null);
        progress.subTask(Messages.SarlBatchCompiler_50);
        return this.runJavaCompiler(classDirectory, Collections.singletonList(sourceDirectory), this.getClassPath(), this.getModulePath(), true, false, progress);
    }

    protected CompilerStatus preCompileJava(File sourceDirectory, File classDirectory, IProgressMonitor progress) {
        assert (progress != null);
        progress.subTask(Messages.SarlBatchCompiler_51);
        Iterable cp = Iterables.concat(Collections.singleton(sourceDirectory), this.getClassPath());
        List<File> mp = Collections.emptyList();
        return this.runJavaCompiler(classDirectory, this.getSourcePaths(), cp, mp, false, false, progress);
    }

    protected CompilerStatus postCompileJava(IProgressMonitor progress) {
        assert (progress != null);
        String msg = MessageFormat.format(Messages.SarlBatchCompiler_25, this.getJavaCompiler().getName());
        progress.subTask(msg);
        this.getLogger().info(msg);
        File classOutputPath = this.getClassOutputPath();
        if (classOutputPath == null) {
            this.getLogger().info(Messages.SarlBatchCompiler_24);
            return CompilerStatus.COMPILATION_SUCCESS;
        }
        Iterable sources = Iterables.concat(this.getSourcePaths(), Collections.singleton(this.getOutputPath()));
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_29, SarlBatchCompiler.toPathString(sources)));
        }
        List<File> classpath = this.getClassPath();
        List<File> modulepath = this.getModulePath();
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_64, SarlBatchCompiler.toPathString(classpath), SarlBatchCompiler.toPathString(modulepath)));
        }
        return this.runJavaCompiler(classOutputPath, sources, classpath, modulepath, true, true, progress);
    }

    private static String toPathString(Iterable<File> files) {
        StringBuilder result = new StringBuilder();
        for (File file : files) {
            if (result.length() > 0) {
                result.append(File.pathSeparator);
            }
            result.append(file.toString());
        }
        return result.toString();
    }

    protected CompilerStatus runJavaCompiler(File classDirectory, Iterable<File> sourcePathDirectories, Iterable<File> classPathEntries, Iterable<File> modulePathEntries, boolean enableCompilerOutput, boolean enableOptimization, IProgressMonitor progress) {
        PrintWriter errWriter;
        PrintWriter outWriter;
        String encoding = this.encodingProvider.getDefaultEncoding();
        if (Strings.isEmpty((String)encoding)) {
            encoding = null;
        }
        if (progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        if (enableCompilerOutput) {
            outWriter = this.getInfoCompilerOutputWriter();
            errWriter = this.getErrorCompilerOutputWriter();
        } else {
            outWriter = this.getDebugCompilerOutputWriter();
            errWriter = this.getDebugCompilerOutputWriter();
        }
        if (progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        return this.getJavaCompiler().compile(classDirectory, sourcePathDirectories, classPathEntries, modulePathEntries, this.getJavaSourceVersion(), encoding, this.isJavaCompilerVerbose(), enableOptimization ? this.getOptimizationLevel() : null, outWriter, errWriter, this.getLogger(), progress);
    }

    private PrintWriter getDebugCompilerOutputWriter() {
        Writer debugWriter = new Writer(){

            @Override
            public void write(char[] data, int offset, int count) throws IOException {
                if (SarlBatchCompiler.this.getLogger().isLoggable(Level.FINEST)) {
                    String message = String.copyValueOf(data, offset, count);
                    SarlBatchCompiler.this.getLogger().finest(message);
                }
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        return new PrintWriter(debugWriter);
    }

    private PrintWriter getErrorCompilerOutputWriter() {
        Writer debugWriter = new Writer(){

            @Override
            public void write(char[] data, int offset, int count) throws IOException {
                String message = String.copyValueOf(data, offset, count);
                SarlBatchCompiler.this.reportInternalError(message, new Object[0]);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        return new PrintWriter(debugWriter);
    }

    private PrintWriter getInfoCompilerOutputWriter() {
        Writer debugWriter = new Writer(){

            @Override
            public void write(char[] data, int offset, int count) throws IOException {
                String message = String.copyValueOf(data, offset, count);
                SarlBatchCompiler.this.reportInternalInfo(message, new Object[0]);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        return new PrintWriter(debugWriter);
    }

    protected File createStubs(ResourceSet resourceSet, IProgressMonitor progress) {
        assert (progress != null);
        progress.subTask(Messages.SarlBatchCompiler_53);
        File outputDirectory = this.createTempDir(STUB_FOLDER_PREFIX);
        if (progress.isCanceled()) {
            return null;
        }
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_19, outputDirectory));
        }
        JavaIoFileSystemAccess fileSystemAccess = (JavaIoFileSystemAccess)this.javaIoFileSystemAccessProvider.get();
        if (progress.isCanceled()) {
            return null;
        }
        fileSystemAccess.setOutputPath(outputDirectory.toString());
        ArrayList resources = new ArrayList(resourceSet.getResources());
        for (Resource resource : resources) {
            if (progress.isCanceled()) {
                return null;
            }
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_20, resource.getURI()));
            }
            IResourceDescription description = this.resourceDescriptionManager.getResourceDescription(resource);
            this.stubGenerator.doGenerateStubs((IFileSystemAccess)fileSystemAccess, description);
        }
        return outputDirectory;
    }

    protected void loadSARLFiles(ResourceSet resourceSet, IProgressMonitor progress) {
        assert (progress != null);
        progress.subTask(Messages.SarlBatchCompiler_54);
        this.encodingProvider.setDefaultEncoding(this.getFileEncoding());
        NameBasedFilter nameBasedFilter = new NameBasedFilter();
        nameBasedFilter.setExtension(this.fileExtensionProvider.getPrimaryFileExtension());
        PathTraverser pathTraverser = new PathTraverser();
        List<String> sourcePathDirectories = this.getSourcePathStrings();
        if (progress.isCanceled()) {
            return;
        }
        Multimap pathes = pathTraverser.resolvePathes(sourcePathDirectories, input -> nameBasedFilter.matches(input));
        if (progress.isCanceled()) {
            return;
        }
        for (String source : pathes.keySet()) {
            for (URI uri : pathes.get((Object)source)) {
                if (progress.isCanceled()) {
                    return;
                }
                if (this.getLogger().isLoggable(Level.FINEST)) {
                    this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_7, uri));
                }
                resourceSet.getResource(uri, true);
            }
        }
    }

    protected File createTempDir(String namePrefix) {
        File tempDir = new File(this.getTempDirectory(), namePrefix);
        this.cleanFolder(tempDir, null);
        if (!tempDir.mkdirs()) {
            throw new RuntimeException(MessageFormat.format(Messages.SarlBatchCompiler_8, tempDir.getAbsolutePath()));
        }
        this.tempFolders.add(tempDir);
        return tempDir;
    }

    protected boolean cleanFolder(File parentFolder, FileFilter filter) {
        try {
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_9, parentFolder.toString()));
            }
            return Files.cleanFolder((File)parentFolder, null, (boolean)true, (boolean)true);
        }
        catch (FileNotFoundException e) {
            return true;
        }
    }

    protected boolean checkConfiguration(IProgressMonitor progress) {
        assert (progress != null);
        progress.subTask(Messages.SarlBatchCompiler_55);
        File output = this.getOutputPath();
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_35, output));
        }
        if (output == null) {
            this.reportInternalError(Messages.SarlBatchCompiler_36, new Object[0]);
            return false;
        }
        progress.subTask(Messages.SarlBatchCompiler_56);
        for (File sourcePath : this.getSourcePaths()) {
            if (progress.isCanceled()) {
                return false;
            }
            try {
                if (this.getLogger().isLoggable(Level.FINEST)) {
                    this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_37, sourcePath));
                }
                if (!SarlBatchCompiler.isContainedIn(output.getCanonicalFile(), sourcePath.getCanonicalFile())) continue;
                this.reportInternalError(Messages.SarlBatchCompiler_10, output, sourcePath);
                return false;
            }
            catch (IOException e) {
                this.reportInternalError(Messages.SarlBatchCompiler_11, e);
            }
        }
        return true;
    }

    private static boolean isContainedIn(File child, File possibleParent) {
        for (File parent = child; parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(possibleParent)) continue;
            return true;
        }
        return false;
    }

    private static LinkedList<String> splitFile(File file, IProgressMonitor progress) {
        assert (progress != null);
        LinkedList<String> elements = new LinkedList<String>();
        File current = file;
        do {
            if (progress.isCanceled()) {
                return null;
            }
            elements.addFirst(current.getName());
        } while ((current = current.getParentFile()) != null);
        return elements;
    }

    private File determineCommonRoot(Iterable<File> files, IProgressMonitor progress) {
        assert (progress != null);
        if (this.baseUri != null) {
            if (this.baseUri.isFile()) {
                if (this.getLogger().isLoggable(Level.FINEST)) {
                    this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_32, this.baseUri));
                }
                return new File(this.baseUri.toFileString());
            }
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_33, this.baseUri));
            }
        }
        LinkedList<String> longuestPrefix = null;
        for (File file : files) {
            int i;
            if (progress.isCanceled()) {
                return null;
            }
            if (file == null) continue;
            LinkedList<String> components = SarlBatchCompiler.splitFile(file, progress);
            if (longuestPrefix == null) {
                longuestPrefix = components;
                continue;
            }
            for (i = 0; i < longuestPrefix.size() && i < components.size() && Strings.equal((String)longuestPrefix.get(i), (String)components.get(i)); ++i) {
                if (!progress.isCanceled()) continue;
                return null;
            }
            while (i < longuestPrefix.size()) {
                if (progress.isCanceled()) {
                    return null;
                }
                longuestPrefix.removeLast();
            }
            if (!longuestPrefix.isEmpty()) continue;
            return null;
        }
        if (longuestPrefix == null || progress.isCanceled()) {
            return null;
        }
        File prefix = null;
        for (String component : longuestPrefix) {
            if (progress.isCanceled()) {
                return null;
            }
            if (prefix == null) {
                prefix = new File(component);
                continue;
            }
            prefix = new File(prefix, component);
        }
        return prefix;
    }

    private boolean configureWorkspace(ResourceSet resourceSet, IProgressMonitor progress) {
        assert (progress != null);
        progress.subTask(Messages.SarlBatchCompiler_57);
        List<File> sourceFolders = this.getSourcePaths();
        File javaOutputFile = this.getOutputPath();
        File classOutputFile = this.getClassOutputPath();
        if (sourceFolders == null || sourceFolders.isEmpty() || javaOutputFile == null || classOutputFile == null || progress.isCanceled()) {
            if (sourceFolders == null || sourceFolders.isEmpty()) {
                this.reportInternalError(Messages.SarlBatchCompiler_60, new Object[0]);
            }
            if (javaOutputFile == null) {
                this.reportInternalError(Messages.SarlBatchCompiler_61, new Object[0]);
            }
            if (classOutputFile == null) {
                this.reportInternalError(Messages.SarlBatchCompiler_62, new Object[0]);
            }
            return false;
        }
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_31, this.baseUri));
        }
        File commonRoot = this.determineCommonRoot(Iterables.concat(sourceFolders, Arrays.asList(javaOutputFile, classOutputFile)), progress);
        if (progress.isCanceled()) {
            return false;
        }
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_34, commonRoot));
        }
        if (commonRoot == null) {
            this.reportInternalError(Messages.SarlBatchCompiler_12, new Object[0]);
            for (File sourceFile : sourceFolders) {
                this.reportInternalError(Messages.SarlBatchCompiler_13, sourceFile);
            }
            this.reportInternalError(Messages.SarlBatchCompiler_14, javaOutputFile);
            return false;
        }
        this.projectConfig = new FileProjectConfig(commonRoot, commonRoot.getName());
        if (progress.isCanceled()) {
            return false;
        }
        java.net.URI commonURI = commonRoot.toURI();
        java.net.URI relativizedTarget = commonURI.relativize(javaOutputFile.toURI());
        if (progress.isCanceled()) {
            return false;
        }
        if (relativizedTarget.isAbsolute()) {
            this.reportInternalError(Messages.SarlBatchCompiler_15, javaOutputFile, commonRoot);
            return false;
        }
        CharMatcher slash = CharMatcher.is((char)'/');
        String relativeTargetFolder = slash.trimTrailingFrom((CharSequence)relativizedTarget.getPath());
        Set allOutputConfigurations = this.outputConfigurationProvider.getOutputConfigurations();
        if (progress.isCanceled()) {
            return false;
        }
        this.outputConfigurations = new TreeMap<String, OutputConfiguration>();
        for (OutputConfiguration configuration : allOutputConfigurations) {
            if (progress.isCanceled()) {
                return false;
            }
            this.outputConfigurations.put(configuration.getName(), configuration);
            if (Strings.equal((String)configuration.getName(), (String)"DEFAULT_OUTPUT")) {
                configuration.setOutputDirectory(new File(commonRoot, relativeTargetFolder).getAbsolutePath());
                continue;
            }
            File outFile = new File(configuration.getOutputDirectory());
            outFile = new File(commonRoot, outFile.getPath());
            configuration.setOutputDirectory(outFile.getAbsolutePath());
        }
        if (progress.isCanceled()) {
            return false;
        }
        for (File source : sourceFolders) {
            if (progress.isCanceled()) {
                return false;
            }
            java.net.URI relSource = commonURI.relativize(source.toURI());
            if (relSource.isAbsolute()) {
                this.reportInternalError(Messages.SarlBatchCompiler_16, source, commonRoot);
                return false;
            }
            this.projectConfig.addSourceFolder(slash.trimTrailingFrom((CharSequence)relSource.getPath()));
        }
        if (progress.isCanceled()) {
            return false;
        }
        HashMap<String, Set> outputConfigurations = new HashMap<String, Set>();
        outputConfigurations.put(this.languageName, allOutputConfigurations);
        ProjectConfigAdapter.install((ResourceSet)resourceSet, (IProjectConfig)this.projectConfig);
        resourceSet.eAdapters().add((Object)new OutputConfigurationAdapter(outputConfigurations));
        return !progress.isCanceled();
    }

    private void installJvmTypeProvider(ResourceSet resourceSet, File temporaryClassDirectory, boolean skipIndexLookup, IProgressMonitor progress) {
        Iterable<File> modulepath;
        Iterable<File> classpath;
        assert (progress != null);
        progress.subTask(Messages.SarlBatchCompiler_58);
        if (temporaryClassDirectory != null) {
            if (this.isModularProject()) {
                classpath = this.getClassPath();
                modulepath = Iterables.concat(Collections.singletonList(temporaryClassDirectory), this.getModulePath(), this.getSourcePaths());
            } else {
                classpath = Iterables.concat(Collections.singletonList(temporaryClassDirectory), this.getClassPath(), this.getSourcePaths());
                modulepath = this.getModulePath();
            }
        } else if (this.isModularProject()) {
            classpath = this.getClassPath();
            modulepath = Iterables.concat(this.getModulePath(), this.getSourcePaths());
        } else {
            classpath = Iterables.concat(this.getClassPath(), this.getSourcePaths());
            modulepath = this.getModulePath();
        }
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest(MessageFormat.format(Messages.SarlBatchCompiler_17, classpath));
        }
        if (progress.isCanceled()) {
            return;
        }
        ClassLoader parentClassLoader = this.isUseCurrentClassLoaderAsParent() ? this.getClass().getClassLoader() : this.getCurrentClassLoader();
        if (progress.isCanceled()) {
            return;
        }
        this.jvmTypesClassLoader = this.createClassLoader(classpath, modulepath, parentClassLoader);
        if (progress.isCanceled()) {
            return;
        }
        new ClasspathTypeProvider(this.jvmTypesClassLoader, resourceSet, skipIndexLookup ? null : this.indexedJvmTypeAccess, null);
        if (progress.isCanceled()) {
            return;
        }
        ((XtextResourceSet)resourceSet).setClasspathURIContext((Object)this.jvmTypesClassLoader);
        if (progress.isCanceled()) {
            return;
        }
        progress.subTask(Messages.SarlBatchCompiler_59);
        this.annotationProcessingClassLoader = this.createClassLoader(classpath, modulepath, this.getCurrentClassLoader());
        if (progress.isCanceled()) {
            return;
        }
        resourceSet.eAdapters().add((Object)new ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter(this.annotationProcessingClassLoader));
    }

    private static Iterable<URL> toURL(Iterable<File> files) {
        return Iterables.transform(files, from -> {
            try {
                URL url = from.toURI().toURL();
                assert (url != null);
                return url;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected ClassLoader createClassLoader(Iterable<File> classPath, Iterable<File> modulePath, ClassLoader parentClassLoader) {
        return new URLClassLoader((URL[])Iterables.toArray(SarlBatchCompiler.toURL(Iterables.concat(classPath, modulePath)), URL.class), parentClassLoader);
    }

    protected void destroyClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof Closeable) {
            Closeable ccl = (Closeable)((Object)classLoader);
            try {
                ccl.close();
            }
            catch (Exception e) {
                this.reportInternalWarning(Messages.SarlBatchCompiler_18, e);
            }
        }
    }

    public void setWarningSeverity(String warningId, Severity severity) {
        if (!Strings.isEmpty((String)warningId) && severity != null) {
            this.issueSeverityProvider.setSeverity(warningId, severity);
        }
    }

    public void setAllWarningSeverities(Severity severity) {
        if (severity != null) {
            this.issueSeverityProvider.setAllSeverities(severity);
        }
    }

    private static class LoggerRepositoryWrapper
    implements LoggerRepository {
        private final LoggerRepository original;
        private final Map<String, org.apache.log4j.Logger> wrapped = new HashMap<String, org.apache.log4j.Logger>();

        LoggerRepositoryWrapper(LoggerRepository original) {
            this.original = original;
        }

        void registerWrapper(String loggerName, org.apache.log4j.Logger logger) {
            this.wrapped.put(loggerName, logger);
        }

        public void addHierarchyEventListener(HierarchyEventListener listener) {
            this.original.addHierarchyEventListener(listener);
        }

        public boolean isDisabled(int level) {
            return this.original.isDisabled(level);
        }

        public void setThreshold(org.apache.log4j.Level level) {
            this.original.setThreshold(level);
        }

        public void setThreshold(String val) {
            this.original.setThreshold(val);
        }

        public void emitNoAppenderWarning(Category cat) {
            this.original.emitNoAppenderWarning(cat);
        }

        public org.apache.log4j.Level getThreshold() {
            return this.original.getThreshold();
        }

        public org.apache.log4j.Logger getLogger(String name) {
            org.apache.log4j.Logger wrapped = this.wrapped.get(name);
            if (wrapped != null) {
                return wrapped;
            }
            return this.original.getLogger(name);
        }

        public org.apache.log4j.Logger getLogger(String name, LoggerFactory factory) {
            org.apache.log4j.Logger wrapped = this.wrapped.get(name);
            if (wrapped != null) {
                return wrapped;
            }
            return this.original.getLogger(name, factory);
        }

        public org.apache.log4j.Logger getRootLogger() {
            return this.original.getRootLogger();
        }

        public org.apache.log4j.Logger exists(String name) {
            return null;
        }

        public void shutdown() {
            this.original.shutdown();
        }

        public Enumeration<?> getCurrentLoggers() {
            return this.getCurrentLoggers();
        }

        public Enumeration<?> getCurrentCategories() {
            return this.original.getCurrentCategories();
        }

        public void fireAddAppenderEvent(Category logger, Appender appender) {
            this.original.fireAddAppenderEvent(logger, appender);
        }

        public void resetConfiguration() {
            this.original.resetConfiguration();
        }
    }
}

