/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler.batch;

import com.google.inject.ImplementedBy;
import io.sarl.lang.compiler.batch.IJavaBatchCompiler;
import io.sarl.lang.compiler.batch.IJavaBatchCompilerFactory;
import io.sarl.lang.compiler.batch.InvalidSarlBatchCompilerError;
import java.io.File;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;

public final class SarlBatchCompilerUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Pure
    public static IJavaBatchCompiler newDefaultJavaBatchCompiler() {
        try {
            ImplementedBy annotation;
            ServiceLoader<IJavaBatchCompilerFactory> loader = ServiceLoader.load(IJavaBatchCompilerFactory.class);
            Iterator<IJavaBatchCompilerFactory> iterator = loader.iterator();
            try {
                while (iterator.hasNext()) {
                    IJavaBatchCompilerFactory factory = iterator.next();
                    try {
                        IJavaBatchCompiler compiler;
                        if (factory == null || (compiler = factory.createBatchCompiler()) == null) continue;
                        return compiler;
                    }
                    catch (Throwable compiler) {
                    }
                }
            }
            catch (Throwable factory) {
                // empty catch block
            }
            if ((annotation = IJavaBatchCompiler.class.getAnnotation(ImplementedBy.class)) == null) throw new InvalidSarlBatchCompilerError();
            Class type = annotation.value();
            if (type == null) throw new InvalidSarlBatchCompilerError();
            Class<IJavaBatchCompiler> ctype = type.asSubclass(IJavaBatchCompiler.class);
            IJavaBatchCompiler compiler = ctype.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (compiler == null) throw new InvalidSarlBatchCompilerError();
            return compiler;
        }
        catch (Exception exception) {
            throw new InvalidSarlBatchCompilerError(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Pure
    public static Class<? extends IJavaBatchCompiler> getDefaultJavaBatchCompilerImplementationType() {
        try {
            ImplementedBy annotation;
            Class<? extends IJavaBatchCompiler> type;
            ServiceLoader<IJavaBatchCompilerFactory> loader = ServiceLoader.load(IJavaBatchCompilerFactory.class);
            Iterator<IJavaBatchCompilerFactory> iterator = loader.iterator();
            try {
                while (iterator.hasNext()) {
                    IJavaBatchCompilerFactory factory = iterator.next();
                    try {
                        if (factory == null || (type = factory.getType()) == null) continue;
                        return type;
                    }
                    catch (Throwable type2) {
                    }
                }
            }
            catch (Throwable factory) {
                // empty catch block
            }
            if ((annotation = IJavaBatchCompiler.class.getAnnotation(ImplementedBy.class)) == null) throw new InvalidSarlBatchCompilerError();
            type = annotation.value();
            if (type == null) throw new InvalidSarlBatchCompilerError();
            return type.asSubclass(IJavaBatchCompiler.class);
        }
        catch (Exception exception) {
            throw new InvalidSarlBatchCompilerError(exception);
        }
    }

    @Pure
    public static JavaVersion parseJavaVersion(String javaVersion) {
        String version = javaVersion;
        if (Strings.isEmpty((String)version)) {
            version = "21";
        }
        return JavaVersion.fromQualifier((String)version);
    }

    @Pure
    public static boolean isModuleFolder(File folder) {
        File file = new File(folder, "module-info.java");
        return file.isFile();
    }
}

