/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.sarl.lang.codebuilder.appenders.BlockExpressionSourceAppender;
import io.sarl.lang.codebuilder.appenders.ExpressionSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlActionSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlAgentSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlAnnotationTypeSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlArtifactSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlBehaviorSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlBehaviorUnitSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlCapacitySourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlClassSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlConstructorSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlEnumLiteralSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlEnumerationSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlEventSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlFieldSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlInterfaceSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlSkillSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlSpaceSourceAppender;
import io.sarl.lang.codebuilder.appenders.ScriptSourceAppender;
import io.sarl.lang.codebuilder.builders.IBlockExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IExpressionBuilder;
import io.sarl.lang.codebuilder.builders.ISarlActionBuilder;
import io.sarl.lang.codebuilder.builders.ISarlAgentBuilder;
import io.sarl.lang.codebuilder.builders.ISarlAnnotationTypeBuilder;
import io.sarl.lang.codebuilder.builders.ISarlArtifactBuilder;
import io.sarl.lang.codebuilder.builders.ISarlBehaviorBuilder;
import io.sarl.lang.codebuilder.builders.ISarlBehaviorUnitBuilder;
import io.sarl.lang.codebuilder.builders.ISarlCapacityBuilder;
import io.sarl.lang.codebuilder.builders.ISarlClassBuilder;
import io.sarl.lang.codebuilder.builders.ISarlConstructorBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEnumLiteralBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEnumerationBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEventBuilder;
import io.sarl.lang.codebuilder.builders.ISarlFieldBuilder;
import io.sarl.lang.codebuilder.builders.ISarlInterfaceBuilder;
import io.sarl.lang.codebuilder.builders.ISarlSkillBuilder;
import io.sarl.lang.codebuilder.builders.ISarlSpaceBuilder;
import io.sarl.lang.codebuilder.builders.IScriptBuilder;
import io.sarl.lang.core.util.SarlUtils;
import jakarta.inject.Inject;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.Constants;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.util.Modules2;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.lib.Pure;

/** Creates {@code ICodeBuilder} to insert SARL code snippets.
	 * @see "BuilderFactoryFragment.java : appendTo : 92"
 */
@SuppressWarnings("all")
public class CodeBuilderFactory {

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 102"
	 */
	private static final String[] FORBIDDEN_INJECTION_PREFIXES = new String[] {
		"com.google.inject.",
	};

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 117"
	 */
	private static final String[] FORBIDDEN_INJECTION_POSTFIXES = new String[] {
		".Logger",
	};

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 132"
	 */
	@Inject
	private IResourceFactory resourceFactory;

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 141"
	 */
	private String fileExtension;

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 145"
	 */
	@Inject
	private Provider<ImportManager> importManagerProvider;

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 156"
	 */
	@Inject
	private Injector originalInjector;

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 165"
	 */
	private Injector builderInjector;

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 171"
	 */
	@Inject
	public void setFileExtensions(@Named(Constants.FILE_EXTENSIONS) String fileExtensions) {
		this.fileExtension = SarlUtils.getMajorFileExtension(fileExtensions);
	}

	/** Compute a unused URI for a synthetic resource.
	 * @param resourceSet the resource set in which the resource should be located.
	 * @return the uri.
	 * @see "BuilderFactoryFragment.java : appendTo : 194"
	 */
	@Pure
	protected URI computeUnusedUri(ResourceSet resourceSet) {
		String name = "__synthetic";
		for (int i = 0; i < Integer.MAX_VALUE; ++i) {
			URI syntheticUri = URI.createURI(name + i + "." + getScriptFileExtension());
			if (resourceSet.getResource(syntheticUri, false) == null) {
				return syntheticUri;
			}
		}
		throw new IllegalStateException();
	}

	/** Replies the script's file extension.
	 * @see "BuilderFactoryFragment.java : appendTo : 231"
	 */
	@Pure
	public String getScriptFileExtension() {
		return this.fileExtension;
	}

	/** Replies the resource factory.
	 *
	 * @return the resource factory.
	 * @see "BuilderFactoryFragment.java : appendTo : 250"
	 */
	@Pure
	protected IResourceFactory getResourceFactory() {
		return this.resourceFactory;
	}

	/** Replies the name of the foo package.
	 *
	 * @return the name of the foo package.
	 * @see "BuilderFactoryFragment.java : appendTo : 271"
	 */
	@Pure
	protected String getFooPackageName() {
		return "io.sarl.lang.foo";
	}

	/** Replies the name of the foo type.
	 *
	 * @return the name of the foo type.
	 * @see "BuilderFactoryFragment.java : appendTo : 292"
	 */
	@Pure
	protected String getFooTypeName() {
		return "FooType";
	}

	/** Replies the name of the foo type member.
	 *
	 * @return the name of the foo type member.
	 * @see "BuilderFactoryFragment.java : appendTo : 311"
	 */
	@Pure
	protected String getFooMemberName() {
		return "fooMember";
	}

	/** Create a synthetic resource.
	 *
	 * @param resourceSet the resourceSet.
	 * @return the resource.
	 * @see "BuilderFactoryFragment.java : appendTo : 332"
	 */
	@Pure
	protected Resource createResource(ResourceSet  resourceSet) {
		URI uri = computeUnusedUri(resourceSet);
		Resource resource = getResourceFactory().createResource(uri);
		resourceSet.getResources().add(resource);
		return resource;
	}

	/** Replies the injector.
	 * @return the injector.
	 * @see "BuilderFactoryFragment.java : appendTo : 363"
	 */
	@Pure
	protected Injector getInjector() {
		if (this.builderInjector == null) {
			ImportManager importManager = this.importManagerProvider.get();
			this.builderInjector = createOverridingInjector(this.originalInjector, new CodeBuilderModule(importManager));
		}
		return builderInjector;
	}

	/** Create an injector that override the given injectors with the modules.
	 *
	 * @param originalInjector the original injector.
	 * @param module the overriding module.
	 * @return the new injector.
	 * @see "BuilderFactoryFragment.java : appendTo : 398"
	 */
	public static Injector createOverridingInjector(Injector originalInjector, com.google.inject.Module module) {
		final Map<Key<?>, Binding<?>> bindings = originalInjector.getBindings();
		return Guice.createInjector(Modules2.mixin((binder) -> {
			for(Binding<?> binding: bindings.values()) {
				final Type typeLiteral = binding.getKey().getTypeLiteral().getType();
				if (typeLiteral != null) {
					final String typeName = typeLiteral.getTypeName();
					if (isValid(typeName)) {
						binding.applyTo(binder);
					}
				}
			}
		}, module));
	}

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 450"
	 */
	private static boolean isValid(String name) {
		for (final String prefix : FORBIDDEN_INJECTION_PREFIXES) {
			if (name.startsWith(prefix)) {
				return false;
			}
		}
		for (final String postfix : FORBIDDEN_INJECTION_POSTFIXES) {
			if (name.endsWith(postfix)) {
				return false;
			}
		}
		return true;
	}

	/** Replies a provider for the given type.
	 * <p>The provider uses a local context singleton of the import manager.
	 * @param type the type of the object to provide.
	 * @return the provider.
	 * @see "BuilderFactoryFragment.java : appendTo : 486"
	 */
	@Pure
	protected <T> Provider<T> getProvider(Class<T> type) {
		return getInjector().getProvider(type);
	}

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 501"
	 */
	private static class CodeBuilderModule extends AbstractModule {

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 507"
	 */
		private final ImportManager importManager;

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 513"
	 */
		public CodeBuilderModule(ImportManager importManager) {
			this.importManager = importManager;
		}

	/**
	 * @see "BuilderFactoryFragment.java : appendTo : 523"
	 */
		@Override
		protected void configure() {
			bind(ImportManager.class).toInstance(this.importManager);
		}

	}

	/** Create the factory for a Sarl script.
	 * @param packageName the name of the package of the script.
	 * @param resourceSet the resource set in which the script is created.
	 * @return the factory.
	 * @see "ScriptBuilderFragment.java : appendTo : 137"
	 */
	@Pure
	public IScriptBuilder createScript(String packageName, ResourceSet resourceSet) {
		return createScript(packageName, createResource(resourceSet), null);
	}

	/** Create the factory for a Sarl script.
	 * @param packageName the name of the package of the script.
	 * @param resource the resource in which the script is created.
	 * @return the factory.
	 * @see "ScriptBuilderFragment.java : appendTo : 162"
	 */
	@Pure
	public IScriptBuilder createScript(String packageName, Resource resource) {
		return createScript(packageName, resource, null);
	}

	/** Create the factory for a Sarl script.
	 * @param packageName the name of the package of the script.
	 * @param resource the resource in which the script is created.
	 * @param context the context for type resolution.
	 * @return the factory.
	 * @see "ScriptBuilderFragment.java : appendTo : 189"
	 */
	@Pure
	public IScriptBuilder createScript(String packageName, Resource resource, IJvmTypeProvider context) {
		IScriptBuilder builder = getProvider(IScriptBuilder.class).get();
		builder.eInit(resource, packageName, context);
		return builder;
	}

	/** Create the factory for a Sarl script.
	 * <p>The resource set is provided by the context.
	 * @param packageName the name of the package of the script.
	 * @param context the context for type resolution.
	 * @return the factory.
	 * @see "ScriptBuilderFragment.java : appendTo : 226"
	 */
	@Pure
	public IScriptBuilder createScript(String packageName, IJvmTypeProvider context) {
		return createScript(packageName, createResource(context.getResourceSet()), context);
	}

	/** Create the appender for a Sarl script.
	 * @param packageName the name of the package of the script.
	 * @param resourceSet the resource set in which the script is created.
	 * @return the appender.
	 * @see "ScriptBuilderFragment.java : appendTo : 257"
	 */
	@Pure
	public ScriptSourceAppender buildScript(String packageName, ResourceSet resourceSet) {
		ScriptSourceAppender a = new ScriptSourceAppender(createScript(packageName, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl script.
	 * @param packageName the name of the package of the script.
	 * @param resource the resource in which the script is created.
	 * @return the appender.
	 * @see "ScriptBuilderFragment.java : appendTo : 290"
	 */
	@Pure
	public ScriptSourceAppender buildScript(String packageName, Resource resource) {
		ScriptSourceAppender a = new ScriptSourceAppender(createScript(packageName, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl script.
	 * @param packageName the name of the package of the script.
	 * @param resource the resource in which the script is created.
	 * @param context the context for type resolution.
	 * @return the appender.
	 * @see "ScriptBuilderFragment.java : appendTo : 325"
	 */
	@Pure
	public ScriptSourceAppender buildScript(String packageName, Resource resource, IJvmTypeProvider context) {
		ScriptSourceAppender a = new ScriptSourceAppender(createScript(packageName, resource, context));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl script.
	 * <p>The resource set is provided by the context.
	 * @param packageName the name of the package of the script.
	 * @param context the context for type resolution.
	 * @return the appender.
	 * @see "ScriptBuilderFragment.java : appendTo : 362"
	 */
	@Pure
	public ScriptSourceAppender buildScript(String packageName, IJvmTypeProvider context) {
		ScriptSourceAppender a = new ScriptSourceAppender(createScript(packageName, context));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl XExpression.
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "ExpressionBuilderFragment.java : appendTo : 1269"
	 */
	public IExpressionBuilder createXExpression(ResourceSet resourceSet) {
		return createXExpression(createResource(resourceSet));	}

	/** Create the factory for a Sarl XExpression.
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "ExpressionBuilderFragment.java : appendTo : 1295"
	 */
	public IExpressionBuilder createXExpression(Resource resource) {
		final IScriptBuilder script = createScript(getFooPackageName(), resource);
		final ISarlEventBuilder topElement = script.addSarlEvent(getFooTypeName());
		final ISarlFieldBuilder memberElement = topElement.addSarlField(getFooMemberName());
		return memberElement.getInitialValue();
	}

	/** Create the appender for a Sarl XExpression.
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "ExpressionBuilderFragment.java : appendTo : 1346"
	 */
	public ExpressionSourceAppender buildXExpression(ResourceSet resourceSet) {
		return new ExpressionSourceAppender(createXExpression(resourceSet));
	}

	/** Create the appender for a Sarl XExpression.
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "ExpressionBuilderFragment.java : appendTo : 1375"
	 */
	public ExpressionSourceAppender buildXExpression(Resource resource) {
		return new ExpressionSourceAppender(createXExpression(resource));
	}

	/** Create the factory for a Sarl block expression.
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 923"
	 */
	@Pure
	public IBlockExpressionBuilder createXBlockExpression(ResourceSet resourceSet) {
		return createXBlockExpression(createResource(resourceSet));
	}

	/** Create the factory for a Sarl block expression.
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 953"
	 */
	@Pure
	public IBlockExpressionBuilder createXBlockExpression(Resource resource) {
		final IScriptBuilder script = createScript(getFooPackageName(), resource);
		final ISarlAgentBuilder topElement = script.addSarlAgent(getFooTypeName());
		final ISarlActionBuilder memberElement = topElement.addSarlAction(getFooMemberName());
		return memberElement.getExpression();
	}

	/** Create the appender for a Sarl block expression.
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 1007"
	 */
	@Pure
	public BlockExpressionSourceAppender buildXBlockExpression(ResourceSet resourceSet) {
		return new BlockExpressionSourceAppender(createXBlockExpression(resourceSet));
	}

	/** Create the appender for a Sarl block expression.
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 1039"
	 */
	@Pure
	public BlockExpressionSourceAppender buildXBlockExpression(Resource resource) {
		return new BlockExpressionSourceAppender(createXBlockExpression(resource));
	}

	/** Create the factory for a Sarl SarlEvent.
	 * @param name the name of the SarlEvent
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlEventBuilder createSarlEvent(String name, ResourceSet resourceSet) {
		 return createSarlEvent(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlEvent.
	 * @param name the name of the SarlEvent
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlEventBuilder createSarlEvent(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlEvent(name);
	}

	/** Create the appender for a Sarl SarlEvent.
	 * @param name the name of the SarlEvent
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlEventSourceAppender buildSarlEvent(String name, ResourceSet resourceSet) {
		SarlEventSourceAppender a = new SarlEventSourceAppender(createSarlEvent(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlEvent.
	 * @param name the name of the SarlEvent
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlEventSourceAppender buildSarlEvent(String name, Resource resource) {
		SarlEventSourceAppender a = new SarlEventSourceAppender(createSarlEvent(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlCapacity.
	 * @param name the name of the SarlCapacity
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlCapacityBuilder createSarlCapacity(String name, ResourceSet resourceSet) {
		 return createSarlCapacity(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlCapacity.
	 * @param name the name of the SarlCapacity
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlCapacityBuilder createSarlCapacity(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlCapacity(name);
	}

	/** Create the appender for a Sarl SarlCapacity.
	 * @param name the name of the SarlCapacity
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlCapacitySourceAppender buildSarlCapacity(String name, ResourceSet resourceSet) {
		SarlCapacitySourceAppender a = new SarlCapacitySourceAppender(createSarlCapacity(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlCapacity.
	 * @param name the name of the SarlCapacity
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlCapacitySourceAppender buildSarlCapacity(String name, Resource resource) {
		SarlCapacitySourceAppender a = new SarlCapacitySourceAppender(createSarlCapacity(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlAgent.
	 * @param name the name of the SarlAgent
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlAgentBuilder createSarlAgent(String name, ResourceSet resourceSet) {
		 return createSarlAgent(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlAgent.
	 * @param name the name of the SarlAgent
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlAgentBuilder createSarlAgent(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlAgent(name);
	}

	/** Create the appender for a Sarl SarlAgent.
	 * @param name the name of the SarlAgent
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlAgentSourceAppender buildSarlAgent(String name, ResourceSet resourceSet) {
		SarlAgentSourceAppender a = new SarlAgentSourceAppender(createSarlAgent(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlAgent.
	 * @param name the name of the SarlAgent
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlAgentSourceAppender buildSarlAgent(String name, Resource resource) {
		SarlAgentSourceAppender a = new SarlAgentSourceAppender(createSarlAgent(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlBehavior.
	 * @param name the name of the SarlBehavior
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlBehaviorBuilder createSarlBehavior(String name, ResourceSet resourceSet) {
		 return createSarlBehavior(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlBehavior.
	 * @param name the name of the SarlBehavior
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlBehaviorBuilder createSarlBehavior(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlBehavior(name);
	}

	/** Create the appender for a Sarl SarlBehavior.
	 * @param name the name of the SarlBehavior
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlBehaviorSourceAppender buildSarlBehavior(String name, ResourceSet resourceSet) {
		SarlBehaviorSourceAppender a = new SarlBehaviorSourceAppender(createSarlBehavior(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlBehavior.
	 * @param name the name of the SarlBehavior
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlBehaviorSourceAppender buildSarlBehavior(String name, Resource resource) {
		SarlBehaviorSourceAppender a = new SarlBehaviorSourceAppender(createSarlBehavior(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlSkill.
	 * @param name the name of the SarlSkill
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlSkillBuilder createSarlSkill(String name, ResourceSet resourceSet) {
		 return createSarlSkill(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlSkill.
	 * @param name the name of the SarlSkill
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlSkillBuilder createSarlSkill(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlSkill(name);
	}

	/** Create the appender for a Sarl SarlSkill.
	 * @param name the name of the SarlSkill
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlSkillSourceAppender buildSarlSkill(String name, ResourceSet resourceSet) {
		SarlSkillSourceAppender a = new SarlSkillSourceAppender(createSarlSkill(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlSkill.
	 * @param name the name of the SarlSkill
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlSkillSourceAppender buildSarlSkill(String name, Resource resource) {
		SarlSkillSourceAppender a = new SarlSkillSourceAppender(createSarlSkill(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlSpace.
	 * @param name the name of the SarlSpace
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlSpaceBuilder createSarlSpace(String name, ResourceSet resourceSet) {
		 return createSarlSpace(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlSpace.
	 * @param name the name of the SarlSpace
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlSpaceBuilder createSarlSpace(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlSpace(name);
	}

	/** Create the appender for a Sarl SarlSpace.
	 * @param name the name of the SarlSpace
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlSpaceSourceAppender buildSarlSpace(String name, ResourceSet resourceSet) {
		SarlSpaceSourceAppender a = new SarlSpaceSourceAppender(createSarlSpace(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlSpace.
	 * @param name the name of the SarlSpace
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlSpaceSourceAppender buildSarlSpace(String name, Resource resource) {
		SarlSpaceSourceAppender a = new SarlSpaceSourceAppender(createSarlSpace(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlArtifact.
	 * @param name the name of the SarlArtifact
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlArtifactBuilder createSarlArtifact(String name, ResourceSet resourceSet) {
		 return createSarlArtifact(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlArtifact.
	 * @param name the name of the SarlArtifact
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlArtifactBuilder createSarlArtifact(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlArtifact(name);
	}

	/** Create the appender for a Sarl SarlArtifact.
	 * @param name the name of the SarlArtifact
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlArtifactSourceAppender buildSarlArtifact(String name, ResourceSet resourceSet) {
		SarlArtifactSourceAppender a = new SarlArtifactSourceAppender(createSarlArtifact(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlArtifact.
	 * @param name the name of the SarlArtifact
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlArtifactSourceAppender buildSarlArtifact(String name, Resource resource) {
		SarlArtifactSourceAppender a = new SarlArtifactSourceAppender(createSarlArtifact(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlClass.
	 * @param name the name of the SarlClass
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlClassBuilder createSarlClass(String name, ResourceSet resourceSet) {
		 return createSarlClass(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlClass.
	 * @param name the name of the SarlClass
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlClassBuilder createSarlClass(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlClass(name);
	}

	/** Create the appender for a Sarl SarlClass.
	 * @param name the name of the SarlClass
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlClassSourceAppender buildSarlClass(String name, ResourceSet resourceSet) {
		SarlClassSourceAppender a = new SarlClassSourceAppender(createSarlClass(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlClass.
	 * @param name the name of the SarlClass
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlClassSourceAppender buildSarlClass(String name, Resource resource) {
		SarlClassSourceAppender a = new SarlClassSourceAppender(createSarlClass(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlInterface.
	 * @param name the name of the SarlInterface
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlInterfaceBuilder createSarlInterface(String name, ResourceSet resourceSet) {
		 return createSarlInterface(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlInterface.
	 * @param name the name of the SarlInterface
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlInterfaceBuilder createSarlInterface(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlInterface(name);
	}

	/** Create the appender for a Sarl SarlInterface.
	 * @param name the name of the SarlInterface
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlInterfaceSourceAppender buildSarlInterface(String name, ResourceSet resourceSet) {
		SarlInterfaceSourceAppender a = new SarlInterfaceSourceAppender(createSarlInterface(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlInterface.
	 * @param name the name of the SarlInterface
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlInterfaceSourceAppender buildSarlInterface(String name, Resource resource) {
		SarlInterfaceSourceAppender a = new SarlInterfaceSourceAppender(createSarlInterface(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlEnumeration.
	 * @param name the name of the SarlEnumeration
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlEnumerationBuilder createSarlEnumeration(String name, ResourceSet resourceSet) {
		 return createSarlEnumeration(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlEnumeration.
	 * @param name the name of the SarlEnumeration
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlEnumerationBuilder createSarlEnumeration(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlEnumeration(name);
	}

	/** Create the appender for a Sarl SarlEnumeration.
	 * @param name the name of the SarlEnumeration
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlEnumerationSourceAppender buildSarlEnumeration(String name, ResourceSet resourceSet) {
		SarlEnumerationSourceAppender a = new SarlEnumerationSourceAppender(createSarlEnumeration(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlEnumeration.
	 * @param name the name of the SarlEnumeration
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlEnumerationSourceAppender buildSarlEnumeration(String name, Resource resource) {
		SarlEnumerationSourceAppender a = new SarlEnumerationSourceAppender(createSarlEnumeration(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlAnnotationType.
	 * @param name the name of the SarlAnnotationType
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 138"
	 */
	@Pure
	public ISarlAnnotationTypeBuilder createSarlAnnotationType(String name, ResourceSet resourceSet) {
		 return createSarlAnnotationType(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlAnnotationType.
	 * @param name the name of the SarlAnnotationType
	 * @param resource the resource that must be used for
	 *    containing the generated element, and resolving types from names.
	 * @return the factory.
	 * @see "TopElementBuilderFragment.java : appendTo : 170"
	 */
	@Pure
	public ISarlAnnotationTypeBuilder createSarlAnnotationType(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		return scriptBuilder.addSarlAnnotationType(name);
	}

	/** Create the appender for a Sarl SarlAnnotationType.
	 * @param name the name of the SarlAnnotationType
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 216"
	 */
	@Pure
	public SarlAnnotationTypeSourceAppender buildSarlAnnotationType(String name, ResourceSet resourceSet) {
		SarlAnnotationTypeSourceAppender a = new SarlAnnotationTypeSourceAppender(createSarlAnnotationType(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlAnnotationType.
	 * @param name the name of the SarlAnnotationType
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "TopElementBuilderFragment.java : appendTo : 256"
	 */
	@Pure
	public SarlAnnotationTypeSourceAppender buildSarlAnnotationType(String name, Resource resource) {
		SarlAnnotationTypeSourceAppender a = new SarlAnnotationTypeSourceAppender(createSarlAnnotationType(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl constructor.
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "ConstructorBuilderFragment.java : appendTo : 102"
	 */
	@Pure
	public ISarlConstructorBuilder createSarlConstructor(ResourceSet resourceSet) {
		return createSarlConstructor(createResource(resourceSet));
	}

	/** Create the factory for a Sarl constructor.
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "ConstructorBuilderFragment.java : appendTo : 131"
	 */
	@Pure
	public ISarlConstructorBuilder createSarlConstructor(Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		ISarlEventBuilder containerBuilder = scriptBuilder.addSarlEvent(getFooTypeName());
		return containerBuilder.addSarlConstructor();
	}

	/** Create the appender for a Sarl constructor.
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "ConstructorBuilderFragment.java : appendTo : 181"
	 */
	@Pure
	public SarlConstructorSourceAppender buildSarlConstructor(ResourceSet resourceSet) {
		SarlConstructorSourceAppender a = new SarlConstructorSourceAppender(createSarlConstructor(resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl constructor.
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "ConstructorBuilderFragment.java : appendTo : 219"
	 */
	@Pure
	public SarlConstructorSourceAppender buildSarlConstructor(Resource resource) {
		SarlConstructorSourceAppender a = new SarlConstructorSourceAppender(createSarlConstructor(resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlAction.
	 * @param name the name of the SarlAction
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 163"
	 */
	@Pure
	public ISarlActionBuilder createDefSarlAction(String name, ResourceSet resourceSet) {
		return createDefSarlAction(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlAction.
	 * @param name the name of the SarlAction
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 196"
	 */
	@Pure
	public ISarlActionBuilder createDefSarlAction(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		ISarlCapacityBuilder containerBuilder = scriptBuilder.addSarlCapacity(getFooTypeName());
		return containerBuilder.addDefSarlAction(name);
	}

	/** Create the appender for a Sarl SarlAction.
	 * @param name the name of the SarlAction
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 251"
	 */
	@Pure
	public SarlActionSourceAppender buildDefSarlAction(String name, ResourceSet resourceSet) {
		SarlActionSourceAppender a = new SarlActionSourceAppender(createDefSarlAction(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlAction.
	 * @param name the name of the SarlAction
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 292"
	 */
	@Pure
	public SarlActionSourceAppender buildDefSarlAction(String name, Resource resource) {
		SarlActionSourceAppender a = new SarlActionSourceAppender(createDefSarlAction(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlAction.
	 * @param name the name of the SarlAction
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 163"
	 */
	@Pure
	public ISarlActionBuilder createOverrideSarlAction(String name, ResourceSet resourceSet) {
		return createOverrideSarlAction(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlAction.
	 * @param name the name of the SarlAction
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 196"
	 */
	@Pure
	public ISarlActionBuilder createOverrideSarlAction(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		ISarlCapacityBuilder containerBuilder = scriptBuilder.addSarlCapacity(getFooTypeName());
		return containerBuilder.addOverrideSarlAction(name);
	}

	/** Create the appender for a Sarl SarlAction.
	 * @param name the name of the SarlAction
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 251"
	 */
	@Pure
	public SarlActionSourceAppender buildOverrideSarlAction(String name, ResourceSet resourceSet) {
		SarlActionSourceAppender a = new SarlActionSourceAppender(createOverrideSarlAction(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlAction.
	 * @param name the name of the SarlAction
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 292"
	 */
	@Pure
	public SarlActionSourceAppender buildOverrideSarlAction(String name, Resource resource) {
		SarlActionSourceAppender a = new SarlActionSourceAppender(createOverrideSarlAction(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlBehaviorUnit.
	 * @param name the name of the SarlBehaviorUnit
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 163"
	 */
	@Pure
	public ISarlBehaviorUnitBuilder createSarlBehaviorUnit(String name, ResourceSet resourceSet) {
		return createSarlBehaviorUnit(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlBehaviorUnit.
	 * @param name the name of the SarlBehaviorUnit
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 196"
	 */
	@Pure
	public ISarlBehaviorUnitBuilder createSarlBehaviorUnit(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		ISarlAgentBuilder containerBuilder = scriptBuilder.addSarlAgent(getFooTypeName());
		return containerBuilder.addSarlBehaviorUnit(name);
	}

	/** Create the appender for a Sarl SarlBehaviorUnit.
	 * @param name the name of the SarlBehaviorUnit
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 251"
	 */
	@Pure
	public SarlBehaviorUnitSourceAppender buildSarlBehaviorUnit(String name, ResourceSet resourceSet) {
		SarlBehaviorUnitSourceAppender a = new SarlBehaviorUnitSourceAppender(createSarlBehaviorUnit(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlBehaviorUnit.
	 * @param name the name of the SarlBehaviorUnit
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 292"
	 */
	@Pure
	public SarlBehaviorUnitSourceAppender buildSarlBehaviorUnit(String name, Resource resource) {
		SarlBehaviorUnitSourceAppender a = new SarlBehaviorUnitSourceAppender(createSarlBehaviorUnit(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlField.
	 * @param name the name of the SarlField
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 163"
	 */
	@Pure
	public ISarlFieldBuilder createVarSarlField(String name, ResourceSet resourceSet) {
		return createVarSarlField(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlField.
	 * @param name the name of the SarlField
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 196"
	 */
	@Pure
	public ISarlFieldBuilder createVarSarlField(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		ISarlEventBuilder containerBuilder = scriptBuilder.addSarlEvent(getFooTypeName());
		return containerBuilder.addVarSarlField(name);
	}

	/** Create the appender for a Sarl SarlField.
	 * @param name the name of the SarlField
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 251"
	 */
	@Pure
	public SarlFieldSourceAppender buildVarSarlField(String name, ResourceSet resourceSet) {
		SarlFieldSourceAppender a = new SarlFieldSourceAppender(createVarSarlField(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlField.
	 * @param name the name of the SarlField
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 292"
	 */
	@Pure
	public SarlFieldSourceAppender buildVarSarlField(String name, Resource resource) {
		SarlFieldSourceAppender a = new SarlFieldSourceAppender(createVarSarlField(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlField.
	 * @param name the name of the SarlField
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 163"
	 */
	@Pure
	public ISarlFieldBuilder createValSarlField(String name, ResourceSet resourceSet) {
		return createValSarlField(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlField.
	 * @param name the name of the SarlField
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 196"
	 */
	@Pure
	public ISarlFieldBuilder createValSarlField(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		ISarlEventBuilder containerBuilder = scriptBuilder.addSarlEvent(getFooTypeName());
		return containerBuilder.addValSarlField(name);
	}

	/** Create the appender for a Sarl SarlField.
	 * @param name the name of the SarlField
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 251"
	 */
	@Pure
	public SarlFieldSourceAppender buildValSarlField(String name, ResourceSet resourceSet) {
		SarlFieldSourceAppender a = new SarlFieldSourceAppender(createValSarlField(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlField.
	 * @param name the name of the SarlField
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 292"
	 */
	@Pure
	public SarlFieldSourceAppender buildValSarlField(String name, Resource resource) {
		SarlFieldSourceAppender a = new SarlFieldSourceAppender(createValSarlField(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the factory for a Sarl SarlEnumLiteral.
	 * @param name the name of the SarlEnumLiteral
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 163"
	 */
	@Pure
	public ISarlEnumLiteralBuilder createSarlEnumLiteral(String name, ResourceSet resourceSet) {
		return createSarlEnumLiteral(name, createResource(resourceSet));
	}

	/** Create the factory for a Sarl SarlEnumLiteral.
	 * @param name the name of the SarlEnumLiteral
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the factory.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 196"
	 */
	@Pure
	public ISarlEnumLiteralBuilder createSarlEnumLiteral(String name, Resource resource) {
		IScriptBuilder scriptBuilder = createScript(getFooPackageName(), resource);
		ISarlEnumerationBuilder containerBuilder = scriptBuilder.addSarlEnumeration(getFooTypeName());
		return containerBuilder.addSarlEnumLiteral(name);
	}

	/** Create the appender for a Sarl SarlEnumLiteral.
	 * @param name the name of the SarlEnumLiteral
	 * @param resourceSet the set of the resources that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 251"
	 */
	@Pure
	public SarlEnumLiteralSourceAppender buildSarlEnumLiteral(String name, ResourceSet resourceSet) {
		SarlEnumLiteralSourceAppender a = new SarlEnumLiteralSourceAppender(createSarlEnumLiteral(name, resourceSet));
		getInjector().injectMembers(a);
		return a;
	}

	/** Create the appender for a Sarl SarlEnumLiteral.
	 * @param name the name of the SarlEnumLiteral
	 * @param resource the resource that must be used for
	 *    containing the generated resource, and resolving types from names.
	 * @return the appender.
	 * @see "NamedMemberBuilderFragment.java : appendTo : 292"
	 */
	@Pure
	public SarlEnumLiteralSourceAppender buildSarlEnumLiteral(String name, Resource resource) {
		SarlEnumLiteralSourceAppender a = new SarlEnumLiteralSourceAppender(createSarlEnumLiteral(name, resource));
		getInjector().injectMembers(a);
		return a;
	}

}

