/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.appenders;

import io.sarl.lang.codebuilder.builders.IBlockExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IExpressionBuilder;
import io.sarl.lang.documentation.InnerBlockDocumentationAdapter;
import java.io.IOException;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.lib.Pure;

/** Appender of a Sarl XBlockExpression.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 178"
 */
@SuppressWarnings("all")
public class BlockExpressionSourceAppender extends AbstractSourceAppender implements IBlockExpressionBuilder {

	private final IBlockExpressionBuilder builder;

	public BlockExpressionSourceAppender(IBlockExpressionBuilder builder) {
		this.builder = builder;
	}

	/** Fill the given receiver with the serialization of the element that is associated to this appender.
	 *
	 * @param appender the receiver of the source code.
	 * @throws IOException if there is error during the serialization.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 550"
	 */
	public void build(ISourceAppender appender) throws IOException {
		build(this.builder.getXBlockExpression(), appender);
	}

	/** Find the reference to the type with the given name.
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 266"
	 */
	public JvmTypeReference newTypeRef(String typeName) {
		return this.builder.newTypeRef(typeName);
	}

	/** Find the reference to the type with the given name.
	 * @param context the context for the type reference use
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 294"
	 */
	public JvmTypeReference newTypeRef(Notifier context, String typeName) {
		return this.builder.newTypeRef(context, typeName);
	}

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 324"
	 */
	public JvmTypeReference newTypeRef(JvmType type, JvmTypeReference... args) {
		return this.builder.newTypeRef(type, args);
	}

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 356"
	 */
	public JvmTypeReference newTypeRef(Class type, JvmTypeReference... args) {
		return this.builder.newTypeRef(type, args);
	}

	/** Find the reference to the type with the given type parameters.
	 * @param context the contet in which the type is defined
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 390"
	 */
	public JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference... args) {
		return this.builder.newTypeRef(context, type, args);
	}

	/** Replies the context for type resolution.
	 * @return the context or {@code null} if the Ecore object is the context.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 435"
	 */
	public IJvmTypeProvider getTypeResolutionContext() {
		return this.builder.getTypeResolutionContext();
	}

	/** Create the XBlockExpression.
	 * @param context the context for type resolution.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 452"
	 */
	public void eInit(IJvmTypeProvider context) {
		this.builder.eInit(context);
	}

	/** Replies the string for "auto-generated" comments.
	 * @return the comment text.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 489"
	 */
	@Pure
	public String getAutoGeneratedActionString() {
		return this.builder.getAutoGeneratedActionString();
	}

	/** Replies the string for "auto-generated" comments.
	 * @param resource the resource for which the comment must be determined.
	 * @return the comment text.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 521"
	 */
	@Pure
	public String getAutoGeneratedActionString(Resource resource) {
		return this.builder.getAutoGeneratedActionString(resource);
	}

	/** An empty block expression.
	 * @return the block expression.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 571"
	 */
	@Pure
	public XBlockExpression getXBlockExpression() {
		return this.builder.getXBlockExpression();
	}

	/** Replies the resource to which the XBlockExpression is attached.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 600"
	 */
	@Pure
	public Resource eResource() {
		return getXBlockExpression().eResource();
	}

	/** Change the documentation of the element.
	 *
	 * <p>getXBlockExpression()
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	public IBlockExpressionBuilder setInnerDocumentation(String doc) {
		if (Strings.isEmpty(doc)) {
			getXBlockExpression().eAdapters().removeIf(new Predicate<Adapter>() {
				public boolean test(Adapter adapter) {
					return adapter.isAdapterForType(InnerBlockDocumentationAdapter.class);
				}
			});
		} else {
			InnerBlockDocumentationAdapter adapter = (InnerBlockDocumentationAdapter) EcoreUtil.getExistingAdapter(
					getXBlockExpression(), InnerBlockDocumentationAdapter.class);
			if (adapter == null) {
				adapter = new InnerBlockDocumentationAdapter();
				getXBlockExpression().eAdapters().add(adapter);
			}
			adapter.setDocumentation(doc);
		}
		return this;
	}

	/** Add an expression inside the block.
	 * @return the expression builder.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 632"
	 */
	public IExpressionBuilder addExpression() {
		return this.builder.addExpression();
	}

	/** Fill the block with the standard "auto-generated" content.
	 * <p>Any previously added content is removed.
	 * @param type the expected type of the block (the last instruction), or
	    {@code null} for no type.
	 * @return {@code this}
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 698"
	 */
	public IBlockExpressionBuilder setDefaultAutoGeneratedContent(String type) {
		this.builder.setDefaultAutoGeneratedContent(type);
		return this;
	}

	/** Fill the block with the standard "auto-generated" content.
	 * <p>Any previously added content is removed.
	 * @param type the expected type of the block (the last instruction), or
	    {@code null} for no type.
	 * @return {@code this}
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 764"
	 */
	public IBlockExpressionBuilder setDefaultAutoGeneratedContent(JvmTypeReference type) {
		this.builder.setDefaultAutoGeneratedContent(type);
		return this;
	}

	/** Fill the block with the standard "auto-generated" content assuming that there is no value to return.
	 * <p>Any previously added content is removed.
	 * @return {@code this}
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 826"
	 */
	public IBlockExpressionBuilder setDefaultAutoGeneratedContent() {
		this.builder.setDefaultAutoGeneratedContent();
		return this;
	}

	/**
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 856"
	 */
	@Override
	@Pure
	public String toString() {
		return this.builder.toString();
	}

	/** Dispose the resource.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 891"
	 */
	public void dispose() {
		this.builder.dispose();
	}

}

