/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.appenders;

import io.sarl.lang.codebuilder.builders.IExpressionBuilder;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl XExpression.
	 * @see "ExpressionBuilderFragment.java : appendTo : 188"
 */
@SuppressWarnings("all")
public class ExpressionSourceAppender extends AbstractSourceAppender implements IExpressionBuilder {

	private final IExpressionBuilder builder;

	public ExpressionSourceAppender(IExpressionBuilder builder) {
		this.builder = builder;
	}

	/** Fill the given receiver with the serialization of the element that is associated to this appender.
	 *
	 * @param appender the receiver of the source code.
	 * @throws IOException if there is error during the serialization.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 550"
	 */
	public void build(ISourceAppender appender) throws IOException {
		build(this.builder.getXExpression(), appender);
	}

	/** Find the reference to the type with the given name.
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 262"
	 */
	public JvmTypeReference newTypeRef(String typeName) {
		return this.builder.newTypeRef(typeName);
	}

	/** Find the reference to the type with the given name.
	 * @param context the context for the type reference use
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 290"
	 */
	public JvmTypeReference newTypeRef(Notifier context, String typeName) {
		return this.builder.newTypeRef(context, typeName);
	}

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 320"
	 */
	public JvmTypeReference newTypeRef(JvmType type, JvmTypeReference... args) {
		return this.builder.newTypeRef(type, args);
	}

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 352"
	 */
	public JvmTypeReference newTypeRef(Class type, JvmTypeReference... args) {
		return this.builder.newTypeRef(type, args);
	}

	/** Find the reference to the type with the given type parameters.
	 * @param context the context in which the type is defined
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 386"
	 */
	public JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference... args) {
		return this.builder.newTypeRef(context, type, args);
	}

	/** Replies the context for type resolution.
	 * @return the context or {@code null} if the Ecore object is the context.
	 * @see "ExpressionBuilderFragment.java : appendTo : 431"
	 */
	public IJvmTypeProvider getTypeResolutionContext() {
		return this.builder.getTypeResolutionContext();
	}

	/** Initialize the expression.
	 * @param context the context of the expressions.
	 * @param setter the object that permits to assign the expression to the context.
	 * @param typeContext the context for type resolution.
	 * @see "ExpressionBuilderFragment.java : appendTo : 452"
	 */
	public void eInit(EObject context, Procedure1<? super XExpression> setter, IJvmTypeProvider typeContext) {
		this.builder.eInit(context, setter, typeContext);
	}

	/** Replies the last created expression.
	 *
	 * @return the last created expression.
	 * @see "ExpressionBuilderFragment.java : appendTo : 495"
	 */
	@Pure
	public XExpression getXExpression() {
		return this.builder.getXExpression();
	}

	/** Replies the resource to which the XExpression is attached.
	 * @see "ExpressionBuilderFragment.java : appendTo : 524"
	 */
	@Pure
	public Resource eResource() {
		return this.builder.eResource();
	}

	/** Change the expression in the container.
	 *
	 * @param expression the textual representation of the expression.
	 * @return {@code this}
	 * @see "ExpressionBuilderFragment.java : appendTo : 567"
	 */
	public IExpressionBuilder setExpression(String expression) {
		this.builder.setExpression(expression);
		return this;
	}

	/** Change the expression in the container.
	 *
	 * @param expression the expression.
	 * @return {@code this}
	 * @see "ExpressionBuilderFragment.java : appendTo : 603"
	 */
	public IExpressionBuilder setXExpression(XExpression expression) {
		this.builder.setXExpression(expression);
		return this;
	}


	/** Replies the XExpression for the default value associated to the given type.
	 * @param type the type for which the default value should be determined.
	 * @return the default value.
	 * @see "ExpressionBuilderFragment.java : appendTo : 857"
	 */
	@Pure
	public XExpression getDefaultXExpressionForType(String type) {
		return this.builder.getDefaultXExpressionForType(type);
	}

	/** Replies the XExpression for the default value associated to the given type.
	 * @param type the type for which the default value should be determined.
	 * @return the default value.
	 * @see "ExpressionBuilderFragment.java : appendTo : 890"
	 */
	@Pure
	public XExpression getDefaultXExpressionForType(JvmTypeReference type) {
		return this.builder.getDefaultXExpressionForType(type);
	}

	/** Replies the default value for the given type.
	 * @param type the type for which the default value should be determined.
	 * @return the default value.
	 * @see "ExpressionBuilderFragment.java : appendTo : 925"
	 */
	@Pure
	public String getDefaultValueForType(String type) {
		return this.builder.getDefaultValueForType(type);
	}

	/** Replies the default value for the given type.
	 * @param type the type for which the default value should be determined.
	 * @return the default value.
	 * @see "ExpressionBuilderFragment.java : appendTo : 957"
	 */
	@Pure
	public String getDefaultValueForType(JvmTypeReference type) {
		return this.builder.getDefaultValueForType(type);
	}

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	public IExpressionBuilder setDocumentation(String doc) {
		this.builder.setDocumentation(doc);
		return this;
	}

	@Override
	@Pure
	public String toString() {
		return this.builder.toString();
	}

	/** Create a reference to "this" object or to the current type.
	 *
	 * @return the reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 1016"
	 */
	public XFeatureCall createReferenceToThis() {
		return this.builder.createReferenceToThis();
	}

	/** Create a reference to "super" object or to the super type.
	 *
	 * @return the reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 1074"
	 */
	public XFeatureCall createReferenceToSuper() {
		return this.builder.createReferenceToSuper();

	}

	/** Dispose the resource.
	 * @see "ExpressionBuilderFragment.java : appendTo : 1173"
	 */
	public void dispose() {
		this.builder.dispose();
	}

}

