/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.appenders;

import io.sarl.lang.codebuilder.builders.IExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IFormalParameterBuilder;
import io.sarl.lang.sarl.SarlFormalParameter;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.lib.Pure;

/** Appender of a Sarl formal parameter.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 177"
 */
@SuppressWarnings("all")
public class FormalParameterSourceAppender extends AbstractSourceAppender implements IFormalParameterBuilder {

	private final IFormalParameterBuilder builder;

	public FormalParameterSourceAppender(IFormalParameterBuilder builder) {
		this.builder = builder;
	}

	/** Fill the given receiver with the serialization of the element that is associated to this appender.
	 *
	 * @param appender the receiver of the source code.
	 * @throws IOException if there is error during the serialization.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 550"
	 */
	public void build(ISourceAppender appender) throws IOException {
		build(this.builder.getSarlFormalParameter(), appender);
	}

	/** Find the reference to the type with the given name.
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 271"
	 */
	public JvmTypeReference newTypeRef(String typeName) {
		return this.builder.newTypeRef(typeName);
	}

	/** Find the reference to the type with the given name.
	 * @param context the context for the type reference use
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 299"
	 */
	public JvmTypeReference newTypeRef(Notifier context, String typeName) {
		return this.builder.newTypeRef(context, typeName);
	}

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 329"
	 */
	public JvmTypeReference newTypeRef(JvmType type, JvmTypeReference... args) {
		return this.builder.newTypeRef(type, args);
	}

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 361"
	 */
	public JvmTypeReference newTypeRef(Class type, JvmTypeReference... args) {
		return this.builder.newTypeRef(type, args);
	}

	/** Find the reference to the type with the given type parameters.
	 * @param context the context in which the type is defined
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 395"
	 */
	public JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference... args) {
		return this.builder.newTypeRef(context, type, args);
	}

	/** Replies the context for type resolution.
	 * @return the context or {@code null} if the Ecore object is the context.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 440"
	 */
	public IJvmTypeProvider getTypeResolutionContext() {
		return this.builder.getTypeResolutionContext();
	}

	/** Initialize the formal parameter.
	 * @param context the context of the formal parameter.
	 * @param name the name of the formal parameter.
	 * @param typeContext the context for type resolution.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 461"
	 */
	public void eInit(XtendExecutable context, String name, IJvmTypeProvider typeContext) {
		this.builder.eInit(context, name, typeContext);
	}

	/** Replies the created parameter.
	 *
	 * @return the parameter.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 514"
	 */
	@Pure
	public SarlFormalParameter getSarlFormalParameter() {
		return this.builder.getSarlFormalParameter();
	}

	/** Add a reference to this formal parameter in the given container.
	 *
	 * @param container the feature call that is supposed to contains the replied identifiable element.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 553"
	 */
	public IFormalParameterBuilder setReferenceInto(XFeatureCall container) {
		this.builder.setReferenceInto(container);
		return this;
	}

	/** Replies the resource to which the formal parameter is attached.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 619"
	 */
	@Pure
	public Resource eResource() {
		return getSarlFormalParameter().eResource();
	}

	/** Change the type.
	 *
	 * @param type the formal parameter type.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 652"
	 */
	public IFormalParameterBuilder setParameterType(String type) {
		this.builder.setParameterType(type);
		return this;
	}

	/** Change the type.
	 *
	 * @param type the formal parameter type.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 706"
	 */
	public IFormalParameterBuilder setParameterType(JvmTypeReference type) {
		this.builder.setParameterType(type);
		return this;
	}

	/** Change the variadic property of the parameter.
	 *
	 * @param isVariadic indicates if the parameter is variadic.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 749"
	 */
	public IFormalParameterBuilder setVarArg(boolean isVariadic) {
		this.builder.setVarArg(isVariadic);
		return this;
	}

	/** Change the extension flag of the parameter.
	 *
	 * @param isExtension indicates if the parameter is defined as an extension.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 789"
	 */
	public IFormalParameterBuilder setExtension(boolean isExtension) {
		this.builder.setExtension(isExtension);
		return this;
	}

	/** Replies the default value of the parameter.
	 * @return the default value builder.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 825"
	 */
	@Pure
	public IExpressionBuilder getDefaultValue() {
		return this.builder.getDefaultValue();
	}

	/** Dispose the resource.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 923"
	 */
	public void dispose() {
		this.builder.dispose();
	}

}

