/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.appenders;

import io.sarl.lang.codebuilder.builders.IBlockExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IFormalParameterBuilder;
import io.sarl.lang.codebuilder.builders.ISarlActionBuilder;
import io.sarl.lang.codebuilder.builders.ITypeParameterBuilder;
import io.sarl.lang.sarl.SarlAction;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.lib.Pure;

/** Source appender of a Sarl SarlAction.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 194"
 */
@SuppressWarnings("all")
public class SarlActionSourceAppender extends AbstractSourceAppender implements ISarlActionBuilder {

	private final ISarlActionBuilder builder;

	public SarlActionSourceAppender(ISarlActionBuilder builder) {
		this.builder = builder;
	}

	/** Fill the given receiver with the serialization of the element that is associated to this appender.
	 *
	 * @param appender the receiver of the source code.
	 * @throws IOException if there is error during the serialization.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 550"
	 */
	public void build(ISourceAppender appender) throws IOException {
		build(this.builder.getSarlAction(), appender);
	}

	/** Find the reference to the type with the given name.
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 406"
	 */
	public JvmTypeReference newTypeRef(String typeName) {
		return this.builder.newTypeRef(typeName);
	}

	/** Find the reference to the type with the given name.
	 * @param context the context for the type reference use
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 434"
	 */
	public JvmTypeReference newTypeRef(Notifier context, String typeName) {
		return this.builder.newTypeRef(context, typeName);
	}

	/** Find the reference to the type and type parameters.
	 * @param type the type to reference
	 * @param args the type arguments to put in the reference to the given type
	 * @return the type reference.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 464"
	 */
	public JvmTypeReference newTypeRef(JvmType type, JvmTypeReference... args) {
		return this.builder.newTypeRef(type, args);
	}

	/** Find the reference to the type and type parameters.
	 * @param type the type to reference
	 * @param args the type arguments to put in the reference to the given type
	 * @return the type reference.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 496"
	 */
	public JvmTypeReference newTypeRef(Class type, JvmTypeReference... args) {
		return this.builder.newTypeRef(type, args);
	}

	/** Find the reference to the type and type parameters.
	 * @param context the context in which the type is defined
	 * @param type the type to reference
	 * @param args the type arguments to put in the reference to the given type
	 * @return the type reference.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 530"
	 */
	public JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference... args) {
		return this.builder.newTypeRef(context, type, args);
	}

	/** Dispose the resource.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 569"
	 */
	public void dispose() {
		this.builder.dispose();
	}

	/** Replies the context for type resolution.
	 * @return the context or {@code null} if the Ecore object is the context.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 598"
	 */
	public IJvmTypeProvider getTypeResolutionContext() {
		return this.builder.getTypeResolutionContext();
	}

	/** Initialize the Ecore element.
	 * @param container the container of the SarlAction.
	 * @param name the name of the SarlAction.
	 * @param modifier the major/default modifier to be associated to the member.
	 * @param context the context in which type resolution must be applied.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 632"
	 */
	public void eInit(EObject container, String name, String modifier, IJvmTypeProvider context) {
		this.builder.eInit(container, name, modifier, context);
	}

	/** Replies the generated element.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 962"
	 */
	@Pure
	public SarlAction getSarlAction() {
		return this.builder.getSarlAction();
	}

	/** Replies the resource.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 996"
	 */
	@Pure
	public Resource eResource() {
		return getSarlAction().eResource();
	}

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	public ISarlActionBuilder setDocumentation(String doc) {
		this.builder.setDocumentation(doc);
		return this;
	}

	/** Add a formal parameter.
	 * @param name the name of the formal parameter.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1114"
	 */
	public IFormalParameterBuilder addParameter(String name) {
		return this.builder.addParameter(name);
	}

	/** Add a throwable exception.
	 * @param type the fully qualified name of the exception.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1158"
	 */
	public ISarlActionBuilder addException(String type) {
		this.builder.addException(type);
		return this;
	}

	/** Add a throwable exception.
	 * @param type the exception.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1201"
	 */
	public ISarlActionBuilder addException(JvmTypeReference type) {
		this.builder.addException(type);
		return this;
	}

	/** Add a fired event.
	 * @param type the fully qualified name of the event.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1246"
	 */
	public ISarlActionBuilder addFiredEvent(String type) {
		this.builder.addFiredEvent(type);
		return this;
	}

	/** Add a fired event.
	 * @param type the event.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1287"
	 */
	public void addFiredEvent(JvmTypeReference type) {
		this.builder.addFiredEvent(type);
	}

	/** Change the return type.
	 @param type the return type of the member.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1329"
	 */
	public ISarlActionBuilder setReturnType(String type) {
		this.builder.setReturnType(type);
		return this;
	}

	/** Change the return type.
	 @param type the return type of the member.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1385"
	 */
	public ISarlActionBuilder setReturnType(JvmTypeReference type) {
		this.builder.setReturnType(type);
		return this;
	}

	/** Create the block of code.
	 * @return the block builder.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1445"
	 */
	public IBlockExpressionBuilder getExpression() {
		return this.builder.getExpression();
	}

	/** Add an annotation.
	 * @param type the qualified name of the annotation
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1508"
	 */
	public ISarlActionBuilder addAnnotation(String type) {
		this.builder.addAnnotation(type);
		return this;
	}

	/** Add an annotation.
	 * @param type the annotation type
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1552"
	 */
	public ISarlActionBuilder addAnnotation(JvmTypeReference type) {
		this.builder.addAnnotation(type);
		return this;
	}

	/** Add a modifier.
	 * @param modifier the modifier to add.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1602"
	 */
	public ISarlActionBuilder addModifier(String modifier) {
		this.builder.addModifier(modifier);
		return this;
	}

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1638"
	 */
	@Override
	@Pure
	public String toString() {
		return this.builder.toString();
	}

	/** Add a type parameter.
	 * @param name the simple name of the type parameter.
	 * @return the builder of type parameter.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1683"
	 */
	public ITypeParameterBuilder addTypeParameter(String name) {
		return this.builder.addTypeParameter(name);
	}

}

