/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlFormalParameter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl formal parameter.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 139"
 */
@SuppressWarnings("all")
public class FormalParameterBuilderImpl extends AbstractBuilder implements IFormalParameterBuilder {

	/**
	 * @see "FormalParameterBuilderFragment.java : appendTo : 217"
	 */
	@Inject
	private Provider<IExpressionBuilder> expressionProvider;

	/**
	 * @see "FormalParameterBuilderFragment.java : appendTo : 228"
	 */
	private XtendExecutable context;

	/**
	 * @see "FormalParameterBuilderFragment.java : appendTo : 234"
	 */
	private SarlFormalParameter parameter;

	/**
	 * @see "FormalParameterBuilderFragment.java : appendTo : 240"
	 */
	private IExpressionBuilder defaultValue;

	/**
	 * @see "FormalParameterBuilderFragment.java : appendTo : 246"
	 */
	@Inject
		private TypesFactory jvmTypesFactory;

	/**
	 * @see "FormalParameterBuilderFragment.java : appendTo : 255"
	 */
	@Inject
 private IFragmentProvider fragmentProvider;

	/** Initialize the formal parameter.
	 * @param context the context of the formal parameter.
	 * @param name the name of the formal parameter.
	 * @param typeContext the context for type resolution.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 461"
	 */
	public void eInit(XtendExecutable context, String name, IJvmTypeProvider typeContext) {
		setTypeResolutionContext(typeContext);
		this.context = context;
		this.parameter = SarlFactory.eINSTANCE.createSarlFormalParameter();
		this.parameter.setName(name);
		this.context.getParameters().add(this.parameter);
		this.parameter.setParameterType(newTypeRef(this.context, Object.class.getName()));
	}

	/** Replies the created parameter.
	 *
	 * @return the parameter.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 514"
	 */
	@Pure
	public SarlFormalParameter getSarlFormalParameter() {
		return this.parameter;
	}

	/** Add a reference to this formal parameter in the given container.
	 *
	 * @param container the feature call that is supposed to contains the replied identifiable element.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 553"
	 */
	public IFormalParameterBuilder setReferenceInto(XFeatureCall container) {
		JvmVoid jvmVoid = this.jvmTypesFactory.createJvmVoid();
		if (jvmVoid instanceof InternalEObject jvmVoidProxy) {
			final EObject param = getSarlFormalParameter();
			final Resource resource = param.eResource();
			// Get the derived object
			final SarlFormalParameter jvmParam = getAssociatedElement(SarlFormalParameter.class, param, resource, true);
			// Set the proxy URI
			final URI uri = EcoreUtil2.getNormalizedURI(jvmParam);
			jvmVoidProxy.eSetProxyURI(uri);
		}
		container.setFeature(jvmVoid);
		return this;
	}

	/** Replies the resource to which the formal parameter is attached.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 619"
	 */
	@Pure
	public Resource eResource() {
		return getSarlFormalParameter().eResource();
	}

	/** Change the type.
	 *
	 * @param type the formal parameter type.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 652"
	 */
	public IFormalParameterBuilder setParameterType(String type) {
		String typeName;
		if (Strings.isEmpty(type)) {
			typeName = Object.class.getName();
		} else {
			typeName = type;
		}
		this.parameter.setParameterType(newTypeRef(this.context, typeName));
		return this;
	}

	/** Change the type.
	 *
	 * @param type the formal parameter type.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 706"
	 */
	public IFormalParameterBuilder setParameterType(JvmTypeReference type) {
		this.parameter.setParameterType(type);
		return this;
	}

	/** Change the variadic property of the parameter.
	 *
	 * @param isVariadic indicates if the parameter is variadic.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 749"
	 */
	public IFormalParameterBuilder setVarArg(boolean isVariadic) {
		this.parameter.setVarArg(isVariadic);
		return this;
	}

	/** Change the extension flag of the parameter.
	 *
	 * @param isExtension indicates if the parameter is defined as an extension.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 789"
	 */
	public IFormalParameterBuilder setExtension(boolean isExtension) {
		this.parameter.setExtension(isExtension);
		return this;
	}

	/** Replies the default value of the parameter.
	 * @return the default value builder.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 825"
	 */
	@Pure
	public IExpressionBuilder getDefaultValue() {
		if (this.defaultValue == null) {
			this.defaultValue = this.expressionProvider.get();
			this.defaultValue.eInit(this.parameter, new Procedures.Procedure1<XExpression>() {
					public void apply(XExpression it) {
						getSarlFormalParameter().setDefaultValue(it);
					}
				}, getTypeResolutionContext());
		}
		return this.defaultValue;
	}

	/**
	 * @see "FormalParameterBuilderFragment.java : appendTo : 885"
	 */
	@Override
	@Pure
	public String toString() {
		return EmfFormatter.objToStr(getDefaultValue());
	}

}

