/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl XBlockExpression.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 112"
 */
@SuppressWarnings("all")
public interface IBlockExpressionBuilder {

	/** Find the reference to the type with the given name.
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 266"
	 */
	JvmTypeReference newTypeRef(String typeName);

	/** Find the reference to the type with the given name.
	 * @param context the context for the type reference use
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 294"
	 */
	JvmTypeReference newTypeRef(Notifier context, String typeName);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 324"
	 */
	JvmTypeReference newTypeRef(JvmType type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 356"
	 */
	JvmTypeReference newTypeRef(Class type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param context the contet in which the type is defined
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 390"
	 */
	JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference... args);

	/** Replies the context for type resolution.
	 * @return the context or {@code null} if the Ecore object is the context.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 422"
	 */
	IJvmTypeProvider getTypeResolutionContext();

	/** Create the XBlockExpression.
	 * @param context the context for type resolution.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 452"
	 */
	void eInit(IJvmTypeProvider context);

	/** Replies the string for "auto-generated" comments.
	 * @return the comment text.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 489"
	 */
	@Pure
	String getAutoGeneratedActionString();

	/** Replies the string for "auto-generated" comments.
	 * @param resource the resource for which the comment must be determined.
	 * @return the comment text.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 521"
	 */
	@Pure
	String getAutoGeneratedActionString(Resource resource);

	/** An empty block expression.
	 * @return the block expression.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 571"
	 */
	@Pure
	XBlockExpression getXBlockExpression();

	/** Replies the resource to which the XBlockExpression is attached.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 600"
	 */
	@Pure
	Resource eResource();

	/** Change the documentation of the element.
	 *
	 * <p>getXBlockExpression()
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	IBlockExpressionBuilder setInnerDocumentation(String doc);

	/** Add an expression inside the block.
	 * @return the expression builder.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 632"
	 */
	IExpressionBuilder addExpression();

	/** Fill the block with the standard "auto-generated" content.
	 * <p>Any previously added content is removed.
	 * @param type the expected type of the block (the last instruction), or
	    {@code null} for no type.
	 * @return {@code this}
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 698"
	 */
	IBlockExpressionBuilder setDefaultAutoGeneratedContent(String type);

	/** Fill the block with the standard "auto-generated" content.
	 * <p>Any previously added content is removed.
	 * @param type the expected type of the block (the last instruction), or
	    {@code null} for no type.
	 * @return {@code this}
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 764"
	 */
	IBlockExpressionBuilder setDefaultAutoGeneratedContent(JvmTypeReference type);

	/** Fill the block with the standard "auto-generated" content assuming that there is no value to return.
	 * <p>Any previously added content is removed.
	 * @return {@code this}
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 826"
	 */
	IBlockExpressionBuilder setDefaultAutoGeneratedContent();

	/** Dispose the resource.
	 * @see "BlockExpressionBuilderFragment.java : appendTo : 882"
	 */
	void dispose();

}

