/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl XExpression.
	 * @see "ExpressionBuilderFragment.java : appendTo : 122"
 */
@SuppressWarnings("all")
public interface IExpressionBuilder {

	/** Find the reference to the type with the given name.
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 262"
	 */
	JvmTypeReference newTypeRef(String typeName);

	/** Find the reference to the type with the given name.
	 * @param context the context for the type reference use
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 290"
	 */
	JvmTypeReference newTypeRef(Notifier context, String typeName);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 320"
	 */
	JvmTypeReference newTypeRef(JvmType type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 352"
	 */
	JvmTypeReference newTypeRef(Class type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param context the context in which the type is defined
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 386"
	 */
	JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference... args);

	/** Replies the context for type resolution.
	 * @return the context or {@code null} if the Ecore object is the context.
	 * @see "ExpressionBuilderFragment.java : appendTo : 418"
	 */
	IJvmTypeProvider getTypeResolutionContext();

	/** Initialize the expression.
	 * @param context the context of the expressions.
	 * @param setter the object that permits to assign the expression to the context.
	 * @param typeContext the context for type resolution.
	 * @see "ExpressionBuilderFragment.java : appendTo : 452"
	 */
	void eInit(EObject context, Procedure1<? super XExpression> setter, IJvmTypeProvider typeContext);

	/** Replies the last created expression.
	 *
	 * @return the last created expression.
	 * @see "ExpressionBuilderFragment.java : appendTo : 495"
	 */
	@Pure
	XExpression getXExpression();

	/** Replies the resource to which the XExpression is attached.
	 * @see "ExpressionBuilderFragment.java : appendTo : 524"
	 */
	@Pure
	Resource eResource();

	/** Change the expression in the container.
	 *
	 * @param expression the textual representation of the expression.
	 * @return {@code this}
	 * @see "ExpressionBuilderFragment.java : appendTo : 567"
	 */
	IExpressionBuilder setExpression(String expression);

	/** Change the expression in the container.
	 *
	 * @param expression the expression.
	 * @return {@code this}
	 * @see "ExpressionBuilderFragment.java : appendTo : 603"
	 */
	IExpressionBuilder setXExpression(XExpression expression);


	/** Replies the XExpression for the default value associated to the given type.
	 * @param type the type for which the default value should be determined.
	 * @return the default value.
	 * @see "ExpressionBuilderFragment.java : appendTo : 857"
	 */
	@Pure
	XExpression getDefaultXExpressionForType(String type);

	/** Replies the XExpression for the default value associated to the given type.
	 * @param type the type for which the default value should be determined.
	 * @return the default value.
	 * @see "ExpressionBuilderFragment.java : appendTo : 890"
	 */
	@Pure
	XExpression getDefaultXExpressionForType(JvmTypeReference type);

	/** Replies the default value for the given type.
	 * @param type the type for which the default value should be determined.
	 * @return the default value.
	 * @see "ExpressionBuilderFragment.java : appendTo : 925"
	 */
	@Pure
	String getDefaultValueForType(String type);

	/** Replies the default value for the given type.
	 * @param type the type for which the default value should be determined.
	 * @return the default value.
	 * @see "ExpressionBuilderFragment.java : appendTo : 957"
	 */
	@Pure
	String getDefaultValueForType(JvmTypeReference type);

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	IExpressionBuilder setDocumentation(String doc);

	/** Create a reference to "this" object or to the current type.
	 *
	 * @return the reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 1016"
	 */
	XFeatureCall createReferenceToThis();

	/** Create a reference to "super" object or to the super type.
	 *
	 * @return the reference.
	 * @see "ExpressionBuilderFragment.java : appendTo : 1074"
	 */
	XFeatureCall createReferenceToSuper();

	/** Dispose the resource.
	 * @see "ExpressionBuilderFragment.java : appendTo : 1164"
	 */
	void dispose();

}

