/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import io.sarl.lang.sarl.SarlFormalParameter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl formal parameter.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 108"
 */
@SuppressWarnings("all")
public interface IFormalParameterBuilder {

	/** Find the reference to the type with the given name.
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 271"
	 */
	JvmTypeReference newTypeRef(String typeName);

	/** Find the reference to the type with the given name.
	 * @param context the context for the type reference use
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 299"
	 */
	JvmTypeReference newTypeRef(Notifier context, String typeName);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 329"
	 */
	JvmTypeReference newTypeRef(JvmType type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 361"
	 */
	JvmTypeReference newTypeRef(Class type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param context the context in which the type is defined
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 395"
	 */
	JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference... args);

	/** Replies the context for type resolution.
	 * @return the context or {@code null} if the Ecore object is the context.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 427"
	 */
	IJvmTypeProvider getTypeResolutionContext();

	/** Initialize the formal parameter.
	 * @param context the context of the formal parameter.
	 * @param name the name of the formal parameter.
	 * @param typeContext the context for type resolution.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 461"
	 */
	void eInit(XtendExecutable context, String name, IJvmTypeProvider typeContext);

	/** Replies the created parameter.
	 *
	 * @return the parameter.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 514"
	 */
	@Pure
	SarlFormalParameter getSarlFormalParameter();

	/** Add a reference to this formal parameter in the given container.
	 *
	 * @param container the feature call that is supposed to contains the replied identifiable element.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 553"
	 */
	IFormalParameterBuilder setReferenceInto(XFeatureCall container) ;

	/** Replies the resource to which the formal parameter is attached.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 619"
	 */
	@Pure
	Resource eResource();

	/** Change the type.
	 *
	 * @param type the formal parameter type.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 652"
	 */
	IFormalParameterBuilder setParameterType(String type);

	/** Change the type.
	 *
	 * @param type the formal parameter type.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 706"
	 */
	IFormalParameterBuilder setParameterType(JvmTypeReference type);

	/** Change the variadic property of the parameter.
	 *
	 * @param isVariadic indicates if the parameter is variadic.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 749"
	 */
	IFormalParameterBuilder setVarArg(boolean isVariadic);

	/** Change the extension flag of the parameter.
	 *
	 * @param isExtension indicates if the parameter is defined as an extension.
	 * @return {@code this}
	 * @see "FormalParameterBuilderFragment.java : appendTo : 789"
	 */
	IFormalParameterBuilder setExtension(boolean isExtension);

	/** Replies the default value of the parameter.
	 * @return the default value builder.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 825"
	 */
	@Pure
	IExpressionBuilder getDefaultValue();

	/** Dispose the resource.
	 * @see "FormalParameterBuilderFragment.java : appendTo : 914"
	 */
	void dispose();

}

