/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlScript;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl SarlEvent.
	 * @see "TopElementBuilderFragment.java : appendTo : 303"
 */
@SuppressWarnings("all")
public interface ISarlEventBuilder {

	/** Find the reference to the type with the given name.
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "TopElementBuilderFragment.java : appendTo : 1426"
	 */
	JvmTypeReference newTypeRef(String typeName);

	/** Find the reference to the type with the given name.
	 * @param context the context for the type reference use
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "TopElementBuilderFragment.java : appendTo : 1454"
	 */
	JvmTypeReference newTypeRef(Notifier context, String typeName);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "TopElementBuilderFragment.java : appendTo : 1484"
	 */
	JvmTypeReference newTypeRef(JvmType type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "TopElementBuilderFragment.java : appendTo : 1516"
	 */
	JvmTypeReference newTypeRef(Class type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param context the context in which the type is defined
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "TopElementBuilderFragment.java : appendTo : 1550"
	 */
	JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference... args);

	/** Replies the context for type resolution.
	 * @return the context or {@code null} if the Ecore object is the context.
	 * @see "TopElementBuilderFragment.java : appendTo : 1582"
	 */
	IJvmTypeProvider getTypeResolutionContext();

	/** Dispose the resource.
	 * @see "TopElementBuilderFragment.java : appendTo : 1604"
	 */
	void dispose();

	/** Initialize the Ecore element when inside a script.
	 * @param script the SARL script in which this SarlEvent is added.
	 * @param name the simple name of the SarlEvent.
	 * @param context the context in which the resolution of types must be done.
	 * @see "TopElementBuilderFragment.java : appendTo : 1662"
	 */
	void eInit(SarlScript script, String name, IJvmTypeProvider context);

	/** Replies the generated SarlEvent.
	 * @see "TopElementBuilderFragment.java : appendTo : 1798"
	 */
	@Pure
	SarlEvent getSarlEvent();

	/** Replies the reference to the generated SarlAgent.
	 * @param args the generic type arguments to put inside the reference.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1838"
	 */
	@Pure
	public JvmTypeReference getSarlEventReference(JvmTypeReference... args);

	/** Replies the JVM declared type for this generated SarlEvent.
	 * @return the type, never {@code null}.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1893"
	 */
	@Pure
	JvmDeclaredType getJvmDeclaredType();

	/** Replies the resource to which the SarlEvent is attached.
	 * @see "TopElementBuilderFragment.java : appendTo : 1928"
	 */
	@Pure
	Resource eResource();

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	ISarlEventBuilder setDocumentation(String doc);

	/** Change the super type.
	 * @param superType the qualified name of the super type,
	 *     or {@code null} if the default type.
	 * @return {@code this}
	 * @see "TopElementBuilderFragment.java : appendTo : 1984"
	 */
	ISarlEventBuilder setExtends(String superType);

	/** Change the super type.
	 * @param superType the super type,
	 *     or {@code null} if the default type.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 2085"
	 */
	ISarlEventBuilder setExtends(JvmTypeReference superType);

	/** Add a modifier.
	 * @param modifier the modifier to add.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 2492"
	 */
	ISarlEventBuilder addModifier(String modifier);

	/** Add a type parameter.
	 * @param name the simple name of the type parameter.
	 * @return the builder of type parameter.
	 * @see "TopElementBuilderFragment.java : appendTo : 2546"
	 */
	ITypeParameterBuilder addTypeParameter(String name);

	/** Create a SarlConstructor.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	ISarlConstructorBuilder addSarlConstructor();

	/** Create a SarlField.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	ISarlFieldBuilder addVarSarlField(String name);

	/** Create a SarlField.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	ISarlFieldBuilder addValSarlField(String name);

	/** Create a SarlField.	 *
	 * <p>This function is equivalent to {@link #addVarSarlField}.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 706"
	 */
	ISarlFieldBuilder addSarlField(String name);

}

