/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import io.sarl.lang.sarl.SarlScript;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of Sarl scripts.
 *
 * <p>This builder is provided for helping to create Sarl Ecore elements.
 *
 * <p>Do not forget to invoke {@link #finalizeScript()} for creating imports, etc.
	 * @see "ScriptBuilderFragment.java : appendTo : 566"
 */
@SuppressWarnings("all")
public interface IScriptBuilder {

	/** Find the reference to the type with the given name.
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "ScriptBuilderFragment.java : appendTo : 702"
	 */
	JvmTypeReference newTypeRef(String typeName);

	/** Find the reference to the type with the given name.
	 * @param context the context for the type reference use
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "ScriptBuilderFragment.java : appendTo : 730"
	 */
	JvmTypeReference newTypeRef(Notifier context, String typeName);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "ScriptBuilderFragment.java : appendTo : 760"
	 */
	JvmTypeReference newTypeRef(JvmType type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "ScriptBuilderFragment.java : appendTo : 792"
	 */
	JvmTypeReference newTypeRef(Class type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param context the context in which the type is defined
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "ScriptBuilderFragment.java : appendTo : 826"
	 */
	JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference... args);

	/** Replies the context for type resolution.
	 * @return the context or {@code null} if the Ecore object is the context.
	 * @see "ScriptBuilderFragment.java : appendTo : 858"
	 */
	IJvmTypeProvider getTypeResolutionContext();

	/** Create the internal Sarl script.
	 * @param resource the Ecore resource in which the SARL script is located.
	 * @param packageName the fully-qualified name of the package of the script.
	 * @param context the context in which all the type resolutions must be done.
	 * @see "ScriptBuilderFragment.java : appendTo : 924"
	 */
	void eInit(Resource resource, String packageName, IJvmTypeProvider context);

	/** Replies the Sarl script.
	 * @see "ScriptBuilderFragment.java : appendTo : 985"
	 */
	@Pure
	SarlScript getScript();

	/** Replies the resource to which the script is attached.
	 * @see "ScriptBuilderFragment.java : appendTo : 1014"
	 */
	@Pure
	Resource eResource();

	/** Finalize the script.
	 *
	 * <p>The finalization includes: <ul>
	 * <li>The import section is created.</li>
	 * </ul>
	 * @see "ScriptBuilderFragment.java : appendTo : 1047"
	 */
	void finalizeScript();

	/** Replies if the script was finalized.
	 * @see "ScriptBuilderFragment.java : appendTo : 1148"
	 */
	boolean isFinalized();

	/** Create a SarlEvent builder.
	 * @param name the name of the SarlEvent.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlEventBuilder addSarlEvent(String name);

	/** Create a SarlCapacity builder.
	 * @param name the name of the SarlCapacity.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlCapacityBuilder addSarlCapacity(String name);

	/** Create a SarlAgent builder.
	 * @param name the name of the SarlAgent.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlAgentBuilder addSarlAgent(String name);

	/** Create a SarlBehavior builder.
	 * @param name the name of the SarlBehavior.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlBehaviorBuilder addSarlBehavior(String name);

	/** Create a SarlSkill builder.
	 * @param name the name of the SarlSkill.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlSkillBuilder addSarlSkill(String name);

	/** Create a SarlSpace builder.
	 * @param name the name of the SarlSpace.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlSpaceBuilder addSarlSpace(String name);

	/** Create a SarlArtifact builder.
	 * @param name the name of the SarlArtifact.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlArtifactBuilder addSarlArtifact(String name);

	/** Create a SarlClass builder.
	 * @param name the name of the SarlClass.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlClassBuilder addSarlClass(String name);

	/** Create a SarlInterface builder.
	 * @param name the name of the SarlInterface.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlInterfaceBuilder addSarlInterface(String name);

	/** Create a SarlEnumeration builder.
	 * @param name the name of the SarlEnumeration.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlEnumerationBuilder addSarlEnumeration(String name);

	/** Create a SarlAnnotationType builder.
	 * @param name the name of the SarlAnnotationType.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	ISarlAnnotationTypeBuilder addSarlAnnotationType(String name);

}

