/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl type parameter.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 101"
 */
@SuppressWarnings("all")
public interface ITypeParameterBuilder {

	/** Find the reference to the type with the given name.
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 239"
	 */
	JvmTypeReference newTypeRef(String typeName);

	/** Find the reference to the type with the given name.
	 * @param context the context for the type reference use
	 * @param typeName the fully qualified name of the type
	 * @return the type reference.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 267"
	 */
	JvmTypeReference newTypeRef(Notifier context, String typeName);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 297"
	 */
	JvmTypeReference newTypeRef(JvmType type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 329"
	 */
	JvmTypeReference newTypeRef(Class type, JvmTypeReference... args);

	/** Find the reference to the type with the given type parameters.
	 * @param context the context in which the type is defined
	 * @param type the type to reference
	 * @param args the type parameters to add to the to reference to the given type
	 * @return the type reference.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 363"
	 */
	JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference... args);

	/** Initialize the type parameter.
	 * <p>Caution: This initialization function does not add the type parameter in its container.
	 * The container is responsible of adding the type parameter in its internal object.
	 * However, this function sets the declarator of the type parameter by calling
	 * {@link JvmTypeParameter#setDeclarator(JvmTypeParameterDeclarator)}.
	 * @param context the container of the type parameter.
	 * @param declarator the container of the type parameter.
	 * @param name the name of the type parameter.
	 * @param typeContext the provider of types or null.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 408"
	 */
	void eInit(XtendTypeDeclaration context, JvmTypeParameterDeclarator declarator, String name, IJvmTypeProvider typeContext);

	/** Initialize the type parameter.
	 * <p>Caution: This initialization function does not add the type parameter in its container.
	 * The container is responsible of adding the type parameter in its internal object.
	 * However, this function sets the declarator of the type parameter by calling
	 * {@link JvmTypeParameter#setDeclarator(JvmTypeParameterDeclarator)}.
	 * @param context the container of the type parameter.
	 * @param declarator the container of the type parameter.
	 * @param name the name of the type parameter.
	 * @param typeContext the provider of types or null.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 455"
	 */
	void eInit(XtendExecutable context, JvmTypeParameterDeclarator declarator, String name, IJvmTypeProvider typeContext);

	/** Replies the context for type resolution.
	 * @return the context or {@code null} if the Ecore object is the context.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 533"
	 */
	IJvmTypeProvider getTypeResolutionContext();

	/** Replies the created parameter.
	 *
	 * @return the parameter.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 565"
	 */
	@Pure
	JvmTypeParameter getJvmTypeParameter();

	/** Replies a reference to the created parameter.
	 *
	 * @return the reference to the parameter.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 602"
	 */
	@Pure
	JvmTypeReference getJvmTypeParameterReference();

	/** Replies the resource to which the type parameter is attached.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 635"
	 */
	@Pure
	Resource eResource();

	/** Dispose the resource.
	 * @see "TypeParameterBuilderFragment.java : appendTo : 689"
	 */
	void dispose();

	/** Add upper type bounds.
	 * @param type the type.
	 * @return {@code this}
	 * @see "TypeParameterBuilderFragment.java : appendTo : 716"
	 */
	ITypeParameterBuilder addUpperConstraint(String type);

	/** Add upper type bounds.
	 * @param type the type.
	 * @return {@code this}
	 * @see "TypeParameterBuilderFragment.java : appendTo : 749"
	 */
	ITypeParameterBuilder addUpperConstraint(JvmTypeReference type);

	/** Add lower type bounds.
	 * @param type the type.
	 * @return {@code this}
	 * @see "TypeParameterBuilderFragment.java : appendTo : 801"
	 */
	ITypeParameterBuilder addLowerConstraint(String type);

	/** Add lower type bounds.
	 * @param type the type.
	 * @return {@code this}
	 * @see "TypeParameterBuilderFragment.java : appendTo : 834"
	 */
	ITypeParameterBuilder addLowerConstraint(JvmTypeReference type);

}

