/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlFactory;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsFactory;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl SarlAction.
 * AbstractMemberBuilderFragment.java : appendTo : 154 */
@SuppressWarnings("all")
public class SarlActionBuilderImpl extends AbstractBuilder implements ISarlActionBuilder {

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 323"
	 */
	@Inject
	private Provider<IFormalParameterBuilder> parameterProvider;

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 336"
	 */
	@Inject
	private Provider<IBlockExpressionBuilder> blockExpressionProvider;

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 361"
	 */
	private EObject container;

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 367"
	 */
	private SarlAction sarlAction;

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 376"
	 */
	private IBlockExpressionBuilder internalBlockExpression;

	/** Initialize the Ecore element.
	 * @param container the container of the SarlAction.
	 * @param name the name of the SarlAction.
	 * @param modifier the major/default modifier to be associated to the member.
	 * @param context the context in which type resolution must be applied.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 632"
	 */
	public void eInit(EObject container, String name, String modifier, IJvmTypeProvider context) {
		// Generator code: AbstractMemberBuilderFragment.java : appendTo : 742
		if (this.sarlAction == null) {
			this.sarlAction = SarlFactory.eINSTANCE.createSarlAction();
			internalEInit(container, context);
			this.sarlAction.setName(name);
			if (Strings.equal(modifier, "def")
				|| Strings.equal(modifier, "override")) {
				this.sarlAction.getModifiers().add(modifier);
			} else {
				throw new IllegalStateException("Invalid modifier");
			}
		}
	}

	private void internalEInit(EObject container, IJvmTypeProvider context) {
		// Generator code: AbstractMemberBuilderFragment.java : appendTo : 919
		assert this.sarlAction != null;
		setTypeResolutionContext(context);
		this.container = container;
		this.sarlAction.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendMember());
		if (container instanceof XtendTypeDeclaration typeDeclaration) {
			typeDeclaration.getMembers().add(this.sarlAction);
			this.sarlAction.setDeclaringType(typeDeclaration);
		}
	}

	/** Replies the generated element.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 962"
	 */
	@Pure
	public SarlAction getSarlAction() {
		return this.sarlAction;
	}

	/** Replies the resource.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 996"
	 */
	@Pure
	public Resource eResource() {
		return getSarlAction().eResource();
	}

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	public ISarlActionBuilder setDocumentation(String doc) {
		if (Strings.isEmpty(doc)) {
			getSarlAction().eAdapters().removeIf(new Predicate<Adapter>() {
				public boolean test(Adapter adapter) {
					return adapter.isAdapterForType(DocumentationAdapter.class);
				}
			});
		} else {
			DocumentationAdapter adapter = (DocumentationAdapter) EcoreUtil.getExistingAdapter(
					getSarlAction(), DocumentationAdapter.class);
			if (adapter == null) {
				adapter = new DocumentationAdapter();
				getSarlAction().eAdapters().add(adapter);
			}
			adapter.setDocumentation(doc);
		}
		return this;
	}

	/** Add a formal parameter.
	 * @param name the name of the formal parameter.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1114"
	 */
	public IFormalParameterBuilder addParameter(String name) {
		IFormalParameterBuilder builder = this.parameterProvider.get();
		builder.eInit(this.sarlAction, name, getTypeResolutionContext());
		return builder;
	}

	/** Add a throwable exception.
	 * @param type the fully qualified name of the exception.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1158"
	 */
	public ISarlActionBuilder addException(String type) {
		JvmTypeReference ref = newTypeRef(this.container, type);
		addException(ref);
		return this;
	}

	/** Add a throwable exception.
	 * @param type the exception.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1201"
	 */
	public ISarlActionBuilder addException(JvmTypeReference type) {
		this.sarlAction.getExceptions().add(type);
		return this;
	}

	/** Add a fired event.
	 * @param type the fully qualified name of the event.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1246"
	 */
	public ISarlActionBuilder addFiredEvent(String type) {
		JvmTypeReference ref = newTypeRef(this.container, type);
		addFiredEvent(ref);
		return this;
	}

	/** Add a fired event.
	 * @param type the event.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1287"
	 */
	public void addFiredEvent(JvmTypeReference type) {
		this.sarlAction.getFiredEvents().add(type);
	}

	/** Change the return type.
	 @param type the return type of the member.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1329"
	 */
	public ISarlActionBuilder setReturnType(String type) {
		if (!Strings.isEmpty(type)) {
			JvmTypeReference ref = newTypeRef(container, type);
			setReturnType(ref);
		} else {
			setReturnType((JvmTypeReference) null);
		}
		return this;
	}

	/** Change the return type.
	 @param type the return type of the member.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1385"
	 */
	public ISarlActionBuilder setReturnType(JvmTypeReference type) {
		if (type != null && !Objects.equals("void", type.getType().getIdentifier())
				&& !Objects.equals(Void.class.getName(), type.getType().getIdentifier())) {
			this.sarlAction.setReturnType(type);
		} else {
			this.sarlAction.setReturnType(null);
		}
		return this;
	}

	/** Create the block of code.
	 * @return the block builder.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1445"
	 */
	public IBlockExpressionBuilder getExpression() {
		IBlockExpressionBuilder block = this.internalBlockExpression;
		if (block == null) {
			block = this.blockExpressionProvider.get();
			block.eInit(getTypeResolutionContext());
			XBlockExpression expr = block.getXBlockExpression();
			this.sarlAction.setExpression(expr);
			this.internalBlockExpression = block;
		}
		return block;
	}

	/** Add an annotation.
	 * @param type the qualified name of the annotation
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1508"
	 */
	public ISarlActionBuilder addAnnotation(String type) {
		if (!Strings.isEmpty(type)) {
			JvmTypeReference ref = newTypeRef(getSarlAction(), type);
			addAnnotation(ref);
		}
		return this;
	}

	/** Add an annotation.
	 * @param type the annotation type
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1552"
	 */
	public ISarlActionBuilder addAnnotation(JvmTypeReference type) {
		if (type != null) {
			XAnnotation annotation = XAnnotationsFactory.eINSTANCE.createXAnnotation();
			annotation.setAnnotationType(type.getType());
			getSarlAction().getAnnotations().add(annotation);
		}
		return this;
	}

	/** Add a modifier.
	 * @param modifier the modifier to add.
	 * @return {@code this}
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1602"
	 */
	public ISarlActionBuilder addModifier(String modifier) {
		if (!Strings.isEmpty(modifier)) {
			getSarlAction().getModifiers().add(modifier);
		}
		return this;
	}

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1638"
	 */
	@Override
	@Pure
	public String toString() {
		return EmfFormatter.objToStr(getSarlAction());
	}

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1665"
	 */
	@Inject
	private Provider<ITypeParameterBuilder> iTypeParameterBuilderProvider;

	/** Add a type parameter.
	 * @param name the simple name of the type parameter.
	 * @return the builder of type parameter.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1683"
	 */
	public ITypeParameterBuilder addTypeParameter(String name) {
		ITypeParameterBuilder builder = this.iTypeParameterBuilderProvider.get();
		final SarlAction object = getSarlAction();
		builder.eInit(object, getExecutableReferenceFor(object), name, getTypeResolutionContext());
		object.getTypeParameters().add(builder.getJvmTypeParameter());
		return builder;
	}

}

