/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlFactory;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl SarlBehaviorUnit.
 * AbstractMemberBuilderFragment.java : appendTo : 154 */
@SuppressWarnings("all")
public class SarlBehaviorUnitBuilderImpl extends AbstractBuilder implements ISarlBehaviorUnitBuilder {

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 336"
	 */
	@Inject
	private Provider<IBlockExpressionBuilder> blockExpressionProvider;

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 349"
	 */
	@Inject
	private Provider<IExpressionBuilder> expressionProvider;

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 361"
	 */
	private EObject container;

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 367"
	 */
	private SarlBehaviorUnit sarlBehaviorUnit;

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 376"
	 */
	private IBlockExpressionBuilder internalBlockExpression;

	/** Initialize the Ecore element.
	 * @param container the container of the SarlBehaviorUnit.
	 * @param name the type of the SarlBehaviorUnit.
	 * @param context the context in which type resolution must be applied.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 632"
	 */
	public void eInit(EObject container, String name, IJvmTypeProvider context) {
		// Generator code: AbstractMemberBuilderFragment.java : appendTo : 666
		if (this.sarlBehaviorUnit == null) {
			this.sarlBehaviorUnit = SarlFactory.eINSTANCE.createSarlBehaviorUnit();
			internalEInit(container, context);
			JvmTypeReference ref = newTypeRef(container, name);
			if (ref instanceof JvmParameterizedTypeReference pref) {
				this.sarlBehaviorUnit.setName(pref);
			} else {
				throw new IllegalArgumentException(name);
			}
		}
	}

	/** Initialize the Ecore element.
	 * @param container the container of the SarlBehaviorUnit.
	 * @param name the type of the SarlBehaviorUnit.
	 * @param context the context in which type resolution must be applied.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 816"
	 */
	public void eInit(EObject container, JvmParameterizedTypeReference name, IJvmTypeProvider context) {
		// Generator code: AbstractMemberBuilderFragment.java : appendTo : 846
		if (this.sarlBehaviorUnit == null) {
			this.sarlBehaviorUnit = SarlFactory.eINSTANCE.createSarlBehaviorUnit();
			internalEInit(container, context);
			this.sarlBehaviorUnit.setName(name);
		}
	}

	private void internalEInit(EObject container, IJvmTypeProvider context) {
		// Generator code: AbstractMemberBuilderFragment.java : appendTo : 919
		assert this.sarlBehaviorUnit != null;
		setTypeResolutionContext(context);
		this.container = container;
		this.sarlBehaviorUnit.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendMember());
		if (container instanceof XtendTypeDeclaration typeDeclaration) {
			typeDeclaration.getMembers().add(this.sarlBehaviorUnit);
			this.sarlBehaviorUnit.setDeclaringType(typeDeclaration);
		}
	}

	/** Replies the generated element.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 962"
	 */
	@Pure
	public SarlBehaviorUnit getSarlBehaviorUnit() {
		return this.sarlBehaviorUnit;
	}

	/** Replies the resource.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 996"
	 */
	@Pure
	public Resource eResource() {
		return getSarlBehaviorUnit().eResource();
	}

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	public ISarlBehaviorUnitBuilder setDocumentation(String doc) {
		if (Strings.isEmpty(doc)) {
			getSarlBehaviorUnit().eAdapters().removeIf(new Predicate<Adapter>() {
				public boolean test(Adapter adapter) {
					return adapter.isAdapterForType(DocumentationAdapter.class);
				}
			});
		} else {
			DocumentationAdapter adapter = (DocumentationAdapter) EcoreUtil.getExistingAdapter(
					getSarlBehaviorUnit(), DocumentationAdapter.class);
			if (adapter == null) {
				adapter = new DocumentationAdapter();
				getSarlBehaviorUnit().eAdapters().add(adapter);
			}
			adapter.setDocumentation(doc);
		}
		return this;
	}

	/** Create the block of code.
	 * @return the block builder.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1445"
	 */
	public IBlockExpressionBuilder getExpression() {
		IBlockExpressionBuilder block = this.internalBlockExpression;
		if (block == null) {
			block = this.blockExpressionProvider.get();
			block.eInit(getTypeResolutionContext());
			XBlockExpression expr = block.getXBlockExpression();
			this.sarlBehaviorUnit.setExpression(expr);
			this.internalBlockExpression = block;
		}
		return block;
	}

	/**
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1638"
	 */
	@Override
	@Pure
	public String toString() {
		return EmfFormatter.objToStr(getSarlBehaviorUnit());
	}

	/** Replies the guard.
	 * @return the value of the guard. It may be {@code null}.
	 * @see "AbstractMemberBuilderFragment.java : appendTo : 1729"
	 */
	@Pure
	public IExpressionBuilder getGuard() {
		IExpressionBuilder exprBuilder = this.expressionProvider.get();
		exprBuilder.eInit(getSarlBehaviorUnit(), new Procedures.Procedure1<XExpression>() {
				public void apply(XExpression expr) {
					getSarlBehaviorUnit().setGuard(expr);
				}
			}, getTypeResolutionContext());
		return exprBuilder;
	}

}

