/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlScript;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl SarlCapacity.
	 * @see "TopElementBuilderFragment.java : appendTo : 410"
 */
@SuppressWarnings("all")
public class SarlCapacityBuilderImpl extends AbstractBuilder implements ISarlCapacityBuilder {

	private SarlCapacity sarlCapacity;

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 1625"
	 */
	@Override
	@Pure
	public String toString() {
		return EmfFormatter.objToStr(getSarlCapacity());
	}

	/** Initialize the Ecore element when inside a script.
	 * @param script the SARL script in which this SarlCapacity is added.
	 * @param name the simple name of the SarlCapacity.
	 * @param context the context in which the resolution of types must be done.
	 * @see "TopElementBuilderFragment.java : appendTo : 1662"
	 */
	public void eInit(SarlScript script, String name, IJvmTypeProvider context) {
		setTypeResolutionContext(context);
		if (this.sarlCapacity == null) {
			this.sarlCapacity = SarlFactory.eINSTANCE.createSarlCapacity();
			this.sarlCapacity.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendTypeDeclaration());
			this.sarlCapacity.setName(name);
			script.getXtendTypes().add(this.sarlCapacity);
		}
	}

	/** Replies the generated SarlCapacity.
	 * @see "TopElementBuilderFragment.java : appendTo : 1798"
	 */
	@Pure
	public SarlCapacity getSarlCapacity() {
		return this.sarlCapacity;
	}

	/** Replies the reference to the generated SarlAgent.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1838"
	 */
	@Pure
	public JvmTypeReference getSarlCapacityReference() {
		SarlCapacity ecoreObject = getSarlCapacity();
		return getTypeReferenceFor(ecoreObject);
	}

	/** Replies the JVM declared type for this generated SarlCapacity.
	 * @return the type, never {@code null}.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1893"
	 */
	@Pure
	public JvmDeclaredType getJvmDeclaredType() {
		return getAssociatedElement(JvmDeclaredType.class, getSarlCapacity(), eResource(), true);
	}

	/** Replies the resource to which the SarlCapacity is attached.
	 * @see "TopElementBuilderFragment.java : appendTo : 1928"
	 */
	@Pure
	public Resource eResource() {
		return getSarlCapacity().eResource();
	}

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	public ISarlCapacityBuilder setDocumentation(String doc) {
		if (Strings.isEmpty(doc)) {
			getSarlCapacity().eAdapters().removeIf(new Predicate<Adapter>() {
				public boolean test(Adapter adapter) {
					return adapter.isAdapterForType(DocumentationAdapter.class);
				}
			});
		} else {
			DocumentationAdapter adapter = (DocumentationAdapter) EcoreUtil.getExistingAdapter(
					getSarlCapacity(), DocumentationAdapter.class);
			if (adapter == null) {
				adapter = new DocumentationAdapter();
				getSarlCapacity().eAdapters().add(adapter);
			}
			adapter.setDocumentation(doc);
		}
		return this;
	}

	/** Add the super type.
	 * @param superType the qualified name of the super type.
	 * @return {@code this}
	 * @see "TopElementBuilderFragment.java : appendTo : 1966"
	 */
	public ISarlCapacityBuilder addExtends(String superType) {
		if (!Strings.isEmpty(superType)) {
			JvmTypeReference superTypeRef = newTypeRef(this.sarlCapacity, superType);
			if (superTypeRef instanceof JvmParameterizedTypeReference pref) {
				addExtends(pref);
			} else {
				throw new IllegalArgumentException();
			}
		}
		return this;
	}

	/** Add the super type.
	 * @param superType the super type.
	 * @return {@code this}
	 * @see "TopElementBuilderFragment.java : appendTo : 2065"
	 */
	public ISarlCapacityBuilder addExtends(JvmParameterizedTypeReference superType) {
		if (superType instanceof JvmParameterizedTypeReference psuperType && !Capacity.class.getName().equals(superType.getType().getIdentifier())) {
			JvmTypeReference baseTypeRef = findType(this.sarlCapacity, Capacity.class.getCanonicalName());
			if (isSubTypeOf(this.sarlCapacity, superType, baseTypeRef)) {
				this.sarlCapacity.getExtends().add(psuperType);
				return this;
			}
		}
		return this;
	}

	/** Add a modifier.
	 * @param modifier the modifier to add.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 2492"
	 */
	public ISarlCapacityBuilder addModifier(String modifier) {
		if (!Strings.isEmpty(modifier)) {
			this.sarlCapacity.getModifiers().add(modifier);
		}
		return this;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlActionBuilder> iSarlActionBuilderProvider;

	/** Create a SarlAction.
	 * @param name the name of the SarlAction.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlActionBuilder addDefSarlAction(String name) {
		ISarlActionBuilder builder = this.iSarlActionBuilderProvider.get();
		builder.eInit(getSarlCapacity(), name, "def", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlAction.
	 * @param name the name of the SarlAction.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlActionBuilder addOverrideSarlAction(String name) {
		ISarlActionBuilder builder = this.iSarlActionBuilderProvider.get();
		builder.eInit(getSarlCapacity(), name, "override", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlAction.	 *
	 * <p>This function is equivalent to {@link #addDefSarlAction}.
	 * @param name the name of the SarlAction.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 706"
	 */
	public ISarlActionBuilder addSarlAction(String name) {
		return this.addDefSarlAction(name);
	}

}

