/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlScript;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl SarlClass.
	 * @see "TopElementBuilderFragment.java : appendTo : 410"
 */
@SuppressWarnings("all")
public class SarlClassBuilderImpl extends AbstractBuilder implements ISarlClassBuilder {

	private SarlClass sarlClass;

	private EObject container;

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 1625"
	 */
	@Override
	@Pure
	public String toString() {
		return EmfFormatter.objToStr(getSarlClass());
	}

	/** Initialize the Ecore element when inside a script.
	 * @param script the SARL script in which this SarlClass is added.
	 * @param name the simple name of the SarlClass.
	 * @param context the context in which the resolution of types must be done.
	 * @see "TopElementBuilderFragment.java : appendTo : 1662"
	 */
	public void eInit(SarlScript script, String name, IJvmTypeProvider context) {
		setTypeResolutionContext(context);
		if (this.sarlClass == null) {
			this.container = script;
			this.sarlClass = SarlFactory.eINSTANCE.createSarlClass();
			this.sarlClass.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendTypeDeclaration());
			this.sarlClass.setName(name);
			script.getXtendTypes().add(this.sarlClass);
		}
	}

	/** Initialize the Ecore element when inner type declaration.
	 * @param container the Ecore type that must contain this new SarlClass.
	 * @param name the simple name of the SarlClass.
	 * @param context the context in which the resolution of types must be done.
	 * @see "TopElementBuilderFragment.java : appendTo : 1741"
	 */
	public void eInit(XtendTypeDeclaration container, String name, IJvmTypeProvider context) {
		setTypeResolutionContext(context);
		if (this.sarlClass == null) {
			this.container = container;
			this.sarlClass = SarlFactory.eINSTANCE.createSarlClass();
			this.sarlClass.setName(name);
			container.getMembers().add(this.sarlClass);
		}
	}

	/** Replies the generated SarlClass.
	 * @see "TopElementBuilderFragment.java : appendTo : 1798"
	 */
	@Pure
	public SarlClass getSarlClass() {
		return this.sarlClass;
	}

	/** Replies the reference to the generated SarlAgent.
	 * @param args the generic type arguments to put inside the reference.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1838"
	 */
	@Pure
	public JvmTypeReference getSarlClassReference(JvmTypeReference... args) {
		SarlClass ecoreObject = getSarlClass();
		return getTypeReferenceFor(ecoreObject, args);
	}

	/** Replies the JVM declared type for this generated SarlClass.
	 * @return the type, never {@code null}.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1893"
	 */
	@Pure
	public JvmDeclaredType getJvmDeclaredType() {
		return getAssociatedElement(JvmDeclaredType.class, getSarlClass(), eResource(), true);
	}

	/** Replies the resource to which the SarlClass is attached.
	 * @see "TopElementBuilderFragment.java : appendTo : 1928"
	 */
	@Pure
	public Resource eResource() {
		return getSarlClass().eResource();
	}

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	public ISarlClassBuilder setDocumentation(String doc) {
		if (Strings.isEmpty(doc)) {
			getSarlClass().eAdapters().removeIf(new Predicate<Adapter>() {
				public boolean test(Adapter adapter) {
					return adapter.isAdapterForType(DocumentationAdapter.class);
				}
			});
		} else {
			DocumentationAdapter adapter = (DocumentationAdapter) EcoreUtil.getExistingAdapter(
					getSarlClass(), DocumentationAdapter.class);
			if (adapter == null) {
				adapter = new DocumentationAdapter();
				getSarlClass().eAdapters().add(adapter);
			}
			adapter.setDocumentation(doc);
		}
		return this;
	}

	/** Change the super type.
	 * @param superType the qualified name of the super type,
	 *     or {@code null} if the default type.
	 * @return {@code this}
	 * @see "TopElementBuilderFragment.java : appendTo : 1984"
	 */
	public ISarlClassBuilder setExtends(String superType) {
		if (!Strings.isEmpty(superType)) {
			JvmTypeReference superTypeRef = newTypeRef(this.container, superType);
			if (superTypeRef instanceof JvmParameterizedTypeReference pref) {
				setExtends(pref);
			} else {
				throw new IllegalArgumentException();
			}
		} else {
			setExtends((JvmParameterizedTypeReference) null);
		}
		return this;
	}

	/** Change the super type.
	 * @param superType the super type,
	 *     or {@code null} if the default type.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 2085"
	 */
	public ISarlClassBuilder setExtends(JvmTypeReference superType) {
		if (superType instanceof JvmParameterizedTypeReference psuperType) {
			this.sarlClass.setExtends(psuperType);
			return this;
		}
		this.sarlClass.setExtends(null);
		return this;
	}

	/** Add an implemented type.
	 * @param type the qualified name of the implemented type.
	 * @return {@code this}
	 * @see "TopElementBuilderFragment.java : appendTo : 2197"
	 */
	public ISarlClassBuilder addImplements(String type) {
		if (!Strings.isEmpty(type)) {
			JvmTypeReference superTypeRef = newTypeRef(this.container, type);
			if (superTypeRef instanceof JvmParameterizedTypeReference pref) {
				addImplements(pref);
			} else {
				throw new IllegalArgumentException(type);
			}
		}
		return this;
	}

	/** Add an implemented type.
	 * @param type the implemented type.
	 * @return {@code this}
	 * @see "TopElementBuilderFragment.java : appendTo : 2294"
	 */
	public ISarlClassBuilder addImplements(JvmTypeReference type) {
		if (type instanceof JvmParameterizedTypeReference ptype) {
			this.sarlClass.getImplements().add(ptype);
		}
		return this;
	}

	/** Add a modifier.
	 * @param modifier the modifier to add.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 2492"
	 */
	public ISarlClassBuilder addModifier(String modifier) {
		if (!Strings.isEmpty(modifier)) {
			this.sarlClass.getModifiers().add(modifier);
		}
		return this;
	}

	@Inject
	private Provider<ITypeParameterBuilder> iTypeParameterBuilderProvider;

	/** Add a type parameter.
	 * @param name the simple name of the type parameter.
	 * @return the builder of type parameter.
	 * @see "TopElementBuilderFragment.java : appendTo : 2546"
	 */
	public ITypeParameterBuilder addTypeParameter(String name) {
		ITypeParameterBuilder builder = this.iTypeParameterBuilderProvider.get();
		final SarlClass object = getSarlClass();
		JvmType jvmType = getSarlClassReference().getType();
		builder.eInit(object, jvmType instanceof JvmTypeParameterDeclarator declarator ? declarator : null, name, getTypeResolutionContext());
		object.getTypeParameters().add(builder.getJvmTypeParameter());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlConstructorBuilder> iSarlConstructorBuilderProvider;

	/** Create a SarlConstructor.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlConstructorBuilder addSarlConstructor() {
		ISarlConstructorBuilder builder = this.iSarlConstructorBuilderProvider.get();
		builder.eInit(getSarlClass(), getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlFieldBuilder> iSarlFieldBuilderProvider;

	/** Create a SarlField.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlFieldBuilder addVarSarlField(String name) {
		ISarlFieldBuilder builder = this.iSarlFieldBuilderProvider.get();
		builder.eInit(getSarlClass(), name, "var", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlField.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlFieldBuilder addValSarlField(String name) {
		ISarlFieldBuilder builder = this.iSarlFieldBuilderProvider.get();
		builder.eInit(getSarlClass(), name, "val", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlField.	 *
	 * <p>This function is equivalent to {@link #addVarSarlField}.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 706"
	 */
	public ISarlFieldBuilder addSarlField(String name) {
		return this.addVarSarlField(name);
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlActionBuilder> iSarlActionBuilderProvider;

	/** Create a SarlAction.
	 * @param name the name of the SarlAction.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlActionBuilder addDefSarlAction(String name) {
		ISarlActionBuilder builder = this.iSarlActionBuilderProvider.get();
		builder.eInit(getSarlClass(), name, "def", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlAction.
	 * @param name the name of the SarlAction.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlActionBuilder addOverrideSarlAction(String name) {
		ISarlActionBuilder builder = this.iSarlActionBuilderProvider.get();
		builder.eInit(getSarlClass(), name, "override", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlAction.	 *
	 * <p>This function is equivalent to {@link #addDefSarlAction}.
	 * @param name the name of the SarlAction.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 706"
	 */
	public ISarlActionBuilder addSarlAction(String name) {
		return this.addDefSarlAction(name);
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlClassBuilder> iSarlClassBuilderProvider;

	/** Create a SarlClass.
	 * @param name the name of the SarlClass.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlClassBuilder addSarlClass(String name) {
		ISarlClassBuilder builder = this.iSarlClassBuilderProvider.get();
		builder.eInit(getSarlClass(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlInterfaceBuilder> iSarlInterfaceBuilderProvider;

	/** Create a SarlInterface.
	 * @param name the name of the SarlInterface.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlInterfaceBuilder addSarlInterface(String name) {
		ISarlInterfaceBuilder builder = this.iSarlInterfaceBuilderProvider.get();
		builder.eInit(getSarlClass(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlEnumerationBuilder> iSarlEnumerationBuilderProvider;

	/** Create a SarlEnumeration.
	 * @param name the name of the SarlEnumeration.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlEnumerationBuilder addSarlEnumeration(String name) {
		ISarlEnumerationBuilder builder = this.iSarlEnumerationBuilderProvider.get();
		builder.eInit(getSarlClass(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlAnnotationTypeBuilder> iSarlAnnotationTypeBuilderProvider;

	/** Create a SarlAnnotationType.
	 * @param name the name of the SarlAnnotationType.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlAnnotationTypeBuilder addSarlAnnotationType(String name) {
		ISarlAnnotationTypeBuilder builder = this.iSarlAnnotationTypeBuilderProvider.get();
		builder.eInit(getSarlClass(), name, getTypeResolutionContext());
		return builder;
	}

}

