/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.sarl.SarlEnumeration;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlScript;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl SarlEnumeration.
	 * @see "TopElementBuilderFragment.java : appendTo : 410"
 */
@SuppressWarnings("all")
public class SarlEnumerationBuilderImpl extends AbstractBuilder implements ISarlEnumerationBuilder {

	private SarlEnumeration sarlEnumeration;

	private EObject container;

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 1625"
	 */
	@Override
	@Pure
	public String toString() {
		return EmfFormatter.objToStr(getSarlEnumeration());
	}

	/** Initialize the Ecore element when inside a script.
	 * @param script the SARL script in which this SarlEnumeration is added.
	 * @param name the simple name of the SarlEnumeration.
	 * @param context the context in which the resolution of types must be done.
	 * @see "TopElementBuilderFragment.java : appendTo : 1662"
	 */
	public void eInit(SarlScript script, String name, IJvmTypeProvider context) {
		setTypeResolutionContext(context);
		if (this.sarlEnumeration == null) {
			this.container = script;
			this.sarlEnumeration = SarlFactory.eINSTANCE.createSarlEnumeration();
			this.sarlEnumeration.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendTypeDeclaration());
			this.sarlEnumeration.setName(name);
			script.getXtendTypes().add(this.sarlEnumeration);
		}
	}

	/** Initialize the Ecore element when inner type declaration.
	 * @param container the Ecore type that must contain this new SarlEnumeration.
	 * @param name the simple name of the SarlEnumeration.
	 * @param context the context in which the resolution of types must be done.
	 * @see "TopElementBuilderFragment.java : appendTo : 1741"
	 */
	public void eInit(XtendTypeDeclaration container, String name, IJvmTypeProvider context) {
		setTypeResolutionContext(context);
		if (this.sarlEnumeration == null) {
			this.container = container;
			this.sarlEnumeration = SarlFactory.eINSTANCE.createSarlEnumeration();
			this.sarlEnumeration.setName(name);
			container.getMembers().add(this.sarlEnumeration);
		}
	}

	/** Replies the generated SarlEnumeration.
	 * @see "TopElementBuilderFragment.java : appendTo : 1798"
	 */
	@Pure
	public SarlEnumeration getSarlEnumeration() {
		return this.sarlEnumeration;
	}

	/** Replies the reference to the generated SarlAgent.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1838"
	 */
	@Pure
	public JvmTypeReference getSarlEnumerationReference() {
		SarlEnumeration ecoreObject = getSarlEnumeration();
		return getTypeReferenceFor(ecoreObject);
	}

	/** Replies the JVM declared type for this generated SarlEnumeration.
	 * @return the type, never {@code null}.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1893"
	 */
	@Pure
	public JvmDeclaredType getJvmDeclaredType() {
		return getAssociatedElement(JvmDeclaredType.class, getSarlEnumeration(), eResource(), true);
	}

	/** Replies the resource to which the SarlEnumeration is attached.
	 * @see "TopElementBuilderFragment.java : appendTo : 1928"
	 */
	@Pure
	public Resource eResource() {
		return getSarlEnumeration().eResource();
	}

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	public ISarlEnumerationBuilder setDocumentation(String doc) {
		if (Strings.isEmpty(doc)) {
			getSarlEnumeration().eAdapters().removeIf(new Predicate<Adapter>() {
				public boolean test(Adapter adapter) {
					return adapter.isAdapterForType(DocumentationAdapter.class);
				}
			});
		} else {
			DocumentationAdapter adapter = (DocumentationAdapter) EcoreUtil.getExistingAdapter(
					getSarlEnumeration(), DocumentationAdapter.class);
			if (adapter == null) {
				adapter = new DocumentationAdapter();
				getSarlEnumeration().eAdapters().add(adapter);
			}
			adapter.setDocumentation(doc);
		}
		return this;
	}

	/** Add a modifier.
	 * @param modifier the modifier to add.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 2492"
	 */
	public ISarlEnumerationBuilder addModifier(String modifier) {
		if (!Strings.isEmpty(modifier)) {
			this.sarlEnumeration.getModifiers().add(modifier);
		}
		return this;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlEnumLiteralBuilder> iSarlEnumLiteralBuilderProvider;

	/** Create a SarlEnumLiteral.
	 * @param name the name of the SarlEnumLiteral.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlEnumLiteralBuilder addSarlEnumLiteral(String name) {
		ISarlEnumLiteralBuilder builder = this.iSarlEnumLiteralBuilderProvider.get();
		builder.eInit(getSarlEnumeration(), name, getTypeResolutionContext());
		return builder;
	}

}

