/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.core.Event;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlScript;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl SarlEvent.
	 * @see "TopElementBuilderFragment.java : appendTo : 410"
 */
@SuppressWarnings("all")
public class SarlEventBuilderImpl extends AbstractBuilder implements ISarlEventBuilder {

	private SarlEvent sarlEvent;

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 1625"
	 */
	@Override
	@Pure
	public String toString() {
		return EmfFormatter.objToStr(getSarlEvent());
	}

	/** Initialize the Ecore element when inside a script.
	 * @param script the SARL script in which this SarlEvent is added.
	 * @param name the simple name of the SarlEvent.
	 * @param context the context in which the resolution of types must be done.
	 * @see "TopElementBuilderFragment.java : appendTo : 1662"
	 */
	public void eInit(SarlScript script, String name, IJvmTypeProvider context) {
		setTypeResolutionContext(context);
		if (this.sarlEvent == null) {
			this.sarlEvent = SarlFactory.eINSTANCE.createSarlEvent();
			this.sarlEvent.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendTypeDeclaration());
			this.sarlEvent.setName(name);
			script.getXtendTypes().add(this.sarlEvent);
		}
	}

	/** Replies the generated SarlEvent.
	 * @see "TopElementBuilderFragment.java : appendTo : 1798"
	 */
	@Pure
	public SarlEvent getSarlEvent() {
		return this.sarlEvent;
	}

	/** Replies the reference to the generated SarlAgent.
	 * @param args the generic type arguments to put inside the reference.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1838"
	 */
	@Pure
	public JvmTypeReference getSarlEventReference(JvmTypeReference... args) {
		SarlEvent ecoreObject = getSarlEvent();
		return getTypeReferenceFor(ecoreObject, args);
	}

	/** Replies the JVM declared type for this generated SarlEvent.
	 * @return the type, never {@code null}.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1893"
	 */
	@Pure
	public JvmDeclaredType getJvmDeclaredType() {
		return getAssociatedElement(JvmDeclaredType.class, getSarlEvent(), eResource(), true);
	}

	/** Replies the resource to which the SarlEvent is attached.
	 * @see "TopElementBuilderFragment.java : appendTo : 1928"
	 */
	@Pure
	public Resource eResource() {
		return getSarlEvent().eResource();
	}

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	public ISarlEventBuilder setDocumentation(String doc) {
		if (Strings.isEmpty(doc)) {
			getSarlEvent().eAdapters().removeIf(new Predicate<Adapter>() {
				public boolean test(Adapter adapter) {
					return adapter.isAdapterForType(DocumentationAdapter.class);
				}
			});
		} else {
			DocumentationAdapter adapter = (DocumentationAdapter) EcoreUtil.getExistingAdapter(
					getSarlEvent(), DocumentationAdapter.class);
			if (adapter == null) {
				adapter = new DocumentationAdapter();
				getSarlEvent().eAdapters().add(adapter);
			}
			adapter.setDocumentation(doc);
		}
		return this;
	}

	/** Change the super type.
	 * @param superType the qualified name of the super type,
	 *     or {@code null} if the default type.
	 * @return {@code this}
	 * @see "TopElementBuilderFragment.java : appendTo : 1984"
	 */
	public ISarlEventBuilder setExtends(String superType) {
		if (!Strings.isEmpty(superType)) {
			JvmTypeReference superTypeRef = newTypeRef(this.sarlEvent, superType);
			if (superTypeRef instanceof JvmParameterizedTypeReference pref) {
				setExtends(pref);
			} else {
				throw new IllegalArgumentException();
			}
		} else {
			setExtends((JvmParameterizedTypeReference) null);
		}
		return this;
	}

	/** Change the super type.
	 * @param superType the super type,
	 *     or {@code null} if the default type.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 2085"
	 */
	public ISarlEventBuilder setExtends(JvmTypeReference superType) {
		if (superType instanceof JvmParameterizedTypeReference psuperType && !Event.class.getName().equals(superType.getType().getIdentifier())) {
			JvmTypeReference baseTypeRef = findType(this.sarlEvent, Event.class.getCanonicalName());
			if (isSubTypeOf(this.sarlEvent, superType, baseTypeRef)) {
				this.sarlEvent.setExtends(psuperType);
				return this;
			}
		}
		this.sarlEvent.setExtends(null);
		return this;
	}

	/** Add a modifier.
	 * @param modifier the modifier to add.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 2492"
	 */
	public ISarlEventBuilder addModifier(String modifier) {
		if (!Strings.isEmpty(modifier)) {
			this.sarlEvent.getModifiers().add(modifier);
		}
		return this;
	}

	@Inject
	private Provider<ITypeParameterBuilder> iTypeParameterBuilderProvider;

	/** Add a type parameter.
	 * @param name the simple name of the type parameter.
	 * @return the builder of type parameter.
	 * @see "TopElementBuilderFragment.java : appendTo : 2546"
	 */
	public ITypeParameterBuilder addTypeParameter(String name) {
		ITypeParameterBuilder builder = this.iTypeParameterBuilderProvider.get();
		final SarlEvent object = getSarlEvent();
		JvmType jvmType = getSarlEventReference().getType();
		builder.eInit(object, jvmType instanceof JvmTypeParameterDeclarator declarator ? declarator : null, name, getTypeResolutionContext());
		object.getTypeParameters().add(builder.getJvmTypeParameter());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlConstructorBuilder> iSarlConstructorBuilderProvider;

	/** Create a SarlConstructor.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlConstructorBuilder addSarlConstructor() {
		ISarlConstructorBuilder builder = this.iSarlConstructorBuilderProvider.get();
		builder.eInit(getSarlEvent(), getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlFieldBuilder> iSarlFieldBuilderProvider;

	/** Create a SarlField.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlFieldBuilder addVarSarlField(String name) {
		ISarlFieldBuilder builder = this.iSarlFieldBuilderProvider.get();
		builder.eInit(getSarlEvent(), name, "var", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlField.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlFieldBuilder addValSarlField(String name) {
		ISarlFieldBuilder builder = this.iSarlFieldBuilderProvider.get();
		builder.eInit(getSarlEvent(), name, "val", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlField.	 *
	 * <p>This function is equivalent to {@link #addVarSarlField}.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 706"
	 */
	public ISarlFieldBuilder addSarlField(String name) {
		return this.addVarSarlField(name);
	}

}

