/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Skill;
import io.sarl.lang.sarl.SarlCapacityUses;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlRequiredCapacity;
import io.sarl.lang.sarl.SarlScript;
import io.sarl.lang.sarl.SarlSkill;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

/** Builder of a Sarl SarlSkill.
	 * @see "TopElementBuilderFragment.java : appendTo : 410"
 */
@SuppressWarnings("all")
public class SarlSkillBuilderImpl extends AbstractBuilder implements ISarlSkillBuilder {

	private SarlSkill sarlSkill;

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 1625"
	 */
	@Override
	@Pure
	public String toString() {
		return EmfFormatter.objToStr(getSarlSkill());
	}

	/** Initialize the Ecore element when inside a script.
	 * @param script the SARL script in which this SarlSkill is added.
	 * @param name the simple name of the SarlSkill.
	 * @param context the context in which the resolution of types must be done.
	 * @see "TopElementBuilderFragment.java : appendTo : 1662"
	 */
	public void eInit(SarlScript script, String name, IJvmTypeProvider context) {
		setTypeResolutionContext(context);
		if (this.sarlSkill == null) {
			this.sarlSkill = SarlFactory.eINSTANCE.createSarlSkill();
			this.sarlSkill.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendTypeDeclaration());
			this.sarlSkill.setName(name);
			script.getXtendTypes().add(this.sarlSkill);
		}
	}

	/** Replies the generated SarlSkill.
	 * @see "TopElementBuilderFragment.java : appendTo : 1798"
	 */
	@Pure
	public SarlSkill getSarlSkill() {
		return this.sarlSkill;
	}

	/** Replies the reference to the generated SarlAgent.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1838"
	 */
	@Pure
	public JvmTypeReference getSarlSkillReference() {
		SarlSkill ecoreObject = getSarlSkill();
		return getTypeReferenceFor(ecoreObject);
	}

	/** Replies the JVM declared type for this generated SarlSkill.
	 * @return the type, never {@code null}.
	 * @since 0.15
	 * @see "TopElementBuilderFragment.java : appendTo : 1893"
	 */
	@Pure
	public JvmDeclaredType getJvmDeclaredType() {
		return getAssociatedElement(JvmDeclaredType.class, getSarlSkill(), eResource(), true);
	}

	/** Replies the resource to which the SarlSkill is attached.
	 * @see "TopElementBuilderFragment.java : appendTo : 1928"
	 */
	@Pure
	public Resource eResource() {
		return getSarlSkill().eResource();
	}

	/** Change the documentation of the element.
	 *
	 * <p>The documentation will be displayed just before the element.
	 *
	 * @param doc the documentation.
	 * @return {@code this}.
	 * @see "AbstractSubCodeBuilderFragment.java : appendTo : 603"
	 */
	public ISarlSkillBuilder setDocumentation(String doc) {
		if (Strings.isEmpty(doc)) {
			getSarlSkill().eAdapters().removeIf(new Predicate<Adapter>() {
				public boolean test(Adapter adapter) {
					return adapter.isAdapterForType(DocumentationAdapter.class);
				}
			});
		} else {
			DocumentationAdapter adapter = (DocumentationAdapter) EcoreUtil.getExistingAdapter(
					getSarlSkill(), DocumentationAdapter.class);
			if (adapter == null) {
				adapter = new DocumentationAdapter();
				getSarlSkill().eAdapters().add(adapter);
			}
			adapter.setDocumentation(doc);
		}
		return this;
	}

	/** Change the super type.
	 * @param superType the qualified name of the super type,
	 *     or {@code null} if the default type.
	 * @return {@code this}
	 * @see "TopElementBuilderFragment.java : appendTo : 1984"
	 */
	public ISarlSkillBuilder setExtends(String superType) {
		if (!Strings.isEmpty(superType)) {
			JvmTypeReference superTypeRef = newTypeRef(this.sarlSkill, superType);
			if (superTypeRef instanceof JvmParameterizedTypeReference pref) {
				setExtends(pref);
			} else {
				throw new IllegalArgumentException();
			}
		} else {
			setExtends((JvmParameterizedTypeReference) null);
		}
		return this;
	}

	/** Change the super type.
	 * @param superType the super type,
	 *     or {@code null} if the default type.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 2085"
	 */
	public ISarlSkillBuilder setExtends(JvmTypeReference superType) {
		if (superType instanceof JvmParameterizedTypeReference psuperType && !Skill.class.getName().equals(superType.getType().getIdentifier())) {
			JvmTypeReference baseTypeRef = findType(this.sarlSkill, Skill.class.getCanonicalName());
			if (isSubTypeOf(this.sarlSkill, superType, baseTypeRef)) {
				this.sarlSkill.setExtends(psuperType);
				return this;
			}
		}
		this.sarlSkill.setExtends(null);
		return this;
	}

	/** Add an implemented type.
	 * @param type the qualified name of the implemented type.
	 * @return {@code this}
	 * @see "TopElementBuilderFragment.java : appendTo : 2197"
	 */
	public ISarlSkillBuilder addImplements(String type) {
		if (!Strings.isEmpty(type)) {
			JvmTypeReference superTypeRef = newTypeRef(this.sarlSkill, type);
			if (superTypeRef instanceof JvmParameterizedTypeReference pref) {
				addImplements(pref);
			} else {
				throw new IllegalArgumentException(type);
			}
		}
		return this;
	}

	/** Add an implemented type.
	 * @param type the implemented type.
	 * @return {@code this}
	 * @see "TopElementBuilderFragment.java : appendTo : 2294"
	 */
	public ISarlSkillBuilder addImplements(JvmTypeReference type) {
		if (type instanceof JvmParameterizedTypeReference ptype && !Capacity.class.getName().equals(type.getType().getIdentifier())) {
			JvmTypeReference baseTypeRef = findType(this.sarlSkill, Capacity.class.getCanonicalName());
			if (isSubTypeOf(this.sarlSkill, type, baseTypeRef)) {
				this.sarlSkill.getImplements().add(ptype);
			}
		}
		return this;
	}

	/** Add a modifier.
	 * @param modifier the modifier to add.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 2492"
	 */
	public ISarlSkillBuilder addModifier(String modifier) {
		if (!Strings.isEmpty(modifier)) {
			this.sarlSkill.getModifiers().add(modifier);
		}
		return this;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlConstructorBuilder> iSarlConstructorBuilderProvider;

	/** Create a SarlConstructor.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlConstructorBuilder addSarlConstructor() {
		ISarlConstructorBuilder builder = this.iSarlConstructorBuilderProvider.get();
		builder.eInit(getSarlSkill(), getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlBehaviorUnitBuilder> iSarlBehaviorUnitBuilderProvider;

	/** Create a SarlBehaviorUnit.
	 * @param name the type of the SarlBehaviorUnit.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlBehaviorUnitBuilder addSarlBehaviorUnit(String name) {
		ISarlBehaviorUnitBuilder builder = this.iSarlBehaviorUnitBuilderProvider.get();
		builder.eInit(getSarlSkill(), name, getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlBehaviorUnit.
	 * @param name the type of the SarlBehaviorUnit.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 626"
	 */
	public ISarlBehaviorUnitBuilder addSarlBehaviorUnit(JvmParameterizedTypeReference name) {
		ISarlBehaviorUnitBuilder builder = this.iSarlBehaviorUnitBuilderProvider.get();
		builder.eInit(getSarlSkill(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlFieldBuilder> iSarlFieldBuilderProvider;

	/** Create a SarlField.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlFieldBuilder addVarSarlField(String name) {
		ISarlFieldBuilder builder = this.iSarlFieldBuilderProvider.get();
		builder.eInit(getSarlSkill(), name, "var", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlField.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlFieldBuilder addValSarlField(String name) {
		ISarlFieldBuilder builder = this.iSarlFieldBuilderProvider.get();
		builder.eInit(getSarlSkill(), name, "val", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlField.	 *
	 * <p>This function is equivalent to {@link #addVarSarlField}.
	 * @param name the name of the SarlField.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 706"
	 */
	public ISarlFieldBuilder addSarlField(String name) {
		return this.addVarSarlField(name);
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlActionBuilder> iSarlActionBuilderProvider;

	/** Create a SarlAction.
	 * @param name the name of the SarlAction.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlActionBuilder addDefSarlAction(String name) {
		ISarlActionBuilder builder = this.iSarlActionBuilderProvider.get();
		builder.eInit(getSarlSkill(), name, "def", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlAction.
	 * @param name the name of the SarlAction.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlActionBuilder addOverrideSarlAction(String name) {
		ISarlActionBuilder builder = this.iSarlActionBuilderProvider.get();
		builder.eInit(getSarlSkill(), name, "override", getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlAction.	 *
	 * <p>This function is equivalent to {@link #addDefSarlAction}.
	 * @param name the name of the SarlAction.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 706"
	 */
	public ISarlActionBuilder addSarlAction(String name) {
		return this.addDefSarlAction(name);
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlClassBuilder> iSarlClassBuilderProvider;

	/** Create a SarlClass.
	 * @param name the name of the SarlClass.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlClassBuilder addSarlClass(String name) {
		ISarlClassBuilder builder = this.iSarlClassBuilderProvider.get();
		builder.eInit(getSarlSkill(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlInterfaceBuilder> iSarlInterfaceBuilderProvider;

	/** Create a SarlInterface.
	 * @param name the name of the SarlInterface.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlInterfaceBuilder addSarlInterface(String name) {
		ISarlInterfaceBuilder builder = this.iSarlInterfaceBuilderProvider.get();
		builder.eInit(getSarlSkill(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlEnumerationBuilder> iSarlEnumerationBuilderProvider;

	/** Create a SarlEnumeration.
	 * @param name the name of the SarlEnumeration.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlEnumerationBuilder addSarlEnumeration(String name) {
		ISarlEnumerationBuilder builder = this.iSarlEnumerationBuilderProvider.get();
		builder.eInit(getSarlSkill(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "TopElementBuilderFragment.java : appendTo : 523"
	 */
	@Inject
	private Provider<ISarlAnnotationTypeBuilder> iSarlAnnotationTypeBuilderProvider;

	/** Create a SarlAnnotationType.
	 * @param name the name of the SarlAnnotationType.
	 * @return the builder.
	 * @see "TopElementBuilderFragment.java : appendTo : 564"
	 */
	public ISarlAnnotationTypeBuilder addSarlAnnotationType(String name) {
		ISarlAnnotationTypeBuilder builder = this.iSarlAnnotationTypeBuilderProvider.get();
		builder.eInit(getSarlSkill(), name, getTypeResolutionContext());
		return builder;
	}

	/** Create a SarlCapacityUses.
	 * @param name the types referenced by the SarlCapacityUses.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 1041"
	 */
	public ISarlSkillBuilder addSarlCapacityUses(String... name) {
		if (name != null && name.length > 0) {
			SarlCapacityUses member = SarlFactory.eINSTANCE.createSarlCapacityUses();
			this.sarlSkill.getMembers().add(member);
			member.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendMember());
			Collection<JvmParameterizedTypeReference> thecollection = member.getCapacities();
			for (final String aname : name) {
				if (!Strings.isEmpty(aname)) {
					JvmTypeReference ref = newTypeRef(this.sarlSkill, aname);
					if (ref instanceof JvmParameterizedTypeReference pref) {
						thecollection.add(pref);
					} else {
						throw new TypeNotPresentException(aname, null);
					}
				}
			}
		}
		return this;
	}

	/** Create a SarlCapacityUses.
	 * @param name the types referenced by the SarlCapacityUses.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 1145"
	 */
	public ISarlSkillBuilder addSarlCapacityUses(JvmParameterizedTypeReference... name) {
		if (name != null) {
			SarlCapacityUses member = SarlFactory.eINSTANCE.createSarlCapacityUses();
			this.sarlSkill.getMembers().add(member);
			member.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendMember());
			Collection<JvmParameterizedTypeReference> thecollection = member.getCapacities();
			for (final JvmParameterizedTypeReference aname : name) {
				if (aname != null) {
					thecollection.add(aname);
				}
			}
		}
		return this;
	}

	/** Create a SarlRequiredCapacity.
	 * @param name the types referenced by the SarlRequiredCapacity.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 1041"
	 */
	public ISarlSkillBuilder addSarlRequiredCapacity(String... name) {
		if (name != null && name.length > 0) {
			SarlRequiredCapacity member = SarlFactory.eINSTANCE.createSarlRequiredCapacity();
			this.sarlSkill.getMembers().add(member);
			member.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendMember());
			Collection<JvmParameterizedTypeReference> thecollection = member.getCapacities();
			for (final String aname : name) {
				if (!Strings.isEmpty(aname)) {
					JvmTypeReference ref = newTypeRef(this.sarlSkill, aname);
					if (ref instanceof JvmParameterizedTypeReference pref) {
						thecollection.add(pref);
					} else {
						throw new TypeNotPresentException(aname, null);
					}
				}
			}
		}
		return this;
	}

	/** Create a SarlRequiredCapacity.
	 * @param name the types referenced by the SarlRequiredCapacity.
	 * @return {@code this}.
	 * @see "TopElementBuilderFragment.java : appendTo : 1145"
	 */
	public ISarlSkillBuilder addSarlRequiredCapacity(JvmParameterizedTypeReference... name) {
		if (name != null) {
			SarlRequiredCapacity member = SarlFactory.eINSTANCE.createSarlRequiredCapacity();
			this.sarlSkill.getMembers().add(member);
			member.setAnnotationInfo(XtendFactory.eINSTANCE.createXtendMember());
			Collection<JvmParameterizedTypeReference> thecollection = member.getCapacities();
			for (final JvmParameterizedTypeReference aname : name) {
				if (aname != null) {
					thecollection.add(aname);
				}
			}
		}
		return this;
	}

}

