/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlScript;
import jakarta.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypeFactory;

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 639"
	 */
@SuppressWarnings("all")
public class ScriptBuilderImpl extends AbstractBuilder implements IScriptBuilder {

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 677"
	 */
	private SarlScript script;

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 683"
	 */
	private boolean isFinalized;

	/** Create the internal Sarl script.
	 * @param resource the Ecore resource in which the SARL script is located.
	 * @param packageName the fully-qualified name of the package of the script.
	 * @param context the context in which all the type resolutions must be done.
	 * @see "ScriptBuilderFragment.java : appendTo : 924"
	 */
	public void eInit(Resource resource, String packageName, IJvmTypeProvider context) {
		setTypeResolutionContext(context);
		if (this.script == null) {
			this.script = SarlFactory.eINSTANCE.createSarlScript();
			EList<EObject> content = resource.getContents();
			if (!content.isEmpty()) {
				content.clear();
			}
			content.add(this.script);
			if (!Strings.isEmpty(packageName)) {
				script.setPackage(packageName);
			}
		}
	}

	/** Replies the Sarl script.
	 * @see "ScriptBuilderFragment.java : appendTo : 985"
	 */
	@Pure
	public SarlScript getScript() {
		return this.script;
	}

	/** Replies the resource to which the script is attached.
	 * @see "ScriptBuilderFragment.java : appendTo : 1014"
	 */
	@Pure
	public Resource eResource() {
		return getScript().eResource();
	}

	/** Finalize the script.
	 *
	 * <p>The finalization includes: <ul>
	 * <li>The import section is created.</li>
	 * </ul>
	 * @see "ScriptBuilderFragment.java : appendTo : 1047"
	 */
	public void finalizeScript() {
		if (this.isFinalized) {
			throw new IllegalStateException("already finalized");
		}
		this.isFinalized = true;
		ImportManager concreteImports = new ImportManager(true);
		XImportSection importSection = getScript().getImportSection();
		if (importSection != null) {
			for (XImportDeclaration decl : importSection.getImportDeclarations()) {
				concreteImports.addImportFor(decl.getImportedType());
			}
		}
		for (String importName : getImportManager().getImports()) {
			JvmType type = findType(getScript(), importName).getType();
			if (type instanceof JvmDeclaredType ctype && concreteImports.addImportFor(ctype)) {
				XImportDeclaration declaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
				declaration.setImportedType(ctype);
				if (importSection == null) {
					importSection = XtypeFactory.eINSTANCE.createXImportSection();
					getScript().setImportSection(importSection);
				}
				importSection.getImportDeclarations().add(declaration);
			}
		}
		Resource resource = getScript().eResource();
		if (resource instanceof DerivedStateAwareResource cresource) {
			cresource.discardDerivedState();
		}
	}

	/** Replies if the script was finalized.
	 * @see "ScriptBuilderFragment.java : appendTo : 1148"
	 */
	public boolean isFinalized() {
		return this.isFinalized;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 1172"
	 */
	@Override
	@Pure
	public String toString() {
		return EmfFormatter.objToStr(this.script);
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlEventBuilder> sarlEventProvider;

	/** Create a SarlEvent builder.
	 * @param name the name of the SarlEvent.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlEventBuilder addSarlEvent(String name) {
		ISarlEventBuilder builder = this.sarlEventProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlCapacityBuilder> sarlCapacityProvider;

	/** Create a SarlCapacity builder.
	 * @param name the name of the SarlCapacity.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlCapacityBuilder addSarlCapacity(String name) {
		ISarlCapacityBuilder builder = this.sarlCapacityProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlAgentBuilder> sarlAgentProvider;

	/** Create a SarlAgent builder.
	 * @param name the name of the SarlAgent.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlAgentBuilder addSarlAgent(String name) {
		ISarlAgentBuilder builder = this.sarlAgentProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlBehaviorBuilder> sarlBehaviorProvider;

	/** Create a SarlBehavior builder.
	 * @param name the name of the SarlBehavior.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlBehaviorBuilder addSarlBehavior(String name) {
		ISarlBehaviorBuilder builder = this.sarlBehaviorProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlSkillBuilder> sarlSkillProvider;

	/** Create a SarlSkill builder.
	 * @param name the name of the SarlSkill.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlSkillBuilder addSarlSkill(String name) {
		ISarlSkillBuilder builder = this.sarlSkillProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlSpaceBuilder> sarlSpaceProvider;

	/** Create a SarlSpace builder.
	 * @param name the name of the SarlSpace.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlSpaceBuilder addSarlSpace(String name) {
		ISarlSpaceBuilder builder = this.sarlSpaceProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlArtifactBuilder> sarlArtifactProvider;

	/** Create a SarlArtifact builder.
	 * @param name the name of the SarlArtifact.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlArtifactBuilder addSarlArtifact(String name) {
		ISarlArtifactBuilder builder = this.sarlArtifactProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlClassBuilder> sarlClassProvider;

	/** Create a SarlClass builder.
	 * @param name the name of the SarlClass.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlClassBuilder addSarlClass(String name) {
		ISarlClassBuilder builder = this.sarlClassProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlInterfaceBuilder> sarlInterfaceProvider;

	/** Create a SarlInterface builder.
	 * @param name the name of the SarlInterface.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlInterfaceBuilder addSarlInterface(String name) {
		ISarlInterfaceBuilder builder = this.sarlInterfaceProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlEnumerationBuilder> sarlEnumerationProvider;

	/** Create a SarlEnumeration builder.
	 * @param name the name of the SarlEnumeration.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlEnumerationBuilder addSarlEnumeration(String name) {
		ISarlEnumerationBuilder builder = this.sarlEnumerationProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

	/**
	 * @see "ScriptBuilderFragment.java : appendTo : 469"
	 */
	@Inject
	private Provider<ISarlAnnotationTypeBuilder> sarlAnnotationTypeProvider;

	/** Create a SarlAnnotationType builder.
	 * @param name the name of the SarlAnnotationType.
	 * @return the builder.
	 * @see "ScriptBuilderFragment.java : appendTo : 490"
	 */
	public ISarlAnnotationTypeBuilder addSarlAnnotationType(String name) {
		ISarlAnnotationTypeBuilder builder = this.sarlAnnotationTypeProvider.get();
		builder.eInit(getScript(), name, getTypeResolutionContext());
		return builder;
	}

}
