/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.documentation;

import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.lib.Pure;

/** Format a documentation string.
	 * @see "DocumentationBuilderFragment.java : appendTo : 290"
 */
public interface IDocumentationFormatter {

	/** Replies the characters that must be used as prefix of each line in a multiline comment.
	 * @return the prefix.
	 * @see "DocumentationBuilderFragment.java : appendTo : 302"
	 */
	@Pure
	String getMultilineCommentLinePrefix();

	/** Replies the characters that must be used to start a comment.
	 * @return the symbols.
	 * @see "DocumentationBuilderFragment.java : appendTo : 315"
	 */
	@Pure
	String getMultilineCommentStartSymbols();

	/** Replies the characters that must be used to end a comment.
	 * @return the symbols.
	 * @see "DocumentationBuilderFragment.java : appendTo : 328"
	 */
	@Pure
	String getMultilineCommentEndSymbols();

	/** Replies the string that must be used as prefix of a singleline comment.
	 * @return the prefix.
	 * @see "DocumentationBuilderFragment.java : appendTo : 341"
	 */
	@Pure
	String getSinglelineCommentPrefix();

	/** Replies the formatted string that corresponds to the given documentation.
	 * @param doc the documentation text. It may be on multiple lines.
	 * @return the formatted comment.
	 * @see "DocumentationBuilderFragment.java : appendTo : 356"
	 */
	@Pure
	String formatMultilineComment(String doc);

	/** Replies the formatted string that corresponds to the given documentation.
	 * @param doc the documentation text. It may be on multiple lines.
	 * @param indentation the string to put for indenting the comment.
	 * @return the formatted comment.
	 * @see "DocumentationBuilderFragment.java : appendTo : 373"
	 */
	@Pure
	String formatMultilineComment(String doc, String indentation);

	/** Replies the formatted string that corresponds to the given documentation.
	 * @param doc the documentation text. It may be on multiple lines.
	 * @param appendable the receiver of the formatted string.
	 * @see "DocumentationBuilderFragment.java : appendTo : 388"
	 */
	@Pure
	void formatMultilineComment(String doc, IAppendable appendable);

	/** Replies the formatted string that corresponds to the given documentation.
	 * @param doc the documentation text. It may be on multiple lines.
	 * @param indentation the string to put for indenting the comment.
	 * @param appendable the receiver of the formatted string.
	 * @see "DocumentationBuilderFragment.java : appendTo : 407"
	 */
	@Pure
	void formatMultilineComment(String doc, String indentation, IAppendable appendable);

	/** Format the given multiline documentation.
	 *
	 * @param context the formatting context.
	 * @param comment the comment to format out.
	 * @see "DocumentationBuilderFragment.java : appendTo : 426"
	 */
	@Pure
	public void formatMultilineComment(ITextReplacerContext context, IComment comment);

	/** Replies the formatted string that corresponds to the given documentation.
	 * @param doc the documentation text. It may be on multiple lines.
	 * @return the formatted comment.
	 * @see "DocumentationBuilderFragment.java : appendTo : 445"
	 */
	@Pure
	String formatSinglelineComment(String doc);

	/** Replies the formatted string that corresponds to the given documentation.
	 * @param doc the documentation text. It may be on multiple lines.
	 * @param indentation the string to put for indenting the comment.
	 * @return the formatted comment.
	 * @see "DocumentationBuilderFragment.java : appendTo : 462"
	 */
	@Pure
	String formatSinglelineComment(String doc, String indentation);

	/** Replies the formatted string that corresponds to the given documentation.
	 * @param doc the documentation text. It may be on multiple lines.
	 * @param appendable the receiver of the formatted string.
	 * @see "DocumentationBuilderFragment.java : appendTo : 477"
	 */
	@Pure
	void formatSinglelineComment(String doc, IAppendable appendable);

	/** Replies the formatted string that corresponds to the given documentation.
	 * @param doc the documentation text. It may be on multiple lines.
	 * @param indentation the string to put for indenting the comment.
	 * @param appendable the receiver of the formatted string.
	 * @see "DocumentationBuilderFragment.java : appendTo : 496"
	 */
	@Pure
	void formatSinglelineComment(String doc, String indentation, IAppendable appendable);

	/** Format the given singleline documentation.
	 *
	 * @param context the formatting context.
	 * @param comment the comment to format out.
	 * @see "DocumentationBuilderFragment.java : appendTo : 515"
	 */
	@Pure
	void formatSinglelineComment(ITextReplacerContext context, IComment comment);

}

