/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.serializer;

import com.google.inject.Inject;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlAnnotationType;
import io.sarl.lang.sarl.SarlArtifact;
import io.sarl.lang.sarl.SarlAssertExpression;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlBreakExpression;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlCapacityUses;
import io.sarl.lang.sarl.SarlCastedExpression;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.SarlConstructor;
import io.sarl.lang.sarl.SarlContinueExpression;
import io.sarl.lang.sarl.SarlEnumLiteral;
import io.sarl.lang.sarl.SarlEnumeration;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlField;
import io.sarl.lang.sarl.SarlFormalParameter;
import io.sarl.lang.sarl.SarlInterface;
import io.sarl.lang.sarl.SarlPackage;
import io.sarl.lang.sarl.SarlRequiredCapacity;
import io.sarl.lang.sarl.SarlScript;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.sarl.SarlSpace;
import io.sarl.lang.services.SARLGrammarAccess;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtend.core.serializer.XtendSemanticSequencer;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.CreateExtensionInfo;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringElseIf;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFormalParameter;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.core.xtend.XtendVariableDeclaration;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypePackage;

@SuppressWarnings("all")
public class SARLSemanticSequencer extends XtendSemanticSequencer {

	@Inject
	private SARLGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == SarlPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case SarlPackage.SARL_ACTION:
				if (rule == grammarAccess.getAOPMemberRule()) {
					sequence_AOPMember(context, (SarlAction) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getCapacityMemberRule()) {
					sequence_CapacityMember(context, (SarlAction) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getMemberRule()) {
					sequence_Member(context, (SarlAction) semanticObject); 
					return; 
				}
				else break;
			case SarlPackage.SARL_AGENT:
				sequence_Type(context, (SarlAgent) semanticObject); 
				return; 
			case SarlPackage.SARL_ANNOTATION_TYPE:
				if (rule == grammarAccess.getAOPMemberRule()) {
					sequence_AOPMember(context, (SarlAnnotationType) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotationFieldRule()) {
					sequence_AnnotationField(context, (SarlAnnotationType) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getMemberRule()) {
					sequence_Member(context, (SarlAnnotationType) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRule()) {
					sequence_Type(context, (SarlAnnotationType) semanticObject); 
					return; 
				}
				else break;
			case SarlPackage.SARL_ARTIFACT:
				sequence_Type(context, (SarlArtifact) semanticObject); 
				return; 
			case SarlPackage.SARL_ASSERT_EXPRESSION:
				if (rule == grammarAccess.getXCastedExpressionRule()
						|| action == grammarAccess.getXCastedExpressionAccess().getSarlCastedExpressionTargetAction_1_0_0_0()
						|| rule == grammarAccess.getXPrimaryExpressionRule()
						|| rule == grammarAccess.getXMultiplicativeExpressionRule()
						|| action == grammarAccess.getXMultiplicativeExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXExponentExpressionRule()
						|| action == grammarAccess.getXExponentExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXUnaryOperationRule()
						|| rule == grammarAccess.getXAssignmentRule()
						|| action == grammarAccess.getXAssignmentAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXConditionalExpressionRule()
						|| action == grammarAccess.getXConditionalExpressionAccess().getXIfExpressionIfAction_1_0_0_0()
						|| rule == grammarAccess.getXExpressionOrSimpleConstructorCallRule()
						|| rule == grammarAccess.getRichStringPartRule()
						|| rule == grammarAccess.getXAnnotationElementValueOrCommaListRule()
						|| action == grammarAccess.getXAnnotationElementValueOrCommaListAccess().getXListLiteralElementsAction_1_1_0()
						|| rule == grammarAccess.getXAnnotationElementValueRule()
						|| rule == grammarAccess.getXAnnotationOrExpressionRule()
						|| rule == grammarAccess.getXExpressionRule()
						|| rule == grammarAccess.getXOrExpressionRule()
						|| action == grammarAccess.getXOrExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAndExpressionRule()
						|| action == grammarAccess.getXAndExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXEqualityExpressionRule()
						|| action == grammarAccess.getXEqualityExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXRelationalExpressionRule()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXInstanceOfExpressionExpressionAction_1_0_0_0_0()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOtherOperatorExpressionRule()
						|| action == grammarAccess.getXOtherOperatorExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAdditiveExpressionRule()
						|| action == grammarAccess.getXAdditiveExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXPostfixOperationRule()
						|| action == grammarAccess.getXPostfixOperationAccess().getXPostfixOperationOperandAction_1_0_0()
						|| rule == grammarAccess.getXMemberFeatureCallRule()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXAssignmentAssignableAction_1_0_0_0_0()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXMemberFeatureCallMemberCallTargetAction_1_1_0_0_0()
						|| rule == grammarAccess.getXParenthesizedExpressionRule()
						|| rule == grammarAccess.getXExpressionOrVarDeclarationRule()) {
					sequence_AssertExpression_AssumeExpression(context, (SarlAssertExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAssertExpressionRule()) {
					sequence_AssertExpression(context, (SarlAssertExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAssumeExpressionRule()) {
					sequence_AssumeExpression(context, (SarlAssertExpression) semanticObject); 
					return; 
				}
				else break;
			case SarlPackage.SARL_BEHAVIOR:
				sequence_Type(context, (SarlBehavior) semanticObject); 
				return; 
			case SarlPackage.SARL_BEHAVIOR_UNIT:
				sequence_AOPMember(context, (SarlBehaviorUnit) semanticObject); 
				return; 
			case SarlPackage.SARL_BREAK_EXPRESSION:
				sequence_BreakExpression(context, (SarlBreakExpression) semanticObject); 
				return; 
			case SarlPackage.SARL_CAPACITY:
				sequence_Type(context, (SarlCapacity) semanticObject); 
				return; 
			case SarlPackage.SARL_CAPACITY_USES:
				sequence_AOPMember(context, (SarlCapacityUses) semanticObject); 
				return; 
			case SarlPackage.SARL_CASTED_EXPRESSION:
				if (rule == grammarAccess.getSarlCastedExpressionRule()) {
					sequence_SarlCastedExpression(context, (SarlCastedExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getXCastedExpressionRule()
						|| action == grammarAccess.getXCastedExpressionAccess().getSarlCastedExpressionTargetAction_1_0_0_0()
						|| rule == grammarAccess.getXPrimaryExpressionRule()
						|| rule == grammarAccess.getXMultiplicativeExpressionRule()
						|| action == grammarAccess.getXMultiplicativeExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXExponentExpressionRule()
						|| action == grammarAccess.getXExponentExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXUnaryOperationRule()
						|| rule == grammarAccess.getXAssignmentRule()
						|| action == grammarAccess.getXAssignmentAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXConditionalExpressionRule()
						|| action == grammarAccess.getXConditionalExpressionAccess().getXIfExpressionIfAction_1_0_0_0()
						|| rule == grammarAccess.getXExpressionOrSimpleConstructorCallRule()
						|| rule == grammarAccess.getRichStringPartRule()
						|| rule == grammarAccess.getXAnnotationElementValueOrCommaListRule()
						|| action == grammarAccess.getXAnnotationElementValueOrCommaListAccess().getXListLiteralElementsAction_1_1_0()
						|| rule == grammarAccess.getXAnnotationElementValueRule()
						|| rule == grammarAccess.getXAnnotationOrExpressionRule()
						|| rule == grammarAccess.getXExpressionRule()
						|| rule == grammarAccess.getXOrExpressionRule()
						|| action == grammarAccess.getXOrExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAndExpressionRule()
						|| action == grammarAccess.getXAndExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXEqualityExpressionRule()
						|| action == grammarAccess.getXEqualityExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXRelationalExpressionRule()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXInstanceOfExpressionExpressionAction_1_0_0_0_0()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOtherOperatorExpressionRule()
						|| action == grammarAccess.getXOtherOperatorExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAdditiveExpressionRule()
						|| action == grammarAccess.getXAdditiveExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXPostfixOperationRule()
						|| action == grammarAccess.getXPostfixOperationAccess().getXPostfixOperationOperandAction_1_0_0()
						|| rule == grammarAccess.getXMemberFeatureCallRule()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXAssignmentAssignableAction_1_0_0_0_0()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXMemberFeatureCallMemberCallTargetAction_1_1_0_0_0()
						|| rule == grammarAccess.getXParenthesizedExpressionRule()
						|| rule == grammarAccess.getXExpressionOrVarDeclarationRule()) {
					sequence_XCastedExpression(context, (SarlCastedExpression) semanticObject); 
					return; 
				}
				else break;
			case SarlPackage.SARL_CLASS:
				if (rule == grammarAccess.getAOPMemberRule()) {
					sequence_AOPMember(context, (SarlClass) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotationFieldRule()) {
					sequence_AnnotationField(context, (SarlClass) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getMemberRule()) {
					sequence_Member(context, (SarlClass) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRule()) {
					sequence_Type(context, (SarlClass) semanticObject); 
					return; 
				}
				else break;
			case SarlPackage.SARL_CONSTRUCTOR:
				if (rule == grammarAccess.getAOPMemberRule()) {
					sequence_AOPMember(context, (SarlConstructor) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getEventMemberRule()) {
					sequence_EventMember(context, (SarlConstructor) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getMemberRule()) {
					sequence_Member(context, (SarlConstructor) semanticObject); 
					return; 
				}
				else break;
			case SarlPackage.SARL_CONTINUE_EXPRESSION:
				sequence_ContinueExpression(context, (SarlContinueExpression) semanticObject); 
				return; 
			case SarlPackage.SARL_ENUM_LITERAL:
				sequence_XtendEnumLiteral(context, (SarlEnumLiteral) semanticObject); 
				return; 
			case SarlPackage.SARL_ENUMERATION:
				if (rule == grammarAccess.getAOPMemberRule()) {
					sequence_AOPMember(context, (SarlEnumeration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotationFieldRule()) {
					sequence_AnnotationField(context, (SarlEnumeration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getMemberRule()) {
					sequence_Member(context, (SarlEnumeration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRule()) {
					sequence_Type(context, (SarlEnumeration) semanticObject); 
					return; 
				}
				else break;
			case SarlPackage.SARL_EVENT:
				sequence_Type(context, (SarlEvent) semanticObject); 
				return; 
			case SarlPackage.SARL_FIELD:
				if (rule == grammarAccess.getAOPMemberRule()) {
					sequence_AOPMember(context, (SarlField) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotationFieldRule()) {
					sequence_AnnotationField(context, (SarlField) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getEventMemberRule()) {
					sequence_EventMember(context, (SarlField) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getMemberRule()) {
					sequence_Member(context, (SarlField) semanticObject); 
					return; 
				}
				else break;
			case SarlPackage.SARL_FORMAL_PARAMETER:
				sequence_Parameter(context, (SarlFormalParameter) semanticObject); 
				return; 
			case SarlPackage.SARL_INTERFACE:
				if (rule == grammarAccess.getAOPMemberRule()) {
					sequence_AOPMember(context, (SarlInterface) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotationFieldRule()) {
					sequence_AnnotationField(context, (SarlInterface) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getMemberRule()) {
					sequence_Member(context, (SarlInterface) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRule()) {
					sequence_Type(context, (SarlInterface) semanticObject); 
					return; 
				}
				else break;
			case SarlPackage.SARL_REQUIRED_CAPACITY:
				sequence_AOPMember(context, (SarlRequiredCapacity) semanticObject); 
				return; 
			case SarlPackage.SARL_SCRIPT:
				sequence_SarlScript(context, (SarlScript) semanticObject); 
				return; 
			case SarlPackage.SARL_SKILL:
				sequence_Type(context, (SarlSkill) semanticObject); 
				return; 
			case SarlPackage.SARL_SPACE:
				sequence_Type(context, (SarlSpace) semanticObject); 
				return; 
			}
		else if (epackage == TypesPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case TypesPackage.JVM_GENERIC_ARRAY_TYPE_REFERENCE:
				if (rule == grammarAccess.getMultiTypeReferenceRule()
						|| action == grammarAccess.getMultiTypeReferenceAccess().getJvmSynonymTypeReferenceReferencesAction_1_0()
						|| rule == grammarAccess.getJvmTypeReferenceRule()
						|| action == grammarAccess.getJvmTypeReferenceAccess().getJvmGenericArrayTypeReferenceComponentTypeAction_0_1_0_0()
						|| rule == grammarAccess.getJvmArgumentTypeReferenceRule()) {
					sequence_JvmTypeReference(context, (JvmGenericArrayTypeReference) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeReferenceWithTypeArgsRule()) {
					sequence_TypeReferenceWithTypeArgs(context, (JvmGenericArrayTypeReference) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getTypeReferenceWithTypeArgsAccess().getJvmGenericArrayTypeReferenceComponentTypeAction_0_1_0_0()) {
					sequence_TypeReferenceWithTypeArgs_JvmGenericArrayTypeReference_0_1_0_0(context, (JvmGenericArrayTypeReference) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getTypeReferenceWithTypeArgsAccess().getJvmGenericArrayTypeReferenceComponentTypeAction_1_1_0_0()) {
					sequence_TypeReferenceWithTypeArgs_JvmGenericArrayTypeReference_1_1_0_0(context, (JvmGenericArrayTypeReference) semanticObject); 
					return; 
				}
				else break;
			case TypesPackage.JVM_INNER_TYPE_REFERENCE:
				if (rule == grammarAccess.getJvmSuperTypeReferenceRule()
						|| rule == grammarAccess.getMultiTypeReferenceRule()
						|| action == grammarAccess.getMultiTypeReferenceAccess().getJvmSynonymTypeReferenceReferencesAction_1_0()
						|| rule == grammarAccess.getJvmTypeReferenceRule()
						|| action == grammarAccess.getJvmTypeReferenceAccess().getJvmGenericArrayTypeReferenceComponentTypeAction_0_1_0_0()
						|| rule == grammarAccess.getJvmParameterizedTypeReferenceRule()
						|| action == grammarAccess.getJvmParameterizedTypeReferenceAccess().getJvmInnerTypeReferenceOuterAction_1_4_0_0_0()
						|| rule == grammarAccess.getJvmArgumentTypeReferenceRule()) {
					sequence_JvmParameterizedTypeReference(context, (JvmInnerTypeReference) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeReferenceWithTypeArgsRule()
						|| action == grammarAccess.getTypeReferenceWithTypeArgsAccess().getJvmGenericArrayTypeReferenceComponentTypeAction_0_1_0_0()
						|| rule == grammarAccess.getParameterizedTypeReferenceWithTypeArgsRule()
						|| action == grammarAccess.getParameterizedTypeReferenceWithTypeArgsAccess().getJvmInnerTypeReferenceOuterAction_1_4_0_0_0()) {
					sequence_ParameterizedTypeReferenceWithTypeArgs(context, (JvmInnerTypeReference) semanticObject); 
					return; 
				}
				else break;
			case TypesPackage.JVM_LOWER_BOUND:
				if (rule == grammarAccess.getJvmLowerBoundAndedRule()) {
					sequence_JvmLowerBoundAnded(context, (JvmLowerBound) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getJvmLowerBoundRule()) {
					sequence_JvmLowerBound(context, (JvmLowerBound) semanticObject); 
					return; 
				}
				else break;
			case TypesPackage.JVM_PARAMETERIZED_TYPE_REFERENCE:
				if (action == grammarAccess.getJvmParameterizedTypeReferenceAccess().getJvmInnerTypeReferenceOuterAction_1_4_0_0_0()) {
					sequence_JvmParameterizedTypeReference_JvmInnerTypeReference_1_4_0_0_0(context, (JvmParameterizedTypeReference) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getJvmSuperTypeReferenceRule()
						|| rule == grammarAccess.getMultiTypeReferenceRule()
						|| action == grammarAccess.getMultiTypeReferenceAccess().getJvmSynonymTypeReferenceReferencesAction_1_0()
						|| rule == grammarAccess.getJvmTypeReferenceRule()
						|| action == grammarAccess.getJvmTypeReferenceAccess().getJvmGenericArrayTypeReferenceComponentTypeAction_0_1_0_0()
						|| rule == grammarAccess.getJvmParameterizedTypeReferenceRule()
						|| rule == grammarAccess.getJvmArgumentTypeReferenceRule()) {
					sequence_JvmParameterizedTypeReference(context, (JvmParameterizedTypeReference) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeReferenceWithTypeArgsRule()
						|| action == grammarAccess.getTypeReferenceWithTypeArgsAccess().getJvmGenericArrayTypeReferenceComponentTypeAction_0_1_0_0()
						|| rule == grammarAccess.getParameterizedTypeReferenceWithTypeArgsRule()
						|| action == grammarAccess.getParameterizedTypeReferenceWithTypeArgsAccess().getJvmInnerTypeReferenceOuterAction_1_4_0_0_0()) {
					sequence_ParameterizedTypeReferenceWithTypeArgs(context, (JvmParameterizedTypeReference) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeReferenceNoTypeArgsRule()
						|| action == grammarAccess.getTypeReferenceWithTypeArgsAccess().getJvmGenericArrayTypeReferenceComponentTypeAction_1_1_0_0()) {
					sequence_TypeReferenceNoTypeArgs(context, (JvmParameterizedTypeReference) semanticObject); 
					return; 
				}
				else break;
			case TypesPackage.JVM_SYNONYM_TYPE_REFERENCE:
				sequence_MultiTypeReference(context, (JvmSynonymTypeReference) semanticObject); 
				return; 
			case TypesPackage.JVM_TYPE_PARAMETER:
				sequence_JvmTypeParameter(context, (JvmTypeParameter) semanticObject); 
				return; 
			case TypesPackage.JVM_UPPER_BOUND:
				if (rule == grammarAccess.getJvmUpperBoundAndedRule()) {
					sequence_JvmUpperBoundAnded(context, (JvmUpperBound) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getJvmUpperBoundRule()) {
					sequence_JvmUpperBound(context, (JvmUpperBound) semanticObject); 
					return; 
				}
				else break;
			case TypesPackage.JVM_WILDCARD_TYPE_REFERENCE:
				sequence_JvmWildcardTypeReference(context, (JvmWildcardTypeReference) semanticObject); 
				return; 
			}
		else if (epackage == XAnnotationsPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case XAnnotationsPackage.XANNOTATION:
				sequence_XAnnotation(context, (XAnnotation) semanticObject); 
				return; 
			case XAnnotationsPackage.XANNOTATION_ELEMENT_VALUE_PAIR:
				sequence_XAnnotationElementValuePair(context, (XAnnotationElementValuePair) semanticObject); 
				return; 
			}
		else if (epackage == XbasePackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case XbasePackage.XASSIGNMENT:
				sequence_XAssignment_XMemberFeatureCall(context, (XAssignment) semanticObject); 
				return; 
			case XbasePackage.XBASIC_FOR_LOOP_EXPRESSION:
				sequence_XBasicForLoopExpression(context, (XBasicForLoopExpression) semanticObject); 
				return; 
			case XbasePackage.XBINARY_OPERATION:
				sequence_XAdditiveExpression_XAndExpression_XAssignment_XEqualityExpression_XExponentExpression_XMultiplicativeExpression_XOrExpression_XOtherOperatorExpression_XRelationalExpression(context, (XBinaryOperation) semanticObject); 
				return; 
			case XbasePackage.XBLOCK_EXPRESSION:
				if (rule == grammarAccess.getXCastedExpressionRule()
						|| action == grammarAccess.getXCastedExpressionAccess().getSarlCastedExpressionTargetAction_1_0_0_0()
						|| rule == grammarAccess.getXPrimaryExpressionRule()
						|| rule == grammarAccess.getXMultiplicativeExpressionRule()
						|| action == grammarAccess.getXMultiplicativeExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXExponentExpressionRule()
						|| action == grammarAccess.getXExponentExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXUnaryOperationRule()
						|| rule == grammarAccess.getXAssignmentRule()
						|| action == grammarAccess.getXAssignmentAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXConditionalExpressionRule()
						|| action == grammarAccess.getXConditionalExpressionAccess().getXIfExpressionIfAction_1_0_0_0()
						|| rule == grammarAccess.getXExpressionOrSimpleConstructorCallRule()
						|| rule == grammarAccess.getRichStringPartRule()
						|| rule == grammarAccess.getXAnnotationElementValueOrCommaListRule()
						|| action == grammarAccess.getXAnnotationElementValueOrCommaListAccess().getXListLiteralElementsAction_1_1_0()
						|| rule == grammarAccess.getXAnnotationElementValueRule()
						|| rule == grammarAccess.getXAnnotationOrExpressionRule()
						|| rule == grammarAccess.getXExpressionRule()
						|| rule == grammarAccess.getXOrExpressionRule()
						|| action == grammarAccess.getXOrExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAndExpressionRule()
						|| action == grammarAccess.getXAndExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXEqualityExpressionRule()
						|| action == grammarAccess.getXEqualityExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXRelationalExpressionRule()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXInstanceOfExpressionExpressionAction_1_0_0_0_0()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOtherOperatorExpressionRule()
						|| action == grammarAccess.getXOtherOperatorExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAdditiveExpressionRule()
						|| action == grammarAccess.getXAdditiveExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXPostfixOperationRule()
						|| action == grammarAccess.getXPostfixOperationAccess().getXPostfixOperationOperandAction_1_0_0()
						|| rule == grammarAccess.getXMemberFeatureCallRule()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXAssignmentAssignableAction_1_0_0_0_0()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXMemberFeatureCallMemberCallTargetAction_1_1_0_0_0()
						|| rule == grammarAccess.getXParenthesizedExpressionRule()
						|| rule == grammarAccess.getXBlockExpressionRule()
						|| rule == grammarAccess.getXExpressionOrVarDeclarationRule()) {
					sequence_XBlockExpression(context, (XBlockExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getXExpressionInClosureRule()) {
					sequence_XExpressionInClosure(context, (XBlockExpression) semanticObject); 
					return; 
				}
				else break;
			case XbasePackage.XBOOLEAN_LITERAL:
				sequence_XBooleanLiteral(context, (XBooleanLiteral) semanticObject); 
				return; 
			case XbasePackage.XCASE_PART:
				sequence_XCasePart(context, (XCasePart) semanticObject); 
				return; 
			case XbasePackage.XCATCH_CLAUSE:
				sequence_XCatchClause(context, (XCatchClause) semanticObject); 
				return; 
			case XbasePackage.XCLOSURE:
				if (rule == grammarAccess.getXCastedExpressionRule()
						|| action == grammarAccess.getXCastedExpressionAccess().getSarlCastedExpressionTargetAction_1_0_0_0()
						|| rule == grammarAccess.getXPrimaryExpressionRule()
						|| rule == grammarAccess.getXMultiplicativeExpressionRule()
						|| action == grammarAccess.getXMultiplicativeExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXExponentExpressionRule()
						|| action == grammarAccess.getXExponentExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXUnaryOperationRule()
						|| rule == grammarAccess.getXAssignmentRule()
						|| action == grammarAccess.getXAssignmentAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXConditionalExpressionRule()
						|| action == grammarAccess.getXConditionalExpressionAccess().getXIfExpressionIfAction_1_0_0_0()
						|| rule == grammarAccess.getXExpressionOrSimpleConstructorCallRule()
						|| rule == grammarAccess.getRichStringPartRule()
						|| rule == grammarAccess.getXAnnotationElementValueOrCommaListRule()
						|| action == grammarAccess.getXAnnotationElementValueOrCommaListAccess().getXListLiteralElementsAction_1_1_0()
						|| rule == grammarAccess.getXAnnotationElementValueRule()
						|| rule == grammarAccess.getXAnnotationOrExpressionRule()
						|| rule == grammarAccess.getXExpressionRule()
						|| rule == grammarAccess.getXOrExpressionRule()
						|| action == grammarAccess.getXOrExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAndExpressionRule()
						|| action == grammarAccess.getXAndExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXEqualityExpressionRule()
						|| action == grammarAccess.getXEqualityExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXRelationalExpressionRule()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXInstanceOfExpressionExpressionAction_1_0_0_0_0()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOtherOperatorExpressionRule()
						|| action == grammarAccess.getXOtherOperatorExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAdditiveExpressionRule()
						|| action == grammarAccess.getXAdditiveExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXPostfixOperationRule()
						|| action == grammarAccess.getXPostfixOperationAccess().getXPostfixOperationOperandAction_1_0_0()
						|| rule == grammarAccess.getXMemberFeatureCallRule()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXAssignmentAssignableAction_1_0_0_0_0()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXMemberFeatureCallMemberCallTargetAction_1_1_0_0_0()
						|| rule == grammarAccess.getXLiteralRule()
						|| rule == grammarAccess.getXClosureRule()
						|| rule == grammarAccess.getXParenthesizedExpressionRule()
						|| rule == grammarAccess.getXExpressionOrVarDeclarationRule()) {
					sequence_XClosure(context, (XClosure) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getXShortClosureRule()) {
					sequence_XShortClosure(context, (XClosure) semanticObject); 
					return; 
				}
				else break;
			case XbasePackage.XCONSTRUCTOR_CALL:
				sequence_XbaseConstructorCall(context, (XConstructorCall) semanticObject); 
				return; 
			case XbasePackage.XDO_WHILE_EXPRESSION:
				sequence_XDoWhileExpression(context, (XDoWhileExpression) semanticObject); 
				return; 
			case XbasePackage.XFEATURE_CALL:
				sequence_XFeatureCall(context, (XFeatureCall) semanticObject); 
				return; 
			case XbasePackage.XFOR_LOOP_EXPRESSION:
				sequence_XForLoopExpression(context, (XForLoopExpression) semanticObject); 
				return; 
			case XbasePackage.XIF_EXPRESSION:
				if (rule == grammarAccess.getXCastedExpressionRule()
						|| action == grammarAccess.getXCastedExpressionAccess().getSarlCastedExpressionTargetAction_1_0_0_0()
						|| rule == grammarAccess.getXPrimaryExpressionRule()
						|| rule == grammarAccess.getXMultiplicativeExpressionRule()
						|| action == grammarAccess.getXMultiplicativeExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXExponentExpressionRule()
						|| action == grammarAccess.getXExponentExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXUnaryOperationRule()
						|| rule == grammarAccess.getXAssignmentRule()
						|| action == grammarAccess.getXAssignmentAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXConditionalExpressionRule()
						|| action == grammarAccess.getXConditionalExpressionAccess().getXIfExpressionIfAction_1_0_0_0()
						|| rule == grammarAccess.getXExpressionOrSimpleConstructorCallRule()
						|| rule == grammarAccess.getRichStringPartRule()
						|| rule == grammarAccess.getXAnnotationElementValueOrCommaListRule()
						|| action == grammarAccess.getXAnnotationElementValueOrCommaListAccess().getXListLiteralElementsAction_1_1_0()
						|| rule == grammarAccess.getXAnnotationElementValueRule()
						|| rule == grammarAccess.getXAnnotationOrExpressionRule()
						|| rule == grammarAccess.getXExpressionRule()
						|| rule == grammarAccess.getXOrExpressionRule()
						|| action == grammarAccess.getXOrExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAndExpressionRule()
						|| action == grammarAccess.getXAndExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXEqualityExpressionRule()
						|| action == grammarAccess.getXEqualityExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXRelationalExpressionRule()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXInstanceOfExpressionExpressionAction_1_0_0_0_0()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOtherOperatorExpressionRule()
						|| action == grammarAccess.getXOtherOperatorExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAdditiveExpressionRule()
						|| action == grammarAccess.getXAdditiveExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXPostfixOperationRule()
						|| action == grammarAccess.getXPostfixOperationAccess().getXPostfixOperationOperandAction_1_0_0()
						|| rule == grammarAccess.getXMemberFeatureCallRule()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXAssignmentAssignableAction_1_0_0_0_0()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXMemberFeatureCallMemberCallTargetAction_1_1_0_0_0()
						|| rule == grammarAccess.getXParenthesizedExpressionRule()
						|| rule == grammarAccess.getXExpressionOrVarDeclarationRule()) {
					sequence_XConditionalExpression_XIfExpression(context, (XIfExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getXIfExpressionRule()) {
					sequence_XIfExpression(context, (XIfExpression) semanticObject); 
					return; 
				}
				else break;
			case XbasePackage.XINSTANCE_OF_EXPRESSION:
				sequence_XRelationalExpression(context, (XInstanceOfExpression) semanticObject); 
				return; 
			case XbasePackage.XLIST_LITERAL:
				if (rule == grammarAccess.getXAnnotationElementValueOrCommaListRule()) {
					sequence_XAnnotationElementValueOrCommaList_XListLiteral(context, (XListLiteral) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getXAnnotationElementValueRule()) {
					sequence_XAnnotationElementValue_XListLiteral(context, (XListLiteral) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getXCastedExpressionRule()
						|| action == grammarAccess.getXCastedExpressionAccess().getSarlCastedExpressionTargetAction_1_0_0_0()
						|| rule == grammarAccess.getXPrimaryExpressionRule()
						|| rule == grammarAccess.getXMultiplicativeExpressionRule()
						|| action == grammarAccess.getXMultiplicativeExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXExponentExpressionRule()
						|| action == grammarAccess.getXExponentExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXUnaryOperationRule()
						|| rule == grammarAccess.getXAssignmentRule()
						|| action == grammarAccess.getXAssignmentAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXConditionalExpressionRule()
						|| action == grammarAccess.getXConditionalExpressionAccess().getXIfExpressionIfAction_1_0_0_0()
						|| rule == grammarAccess.getXExpressionOrSimpleConstructorCallRule()
						|| rule == grammarAccess.getRichStringPartRule()
						|| action == grammarAccess.getXAnnotationElementValueOrCommaListAccess().getXListLiteralElementsAction_1_1_0()
						|| rule == grammarAccess.getXAnnotationOrExpressionRule()
						|| rule == grammarAccess.getXExpressionRule()
						|| rule == grammarAccess.getXOrExpressionRule()
						|| action == grammarAccess.getXOrExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAndExpressionRule()
						|| action == grammarAccess.getXAndExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXEqualityExpressionRule()
						|| action == grammarAccess.getXEqualityExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXRelationalExpressionRule()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXInstanceOfExpressionExpressionAction_1_0_0_0_0()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOtherOperatorExpressionRule()
						|| action == grammarAccess.getXOtherOperatorExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAdditiveExpressionRule()
						|| action == grammarAccess.getXAdditiveExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXPostfixOperationRule()
						|| action == grammarAccess.getXPostfixOperationAccess().getXPostfixOperationOperandAction_1_0_0()
						|| rule == grammarAccess.getXMemberFeatureCallRule()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXAssignmentAssignableAction_1_0_0_0_0()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXMemberFeatureCallMemberCallTargetAction_1_1_0_0_0()
						|| rule == grammarAccess.getXLiteralRule()
						|| rule == grammarAccess.getXCollectionLiteralRule()
						|| rule == grammarAccess.getXListLiteralRule()
						|| rule == grammarAccess.getXParenthesizedExpressionRule()
						|| rule == grammarAccess.getXExpressionOrVarDeclarationRule()) {
					sequence_XListLiteral(context, (XListLiteral) semanticObject); 
					return; 
				}
				else break;
			case XbasePackage.XMEMBER_FEATURE_CALL:
				sequence_XMemberFeatureCall(context, (XMemberFeatureCall) semanticObject); 
				return; 
			case XbasePackage.XNULL_LITERAL:
				sequence_XNullLiteral(context, (XNullLiteral) semanticObject); 
				return; 
			case XbasePackage.XNUMBER_LITERAL:
				sequence_XNumberLiteral(context, (XNumberLiteral) semanticObject); 
				return; 
			case XbasePackage.XPOSTFIX_OPERATION:
				sequence_XPostfixOperation(context, (XPostfixOperation) semanticObject); 
				return; 
			case XbasePackage.XRETURN_EXPRESSION:
				sequence_XReturnExpression(context, (XReturnExpression) semanticObject); 
				return; 
			case XbasePackage.XSET_LITERAL:
				sequence_XSetLiteral(context, (XSetLiteral) semanticObject); 
				return; 
			case XbasePackage.XSTRING_LITERAL:
				sequence_SimpleStringLiteral(context, (XStringLiteral) semanticObject); 
				return; 
			case XbasePackage.XSWITCH_EXPRESSION:
				sequence_XSwitchExpression(context, (XSwitchExpression) semanticObject); 
				return; 
			case XbasePackage.XSYNCHRONIZED_EXPRESSION:
				sequence_XSynchronizedExpression(context, (XSynchronizedExpression) semanticObject); 
				return; 
			case XbasePackage.XTHROW_EXPRESSION:
				sequence_XThrowExpression(context, (XThrowExpression) semanticObject); 
				return; 
			case XbasePackage.XTRY_CATCH_FINALLY_EXPRESSION:
				sequence_XTryCatchFinallyExpression(context, (XTryCatchFinallyExpression) semanticObject); 
				return; 
			case XbasePackage.XTYPE_LITERAL:
				sequence_XTypeLiteral(context, (XTypeLiteral) semanticObject); 
				return; 
			case XbasePackage.XUNARY_OPERATION:
				sequence_XUnaryOperation(context, (XUnaryOperation) semanticObject); 
				return; 
			case XbasePackage.XWHILE_EXPRESSION:
				sequence_XWhileExpression(context, (XWhileExpression) semanticObject); 
				return; 
			}
		else if (epackage == XtendPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case XtendPackage.ANONYMOUS_CLASS:
				sequence_XConstructorCall(context, (AnonymousClass) semanticObject); 
				return; 
			case XtendPackage.CREATE_EXTENSION_INFO:
				sequence_CreateExtensionInfo(context, (CreateExtensionInfo) semanticObject); 
				return; 
			case XtendPackage.RICH_STRING:
				if (rule == grammarAccess.getInternalRichStringRule()) {
					sequence_InternalRichString(context, (RichString) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getXCastedExpressionRule()
						|| action == grammarAccess.getXCastedExpressionAccess().getSarlCastedExpressionTargetAction_1_0_0_0()
						|| rule == grammarAccess.getXPrimaryExpressionRule()
						|| rule == grammarAccess.getXMultiplicativeExpressionRule()
						|| action == grammarAccess.getXMultiplicativeExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXExponentExpressionRule()
						|| action == grammarAccess.getXExponentExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXUnaryOperationRule()
						|| rule == grammarAccess.getXAssignmentRule()
						|| action == grammarAccess.getXAssignmentAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXConditionalExpressionRule()
						|| action == grammarAccess.getXConditionalExpressionAccess().getXIfExpressionIfAction_1_0_0_0()
						|| rule == grammarAccess.getXStringLiteralRule()
						|| rule == grammarAccess.getXExpressionOrSimpleConstructorCallRule()
						|| rule == grammarAccess.getRichStringRule()
						|| rule == grammarAccess.getRichStringPartRule()
						|| rule == grammarAccess.getXAnnotationElementValueOrCommaListRule()
						|| action == grammarAccess.getXAnnotationElementValueOrCommaListAccess().getXListLiteralElementsAction_1_1_0()
						|| rule == grammarAccess.getXAnnotationElementValueRule()
						|| rule == grammarAccess.getXAnnotationOrExpressionRule()
						|| rule == grammarAccess.getXExpressionRule()
						|| rule == grammarAccess.getXOrExpressionRule()
						|| action == grammarAccess.getXOrExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAndExpressionRule()
						|| action == grammarAccess.getXAndExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXEqualityExpressionRule()
						|| action == grammarAccess.getXEqualityExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXRelationalExpressionRule()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXInstanceOfExpressionExpressionAction_1_0_0_0_0()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOtherOperatorExpressionRule()
						|| action == grammarAccess.getXOtherOperatorExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAdditiveExpressionRule()
						|| action == grammarAccess.getXAdditiveExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXPostfixOperationRule()
						|| action == grammarAccess.getXPostfixOperationAccess().getXPostfixOperationOperandAction_1_0_0()
						|| rule == grammarAccess.getXMemberFeatureCallRule()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXAssignmentAssignableAction_1_0_0_0_0()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXMemberFeatureCallMemberCallTargetAction_1_1_0_0_0()
						|| rule == grammarAccess.getXLiteralRule()
						|| rule == grammarAccess.getXParenthesizedExpressionRule()
						|| rule == grammarAccess.getXExpressionOrVarDeclarationRule()) {
					sequence_RichString(context, (RichString) semanticObject); 
					return; 
				}
				else break;
			case XtendPackage.RICH_STRING_ELSE_IF:
				sequence_RichStringElseIf(context, (RichStringElseIf) semanticObject); 
				return; 
			case XtendPackage.RICH_STRING_FOR_LOOP:
				sequence_RichStringForLoop(context, (RichStringForLoop) semanticObject); 
				return; 
			case XtendPackage.RICH_STRING_IF:
				sequence_RichStringIf(context, (RichStringIf) semanticObject); 
				return; 
			case XtendPackage.RICH_STRING_LITERAL:
				if (rule == grammarAccess.getRichStringLiteralEndRule()) {
					sequence_RichStringLiteralEnd(context, (RichStringLiteral) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getRichStringLiteralInbetweenRule()) {
					sequence_RichStringLiteralInbetween(context, (RichStringLiteral) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getRichStringLiteralStartRule()) {
					sequence_RichStringLiteralStart(context, (RichStringLiteral) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getRichStringLiteralRule()) {
					sequence_RichStringLiteral(context, (RichStringLiteral) semanticObject); 
					return; 
				}
				else break;
			case XtendPackage.XTEND_FILE:
				sequence_File(context, (XtendFile) semanticObject); 
				return; 
			case XtendPackage.XTEND_FORMAL_PARAMETER:
				if (rule == grammarAccess.getFullJvmFormalParameterRule()) {
					sequence_FullJvmFormalParameter(context, (XtendFormalParameter) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getJvmFormalParameterRule()) {
					sequence_JvmFormalParameter(context, (XtendFormalParameter) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getSarlXLoopFormalParameterRule()) {
					sequence_SarlXLoopFormalParameter(context, (XtendFormalParameter) semanticObject); 
					return; 
				}
				else break;
			case XtendPackage.XTEND_MEMBER:
				if (action == grammarAccess.getAOPMemberAccess().getSarlBehaviorUnitAnnotationInfoAction_2_0_0()
						|| action == grammarAccess.getAOPMemberAccess().getSarlCapacityUsesAnnotationInfoAction_2_1_0()
						|| action == grammarAccess.getAOPMemberAccess().getSarlRequiredCapacityAnnotationInfoAction_2_2_0()
						|| action == grammarAccess.getAOPMemberAccess().getSarlFieldAnnotationInfoAction_2_3_0()
						|| action == grammarAccess.getAOPMemberAccess().getSarlConstructorAnnotationInfoAction_2_4_0()
						|| action == grammarAccess.getAOPMemberAccess().getSarlActionAnnotationInfoAction_2_5_0()
						|| action == grammarAccess.getAOPMemberAccess().getSarlClassAnnotationInfoAction_2_6_0()
						|| action == grammarAccess.getAOPMemberAccess().getSarlInterfaceAnnotationInfoAction_2_7_0()
						|| action == grammarAccess.getAOPMemberAccess().getSarlEnumerationAnnotationInfoAction_2_8_0()
						|| action == grammarAccess.getAOPMemberAccess().getSarlAnnotationTypeAnnotationInfoAction_2_9_0()) {
					sequence_AOPMember_SarlAction_2_5_0_SarlAnnotationType_2_9_0_SarlBehaviorUnit_2_0_0_SarlCapacityUses_2_1_0_SarlClass_2_6_0_SarlConstructor_2_4_0_SarlEnumeration_2_8_0_SarlField_2_3_0_SarlInterface_2_7_0_SarlRequiredCapacity_2_2_0(context, (XtendMember) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getAnnotationFieldAccess().getSarlFieldAnnotationInfoAction_2_0_0()
						|| action == grammarAccess.getAnnotationFieldAccess().getSarlClassAnnotationInfoAction_2_1_0()
						|| action == grammarAccess.getAnnotationFieldAccess().getSarlInterfaceAnnotationInfoAction_2_2_0()
						|| action == grammarAccess.getAnnotationFieldAccess().getSarlEnumerationAnnotationInfoAction_2_3_0()
						|| action == grammarAccess.getAnnotationFieldAccess().getSarlAnnotationTypeAnnotationInfoAction_2_4_0()) {
					sequence_AnnotationField_SarlAnnotationType_2_4_0_SarlClass_2_1_0_SarlEnumeration_2_3_0_SarlField_2_0_0_SarlInterface_2_2_0(context, (XtendMember) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getCapacityMemberAccess().getSarlActionAnnotationInfoAction_2()) {
					sequence_CapacityMember_SarlAction_2(context, (XtendMember) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getEventMemberAccess().getSarlFieldAnnotationInfoAction_2_0_0()
						|| action == grammarAccess.getEventMemberAccess().getSarlConstructorAnnotationInfoAction_2_1_0()) {
					sequence_EventMember_SarlConstructor_2_1_0_SarlField_2_0_0(context, (XtendMember) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getMemberAccess().getSarlFieldAnnotationInfoAction_2_0_0()
						|| action == grammarAccess.getMemberAccess().getSarlConstructorAnnotationInfoAction_2_1_0()
						|| action == grammarAccess.getMemberAccess().getSarlActionAnnotationInfoAction_2_2_0()
						|| action == grammarAccess.getMemberAccess().getSarlClassAnnotationInfoAction_2_3_0()
						|| action == grammarAccess.getMemberAccess().getSarlInterfaceAnnotationInfoAction_2_4_0()
						|| action == grammarAccess.getMemberAccess().getSarlEnumerationAnnotationInfoAction_2_5_0()
						|| action == grammarAccess.getMemberAccess().getSarlAnnotationTypeAnnotationInfoAction_2_6_0()) {
					sequence_Member_SarlAction_2_2_0_SarlAnnotationType_2_6_0_SarlClass_2_3_0_SarlConstructor_2_1_0_SarlEnumeration_2_5_0_SarlField_2_0_0_SarlInterface_2_4_0(context, (XtendMember) semanticObject); 
					return; 
				}
				else break;
			case XtendPackage.XTEND_TYPE_DECLARATION:
				sequence_Type_SarlAgent_2_2_0_SarlAnnotationType_2_10_0_SarlArtifact_2_6_0_SarlBehavior_2_3_0_SarlCapacity_2_1_0_SarlClass_2_7_0_SarlEnumeration_2_9_0_SarlEvent_2_0_0_SarlInterface_2_8_0_SarlSkill_2_4_0_SarlSpace_2_5_0(context, (XtendTypeDeclaration) semanticObject); 
				return; 
			case XtendPackage.XTEND_VARIABLE_DECLARATION:
				if (rule == grammarAccess.getInitializedVariableDeclarationRule()) {
					sequence_InitializedVariableDeclaration_VariableModifier(context, (XtendVariableDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getXVariableDeclarationRule()
						|| rule == grammarAccess.getRichStringPartRule()
						|| rule == grammarAccess.getXExpressionOrVarDeclarationRule()) {
					sequence_XVariableDeclaration(context, (XtendVariableDeclaration) semanticObject); 
					return; 
				}
				else break;
			}
		else if (epackage == XtypePackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case XtypePackage.XFUNCTION_TYPE_REF:
				if (rule == grammarAccess.getJvmSuperTypeReferenceRule()
						|| rule == grammarAccess.getXFunctionSuperTypeRefRule()) {
					sequence_XFunctionSuperTypeRef(context, (XFunctionTypeRef) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeReferenceWithTypeArgsRule()
						|| rule == grammarAccess.getMultiTypeReferenceRule()
						|| action == grammarAccess.getMultiTypeReferenceAccess().getJvmSynonymTypeReferenceReferencesAction_1_0()
						|| rule == grammarAccess.getJvmTypeReferenceRule()
						|| rule == grammarAccess.getXFunctionTypeRefRule()
						|| rule == grammarAccess.getJvmArgumentTypeReferenceRule()) {
					sequence_XFunctionTypeRef(context, (XFunctionTypeRef) semanticObject); 
					return; 
				}
				else break;
			case XtypePackage.XIMPORT_DECLARATION:
				sequence_XImportDeclaration(context, (XImportDeclaration) semanticObject); 
				return; 
			case XtypePackage.XIMPORT_SECTION:
				sequence_XImportSection(context, (XImportSection) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember returns SarlAction
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=AOPMember_SarlAction_2_5_0 
	 *         modifiers+=CommonModifier* 
	 *         modifiers+=MethodModifier 
	 *         (modifiers+=CommonModifier | modifiers+=MethodModifier)* 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         name=FunctionID 
	 *         (parameters+=Parameter parameters+=Parameter*)? 
	 *         (returnType=TypeReferenceWithTypeArgs | returnType=TypeReferenceNoTypeArgs)? 
	 *         (
	 *             (exceptions+=JvmTypeReference exceptions+=JvmTypeReference*) | 
	 *             (firedEvents+=JvmTypeReference firedEvents+=JvmTypeReference*) | 
	 *             (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)
	 *         )* 
	 *         expression=XBlockExpression?
	 *     )
	 * </pre>
	 */
	protected void sequence_AOPMember(ISerializationContext context, SarlAction semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember.SarlBehaviorUnit_2_0_0 returns XtendMember
	 *     AOPMember.SarlCapacityUses_2_1_0 returns XtendMember
	 *     AOPMember.SarlRequiredCapacity_2_2_0 returns XtendMember
	 *     AOPMember.SarlField_2_3_0 returns XtendMember
	 *     AOPMember.SarlConstructor_2_4_0 returns XtendMember
	 *     AOPMember.SarlAction_2_5_0 returns XtendMember
	 *     AOPMember.SarlClass_2_6_0 returns XtendMember
	 *     AOPMember.SarlInterface_2_7_0 returns XtendMember
	 *     AOPMember.SarlEnumeration_2_8_0 returns XtendMember
	 *     AOPMember.SarlAnnotationType_2_9_0 returns XtendMember
	 *
	 * Constraint:
	 *     annotations+=XAnnotation*
	 * </pre>
	 */
	protected void sequence_AOPMember_SarlAction_2_5_0_SarlAnnotationType_2_9_0_SarlBehaviorUnit_2_0_0_SarlCapacityUses_2_1_0_SarlClass_2_6_0_SarlConstructor_2_4_0_SarlEnumeration_2_8_0_SarlField_2_3_0_SarlInterface_2_7_0_SarlRequiredCapacity_2_2_0(ISerializationContext context, XtendMember semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember returns SarlAnnotationType
	 *
	 * Constraint:
	 *     (annotationInfo=AOPMember_SarlAnnotationType_2_9_0 modifiers+=CommonModifier* name=ValidID members+=AnnotationField*)
	 * </pre>
	 */
	protected void sequence_AOPMember(ISerializationContext context, SarlAnnotationType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember returns SarlBehaviorUnit
	 *
	 * Constraint:
	 *     (annotationInfo=AOPMember_SarlBehaviorUnit_2_0_0 name=JvmParameterizedTypeReference guard=XExpression? expression=XBlockExpression)
	 * </pre>
	 */
	protected void sequence_AOPMember(ISerializationContext context, SarlBehaviorUnit semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember returns SarlCapacityUses
	 *
	 * Constraint:
	 *     (annotationInfo=AOPMember_SarlCapacityUses_2_1_0 capacities+=JvmParameterizedTypeReference capacities+=JvmParameterizedTypeReference*)
	 * </pre>
	 */
	protected void sequence_AOPMember(ISerializationContext context, SarlCapacityUses semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember returns SarlClass
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=AOPMember_SarlClass_2_6_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (extends=JvmParameterizedTypeReference? (implements+=JvmParameterizedTypeReference implements+=JvmParameterizedTypeReference*)?)+ 
	 *         members+=Member*
	 *     )
	 * </pre>
	 */
	protected void sequence_AOPMember(ISerializationContext context, SarlClass semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember returns SarlConstructor
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=AOPMember_SarlConstructor_2_4_0 
	 *         modifiers+=CommonModifier* 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (parameters+=Parameter parameters+=Parameter*)? 
	 *         ((exceptions+=JvmTypeReference exceptions+=JvmTypeReference*) | (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*))* 
	 *         expression=XBlockExpression
	 *     )
	 * </pre>
	 */
	protected void sequence_AOPMember(ISerializationContext context, SarlConstructor semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember returns SarlEnumeration
	 *
	 * Constraint:
	 *     (annotationInfo=AOPMember_SarlEnumeration_2_8_0 modifiers+=CommonModifier* name=ValidID (members+=XtendEnumLiteral members+=XtendEnumLiteral*)?)
	 * </pre>
	 */
	protected void sequence_AOPMember(ISerializationContext context, SarlEnumeration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember returns SarlField
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=AOPMember_SarlField_2_3_0 
	 *         modifiers+=CommonModifier* 
	 *         (
	 *             (modifiers+='extension' (modifiers+=FieldModifier | modifiers+=CommonModifier)* name=ValidID type=JvmTypeReference) | 
	 *             (
	 *                 modifiers+=FieldModifier 
	 *                 modifiers+=CommonModifier* 
	 *                 ((modifiers+='extension' name=ValidID type=JvmTypeReference) | (name=ValidID type=JvmTypeReference?))
	 *             )
	 *         ) 
	 *         initialValue=XExpression?
	 *     )
	 * </pre>
	 */
	protected void sequence_AOPMember(ISerializationContext context, SarlField semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember returns SarlInterface
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=AOPMember_SarlInterface_2_7_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (extends+=JvmParameterizedTypeReference extends+=JvmParameterizedTypeReference*)? 
	 *         members+=Member*
	 *     )
	 * </pre>
	 */
	protected void sequence_AOPMember(ISerializationContext context, SarlInterface semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AOPMember returns SarlRequiredCapacity
	 *
	 * Constraint:
	 *     (annotationInfo=AOPMember_SarlRequiredCapacity_2_2_0 capacities+=JvmParameterizedTypeReference capacities+=JvmParameterizedTypeReference*)
	 * </pre>
	 */
	protected void sequence_AOPMember(ISerializationContext context, SarlRequiredCapacity semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AnnotationField returns SarlAnnotationType
	 *
	 * Constraint:
	 *     (annotationInfo=AnnotationField_SarlAnnotationType_2_4_0 modifiers+=CommonModifier* name=ValidID members+=AnnotationField*)
	 * </pre>
	 */
	protected void sequence_AnnotationField(ISerializationContext context, SarlAnnotationType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AnnotationField.SarlField_2_0_0 returns XtendMember
	 *     AnnotationField.SarlClass_2_1_0 returns XtendMember
	 *     AnnotationField.SarlInterface_2_2_0 returns XtendMember
	 *     AnnotationField.SarlEnumeration_2_3_0 returns XtendMember
	 *     AnnotationField.SarlAnnotationType_2_4_0 returns XtendMember
	 *
	 * Constraint:
	 *     annotations+=XAnnotation*
	 * </pre>
	 */
	protected void sequence_AnnotationField_SarlAnnotationType_2_4_0_SarlClass_2_1_0_SarlEnumeration_2_3_0_SarlField_2_0_0_SarlInterface_2_2_0(ISerializationContext context, XtendMember semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AnnotationField returns SarlClass
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=AnnotationField_SarlClass_2_1_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (extends=JvmParameterizedTypeReference? (implements+=JvmParameterizedTypeReference implements+=JvmParameterizedTypeReference*)?)+ 
	 *         members+=Member*
	 *     )
	 * </pre>
	 */
	protected void sequence_AnnotationField(ISerializationContext context, SarlClass semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AnnotationField returns SarlEnumeration
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=AnnotationField_SarlEnumeration_2_3_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (members+=XtendEnumLiteral members+=XtendEnumLiteral*)?
	 *     )
	 * </pre>
	 */
	protected void sequence_AnnotationField(ISerializationContext context, SarlEnumeration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AnnotationField returns SarlField
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=AnnotationField_SarlField_2_0_0 
	 *         modifiers+=CommonModifier* 
	 *         modifiers+=FieldModifier 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         type=JvmTypeReference? 
	 *         initialValue=XAnnotationElementValue?
	 *     )
	 * </pre>
	 */
	protected void sequence_AnnotationField(ISerializationContext context, SarlField semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AnnotationField returns SarlInterface
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=AnnotationField_SarlInterface_2_2_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (extends+=JvmParameterizedTypeReference extends+=JvmParameterizedTypeReference*)? 
	 *         members+=Member*
	 *     )
	 * </pre>
	 */
	protected void sequence_AnnotationField(ISerializationContext context, SarlInterface semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     XCastedExpression returns SarlAssertExpression
	 *     XCastedExpression.SarlCastedExpression_1_0_0_0 returns SarlAssertExpression
	 *     XPrimaryExpression returns SarlAssertExpression
	 *     XMultiplicativeExpression returns SarlAssertExpression
	 *     XMultiplicativeExpression.XBinaryOperation_1_0_0_0 returns SarlAssertExpression
	 *     XExponentExpression returns SarlAssertExpression
	 *     XExponentExpression.XBinaryOperation_1_0_0_0 returns SarlAssertExpression
	 *     XUnaryOperation returns SarlAssertExpression
	 *     XAssignment returns SarlAssertExpression
	 *     XAssignment.XBinaryOperation_1_1_0_0_0 returns SarlAssertExpression
	 *     XConditionalExpression returns SarlAssertExpression
	 *     XConditionalExpression.XIfExpression_1_0_0_0 returns SarlAssertExpression
	 *     XExpressionOrSimpleConstructorCall returns SarlAssertExpression
	 *     RichStringPart returns SarlAssertExpression
	 *     XAnnotationElementValueOrCommaList returns SarlAssertExpression
	 *     XAnnotationElementValueOrCommaList.XListLiteral_1_1_0 returns SarlAssertExpression
	 *     XAnnotationElementValue returns SarlAssertExpression
	 *     XAnnotationOrExpression returns SarlAssertExpression
	 *     XExpression returns SarlAssertExpression
	 *     XOrExpression returns SarlAssertExpression
	 *     XOrExpression.XBinaryOperation_1_0_0_0 returns SarlAssertExpression
	 *     XAndExpression returns SarlAssertExpression
	 *     XAndExpression.XBinaryOperation_1_0_0_0 returns SarlAssertExpression
	 *     XEqualityExpression returns SarlAssertExpression
	 *     XEqualityExpression.XBinaryOperation_1_0_0_0 returns SarlAssertExpression
	 *     XRelationalExpression returns SarlAssertExpression
	 *     XRelationalExpression.XInstanceOfExpression_1_0_0_0_0 returns SarlAssertExpression
	 *     XRelationalExpression.XBinaryOperation_1_1_0_0_0 returns SarlAssertExpression
	 *     XOtherOperatorExpression returns SarlAssertExpression
	 *     XOtherOperatorExpression.XBinaryOperation_1_0_0_0 returns SarlAssertExpression
	 *     XAdditiveExpression returns SarlAssertExpression
	 *     XAdditiveExpression.XBinaryOperation_1_0_0_0 returns SarlAssertExpression
	 *     XPostfixOperation returns SarlAssertExpression
	 *     XPostfixOperation.XPostfixOperation_1_0_0 returns SarlAssertExpression
	 *     XMemberFeatureCall returns SarlAssertExpression
	 *     XMemberFeatureCall.XAssignment_1_0_0_0_0 returns SarlAssertExpression
	 *     XMemberFeatureCall.XMemberFeatureCall_1_1_0_0_0 returns SarlAssertExpression
	 *     XParenthesizedExpression returns SarlAssertExpression
	 *     XExpressionOrVarDeclaration returns SarlAssertExpression
	 *
	 * Constraint:
	 *     ((condition=XExpression message=STRING?) | (isStatic?='assume' condition=XExpression message=STRING?))
	 * </pre>
	 */
	protected void sequence_AssertExpression_AssumeExpression(ISerializationContext context, SarlAssertExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AssertExpression returns SarlAssertExpression
	 *
	 * Constraint:
	 *     (condition=XExpression message=STRING?)
	 * </pre>
	 */
	protected void sequence_AssertExpression(ISerializationContext context, SarlAssertExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AssumeExpression returns SarlAssertExpression
	 *
	 * Constraint:
	 *     (isStatic?='assume' condition=XExpression message=STRING?)
	 * </pre>
	 */
	protected void sequence_AssumeExpression(ISerializationContext context, SarlAssertExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     BreakExpression returns SarlBreakExpression
	 *     XCastedExpression returns SarlBreakExpression
	 *     XCastedExpression.SarlCastedExpression_1_0_0_0 returns SarlBreakExpression
	 *     XPrimaryExpression returns SarlBreakExpression
	 *     XMultiplicativeExpression returns SarlBreakExpression
	 *     XMultiplicativeExpression.XBinaryOperation_1_0_0_0 returns SarlBreakExpression
	 *     XExponentExpression returns SarlBreakExpression
	 *     XExponentExpression.XBinaryOperation_1_0_0_0 returns SarlBreakExpression
	 *     XUnaryOperation returns SarlBreakExpression
	 *     XAssignment returns SarlBreakExpression
	 *     XAssignment.XBinaryOperation_1_1_0_0_0 returns SarlBreakExpression
	 *     XConditionalExpression returns SarlBreakExpression
	 *     XConditionalExpression.XIfExpression_1_0_0_0 returns SarlBreakExpression
	 *     XExpressionOrSimpleConstructorCall returns SarlBreakExpression
	 *     RichStringPart returns SarlBreakExpression
	 *     XAnnotationElementValueOrCommaList returns SarlBreakExpression
	 *     XAnnotationElementValueOrCommaList.XListLiteral_1_1_0 returns SarlBreakExpression
	 *     XAnnotationElementValue returns SarlBreakExpression
	 *     XAnnotationOrExpression returns SarlBreakExpression
	 *     XExpression returns SarlBreakExpression
	 *     XOrExpression returns SarlBreakExpression
	 *     XOrExpression.XBinaryOperation_1_0_0_0 returns SarlBreakExpression
	 *     XAndExpression returns SarlBreakExpression
	 *     XAndExpression.XBinaryOperation_1_0_0_0 returns SarlBreakExpression
	 *     XEqualityExpression returns SarlBreakExpression
	 *     XEqualityExpression.XBinaryOperation_1_0_0_0 returns SarlBreakExpression
	 *     XRelationalExpression returns SarlBreakExpression
	 *     XRelationalExpression.XInstanceOfExpression_1_0_0_0_0 returns SarlBreakExpression
	 *     XRelationalExpression.XBinaryOperation_1_1_0_0_0 returns SarlBreakExpression
	 *     XOtherOperatorExpression returns SarlBreakExpression
	 *     XOtherOperatorExpression.XBinaryOperation_1_0_0_0 returns SarlBreakExpression
	 *     XAdditiveExpression returns SarlBreakExpression
	 *     XAdditiveExpression.XBinaryOperation_1_0_0_0 returns SarlBreakExpression
	 *     XPostfixOperation returns SarlBreakExpression
	 *     XPostfixOperation.XPostfixOperation_1_0_0 returns SarlBreakExpression
	 *     XMemberFeatureCall returns SarlBreakExpression
	 *     XMemberFeatureCall.XAssignment_1_0_0_0_0 returns SarlBreakExpression
	 *     XMemberFeatureCall.XMemberFeatureCall_1_1_0_0_0 returns SarlBreakExpression
	 *     XParenthesizedExpression returns SarlBreakExpression
	 *     XExpressionOrVarDeclaration returns SarlBreakExpression
	 *
	 * Constraint:
	 *     {SarlBreakExpression}
	 * </pre>
	 */
	protected void sequence_BreakExpression(ISerializationContext context, SarlBreakExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     CapacityMember returns SarlAction
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=CapacityMember_SarlAction_2 
	 *         modifiers+=CommonModifier* 
	 *         modifiers+=MethodModifier 
	 *         modifiers+=CommonModifier* 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         name=FunctionID 
	 *         (parameters+=Parameter parameters+=Parameter*)? 
	 *         (returnType=TypeReferenceWithTypeArgs | returnType=TypeReferenceNoTypeArgs)? 
	 *         (
	 *             (exceptions+=JvmTypeReference exceptions+=JvmTypeReference*) | 
	 *             (firedEvents+=JvmTypeReference firedEvents+=JvmTypeReference*) | 
	 *             (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)
	 *         )* 
	 *         expression=XBlockExpression?
	 *     )
	 * </pre>
	 */
	protected void sequence_CapacityMember(ISerializationContext context, SarlAction semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     CapacityMember.SarlAction_2 returns XtendMember
	 *
	 * Constraint:
	 *     annotations+=XAnnotation*
	 * </pre>
	 */
	protected void sequence_CapacityMember_SarlAction_2(ISerializationContext context, XtendMember semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ContinueExpression returns SarlContinueExpression
	 *     XCastedExpression returns SarlContinueExpression
	 *     XCastedExpression.SarlCastedExpression_1_0_0_0 returns SarlContinueExpression
	 *     XPrimaryExpression returns SarlContinueExpression
	 *     XMultiplicativeExpression returns SarlContinueExpression
	 *     XMultiplicativeExpression.XBinaryOperation_1_0_0_0 returns SarlContinueExpression
	 *     XExponentExpression returns SarlContinueExpression
	 *     XExponentExpression.XBinaryOperation_1_0_0_0 returns SarlContinueExpression
	 *     XUnaryOperation returns SarlContinueExpression
	 *     XAssignment returns SarlContinueExpression
	 *     XAssignment.XBinaryOperation_1_1_0_0_0 returns SarlContinueExpression
	 *     XConditionalExpression returns SarlContinueExpression
	 *     XConditionalExpression.XIfExpression_1_0_0_0 returns SarlContinueExpression
	 *     XExpressionOrSimpleConstructorCall returns SarlContinueExpression
	 *     RichStringPart returns SarlContinueExpression
	 *     XAnnotationElementValueOrCommaList returns SarlContinueExpression
	 *     XAnnotationElementValueOrCommaList.XListLiteral_1_1_0 returns SarlContinueExpression
	 *     XAnnotationElementValue returns SarlContinueExpression
	 *     XAnnotationOrExpression returns SarlContinueExpression
	 *     XExpression returns SarlContinueExpression
	 *     XOrExpression returns SarlContinueExpression
	 *     XOrExpression.XBinaryOperation_1_0_0_0 returns SarlContinueExpression
	 *     XAndExpression returns SarlContinueExpression
	 *     XAndExpression.XBinaryOperation_1_0_0_0 returns SarlContinueExpression
	 *     XEqualityExpression returns SarlContinueExpression
	 *     XEqualityExpression.XBinaryOperation_1_0_0_0 returns SarlContinueExpression
	 *     XRelationalExpression returns SarlContinueExpression
	 *     XRelationalExpression.XInstanceOfExpression_1_0_0_0_0 returns SarlContinueExpression
	 *     XRelationalExpression.XBinaryOperation_1_1_0_0_0 returns SarlContinueExpression
	 *     XOtherOperatorExpression returns SarlContinueExpression
	 *     XOtherOperatorExpression.XBinaryOperation_1_0_0_0 returns SarlContinueExpression
	 *     XAdditiveExpression returns SarlContinueExpression
	 *     XAdditiveExpression.XBinaryOperation_1_0_0_0 returns SarlContinueExpression
	 *     XPostfixOperation returns SarlContinueExpression
	 *     XPostfixOperation.XPostfixOperation_1_0_0 returns SarlContinueExpression
	 *     XMemberFeatureCall returns SarlContinueExpression
	 *     XMemberFeatureCall.XAssignment_1_0_0_0_0 returns SarlContinueExpression
	 *     XMemberFeatureCall.XMemberFeatureCall_1_1_0_0_0 returns SarlContinueExpression
	 *     XParenthesizedExpression returns SarlContinueExpression
	 *     XExpressionOrVarDeclaration returns SarlContinueExpression
	 *
	 * Constraint:
	 *     {SarlContinueExpression}
	 * </pre>
	 */
	protected void sequence_ContinueExpression(ISerializationContext context, SarlContinueExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     EventMember returns SarlConstructor
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=EventMember_SarlConstructor_2_1_0 
	 *         modifiers+=CommonModifier* 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (parameters+=Parameter parameters+=Parameter*)? 
	 *         ((exceptions+=JvmTypeReference exceptions+=JvmTypeReference*) | (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*))* 
	 *         expression=XBlockExpression
	 *     )
	 * </pre>
	 */
	protected void sequence_EventMember(ISerializationContext context, SarlConstructor semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     EventMember.SarlField_2_0_0 returns XtendMember
	 *     EventMember.SarlConstructor_2_1_0 returns XtendMember
	 *
	 * Constraint:
	 *     annotations+=XAnnotation*
	 * </pre>
	 */
	protected void sequence_EventMember_SarlConstructor_2_1_0_SarlField_2_0_0(ISerializationContext context, XtendMember semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     EventMember returns SarlField
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=EventMember_SarlField_2_0_0 
	 *         modifiers+=CommonModifier* 
	 *         (
	 *             (modifiers+='extension' (modifiers+=FieldModifier | modifiers+=CommonModifier)* name=ValidID type=JvmTypeReference) | 
	 *             (
	 *                 modifiers+=FieldModifier 
	 *                 modifiers+=CommonModifier* 
	 *                 ((modifiers+='extension' name=ValidID type=JvmTypeReference) | (name=ValidID type=JvmTypeReference?))
	 *             )
	 *         ) 
	 *         initialValue=XExpression?
	 *     )
	 * </pre>
	 */
	protected void sequence_EventMember(ISerializationContext context, SarlField semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     FullJvmFormalParameter returns XtendFormalParameter
	 *
	 * Constraint:
	 *     (extension?='extension'? name=ValidID parameterType=MultiTypeReference)
	 * </pre>
	 */
	protected void sequence_FullJvmFormalParameter(ISerializationContext context, XtendFormalParameter semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     JvmFormalParameter returns XtendFormalParameter
	 *
	 * Constraint:
	 *     (extension?='extension'? name=ValidID parameterType=JvmTypeReference?)
	 * </pre>
	 */
	protected void sequence_JvmFormalParameter(ISerializationContext context, XtendFormalParameter semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Member returns SarlAction
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=Member_SarlAction_2_2_0 
	 *         modifiers+=CommonModifier* 
	 *         modifiers+=MethodModifier 
	 *         (modifiers+=CommonModifier | modifiers+=MethodModifier)* 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         name=FunctionID 
	 *         (parameters+=Parameter parameters+=Parameter*)? 
	 *         (returnType=TypeReferenceWithTypeArgs | returnType=TypeReferenceNoTypeArgs)? 
	 *         (
	 *             (exceptions+=JvmTypeReference exceptions+=JvmTypeReference*) | 
	 *             (firedEvents+=JvmTypeReference firedEvents+=JvmTypeReference*) | 
	 *             (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)
	 *         )* 
	 *         expression=XBlockExpression?
	 *     )
	 * </pre>
	 */
	protected void sequence_Member(ISerializationContext context, SarlAction semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Member.SarlField_2_0_0 returns XtendMember
	 *     Member.SarlConstructor_2_1_0 returns XtendMember
	 *     Member.SarlAction_2_2_0 returns XtendMember
	 *     Member.SarlClass_2_3_0 returns XtendMember
	 *     Member.SarlInterface_2_4_0 returns XtendMember
	 *     Member.SarlEnumeration_2_5_0 returns XtendMember
	 *     Member.SarlAnnotationType_2_6_0 returns XtendMember
	 *
	 * Constraint:
	 *     annotations+=XAnnotation*
	 * </pre>
	 */
	protected void sequence_Member_SarlAction_2_2_0_SarlAnnotationType_2_6_0_SarlClass_2_3_0_SarlConstructor_2_1_0_SarlEnumeration_2_5_0_SarlField_2_0_0_SarlInterface_2_4_0(ISerializationContext context, XtendMember semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Member returns SarlAnnotationType
	 *
	 * Constraint:
	 *     (annotationInfo=Member_SarlAnnotationType_2_6_0 modifiers+=CommonModifier* name=ValidID members+=AnnotationField*)
	 * </pre>
	 */
	protected void sequence_Member(ISerializationContext context, SarlAnnotationType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Member returns SarlClass
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=Member_SarlClass_2_3_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (extends=JvmParameterizedTypeReference? (implements+=JvmParameterizedTypeReference implements+=JvmParameterizedTypeReference*)?)+ 
	 *         members+=Member*
	 *     )
	 * </pre>
	 */
	protected void sequence_Member(ISerializationContext context, SarlClass semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Member returns SarlConstructor
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=Member_SarlConstructor_2_1_0 
	 *         modifiers+=CommonModifier* 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (parameters+=Parameter parameters+=Parameter*)? 
	 *         ((exceptions+=JvmTypeReference exceptions+=JvmTypeReference*) | (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*))* 
	 *         expression=XBlockExpression
	 *     )
	 * </pre>
	 */
	protected void sequence_Member(ISerializationContext context, SarlConstructor semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Member returns SarlEnumeration
	 *
	 * Constraint:
	 *     (annotationInfo=Member_SarlEnumeration_2_5_0 modifiers+=CommonModifier* name=ValidID (members+=XtendEnumLiteral members+=XtendEnumLiteral*)?)
	 * </pre>
	 */
	protected void sequence_Member(ISerializationContext context, SarlEnumeration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Member returns SarlField
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=Member_SarlField_2_0_0 
	 *         modifiers+=CommonModifier* 
	 *         (
	 *             (modifiers+='extension' (modifiers+=FieldModifier | modifiers+=CommonModifier)* name=ValidID type=JvmTypeReference) | 
	 *             (
	 *                 modifiers+=FieldModifier 
	 *                 modifiers+=CommonModifier* 
	 *                 ((modifiers+='extension' name=ValidID type=JvmTypeReference) | (name=ValidID type=JvmTypeReference?))
	 *             )
	 *         ) 
	 *         initialValue=XExpression?
	 *     )
	 * </pre>
	 */
	protected void sequence_Member(ISerializationContext context, SarlField semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Member returns SarlInterface
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=Member_SarlInterface_2_4_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (extends+=JvmParameterizedTypeReference extends+=JvmParameterizedTypeReference*)? 
	 *         members+=Member*
	 *     )
	 * </pre>
	 */
	protected void sequence_Member(ISerializationContext context, SarlInterface semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Parameter returns SarlFormalParameter
	 *
	 * Constraint:
	 *     (
	 *         annotations+=XAnnotation* 
	 *         (extension?='extension' annotations+=XAnnotation*)? 
	 *         name=ValidID 
	 *         parameterType=JvmTypeReference 
	 *         (varArg?='*' | defaultValue=XExpression)?
	 *     )
	 * </pre>
	 */
	protected void sequence_Parameter(ISerializationContext context, SarlFormalParameter semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SarlCastedExpression returns SarlCastedExpression
	 *
	 * Constraint:
	 *     feature=[JvmIdentifiableElement|IdOrSuper]?
	 * </pre>
	 */
	protected void sequence_SarlCastedExpression(ISerializationContext context, SarlCastedExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SarlScript returns SarlScript
	 *
	 * Constraint:
	 *     (package=QualifiedName? importSection=XImportSection? xtendTypes+=Type*)
	 * </pre>
	 */
	protected void sequence_SarlScript(ISerializationContext context, SarlScript semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SarlXLoopFormalParameter returns XtendFormalParameter
	 *
	 * Constraint:
	 *     (extension?='extension'? name=ValidID parameterType=JvmTypeReference?)
	 * </pre>
	 */
	protected void sequence_SarlXLoopFormalParameter(ISerializationContext context, XtendFormalParameter semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlAgent
	 *
	 * Constraint:
	 *     (annotationInfo=Type_SarlAgent_2_2_0 modifiers+=CommonModifier* name=ValidID extends=JvmParameterizedTypeReference? members+=AOPMember*)
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlAgent semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type.SarlEvent_2_0_0 returns XtendTypeDeclaration
	 *     Type.SarlCapacity_2_1_0 returns XtendTypeDeclaration
	 *     Type.SarlAgent_2_2_0 returns XtendTypeDeclaration
	 *     Type.SarlBehavior_2_3_0 returns XtendTypeDeclaration
	 *     Type.SarlSkill_2_4_0 returns XtendTypeDeclaration
	 *     Type.SarlSpace_2_5_0 returns XtendTypeDeclaration
	 *     Type.SarlArtifact_2_6_0 returns XtendTypeDeclaration
	 *     Type.SarlClass_2_7_0 returns XtendTypeDeclaration
	 *     Type.SarlInterface_2_8_0 returns XtendTypeDeclaration
	 *     Type.SarlEnumeration_2_9_0 returns XtendTypeDeclaration
	 *     Type.SarlAnnotationType_2_10_0 returns XtendTypeDeclaration
	 *
	 * Constraint:
	 *     annotations+=XAnnotation*
	 * </pre>
	 */
	protected void sequence_Type_SarlAgent_2_2_0_SarlAnnotationType_2_10_0_SarlArtifact_2_6_0_SarlBehavior_2_3_0_SarlCapacity_2_1_0_SarlClass_2_7_0_SarlEnumeration_2_9_0_SarlEvent_2_0_0_SarlInterface_2_8_0_SarlSkill_2_4_0_SarlSpace_2_5_0(ISerializationContext context, XtendTypeDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlAnnotationType
	 *
	 * Constraint:
	 *     (annotationInfo=Type_SarlAnnotationType_2_10_0 modifiers+=CommonModifier* name=ValidID members+=AnnotationField*)
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlAnnotationType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlArtifact
	 *
	 * Constraint:
	 *     (annotationInfo=Type_SarlArtifact_2_6_0 modifiers+=CommonModifier* name=ValidID)
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlArtifact semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlBehavior
	 *
	 * Constraint:
	 *     (annotationInfo=Type_SarlBehavior_2_3_0 modifiers+=CommonModifier* name=ValidID extends=JvmParameterizedTypeReference? members+=AOPMember*)
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlBehavior semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlCapacity
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=Type_SarlCapacity_2_1_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (extends+=JvmParameterizedTypeReference extends+=JvmParameterizedTypeReference*)? 
	 *         members+=CapacityMember*
	 *     )
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlCapacity semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlClass
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=Type_SarlClass_2_7_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (extends=JvmParameterizedTypeReference? (implements+=JvmParameterizedTypeReference implements+=JvmParameterizedTypeReference*)?)+ 
	 *         members+=Member*
	 *     )
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlClass semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlEnumeration
	 *
	 * Constraint:
	 *     (annotationInfo=Type_SarlEnumeration_2_9_0 modifiers+=CommonModifier* name=ValidID (members+=XtendEnumLiteral members+=XtendEnumLiteral*)?)
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlEnumeration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlEvent
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=Type_SarlEvent_2_0_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         extends=JvmParameterizedTypeReference? 
	 *         members+=EventMember*
	 *     )
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlEvent semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlInterface
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=Type_SarlInterface_2_8_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (typeParameters+=JvmTypeParameter typeParameters+=JvmTypeParameter*)? 
	 *         (extends+=JvmParameterizedTypeReference extends+=JvmParameterizedTypeReference*)? 
	 *         members+=Member*
	 *     )
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlInterface semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlSkill
	 *
	 * Constraint:
	 *     (
	 *         annotationInfo=Type_SarlSkill_2_4_0 
	 *         modifiers+=CommonModifier* 
	 *         name=ValidID 
	 *         (extends=JvmParameterizedTypeReference? (implements+=JvmParameterizedTypeReference implements+=JvmParameterizedTypeReference*)?)+ 
	 *         members+=AOPMember*
	 *     )
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlSkill semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Type returns SarlSpace
	 *
	 * Constraint:
	 *     (annotationInfo=Type_SarlSpace_2_5_0 modifiers+=CommonModifier* name=ValidID)
	 * </pre>
	 */
	protected void sequence_Type(ISerializationContext context, SarlSpace semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     XCastedExpression returns XBinaryOperation
	 *     XCastedExpression.SarlCastedExpression_1_0_0_0 returns XBinaryOperation
	 *     XPrimaryExpression returns XBinaryOperation
	 *     XMultiplicativeExpression returns XBinaryOperation
	 *     XMultiplicativeExpression.XBinaryOperation_1_0_0_0 returns XBinaryOperation
	 *     XExponentExpression returns XBinaryOperation
	 *     XExponentExpression.XBinaryOperation_1_0_0_0 returns XBinaryOperation
	 *     XUnaryOperation returns XBinaryOperation
	 *     XAssignment returns XBinaryOperation
	 *     XAssignment.XBinaryOperation_1_1_0_0_0 returns XBinaryOperation
	 *     XConditionalExpression returns XBinaryOperation
	 *     XConditionalExpression.XIfExpression_1_0_0_0 returns XBinaryOperation
	 *     XExpressionOrSimpleConstructorCall returns XBinaryOperation
	 *     RichStringPart returns XBinaryOperation
	 *     XAnnotationElementValueOrCommaList returns XBinaryOperation
	 *     XAnnotationElementValueOrCommaList.XListLiteral_1_1_0 returns XBinaryOperation
	 *     XAnnotationElementValue returns XBinaryOperation
	 *     XAnnotationOrExpression returns XBinaryOperation
	 *     XExpression returns XBinaryOperation
	 *     XOrExpression returns XBinaryOperation
	 *     XOrExpression.XBinaryOperation_1_0_0_0 returns XBinaryOperation
	 *     XAndExpression returns XBinaryOperation
	 *     XAndExpression.XBinaryOperation_1_0_0_0 returns XBinaryOperation
	 *     XEqualityExpression returns XBinaryOperation
	 *     XEqualityExpression.XBinaryOperation_1_0_0_0 returns XBinaryOperation
	 *     XRelationalExpression returns XBinaryOperation
	 *     XRelationalExpression.XInstanceOfExpression_1_0_0_0_0 returns XBinaryOperation
	 *     XRelationalExpression.XBinaryOperation_1_1_0_0_0 returns XBinaryOperation
	 *     XOtherOperatorExpression returns XBinaryOperation
	 *     XOtherOperatorExpression.XBinaryOperation_1_0_0_0 returns XBinaryOperation
	 *     XAdditiveExpression returns XBinaryOperation
	 *     XAdditiveExpression.XBinaryOperation_1_0_0_0 returns XBinaryOperation
	 *     XPostfixOperation returns XBinaryOperation
	 *     XPostfixOperation.XPostfixOperation_1_0_0 returns XBinaryOperation
	 *     XMemberFeatureCall returns XBinaryOperation
	 *     XMemberFeatureCall.XAssignment_1_0_0_0_0 returns XBinaryOperation
	 *     XMemberFeatureCall.XMemberFeatureCall_1_1_0_0_0 returns XBinaryOperation
	 *     XParenthesizedExpression returns XBinaryOperation
	 *     XExpressionOrVarDeclaration returns XBinaryOperation
	 *
	 * Constraint:
	 *     (
	 *         (leftOperand=XMultiplicativeExpression_XBinaryOperation_1_0_0_0 feature=[JvmIdentifiableElement|OpMulti] rightOperand=XCastedExpression) | 
	 *         (leftOperand=XExponentExpression_XBinaryOperation_1_0_0_0 feature=[JvmIdentifiableElement|OpExponent] rightOperand=XUnaryOperation) | 
	 *         (leftOperand=XAssignment_XBinaryOperation_1_1_0_0_0 feature=[JvmIdentifiableElement|OpMultiAssign] rightOperand=XAssignment) | 
	 *         (leftOperand=XOrExpression_XBinaryOperation_1_0_0_0 feature=[JvmIdentifiableElement|OpOr] rightOperand=XAndExpression) | 
	 *         (leftOperand=XAndExpression_XBinaryOperation_1_0_0_0 feature=[JvmIdentifiableElement|OpAnd] rightOperand=XEqualityExpression) | 
	 *         (leftOperand=XEqualityExpression_XBinaryOperation_1_0_0_0 feature=[JvmIdentifiableElement|OpEquality] rightOperand=XRelationalExpression) | 
	 *         (leftOperand=XRelationalExpression_XBinaryOperation_1_1_0_0_0 feature=[JvmIdentifiableElement|OpCompare] rightOperand=XOtherOperatorExpression) | 
	 *         (leftOperand=XOtherOperatorExpression_XBinaryOperation_1_0_0_0 feature=[JvmIdentifiableElement|OpOther] rightOperand=XAdditiveExpression) | 
	 *         (leftOperand=XAdditiveExpression_XBinaryOperation_1_0_0_0 feature=[JvmIdentifiableElement|OpAdd] rightOperand=XMultiplicativeExpression)
	 *     )
	 * </pre>
	 */
	protected void sequence_XAdditiveExpression_XAndExpression_XAssignment_XEqualityExpression_XExponentExpression_XMultiplicativeExpression_XOrExpression_XOtherOperatorExpression_XRelationalExpression(ISerializationContext context, XBinaryOperation semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     XCastedExpression returns SarlCastedExpression
	 *     XCastedExpression.SarlCastedExpression_1_0_0_0 returns SarlCastedExpression
	 *     XPrimaryExpression returns SarlCastedExpression
	 *     XMultiplicativeExpression returns SarlCastedExpression
	 *     XMultiplicativeExpression.XBinaryOperation_1_0_0_0 returns SarlCastedExpression
	 *     XExponentExpression returns SarlCastedExpression
	 *     XExponentExpression.XBinaryOperation_1_0_0_0 returns SarlCastedExpression
	 *     XUnaryOperation returns SarlCastedExpression
	 *     XAssignment returns SarlCastedExpression
	 *     XAssignment.XBinaryOperation_1_1_0_0_0 returns SarlCastedExpression
	 *     XConditionalExpression returns SarlCastedExpression
	 *     XConditionalExpression.XIfExpression_1_0_0_0 returns SarlCastedExpression
	 *     XExpressionOrSimpleConstructorCall returns SarlCastedExpression
	 *     RichStringPart returns SarlCastedExpression
	 *     XAnnotationElementValueOrCommaList returns SarlCastedExpression
	 *     XAnnotationElementValueOrCommaList.XListLiteral_1_1_0 returns SarlCastedExpression
	 *     XAnnotationElementValue returns SarlCastedExpression
	 *     XAnnotationOrExpression returns SarlCastedExpression
	 *     XExpression returns SarlCastedExpression
	 *     XOrExpression returns SarlCastedExpression
	 *     XOrExpression.XBinaryOperation_1_0_0_0 returns SarlCastedExpression
	 *     XAndExpression returns SarlCastedExpression
	 *     XAndExpression.XBinaryOperation_1_0_0_0 returns SarlCastedExpression
	 *     XEqualityExpression returns SarlCastedExpression
	 *     XEqualityExpression.XBinaryOperation_1_0_0_0 returns SarlCastedExpression
	 *     XRelationalExpression returns SarlCastedExpression
	 *     XRelationalExpression.XInstanceOfExpression_1_0_0_0_0 returns SarlCastedExpression
	 *     XRelationalExpression.XBinaryOperation_1_1_0_0_0 returns SarlCastedExpression
	 *     XOtherOperatorExpression returns SarlCastedExpression
	 *     XOtherOperatorExpression.XBinaryOperation_1_0_0_0 returns SarlCastedExpression
	 *     XAdditiveExpression returns SarlCastedExpression
	 *     XAdditiveExpression.XBinaryOperation_1_0_0_0 returns SarlCastedExpression
	 *     XPostfixOperation returns SarlCastedExpression
	 *     XPostfixOperation.XPostfixOperation_1_0_0 returns SarlCastedExpression
	 *     XMemberFeatureCall returns SarlCastedExpression
	 *     XMemberFeatureCall.XAssignment_1_0_0_0_0 returns SarlCastedExpression
	 *     XMemberFeatureCall.XMemberFeatureCall_1_1_0_0_0 returns SarlCastedExpression
	 *     XParenthesizedExpression returns SarlCastedExpression
	 *     XExpressionOrVarDeclaration returns SarlCastedExpression
	 *
	 * Constraint:
	 *     (target=XCastedExpression_SarlCastedExpression_1_0_0_0 type=JvmTypeReference)
	 * </pre>
	 */
	protected void sequence_XCastedExpression(ISerializationContext context, SarlCastedExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, XbasePackage.Literals.XCASTED_EXPRESSION__TARGET) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XbasePackage.Literals.XCASTED_EXPRESSION__TARGET));
			if (transientValues.isValueTransient(semanticObject, XbasePackage.Literals.XCASTED_EXPRESSION__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XbasePackage.Literals.XCASTED_EXPRESSION__TYPE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getXCastedExpressionAccess().getSarlCastedExpressionTargetAction_1_0_0_0(), semanticObject.getTarget());
		feeder.accept(grammarAccess.getXCastedExpressionAccess().getTypeJvmTypeReferenceParserRuleCall_1_1_0(), semanticObject.getType());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     XCastedExpression returns XForLoopExpression
	 *     XCastedExpression.SarlCastedExpression_1_0_0_0 returns XForLoopExpression
	 *     XPrimaryExpression returns XForLoopExpression
	 *     XForLoopExpression returns XForLoopExpression
	 *     XMultiplicativeExpression returns XForLoopExpression
	 *     XMultiplicativeExpression.XBinaryOperation_1_0_0_0 returns XForLoopExpression
	 *     XExponentExpression returns XForLoopExpression
	 *     XExponentExpression.XBinaryOperation_1_0_0_0 returns XForLoopExpression
	 *     XUnaryOperation returns XForLoopExpression
	 *     XAssignment returns XForLoopExpression
	 *     XAssignment.XBinaryOperation_1_1_0_0_0 returns XForLoopExpression
	 *     XConditionalExpression returns XForLoopExpression
	 *     XConditionalExpression.XIfExpression_1_0_0_0 returns XForLoopExpression
	 *     XExpressionOrSimpleConstructorCall returns XForLoopExpression
	 *     RichStringPart returns XForLoopExpression
	 *     XAnnotationElementValueOrCommaList returns XForLoopExpression
	 *     XAnnotationElementValueOrCommaList.XListLiteral_1_1_0 returns XForLoopExpression
	 *     XAnnotationElementValue returns XForLoopExpression
	 *     XAnnotationOrExpression returns XForLoopExpression
	 *     XExpression returns XForLoopExpression
	 *     XOrExpression returns XForLoopExpression
	 *     XOrExpression.XBinaryOperation_1_0_0_0 returns XForLoopExpression
	 *     XAndExpression returns XForLoopExpression
	 *     XAndExpression.XBinaryOperation_1_0_0_0 returns XForLoopExpression
	 *     XEqualityExpression returns XForLoopExpression
	 *     XEqualityExpression.XBinaryOperation_1_0_0_0 returns XForLoopExpression
	 *     XRelationalExpression returns XForLoopExpression
	 *     XRelationalExpression.XInstanceOfExpression_1_0_0_0_0 returns XForLoopExpression
	 *     XRelationalExpression.XBinaryOperation_1_1_0_0_0 returns XForLoopExpression
	 *     XOtherOperatorExpression returns XForLoopExpression
	 *     XOtherOperatorExpression.XBinaryOperation_1_0_0_0 returns XForLoopExpression
	 *     XAdditiveExpression returns XForLoopExpression
	 *     XAdditiveExpression.XBinaryOperation_1_0_0_0 returns XForLoopExpression
	 *     XPostfixOperation returns XForLoopExpression
	 *     XPostfixOperation.XPostfixOperation_1_0_0 returns XForLoopExpression
	 *     XMemberFeatureCall returns XForLoopExpression
	 *     XMemberFeatureCall.XAssignment_1_0_0_0_0 returns XForLoopExpression
	 *     XMemberFeatureCall.XMemberFeatureCall_1_1_0_0_0 returns XForLoopExpression
	 *     XParenthesizedExpression returns XForLoopExpression
	 *     XExpressionOrVarDeclaration returns XForLoopExpression
	 *
	 * Constraint:
	 *     (declaredParam=SarlXLoopFormalParameter forExpression=XExpression eachExpression=XExpression?)
	 * </pre>
	 */
	protected void sequence_XForLoopExpression(ISerializationContext context, XForLoopExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     XCastedExpression returns XSwitchExpression
	 *     XCastedExpression.SarlCastedExpression_1_0_0_0 returns XSwitchExpression
	 *     XPrimaryExpression returns XSwitchExpression
	 *     XSwitchExpression returns XSwitchExpression
	 *     XMultiplicativeExpression returns XSwitchExpression
	 *     XMultiplicativeExpression.XBinaryOperation_1_0_0_0 returns XSwitchExpression
	 *     XExponentExpression returns XSwitchExpression
	 *     XExponentExpression.XBinaryOperation_1_0_0_0 returns XSwitchExpression
	 *     XUnaryOperation returns XSwitchExpression
	 *     XAssignment returns XSwitchExpression
	 *     XAssignment.XBinaryOperation_1_1_0_0_0 returns XSwitchExpression
	 *     XConditionalExpression returns XSwitchExpression
	 *     XConditionalExpression.XIfExpression_1_0_0_0 returns XSwitchExpression
	 *     XExpressionOrSimpleConstructorCall returns XSwitchExpression
	 *     RichStringPart returns XSwitchExpression
	 *     XAnnotationElementValueOrCommaList returns XSwitchExpression
	 *     XAnnotationElementValueOrCommaList.XListLiteral_1_1_0 returns XSwitchExpression
	 *     XAnnotationElementValue returns XSwitchExpression
	 *     XAnnotationOrExpression returns XSwitchExpression
	 *     XExpression returns XSwitchExpression
	 *     XOrExpression returns XSwitchExpression
	 *     XOrExpression.XBinaryOperation_1_0_0_0 returns XSwitchExpression
	 *     XAndExpression returns XSwitchExpression
	 *     XAndExpression.XBinaryOperation_1_0_0_0 returns XSwitchExpression
	 *     XEqualityExpression returns XSwitchExpression
	 *     XEqualityExpression.XBinaryOperation_1_0_0_0 returns XSwitchExpression
	 *     XRelationalExpression returns XSwitchExpression
	 *     XRelationalExpression.XInstanceOfExpression_1_0_0_0_0 returns XSwitchExpression
	 *     XRelationalExpression.XBinaryOperation_1_1_0_0_0 returns XSwitchExpression
	 *     XOtherOperatorExpression returns XSwitchExpression
	 *     XOtherOperatorExpression.XBinaryOperation_1_0_0_0 returns XSwitchExpression
	 *     XAdditiveExpression returns XSwitchExpression
	 *     XAdditiveExpression.XBinaryOperation_1_0_0_0 returns XSwitchExpression
	 *     XPostfixOperation returns XSwitchExpression
	 *     XPostfixOperation.XPostfixOperation_1_0_0 returns XSwitchExpression
	 *     XMemberFeatureCall returns XSwitchExpression
	 *     XMemberFeatureCall.XAssignment_1_0_0_0_0 returns XSwitchExpression
	 *     XMemberFeatureCall.XMemberFeatureCall_1_1_0_0_0 returns XSwitchExpression
	 *     XParenthesizedExpression returns XSwitchExpression
	 *     XExpressionOrVarDeclaration returns XSwitchExpression
	 *
	 * Constraint:
	 *     (
	 *         ((declaredParam=JvmFormalParameter switch=XExpression) | (declaredParam=JvmFormalParameter? switch=XExpression)) 
	 *         cases+=XCasePart* 
	 *         default=XExpression?
	 *     )
	 * </pre>
	 */
	protected void sequence_XSwitchExpression(ISerializationContext context, XSwitchExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     XCastedExpression returns XUnaryOperation
	 *     XCastedExpression.SarlCastedExpression_1_0_0_0 returns XUnaryOperation
	 *     XPrimaryExpression returns XUnaryOperation
	 *     XMultiplicativeExpression returns XUnaryOperation
	 *     XMultiplicativeExpression.XBinaryOperation_1_0_0_0 returns XUnaryOperation
	 *     XExponentExpression returns XUnaryOperation
	 *     XExponentExpression.XBinaryOperation_1_0_0_0 returns XUnaryOperation
	 *     XUnaryOperation returns XUnaryOperation
	 *     XAssignment returns XUnaryOperation
	 *     XAssignment.XBinaryOperation_1_1_0_0_0 returns XUnaryOperation
	 *     XConditionalExpression returns XUnaryOperation
	 *     XConditionalExpression.XIfExpression_1_0_0_0 returns XUnaryOperation
	 *     XExpressionOrSimpleConstructorCall returns XUnaryOperation
	 *     RichStringPart returns XUnaryOperation
	 *     XAnnotationElementValueOrCommaList returns XUnaryOperation
	 *     XAnnotationElementValueOrCommaList.XListLiteral_1_1_0 returns XUnaryOperation
	 *     XAnnotationElementValue returns XUnaryOperation
	 *     XAnnotationOrExpression returns XUnaryOperation
	 *     XExpression returns XUnaryOperation
	 *     XOrExpression returns XUnaryOperation
	 *     XOrExpression.XBinaryOperation_1_0_0_0 returns XUnaryOperation
	 *     XAndExpression returns XUnaryOperation
	 *     XAndExpression.XBinaryOperation_1_0_0_0 returns XUnaryOperation
	 *     XEqualityExpression returns XUnaryOperation
	 *     XEqualityExpression.XBinaryOperation_1_0_0_0 returns XUnaryOperation
	 *     XRelationalExpression returns XUnaryOperation
	 *     XRelationalExpression.XInstanceOfExpression_1_0_0_0_0 returns XUnaryOperation
	 *     XRelationalExpression.XBinaryOperation_1_1_0_0_0 returns XUnaryOperation
	 *     XOtherOperatorExpression returns XUnaryOperation
	 *     XOtherOperatorExpression.XBinaryOperation_1_0_0_0 returns XUnaryOperation
	 *     XAdditiveExpression returns XUnaryOperation
	 *     XAdditiveExpression.XBinaryOperation_1_0_0_0 returns XUnaryOperation
	 *     XPostfixOperation returns XUnaryOperation
	 *     XPostfixOperation.XPostfixOperation_1_0_0 returns XUnaryOperation
	 *     XMemberFeatureCall returns XUnaryOperation
	 *     XMemberFeatureCall.XAssignment_1_0_0_0_0 returns XUnaryOperation
	 *     XMemberFeatureCall.XMemberFeatureCall_1_1_0_0_0 returns XUnaryOperation
	 *     XParenthesizedExpression returns XUnaryOperation
	 *     XExpressionOrVarDeclaration returns XUnaryOperation
	 *
	 * Constraint:
	 *     (feature=[JvmIdentifiableElement|OpUnary] operand=XUnaryOperation)
	 * </pre>
	 */
	protected void sequence_XUnaryOperation(ISerializationContext context, XUnaryOperation semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE));
			if (transientValues.isValueTransient(semanticObject, XbasePackage.Literals.XUNARY_OPERATION__OPERAND) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XbasePackage.Literals.XUNARY_OPERATION__OPERAND));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getXUnaryOperationAccess().getFeatureJvmIdentifiableElementOpUnaryParserRuleCall_0_1_0_1(), semanticObject.eGet(XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, false));
		feeder.accept(grammarAccess.getXUnaryOperationAccess().getOperandXUnaryOperationParserRuleCall_0_2_0(), semanticObject.getOperand());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     XVariableDeclaration returns XtendVariableDeclaration
	 *     RichStringPart returns XtendVariableDeclaration
	 *     XExpressionOrVarDeclaration returns XtendVariableDeclaration
	 *
	 * Constraint:
	 *     (
	 *         ((writeable?='var'? extension?='extension'?) | (extension?='extension' writeable?='var'?)) 
	 *         name=ValidID 
	 *         type=JvmTypeReference? 
	 *         right=XExpression?
	 *     )
	 * </pre>
	 */
	protected void sequence_XVariableDeclaration(ISerializationContext context, XtendVariableDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     XtendEnumLiteral returns SarlEnumLiteral
	 *
	 * Constraint:
	 *     name=ValidID
	 * </pre>
	 */
	protected void sequence_XtendEnumLiteral(ISerializationContext context, SarlEnumLiteral semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, XtendPackage.Literals.XTEND_ENUM_LITERAL__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XtendPackage.Literals.XTEND_ENUM_LITERAL__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getXtendEnumLiteralAccess().getNameValidIDParserRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
}
