/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.serializer;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtend.core.serializer.XtendSerializerScopeProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;

/** Provider of scope for the serializer that is used by a appender/builder of Ecore elements.
 * SerializerScopeProviderFragment.java : appendTo : 100
 */
public class SARLSerializerScopeProvider extends XtendSerializerScopeProvider {

	@Inject
	private IJvmModelAssociations associations;

	@Override
	public IScope getScope(EObject context, EReference reference) {
		var scope = super.getScope(context, reference);
		// When the Sarl Ecore was created by the regular compiler tools, a grammar node is attached.
		// When the Sarl Ecore was builder with a coe builder, no grammar node is attached.
		if (EcoreUtil2.getExistingAdapter(context, CompositeNodeWithSemanticElement.class) == null) {
			scope = doGetScopeIfTypeParameter(context, reference, scope);
		}
		return scope;
	}

	public IScope doGetScopeIfTypeParameter(EObject context, EReference reference, IScope baseScope) {
		IScope scope = baseScope;
		if (scope instanceof AbstractScope ascope && context instanceof JvmParameterizedTypeReference ref && ref.getType() instanceof JvmTypeParameter) {
			final var jvmObject = this.associations.getPrimaryJvmElement(context);
			final var typeParameters = new ArrayList<List<JvmTypeParameter>>();
			if (jvmObject == null) {
				EObject logicalContainer = context.eContainer();
				if (logicalContainer != null) {
					while (logicalContainer != null) {
						final var logicalContainer0 = this.associations.getPrimaryJvmElement(context);
						if (logicalContainer0 instanceof JvmTypeParameterDeclarator typeParamProvider) {
							if (!typeParamProvider.getTypeParameters().isEmpty()) {
								typeParameters.add(typeParamProvider.getTypeParameters());
							}
						} else {
							final var eclass = logicalContainer.eClass();
							try {
								final var sfeature = eclass.getEStructuralFeature("typeParameters");
								if (logicalContainer.eIsSet(sfeature)) {
									final var params = logicalContainer.eGet(sfeature);
									if (params != null) {
										if (params instanceof List<?> list) {
											typeParameters.add((List<JvmTypeParameter>) list);
										}
										break;
									}
								}
							} catch (Throwable ex) {
								// Ignore this error because it corresponding to an unknown feature for the container
							}
						}
						logicalContainer = logicalContainer.eContainer();
					}
				}
			} else {
				EObject logicalContainer = jvmObject.eContainer();
				if (logicalContainer != null) {
					while (logicalContainer != null) {
						if (logicalContainer instanceof JvmTypeParameterDeclarator typeParamProvider && !typeParamProvider.getTypeParameters().isEmpty()) {
							typeParameters.add(typeParamProvider.getTypeParameters());
						}
						logicalContainer = logicalContainer.eContainer();
					}
				}
			}
			if (!typeParameters.isEmpty()) {
				scope = new SARLTypeParameterScope(typeParameters, ascope, this.associations);
			}
		}
		return scope;
	}
}
