/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.serializer;

import java.util.List;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtend.core.scoping.TypeParameterScope;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;

/** Scope dedicated to type parameters for the serializer that is used by a appender/builder of Ecore elements.
 * SerializerScopeProviderFragment.java : appendTo : 317
 */public class SARLTypeParameterScope extends TypeParameterScope {

	private final IJvmModelAssociations associations;

	/** Constructor.
	 *
	 * @param typeParameters the type parameters to include in the scope.
	 * @param parent the parent scope.
	 * @param associations the tool for finding associated objects to an EObject.
	 */
	public SARLTypeParameterScope(List<List<JvmTypeParameter>> typeParameters, AbstractScope parent, IJvmModelAssociations associations) {
		super(typeParameters, parent);
		this.associations = associations;
	}

	@Override
	protected IEObjectDescription doGetSingleElement(QualifiedName name) {
		final var candidate = super.doGetSingleElement(name);
		// This is the place of the bug fix
		if (candidate != null && candidate.getEObjectOrProxy() instanceof JvmTypeParameter param) {
			final var sourceElement = this.associations.getPrimarySourceElement(param);
			if (sourceElement != null) {
				return EObjectDescription.create(name, sourceElement);
			}
		}
		return candidate;
	}

}
