/*
 * $Id$
 *
 * File is automatically generated by the Xtext language generator.
 * Do not change it.
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.lang.services;

import jakarta.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.lib.Pure;

/** Replies the default value that is associated to a {@code JvmType}.
 */
@SuppressWarnings("all")
public class TypeDefaultValueProviderImpl implements ITypeDefaultValueProvider {

	private TypeReferences typeReferences;

	private SARLGrammarKeywordAccess keywords;

	@Inject
	public void setTypeReferences(TypeReferences typeReferences) {
		this.typeReferences = typeReferences;
	}

	@Inject
	public void setKeywords(SARLGrammarKeywordAccess keywords) {
		this.keywords = keywords;
	}

	/** Replies the default value that is associated to the given type.
	 * @param type the type to consider.
	 * @return the default value
	 */
	@Pure
	public Object getDefaultValue(JvmType type) {
		if (type == null) {
			return null;
		}
		return getDefaultValue(type.getQualifiedName());
	};

	/** Replies the default value that is associated to the given type.
	 * @param typeName the name of the type to consider.
	 * @return the default value
	 */
	@Pure
	public Object getDefaultValue(String typeName) {
		Object defaultValue = null;
		if (!Strings.isEmpty(typeName) && !"void".equals(typeName)) {
			switch (typeName) {
			case "boolean":
			case "java.lang.Boolean":
			case "java.util.concurrent.atomic.AtomicBoolean":
				defaultValue = Boolean.FALSE;
				break;
			case "double":
			case "java.lang.Double":
			case "com.google.common.util.concurrent.AtomicDouble":
			case "java.math.BigDecimal":
				defaultValue = Double.valueOf(0.);
				break;
			case "float":
			case "java.lang.Float":
				defaultValue = Float.valueOf(0f);
				break;
			case "int":
			case "java.lang.Integer":
			case "java.util.concurrent.atomic.AtomicInteger":
			case "java.math.BigInteger":
				defaultValue = Integer.valueOf(0);
				break;
			case "long":
			case "java.lang.Long":
			case "java.util.concurrent.atomic.AtomicLong":
				defaultValue = Long.valueOf(0);
				break;
			case "byte":
			case "java.lang.Byte":
				defaultValue = Byte.valueOf((byte) 0);
				break;
			case "short":
			case "java.lang.Short":
				defaultValue = Short.valueOf((short) 0);
				break;
			case "char":
			case "java.lang.Character":
				defaultValue = Character.valueOf((char) 0);
				break;
			default:
				defaultValue = null;
				break;
			}
		}
		return defaultValue;
	};

	/** Replies the default value in Sarl syntax and that is associated to the given type.
	 * @param type the type to consider.
	 * @return the default value in Sarl syntax
	 */
	@Pure
	public String getDefaultValueInSarlSyntax(JvmType type) {
		if (type == null) {
			return null;
		}
		return getDefaultValueInSarlSyntax(type.getQualifiedName());
	}

	/** Replies the default value in Sarl syntax and that is associated to the given type.
	 * @param typeName the name of the type to consider.
	 * @return the default value in Sarl syntax
	 */
	@Pure
	public String getDefaultValueInSarlSyntax(String typeName) {
		String defaultValue = "";
		if (!Strings.isEmpty(typeName) && !"void".equals(typeName)) {
			switch (typeName) {
			case "boolean":
			case "java.lang.Boolean":
			case "java.util.concurrent.atomic.AtomicBoolean":
				defaultValue = "false";
				break;
			case "double":
			case "java.lang.Double":
			case "com.google.common.util.concurrent.AtomicDouble":
			case "java.math.BigDecimal":
				defaultValue = "0.0";
				break;
			case "float":
			case "java.lang.Float":
				defaultValue = "0.0f";
				break;
			case "int":
			case "java.lang.Integer":
			case "long":
			case "java.lang.Long":
			case "java.util.concurrent.atomic.AtomicInteger":
			case "java.util.concurrent.atomic.AtomicLong":
			case "java.math.BigInteger":
				defaultValue = "0";
				break;
			case "byte":
			case "java.lang.Byte":
				defaultValue = "(0 " + this.keywords.getAsKeyword() + " byte)";
				break;
			case "short":
			case "java.lang.Short":
				defaultValue = "(0 " + this.keywords.getAsKeyword() + " short)";
				break;
			case "char":
			case "java.lang.Character":
				defaultValue = "(0 " + this.keywords.getAsKeyword() + " char)";
				break;
			default:
				defaultValue = "null";
				break;
			}
		}
		return defaultValue;
	}

	/** Replies the XExpression for the default value that is associated to the given type.
	 * @param type the type to consider.
	 * @param notifier the context from whic a type must be loaded if needed.
	 * @return the XExpression for the default value
	 */
	@Pure
	public XExpression getDefaultValueXExpression(JvmType type, Notifier notifier) {
		if (type == null) {
			return null;
		}
		return getDefaultValueXExpression(type.getQualifiedName(), notifier);
	}

	/** Replies the XExpression for the default value that is associated to the given type.
	 * @param typeName the type to consider.
	 * @param notifier the context from whic a type must be loaded if needed.
	 * @return the XExpression for the default value
	 */
	@Pure
	public XExpression getDefaultValueXExpression(String typeName, Notifier notifier) {
		XExpression expr = null;
		if (typeName != null && !"void".equals(typeName) && !Void.class.getName().equals(typeName)) {
			switch (typeName) {
			case "boolean":
			case "java.lang.Boolean":
			case "java.util.concurrent.atomic.AtomicBoolean":
				XBooleanLiteral booleanLiteral = XbaseFactory.eINSTANCE.createXBooleanLiteral();
				booleanLiteral.setIsTrue(false);
				expr = booleanLiteral;
				break;
			case "float":
			case "java.lang.Float":
				XNumberLiteral floatLiteral = XbaseFactory.eINSTANCE.createXNumberLiteral();
				floatLiteral.setValue("0.0f");
				expr = floatLiteral;
				break;
			case "double":
			case "java.lang.Double":
			case "com.google.common.util.concurrent.AtomicDouble":
			case "java.math.BigDecimal":
				XNumberLiteral doubleLiteral = XbaseFactory.eINSTANCE.createXNumberLiteral();
				doubleLiteral.setValue("0.0");
				expr = doubleLiteral;
				break;
			case "int":
			case "java.lang.Integer":
			case "long":
			case "java.lang.Long":
			case "java.util.concurrent.atomic.AtomicInteger":
			case "java.util.concurrent.atomic.AtomicLong":
			case "java.math.BigInteger":
				XNumberLiteral intLiteral = XbaseFactory.eINSTANCE.createXNumberLiteral();
				intLiteral.setValue("0");
				expr = intLiteral;
				break;
			case "byte":
			case "java.lang.Byte":
				expr = createCastExpression("byte", notifier);
				break;
			case "short":
			case "java.lang.Short":
				expr = createCastExpression("short", notifier);
				break;
			case "char":
			case "java.lang.Character":
				expr = createCastExpression("char", notifier);
				break;
			default:
				expr = XbaseFactory.eINSTANCE.createXNullLiteral();
				break;
			}
		}
		return expr;
	}

	private XExpression createCastExpression(String targetTypeName, Notifier notifier) {
		XNumberLiteral cnumberLiteral = XbaseFactory.eINSTANCE.createXNumberLiteral();
		cnumberLiteral.setValue("0");
		XCastedExpression castExpression = XbaseFactory.eINSTANCE.createXCastedExpression();
		castExpression.setTarget(cnumberLiteral);
		castExpression.setType(this.typeReferences.getTypeForName(targetTypeName, notifier));
		return castExpression;
	}

}
