/*
 * $Id$
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.sarl.lang.validation.subvalidators;

import org.eclipse.osgi.util.NLS;

/** Localized Messages.
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version compiler 0.15.1 20250911-224823
 * @mavengroupid io.sarl.lang
 * @mavenartifactid compiler
 * @ExcludeFromApidoc
 */
@SuppressWarnings("all")
public class Messages extends NLS {
	private static final String BUNDLE_NAME = Messages.class.getPackage().getName() + ".messages"; //$NON-NLS-1$
	static {
		// initialize resource bundle
		NLS.initializeMessages(BUNDLE_NAME, Messages.class);
	}

	private Messages() {
	}

	public static String AbstractSARLSubValidator_1;
	public static String AbstractSARLSubValidator_2;
	public static String AbstractSARLSubValidator_3;
	public static String AbstractSARLSubValidator_4;
	public static String AbstractSARLSubValidator_5;
	public static String AbstractSARLSubValidator_6;
	public static String AbstractSARLSubValidator_7;
	public static String AbstractSARLSubValidator_8;
	public static String AbstractSARLSubValidator_9;

	public static String SARLAnnotationValidator_1;
	public static String SARLAnnotationValidator_2;
	public static String SARLAnnotationValidator_3;
	public static String SARLAnnotationValidator_4;
	public static String SARLAnnotationValidator_5;
	public static String SARLAnnotationValidator_6;
	public static String SARLAnnotationValidator_7;
	public static String SARLAnnotationValidator_8;
	public static String SARLAnnotationValidator_9;

	public static String SARLBehaviorUnitValidator_1;
	public static String SARLBehaviorUnitValidator_2;
	public static String SARLBehaviorUnitValidator_3;
	public static String SARLBehaviorUnitValidator_4;
	public static String SARLBehaviorUnitValidator_5;
	public static String SARLBehaviorUnitValidator_6;
	public static String SARLBehaviorUnitValidator_7;
	public static String SARLBehaviorUnitValidator_8;
	public static String SARLBehaviorUnitValidator_9;
	public static String SARLBehaviorUnitValidator_10;
	public static String SARLBehaviorUnitValidator_11;

	public static String SARLCastValidator_1;
	public static String SARLCastValidator_2;
	public static String SARLCastValidator_3;

	public static String SARLDocumentationValidator_1;

	public static String SARLFeatureCallsValidator_1;
	public static String SARLFeatureCallsValidator_2;
	public static String SARLFeatureCallsValidator_3;
	public static String SARLFeatureCallsValidator_4;
	public static String SARLFeatureCallsValidator_5;
	public static String SARLFeatureCallsValidator_6;
	public static String SARLFeatureCallsValidator_7;
	public static String SARLFeatureCallsValidator_8;
	public static String SARLFeatureCallsValidator_9;
	public static String SARLFeatureCallsValidator_10;
	public static String SARLFeatureCallsValidator_11;
	public static String SARLFeatureCallsValidator_12;
	public static String SARLFeatureCallsValidator_13;
	public static String SARLFeatureCallsValidator_14;
	public static String SARLFeatureCallsValidator_15;
	public static String SARLFeatureCallsValidator_16;
	public static String SARLFeatureCallsValidator_17;
	public static String SARLFeatureCallsValidator_18;
	
	public static String SARLFeatureModifierValidator_1;
	public static String SARLFeatureModifierValidator_2;
	public static String SARLFeatureModifierValidator_3;
	public static String SARLFeatureModifierValidator_4;
	public static String SARLFeatureModifierValidator_5;
	public static String SARLFeatureModifierValidator_6;
	public static String SARLFeatureModifierValidator_7;
	public static String SARLFeatureModifierValidator_8;
	public static String SARLFeatureModifierValidator_9;
	public static String SARLFeatureModifierValidator_10;
	public static String SARLFeatureModifierValidator_11;
	public static String SARLFeatureModifierValidator_12;
	public static String SARLFeatureModifierValidator_13;

	public static String SARLInheritanceValidator_1;
	public static String SARLInheritanceValidator_2;
	public static String SARLInheritanceValidator_3;
	public static String SARLInheritanceValidator_4;
	public static String SARLInheritanceValidator_5;
	public static String SARLInheritanceValidator_6;
	public static String SARLInheritanceValidator_7;
	public static String SARLInheritanceValidator_8;
	public static String SARLInheritanceValidator_9;
	public static String SARLInheritanceValidator_10;
	public static String SARLInheritanceValidator_11;
	public static String SARLInheritanceValidator_12;
	public static String SARLInheritanceValidator_13;
	public static String SARLInheritanceValidator_14;
	public static String SARLInheritanceValidator_15;
	public static String SARLInheritanceValidator_16;
	public static String SARLInheritanceValidator_17;
	public static String SARLInheritanceValidator_18;
	public static String SARLInheritanceValidator_19;
	public static String SARLInheritanceValidator_20;
	public static String SARLInheritanceValidator_21;
	public static String SARLInheritanceValidator_22;
	public static String SARLInheritanceValidator_23;
	public static String SARLInheritanceValidator_24;

	public static String SARLMemberValidator_1;
	public static String SARLMemberValidator_2;
	public static String SARLMemberValidator_3;
	public static String SARLMemberValidator_4;
	public static String SARLMemberValidator_5;
	public static String SARLMemberValidator_6;
	public static String SARLMemberValidator_7;
	public static String SARLMemberValidator_8;
	public static String SARLMemberValidator_9;
	public static String SARLMemberValidator_10;
	public static String SARLMemberValidator_11;
	public static String SARLMemberValidator_12;
	public static String SARLMemberValidator_13;
	public static String SARLMemberValidator_14;
	public static String SARLMemberValidator_15;
	public static String SARLMemberValidator_16;
	public static String SARLMemberValidator_17;
	public static String SARLMemberValidator_18;
	public static String SARLMemberValidator_19;
	public static String SARLMemberValidator_20;
	public static String SARLMemberValidator_21;
	public static String SARLMemberValidator_22;
	public static String SARLMemberValidator_23;
	public static String SARLMemberValidator_24;
	public static String SARLMemberValidator_25;
	public static String SARLMemberValidator_26;
	public static String SARLMemberValidator_27;
	public static String SARLMemberValidator_28;
	public static String SARLMemberValidator_29;
	public static String SARLMemberValidator_30;
	public static String SARLMemberValidator_31;
	public static String SARLMemberValidator_32;
	public static String SARLMemberValidator_33;
	public static String SARLMemberValidator_34;
	public static String SARLMemberValidator_35;
	public static String SARLMemberValidator_36;
	public static String SARLMemberValidator_37;
	public static String SARLMemberValidator_38;
	public static String SARLMemberValidator_39;
	public static String SARLMemberValidator_40;
	public static String SARLMemberValidator_41;
	public static String SARLMemberValidator_42;
	public static String SARLMemberValidator_43;
	public static String SARLMemberValidator_44;
	public static String SARLMemberValidator_45;
	public static String SARLMemberValidator_46;
	public static String SARLMemberValidator_47;
	public static String SARLMemberValidator_48;
	public static String SARLMemberValidator_49;
	public static String SARLMemberValidator_50;
	public static String SARLMemberValidator_51;
	public static String SARLMemberValidator_52;
	public static String SARLMemberValidator_53;
	public static String SARLMemberValidator_54;
	public static String SARLMemberValidator_55;
	public static String SARLMemberValidator_56;

	public static String SARLModifierValidator_1;
	public static String SARLModifierValidator_2;
	public static String SARLModifierValidator_3;
	public static String SARLModifierValidator_4;
	public static String SARLModifierValidator_5;
	public static String SARLModifierValidator_6;
	public static String SARLModifierValidator_7;
	public static String SARLModifierValidator_8;
	public static String SARLModifierValidator_9;
	public static String SARLModifierValidator_10;
	public static String SARLModifierValidator_11;
	public static String SARLModifierValidator_12;

	public static String SARLNamingValidator_1;
	public static String SARLNamingValidator_2;
	public static String SARLNamingValidator_3;
	public static String SARLNamingValidator_4;
	public static String SARLNamingValidator_5;
	public static String SARLNamingValidator_6;
	public static String SARLNamingValidator_7;
	public static String SARLNamingValidator_8;

	public static String SARLScriptValidator_1;
	public static String SARLScriptValidator_2;
	public static String SARLScriptValidator_3;
	public static String SARLScriptValidator_4;
	public static String SARLScriptValidator_5;

	public static String SARLSynchronizationValidator_1;
	
	public static String SARLTypeValidator_1;
	public static String SARLTypeValidator_2;
	public static String SARLTypeValidator_3;
	public static String SARLTypeValidator_4;
	public static String SARLTypeValidator_5;
	public static String SARLTypeValidator_6;
	public static String SARLTypeValidator_7;
	public static String SARLTypeValidator_8;
	public static String SARLTypeValidator_9;
	public static String SARLTypeValidator_10;
	public static String SARLTypeValidator_11;
	public static String SARLTypeValidator_12;
	public static String SARLTypeValidator_13;
	public static String SARLTypeValidator_14;
	public static String SARLTypeValidator_15;
	public static String SARLTypeValidator_16;
	public static String SARLTypeValidator_17;
	public static String SARLTypeValidator_18;
	public static String SARLTypeValidator_19;

}
