/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.async;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.AtomicDoubleArray;
import com.google.common.util.concurrent.AtomicLongMap;
import com.google.inject.Inject;
import io.sarl.lang.async.ISynchronizedFieldDetector;
import io.sarl.lang.core.util.ConcurrentCollection;
import io.sarl.lang.core.util.ConcurrentList;
import io.sarl.lang.core.util.ConcurrentSet;
import io.sarl.lang.util.Utils;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class StandardSynchronizedFieldDetector
implements ISynchronizedFieldDetector {
    private static final Class<?>[] SYNCHRONIZED_TYPES = new Class[]{AtomicBoolean.class, AtomicDouble.class, AtomicDoubleArray.class, AtomicInteger.class, AtomicIntegerArray.class, AtomicLong.class, AtomicLongArray.class, AtomicLongMap.class, AtomicMarkableReference.class, AtomicReference.class, BlockingDeque.class, BlockingQueue.class, ConcurrentCollection.class, ConcurrentHashMap.class, ConcurrentHashMultiset.class, ConcurrentLinkedDeque.class, ConcurrentLinkedQueue.class, ConcurrentList.class, ConcurrentMap.class, ConcurrentNavigableMap.class, ConcurrentSet.class, ConcurrentSkipListMap.class, ConcurrentSkipListSet.class, CopyOnWriteArrayList.class, CopyOnWriteArraySet.class, CountDownLatch.class, DoubleAccumulator.class, DoubleAdder.class, LongAccumulator.class, LongAdder.class};
    @Inject
    private CommonTypeComputationServices types;

    @Override
    @Pure
    public boolean isSynchronizedField(XtendField field) {
        LightweightTypeReference fieldType = Utils.toLightweightTypeReference(field.getType(), this.types).getPrimitiveIfWrapperType();
        if (fieldType.isPrimitive()) {
            return field.isFinal() || field.isVolatile();
        }
        for (Class<?> type : SYNCHRONIZED_TYPES) {
            JvmType ltype = this.types.getTypeReferences().findDeclaredType(type, (Notifier)field);
            if (ltype == null || !fieldType.isSubtypeOf(type)) continue;
            return true;
        }
        return false;
    }
}

