/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.bugfixes.pending.bug621;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import io.sarl.lang.SARLConfig;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypesSwitch;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.ConflictingDefaultOperation;
import org.eclipse.xtext.xbase.typesystem.override.IOverrideCheckResult;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class Bug621ResolvedFeatures
extends ResolvedFeatures {
    private JavaVersion targetVersion = SARLConfig.getMinimumJavaVersionForCompilation();

    public Bug621ResolvedFeatures(LightweightTypeReference type, OverrideTester overrideTester, JavaVersion targetVersion) {
        super(type, overrideTester, targetVersion);
        this.targetVersion = targetVersion;
    }

    public Bug621ResolvedFeatures(LightweightTypeReference type, OverrideTester overrideTester) {
        super(type, overrideTester);
    }

    public Bug621ResolvedFeatures(LightweightTypeReference type) {
        super(type);
    }

    protected void computeAllOperationsFromSortedSuperTypes(final JvmDeclaredType rootType, final Multimap<String, AbstractResolvedOperation> processedOperations) {
        class SuperTypes
        extends TypesSwitch<Boolean> {
            private Multiset<JvmType> interfaces = LinkedHashMultiset.create();
            private Set<JvmType> notInterfaces = Sets.newLinkedHashSet();

            public SuperTypes(Bug621ResolvedFeatures this$0, JvmDeclaredType rootType) {
                this.doSwitch((EObject)rootType);
            }

            public Boolean doSwitch(EObject theEObject) {
                if (theEObject == null) {
                    return Boolean.FALSE;
                }
                return (Boolean)super.doSwitch(theEObject);
            }

            public Boolean caseJvmTypeReference(JvmTypeReference object) {
                return this.doSwitch((EObject)object.getType());
            }

            public Boolean caseJvmType(JvmType object) {
                return this.notInterfaces.add(object);
            }

            public Boolean caseJvmDeclaredType(JvmDeclaredType object) {
                if (this.notInterfaces.add((JvmType)object)) {
                    for (JvmTypeReference superType : object.getSuperTypes()) {
                        this.doSwitch((EObject)superType);
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public Boolean caseJvmGenericType(JvmGenericType object) {
                boolean traverseSuperTypes = false;
                traverseSuperTypes = object.isInterface() ? this.interfaces.add((Object)object, 1) == 0 : this.notInterfaces.add((JvmType)object);
                if (traverseSuperTypes) {
                    for (JvmTypeReference superType : object.getSuperTypes()) {
                        this.doSwitch((EObject)superType);
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public Collection<JvmType> getSuperTypesNoInterfaces() {
                return this.notInterfaces;
            }

            public int consumeInterfaceOccurrence(JvmGenericType intf) {
                return this.interfaces.remove((Object)intf, 1);
            }
        }
        final SuperTypes superTypes = new SuperTypes(this, rootType);
        for (JvmType superClass : superTypes.getSuperTypesNoInterfaces()) {
            if (!(superClass instanceof JvmDeclaredType)) continue;
            JvmDeclaredType jdt = (JvmDeclaredType)superClass;
            this.computeAllOperations(jdt, processedOperations);
        }
        class SuperInterfaceConsumer
        extends TypesSwitch<Boolean> {
            private Set<JvmType> seen = Sets.newHashSet();
            private boolean isSuperclassBranch;
            private Multimap<String, AbstractResolvedOperation> superclassBranchOperations;

            SuperInterfaceConsumer() {
            }

            public Boolean doSwitch(EObject theEObject) {
                if (theEObject == null) {
                    return Boolean.FALSE;
                }
                return (Boolean)super.doSwitch(theEObject);
            }

            public Boolean defaultCase(EObject object) {
                return Boolean.FALSE;
            }

            public Boolean caseJvmTypeReference(JvmTypeReference object) {
                return this.doSwitch((EObject)object.getType());
            }

            public Boolean caseJvmDeclaredType(JvmDeclaredType object) {
                if (this.seen.add((JvmType)object)) {
                    for (JvmTypeReference superType : object.getSuperTypes()) {
                        this.doSwitch((EObject)superType);
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public Boolean caseJvmGenericType(JvmGenericType object) {
                if (object.isInterface()) {
                    int was = superTypes.consumeInterfaceOccurrence(object);
                    if (was == 0) {
                        return Boolean.FALSE;
                    }
                    if (was == 1) {
                        Bug621ResolvedFeatures.this.computeAllOperations(this.isSuperclassBranch, this.superclassBranchOperations, (JvmDeclaredType)object, (Multimap<String, AbstractResolvedOperation>)processedOperations);
                    }
                    for (JvmTypeReference superType : object.getSuperTypes()) {
                        this.doSwitch((EObject)superType);
                    }
                    return was > 1;
                }
                if (this.seen.add((JvmType)object)) {
                    boolean saved = this.isSuperclassBranch;
                    this.isSuperclassBranch = object != rootType;
                    for (JvmTypeReference superType : object.getSuperTypes()) {
                        this.doSwitch((EObject)superType);
                    }
                    this.isSuperclassBranch = saved;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public void consume(JvmType rootType2) {
                this.isSuperclassBranch = false;
                this.superclassBranchOperations = LinkedHashMultimap.create();
                this.doSwitch((EObject)rootType2);
            }
        }
        new SuperInterfaceConsumer().consume((JvmType)rootType);
    }

    private OverrideTester _getOverrideTester(AbstractResolvedOperation op) {
        try {
            Method meth = AbstractResolvedOperation.class.getDeclaredMethod("getOverrideTester", new Class[0]);
            meth.setAccessible(true);
            return (OverrideTester)meth.invoke((Object)op, new Object[0]);
        }
        catch (Throwable exception) {
            throw new Error(exception);
        }
    }

    private boolean _handleOverridesAndConflicts(JvmOperation operation, Multimap<String, AbstractResolvedOperation> processedOperations) {
        try {
            Method meth = ResolvedFeatures.class.getDeclaredMethod("handleOverridesAndConflicts", JvmOperation.class, Multimap.class);
            meth.setAccessible(true);
            return (Boolean)meth.invoke((Object)this, operation, processedOperations);
        }
        catch (Throwable exception) {
            throw new Error(exception);
        }
    }

    protected void computeAllOperations(boolean isSuperClassBranch, Multimap<String, AbstractResolvedOperation> superClassBranchOperations, JvmDeclaredType type, Multimap<String, AbstractResolvedOperation> processedOperations) {
        for (JvmOperation operation : type.getDeclaredOperations()) {
            boolean addToResult = this.handleOverridesAndConflicts(isSuperClassBranch, operation, processedOperations, superClassBranchOperations);
            if (!addToResult) continue;
            BottomResolvedOperation resolvedOperation = this.createResolvedOperation(operation);
            processedOperations.put((Object)operation.getSimpleName(), (Object)resolvedOperation);
            if (!isSuperClassBranch) continue;
            superClassBranchOperations.put((Object)operation.getSimpleName(), (Object)resolvedOperation);
        }
    }

    private boolean handleOverridesAndConflicts(boolean isSuperClassBranch, JvmOperation operation, Multimap<String, AbstractResolvedOperation> processedOperations, Multimap<String, AbstractResolvedOperation> superClassBranchOperations) {
        Object overrideTester;
        String simpleName = operation.getSimpleName();
        if (!processedOperations.containsKey((Object)simpleName)) {
            return true;
        }
        List conflictingOperations = null;
        Iterator iterator = processedOperations.get((Object)simpleName).iterator();
        while (iterator.hasNext()) {
            AbstractResolvedOperation candidate = (AbstractResolvedOperation)iterator.next();
            overrideTester = this._getOverrideTester(candidate);
            IOverrideCheckResult checkResult = overrideTester.isSubsignature(candidate, operation, false);
            if (checkResult.getDetails().contains(IOverrideCheckResult.OverrideCheckDetails.DEFAULT_IMPL_CONFLICT)) {
                if (!isSuperClassBranch && superClassBranchOperations.containsKey((Object)simpleName)) {
                    iterator.remove();
                    continue;
                }
                if (conflictingOperations == null) {
                    conflictingOperations = Lists.newLinkedList();
                }
                conflictingOperations.add(candidate);
                continue;
            }
            if (!checkResult.isOverridingOrImplementing()) continue;
            return false;
        }
        if (conflictingOperations != null) {
            if (conflictingOperations.size() == 1 && (overrideTester = conflictingOperations.get(0)) instanceof ConflictingDefaultOperation) {
                ConflictingDefaultOperation conflictingDefaultOperation = (ConflictingDefaultOperation)overrideTester;
                boolean isOverridden = false;
                for (IResolvedOperation conflictingOp : conflictingDefaultOperation.getConflictingOperations()) {
                    if (!conflictingOp.getResolvedDeclarator().isSubtypeOf((JvmType)operation.getDeclaringType())) continue;
                    isOverridden = true;
                    break;
                }
                if (!isOverridden) {
                    conflictingDefaultOperation.getConflictingOperations().add(this.createResolvedOperation(operation));
                }
                return false;
            }
            if (operation.isAbstract()) {
                resolvedOperation = this.createConflictingOperation((JvmOperation)((AbstractResolvedOperation)conflictingOperations.get(0)).getDeclaration(), new IResolvedOperation[0]);
                resolvedOperation.getConflictingOperations().add(this.createResolvedOperation(operation));
                for (AbstractResolvedOperation conflictingOp : conflictingOperations) {
                    processedOperations.remove((Object)simpleName, (Object)conflictingOp);
                    if (conflictingOp.getDeclaration() == resolvedOperation.getDeclaration()) continue;
                    resolvedOperation.getConflictingOperations().add(conflictingOp);
                }
                processedOperations.put((Object)simpleName, (Object)resolvedOperation);
            } else {
                resolvedOperation = this.createConflictingOperation(operation, new IResolvedOperation[0]);
                for (AbstractResolvedOperation conflictingOp : conflictingOperations) {
                    processedOperations.remove((Object)simpleName, (Object)conflictingOp);
                    resolvedOperation.getConflictingOperations().add(conflictingOp);
                }
                processedOperations.put((Object)simpleName, (Object)resolvedOperation);
            }
            return false;
        }
        return true;
    }
}

