/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.bugfixes.unpublished;

import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.util.Strings;

@Singleton
public class BugMultilineCommentIndentation {
    public ITextReplacerContext fix(ITextReplacerContext context, IComment comment) {
        IHiddenRegion hiddenRegion = comment.getHiddenRegion();
        if (BugMultilineCommentIndentation.detectBugSituation(hiddenRegion) && BugMultilineCommentIndentation.fixBug(hiddenRegion)) {
            ITextRegionAccess access = comment.getTextRegionAccess();
            ITextSegment target = access.regionForOffset(comment.getOffset(), 0);
            context.addReplacement(target.replaceWith(context.getIndentationString(1)));
            return new FixedReplacementContext(context);
        }
        return context;
    }

    private static boolean detectBugSituation(IHiddenRegion hiddenRegion) {
        Keyword kw;
        EObject element;
        ISemanticRegion semanticRegion;
        return hiddenRegion != null && (semanticRegion = hiddenRegion.getPreviousSemanticRegion()) != null && (element = semanticRegion.getGrammarElement()) instanceof Keyword && Strings.equal((String)(kw = (Keyword)element).getValue(), (String)"{");
    }

    private static boolean fixBug(IHiddenRegion hiddenRegion) {
        Keyword kw;
        EObject element;
        boolean needBugFix = true;
        ISemanticRegion semanticRegion = hiddenRegion.getNextSemanticRegion();
        if (semanticRegion != null && (element = semanticRegion.getGrammarElement()) instanceof Keyword && Strings.equal((String)(kw = (Keyword)element).getValue(), (String)"}")) {
            needBugFix = false;
        }
        return needBugFix;
    }

    private static class FixedReplacementContext
    implements ITextReplacerContext {
        private final ITextReplacerContext context;

        FixedReplacementContext(ITextReplacerContext context) {
            this.context = context;
        }

        public ITextReplacerContext withReplacer(ITextReplacer replacer) {
            return this.context.withReplacer(replacer);
        }

        public ITextReplacerContext withIndentation(int indentation) {
            return this.context.withIndentation(indentation);
        }

        public ITextReplacerContext withDocument(IFormattableDocument document) {
            return this.context.withDocument(document);
        }

        public void setNextReplacerIsChild() {
            this.context.setNextReplacerIsChild();
        }

        public void setCanAutowrap(Integer value) {
            this.context.setCanAutowrap(value);
        }

        public void setAutowrap(boolean value) {
            this.context.setAutowrap(value);
        }

        public boolean isInsideFormattedRegion() {
            return this.context.isInsideFormattedRegion();
        }

        public boolean isAutowrap() {
            return this.context.isAutowrap();
        }

        public ITextReplacer getReplacer() {
            return this.context.getReplacer();
        }

        public List<ITextReplacement> getReplacementsUntil(ITextReplacerContext first) {
            return this.context.getReplacementsUntil(first);
        }

        public ITextReplacerContext getPreviousContext() {
            return this.context.getPreviousContext();
        }

        public String getNewLinesString(int count) {
            return this.context.getNewLinesString(count);
        }

        public Iterable<ITextReplacement> getLocalReplacements() {
            return this.context.getLocalReplacements();
        }

        public Iterable<ITextReplacement> getLocalReplacementsReverse() {
            return this.context.getLocalReplacementsReverse();
        }

        public int getLeadingCharsInLineCount() {
            return this.context.getLeadingCharsInLineCount();
        }

        public String getIndentationString(int indentationLevel) {
            return this.context.getIndentationString(indentationLevel);
        }

        public String getIndentationString() {
            return this.getIndentationString(this.getIndentation());
        }

        public int getIndentation() {
            return this.context.getIndentation() + 1;
        }

        public AbstractFormatter2 getFormatter() {
            return this.context.getFormatter();
        }

        public IFormattableDocument getDocument() {
            return this.context.getDocument();
        }

        public Integer canAutowrap() {
            return this.context.canAutowrap();
        }

        public void addReplacement(ITextReplacement replacement) {
            this.context.addReplacement(replacement);
        }

        public boolean isWrapInRegion() {
            return this.context.isWrapInRegion();
        }

        public boolean isWrapSincePrevious() {
            return this.context.isWrapSincePrevious();
        }
    }
}

