/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.bugfixes.unpublished;

import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.util.Strings;

@Singleton
public class BugSinglelineCommentIndentation {
    public ITextReplacerContext fix(ITextReplacerContext context, IComment comment) {
        IHiddenRegion hiddenRegion = comment.getHiddenRegion();
        if (BugSinglelineCommentIndentation.detectBugSituation(hiddenRegion) && BugSinglelineCommentIndentation.fixBug(hiddenRegion)) {
            ITextRegionAccess access = comment.getTextRegionAccess();
            ITextSegment target = access.regionForOffset(comment.getOffset(), 0);
            context.addReplacement(target.replaceWith(context.getIndentationString(1)));
        }
        return context;
    }

    private static boolean detectBugSituation(IHiddenRegion hiddenRegion) {
        Keyword kw;
        EObject element;
        ISemanticRegion semanticRegion;
        return hiddenRegion != null && (semanticRegion = hiddenRegion.getNextSemanticRegion()) != null && (element = semanticRegion.getGrammarElement()) instanceof Keyword && Strings.equal((String)(kw = (Keyword)element).getValue(), (String)"}");
    }

    private static boolean fixBug(IHiddenRegion hiddenRegion) {
        Keyword kw;
        EObject element;
        boolean needBugFix = true;
        ISemanticRegion semanticRegion = hiddenRegion.getPreviousSemanticRegion();
        if (semanticRegion != null && (element = semanticRegion.getGrammarElement()) instanceof Keyword && Strings.equal((String)(kw = (Keyword)element).getValue(), (String)"{")) {
            needBugFix = false;
        }
        return needBugFix;
    }
}

