/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.sarl.lang.codebuilder.appenders.BlockExpressionSourceAppender;
import io.sarl.lang.codebuilder.appenders.ExpressionSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlActionSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlAgentSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlAnnotationTypeSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlArtifactSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlBehaviorSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlBehaviorUnitSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlCapacitySourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlClassSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlConstructorSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlEnumLiteralSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlEnumerationSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlEventSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlFieldSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlInterfaceSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlSkillSourceAppender;
import io.sarl.lang.codebuilder.appenders.SarlSpaceSourceAppender;
import io.sarl.lang.codebuilder.appenders.ScriptSourceAppender;
import io.sarl.lang.codebuilder.builders.IBlockExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IExpressionBuilder;
import io.sarl.lang.codebuilder.builders.ISarlActionBuilder;
import io.sarl.lang.codebuilder.builders.ISarlAgentBuilder;
import io.sarl.lang.codebuilder.builders.ISarlAnnotationTypeBuilder;
import io.sarl.lang.codebuilder.builders.ISarlArtifactBuilder;
import io.sarl.lang.codebuilder.builders.ISarlBehaviorBuilder;
import io.sarl.lang.codebuilder.builders.ISarlBehaviorUnitBuilder;
import io.sarl.lang.codebuilder.builders.ISarlCapacityBuilder;
import io.sarl.lang.codebuilder.builders.ISarlClassBuilder;
import io.sarl.lang.codebuilder.builders.ISarlConstructorBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEnumLiteralBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEnumerationBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEventBuilder;
import io.sarl.lang.codebuilder.builders.ISarlFieldBuilder;
import io.sarl.lang.codebuilder.builders.ISarlInterfaceBuilder;
import io.sarl.lang.codebuilder.builders.ISarlSkillBuilder;
import io.sarl.lang.codebuilder.builders.ISarlSpaceBuilder;
import io.sarl.lang.codebuilder.builders.IScriptBuilder;
import io.sarl.lang.core.util.SarlUtils;
import jakarta.inject.Inject;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.util.Modules2;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.lib.Pure;

public class CodeBuilderFactory {
    private static final String[] FORBIDDEN_INJECTION_PREFIXES = new String[]{"com.google.inject."};
    private static final String[] FORBIDDEN_INJECTION_POSTFIXES = new String[]{".Logger"};
    @Inject
    private IResourceFactory resourceFactory;
    private String fileExtension;
    @Inject
    private Provider<ImportManager> importManagerProvider;
    @Inject
    private Injector originalInjector;
    private Injector builderInjector;

    @Inject
    public void setFileExtensions(@Named(value="file.extensions") String fileExtensions) {
        this.fileExtension = SarlUtils.getMajorFileExtension((String)fileExtensions);
    }

    @Pure
    protected URI computeUnusedUri(ResourceSet resourceSet) {
        String name = "__synthetic";
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            URI syntheticUri = URI.createURI((String)(name + i + "." + this.getScriptFileExtension()));
            if (resourceSet.getResource(syntheticUri, false) != null) continue;
            return syntheticUri;
        }
        throw new IllegalStateException();
    }

    @Pure
    public String getScriptFileExtension() {
        return this.fileExtension;
    }

    @Pure
    protected IResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    @Pure
    protected String getFooPackageName() {
        return "io.sarl.lang.foo";
    }

    @Pure
    protected String getFooTypeName() {
        return "FooType";
    }

    @Pure
    protected String getFooMemberName() {
        return "fooMember";
    }

    @Pure
    protected Resource createResource(ResourceSet resourceSet) {
        URI uri = this.computeUnusedUri(resourceSet);
        Resource resource = this.getResourceFactory().createResource(uri);
        resourceSet.getResources().add((Object)resource);
        return resource;
    }

    @Pure
    protected Injector getInjector() {
        if (this.builderInjector == null) {
            ImportManager importManager = (ImportManager)this.importManagerProvider.get();
            this.builderInjector = CodeBuilderFactory.createOverridingInjector(this.originalInjector, (Module)new CodeBuilderModule(importManager));
        }
        return this.builderInjector;
    }

    public static Injector createOverridingInjector(Injector originalInjector, Module module) {
        Map bindings = originalInjector.getBindings();
        return Guice.createInjector((Module[])new Module[]{Modules2.mixin((Module[])new Module[]{binder -> {
            for (Binding binding : bindings.values()) {
                String typeName;
                Type typeLiteral = binding.getKey().getTypeLiteral().getType();
                if (typeLiteral == null || !CodeBuilderFactory.isValid(typeName = typeLiteral.getTypeName())) continue;
                binding.applyTo(binder);
            }
        }, module})});
    }

    private static boolean isValid(String name) {
        for (String prefix : FORBIDDEN_INJECTION_PREFIXES) {
            if (!name.startsWith(prefix)) continue;
            return false;
        }
        for (String postfix : FORBIDDEN_INJECTION_POSTFIXES) {
            if (!name.endsWith(postfix)) continue;
            return false;
        }
        return true;
    }

    @Pure
    protected <T> Provider<T> getProvider(Class<T> type) {
        return this.getInjector().getProvider(type);
    }

    @Pure
    public IScriptBuilder createScript(String packageName, ResourceSet resourceSet) {
        return this.createScript(packageName, this.createResource(resourceSet), null);
    }

    @Pure
    public IScriptBuilder createScript(String packageName, Resource resource) {
        return this.createScript(packageName, resource, null);
    }

    @Pure
    public IScriptBuilder createScript(String packageName, Resource resource, IJvmTypeProvider context) {
        IScriptBuilder builder = (IScriptBuilder)this.getProvider(IScriptBuilder.class).get();
        builder.eInit(resource, packageName, context);
        return builder;
    }

    @Pure
    public IScriptBuilder createScript(String packageName, IJvmTypeProvider context) {
        return this.createScript(packageName, this.createResource(context.getResourceSet()), context);
    }

    @Pure
    public ScriptSourceAppender buildScript(String packageName, ResourceSet resourceSet) {
        ScriptSourceAppender a = new ScriptSourceAppender(this.createScript(packageName, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ScriptSourceAppender buildScript(String packageName, Resource resource) {
        ScriptSourceAppender a = new ScriptSourceAppender(this.createScript(packageName, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ScriptSourceAppender buildScript(String packageName, Resource resource, IJvmTypeProvider context) {
        ScriptSourceAppender a = new ScriptSourceAppender(this.createScript(packageName, resource, context));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ScriptSourceAppender buildScript(String packageName, IJvmTypeProvider context) {
        ScriptSourceAppender a = new ScriptSourceAppender(this.createScript(packageName, context));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    public IExpressionBuilder createXExpression(ResourceSet resourceSet) {
        return this.createXExpression(this.createResource(resourceSet));
    }

    public IExpressionBuilder createXExpression(Resource resource) {
        IScriptBuilder script = this.createScript(this.getFooPackageName(), resource);
        ISarlEventBuilder topElement = script.addSarlEvent(this.getFooTypeName());
        ISarlFieldBuilder memberElement = topElement.addSarlField(this.getFooMemberName());
        return memberElement.getInitialValue();
    }

    public ExpressionSourceAppender buildXExpression(ResourceSet resourceSet) {
        return new ExpressionSourceAppender(this.createXExpression(resourceSet));
    }

    public ExpressionSourceAppender buildXExpression(Resource resource) {
        return new ExpressionSourceAppender(this.createXExpression(resource));
    }

    @Pure
    public IBlockExpressionBuilder createXBlockExpression(ResourceSet resourceSet) {
        return this.createXBlockExpression(this.createResource(resourceSet));
    }

    @Pure
    public IBlockExpressionBuilder createXBlockExpression(Resource resource) {
        IScriptBuilder script = this.createScript(this.getFooPackageName(), resource);
        ISarlAgentBuilder topElement = script.addSarlAgent(this.getFooTypeName());
        ISarlActionBuilder memberElement = topElement.addSarlAction(this.getFooMemberName());
        return memberElement.getExpression();
    }

    @Pure
    public BlockExpressionSourceAppender buildXBlockExpression(ResourceSet resourceSet) {
        return new BlockExpressionSourceAppender(this.createXBlockExpression(resourceSet));
    }

    @Pure
    public BlockExpressionSourceAppender buildXBlockExpression(Resource resource) {
        return new BlockExpressionSourceAppender(this.createXBlockExpression(resource));
    }

    @Pure
    public ISarlEventBuilder createSarlEvent(String name, ResourceSet resourceSet) {
        return this.createSarlEvent(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlEventBuilder createSarlEvent(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlEvent(name);
    }

    @Pure
    public SarlEventSourceAppender buildSarlEvent(String name, ResourceSet resourceSet) {
        SarlEventSourceAppender a = new SarlEventSourceAppender(this.createSarlEvent(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlEventSourceAppender buildSarlEvent(String name, Resource resource) {
        SarlEventSourceAppender a = new SarlEventSourceAppender(this.createSarlEvent(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlCapacityBuilder createSarlCapacity(String name, ResourceSet resourceSet) {
        return this.createSarlCapacity(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlCapacityBuilder createSarlCapacity(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlCapacity(name);
    }

    @Pure
    public SarlCapacitySourceAppender buildSarlCapacity(String name, ResourceSet resourceSet) {
        SarlCapacitySourceAppender a = new SarlCapacitySourceAppender(this.createSarlCapacity(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlCapacitySourceAppender buildSarlCapacity(String name, Resource resource) {
        SarlCapacitySourceAppender a = new SarlCapacitySourceAppender(this.createSarlCapacity(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlAgentBuilder createSarlAgent(String name, ResourceSet resourceSet) {
        return this.createSarlAgent(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlAgentBuilder createSarlAgent(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlAgent(name);
    }

    @Pure
    public SarlAgentSourceAppender buildSarlAgent(String name, ResourceSet resourceSet) {
        SarlAgentSourceAppender a = new SarlAgentSourceAppender(this.createSarlAgent(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlAgentSourceAppender buildSarlAgent(String name, Resource resource) {
        SarlAgentSourceAppender a = new SarlAgentSourceAppender(this.createSarlAgent(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlBehaviorBuilder createSarlBehavior(String name, ResourceSet resourceSet) {
        return this.createSarlBehavior(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlBehaviorBuilder createSarlBehavior(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlBehavior(name);
    }

    @Pure
    public SarlBehaviorSourceAppender buildSarlBehavior(String name, ResourceSet resourceSet) {
        SarlBehaviorSourceAppender a = new SarlBehaviorSourceAppender(this.createSarlBehavior(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlBehaviorSourceAppender buildSarlBehavior(String name, Resource resource) {
        SarlBehaviorSourceAppender a = new SarlBehaviorSourceAppender(this.createSarlBehavior(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlSkillBuilder createSarlSkill(String name, ResourceSet resourceSet) {
        return this.createSarlSkill(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlSkillBuilder createSarlSkill(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlSkill(name);
    }

    @Pure
    public SarlSkillSourceAppender buildSarlSkill(String name, ResourceSet resourceSet) {
        SarlSkillSourceAppender a = new SarlSkillSourceAppender(this.createSarlSkill(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlSkillSourceAppender buildSarlSkill(String name, Resource resource) {
        SarlSkillSourceAppender a = new SarlSkillSourceAppender(this.createSarlSkill(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlSpaceBuilder createSarlSpace(String name, ResourceSet resourceSet) {
        return this.createSarlSpace(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlSpaceBuilder createSarlSpace(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlSpace(name);
    }

    @Pure
    public SarlSpaceSourceAppender buildSarlSpace(String name, ResourceSet resourceSet) {
        SarlSpaceSourceAppender a = new SarlSpaceSourceAppender(this.createSarlSpace(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlSpaceSourceAppender buildSarlSpace(String name, Resource resource) {
        SarlSpaceSourceAppender a = new SarlSpaceSourceAppender(this.createSarlSpace(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlArtifactBuilder createSarlArtifact(String name, ResourceSet resourceSet) {
        return this.createSarlArtifact(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlArtifactBuilder createSarlArtifact(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlArtifact(name);
    }

    @Pure
    public SarlArtifactSourceAppender buildSarlArtifact(String name, ResourceSet resourceSet) {
        SarlArtifactSourceAppender a = new SarlArtifactSourceAppender(this.createSarlArtifact(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlArtifactSourceAppender buildSarlArtifact(String name, Resource resource) {
        SarlArtifactSourceAppender a = new SarlArtifactSourceAppender(this.createSarlArtifact(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlClassBuilder createSarlClass(String name, ResourceSet resourceSet) {
        return this.createSarlClass(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlClassBuilder createSarlClass(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlClass(name);
    }

    @Pure
    public SarlClassSourceAppender buildSarlClass(String name, ResourceSet resourceSet) {
        SarlClassSourceAppender a = new SarlClassSourceAppender(this.createSarlClass(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlClassSourceAppender buildSarlClass(String name, Resource resource) {
        SarlClassSourceAppender a = new SarlClassSourceAppender(this.createSarlClass(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlInterfaceBuilder createSarlInterface(String name, ResourceSet resourceSet) {
        return this.createSarlInterface(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlInterfaceBuilder createSarlInterface(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlInterface(name);
    }

    @Pure
    public SarlInterfaceSourceAppender buildSarlInterface(String name, ResourceSet resourceSet) {
        SarlInterfaceSourceAppender a = new SarlInterfaceSourceAppender(this.createSarlInterface(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlInterfaceSourceAppender buildSarlInterface(String name, Resource resource) {
        SarlInterfaceSourceAppender a = new SarlInterfaceSourceAppender(this.createSarlInterface(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlEnumerationBuilder createSarlEnumeration(String name, ResourceSet resourceSet) {
        return this.createSarlEnumeration(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlEnumerationBuilder createSarlEnumeration(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlEnumeration(name);
    }

    @Pure
    public SarlEnumerationSourceAppender buildSarlEnumeration(String name, ResourceSet resourceSet) {
        SarlEnumerationSourceAppender a = new SarlEnumerationSourceAppender(this.createSarlEnumeration(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlEnumerationSourceAppender buildSarlEnumeration(String name, Resource resource) {
        SarlEnumerationSourceAppender a = new SarlEnumerationSourceAppender(this.createSarlEnumeration(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlAnnotationTypeBuilder createSarlAnnotationType(String name, ResourceSet resourceSet) {
        return this.createSarlAnnotationType(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlAnnotationTypeBuilder createSarlAnnotationType(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        return scriptBuilder.addSarlAnnotationType(name);
    }

    @Pure
    public SarlAnnotationTypeSourceAppender buildSarlAnnotationType(String name, ResourceSet resourceSet) {
        SarlAnnotationTypeSourceAppender a = new SarlAnnotationTypeSourceAppender(this.createSarlAnnotationType(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlAnnotationTypeSourceAppender buildSarlAnnotationType(String name, Resource resource) {
        SarlAnnotationTypeSourceAppender a = new SarlAnnotationTypeSourceAppender(this.createSarlAnnotationType(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlConstructorBuilder createSarlConstructor(ResourceSet resourceSet) {
        return this.createSarlConstructor(this.createResource(resourceSet));
    }

    @Pure
    public ISarlConstructorBuilder createSarlConstructor(Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        ISarlEventBuilder containerBuilder = scriptBuilder.addSarlEvent(this.getFooTypeName());
        return containerBuilder.addSarlConstructor();
    }

    @Pure
    public SarlConstructorSourceAppender buildSarlConstructor(ResourceSet resourceSet) {
        SarlConstructorSourceAppender a = new SarlConstructorSourceAppender(this.createSarlConstructor(resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlConstructorSourceAppender buildSarlConstructor(Resource resource) {
        SarlConstructorSourceAppender a = new SarlConstructorSourceAppender(this.createSarlConstructor(resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlActionBuilder createDefSarlAction(String name, ResourceSet resourceSet) {
        return this.createDefSarlAction(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlActionBuilder createDefSarlAction(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        ISarlCapacityBuilder containerBuilder = scriptBuilder.addSarlCapacity(this.getFooTypeName());
        return containerBuilder.addDefSarlAction(name);
    }

    @Pure
    public SarlActionSourceAppender buildDefSarlAction(String name, ResourceSet resourceSet) {
        SarlActionSourceAppender a = new SarlActionSourceAppender(this.createDefSarlAction(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlActionSourceAppender buildDefSarlAction(String name, Resource resource) {
        SarlActionSourceAppender a = new SarlActionSourceAppender(this.createDefSarlAction(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlActionBuilder createOverrideSarlAction(String name, ResourceSet resourceSet) {
        return this.createOverrideSarlAction(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlActionBuilder createOverrideSarlAction(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        ISarlCapacityBuilder containerBuilder = scriptBuilder.addSarlCapacity(this.getFooTypeName());
        return containerBuilder.addOverrideSarlAction(name);
    }

    @Pure
    public SarlActionSourceAppender buildOverrideSarlAction(String name, ResourceSet resourceSet) {
        SarlActionSourceAppender a = new SarlActionSourceAppender(this.createOverrideSarlAction(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlActionSourceAppender buildOverrideSarlAction(String name, Resource resource) {
        SarlActionSourceAppender a = new SarlActionSourceAppender(this.createOverrideSarlAction(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlBehaviorUnitBuilder createSarlBehaviorUnit(String name, ResourceSet resourceSet) {
        return this.createSarlBehaviorUnit(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlBehaviorUnitBuilder createSarlBehaviorUnit(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        ISarlAgentBuilder containerBuilder = scriptBuilder.addSarlAgent(this.getFooTypeName());
        return containerBuilder.addSarlBehaviorUnit(name);
    }

    @Pure
    public SarlBehaviorUnitSourceAppender buildSarlBehaviorUnit(String name, ResourceSet resourceSet) {
        SarlBehaviorUnitSourceAppender a = new SarlBehaviorUnitSourceAppender(this.createSarlBehaviorUnit(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlBehaviorUnitSourceAppender buildSarlBehaviorUnit(String name, Resource resource) {
        SarlBehaviorUnitSourceAppender a = new SarlBehaviorUnitSourceAppender(this.createSarlBehaviorUnit(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlFieldBuilder createVarSarlField(String name, ResourceSet resourceSet) {
        return this.createVarSarlField(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlFieldBuilder createVarSarlField(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        ISarlEventBuilder containerBuilder = scriptBuilder.addSarlEvent(this.getFooTypeName());
        return containerBuilder.addVarSarlField(name);
    }

    @Pure
    public SarlFieldSourceAppender buildVarSarlField(String name, ResourceSet resourceSet) {
        SarlFieldSourceAppender a = new SarlFieldSourceAppender(this.createVarSarlField(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlFieldSourceAppender buildVarSarlField(String name, Resource resource) {
        SarlFieldSourceAppender a = new SarlFieldSourceAppender(this.createVarSarlField(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlFieldBuilder createValSarlField(String name, ResourceSet resourceSet) {
        return this.createValSarlField(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlFieldBuilder createValSarlField(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        ISarlEventBuilder containerBuilder = scriptBuilder.addSarlEvent(this.getFooTypeName());
        return containerBuilder.addValSarlField(name);
    }

    @Pure
    public SarlFieldSourceAppender buildValSarlField(String name, ResourceSet resourceSet) {
        SarlFieldSourceAppender a = new SarlFieldSourceAppender(this.createValSarlField(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlFieldSourceAppender buildValSarlField(String name, Resource resource) {
        SarlFieldSourceAppender a = new SarlFieldSourceAppender(this.createValSarlField(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public ISarlEnumLiteralBuilder createSarlEnumLiteral(String name, ResourceSet resourceSet) {
        return this.createSarlEnumLiteral(name, this.createResource(resourceSet));
    }

    @Pure
    public ISarlEnumLiteralBuilder createSarlEnumLiteral(String name, Resource resource) {
        IScriptBuilder scriptBuilder = this.createScript(this.getFooPackageName(), resource);
        ISarlEnumerationBuilder containerBuilder = scriptBuilder.addSarlEnumeration(this.getFooTypeName());
        return containerBuilder.addSarlEnumLiteral(name);
    }

    @Pure
    public SarlEnumLiteralSourceAppender buildSarlEnumLiteral(String name, ResourceSet resourceSet) {
        SarlEnumLiteralSourceAppender a = new SarlEnumLiteralSourceAppender(this.createSarlEnumLiteral(name, resourceSet));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    @Pure
    public SarlEnumLiteralSourceAppender buildSarlEnumLiteral(String name, Resource resource) {
        SarlEnumLiteralSourceAppender a = new SarlEnumLiteralSourceAppender(this.createSarlEnumLiteral(name, resource));
        this.getInjector().injectMembers((Object)a);
        return a;
    }

    private static class CodeBuilderModule
    extends AbstractModule {
        private final ImportManager importManager;

        public CodeBuilderModule(ImportManager importManager) {
            this.importManager = importManager;
        }

        protected void configure() {
            this.bind(ImportManager.class).toInstance((Object)this.importManager);
        }
    }
}

