/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.appenders;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.sarl.lang.codebuilder.CodeBuilderFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScopeProvider;
import org.eclipse.xtext.formatting.impl.AbstractTokenStream;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.scoping.batch.DelegatingScopes;
import org.eclipse.xtext.xbase.scoping.batch.TypeScopes;

public abstract class AbstractSourceAppender {
    public static final String OVERRIDEN_TYPE_SCOPE_PROVIDER_NAME = "io.sarl.lang.codebuilder.appenders.SourceAppender.providerType";
    @Inject
    private Injector originalInjector;
    @Inject
    @Named(value="io.sarl.lang.codebuilder.appenders.SourceAppender.providerType")
    private AbstractTypeScopeProvider scopeProvider;
    @Inject
    private TypeScopes typeScopes;
    private boolean isFormatting;

    public void setFormatting(boolean formatting) {
        this.isFormatting = formatting;
    }

    public boolean isFormatting() {
        return this.isFormatting;
    }

    protected abstract IJvmTypeProvider getTypeResolutionContext();

    public abstract void build(ISourceAppender var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(EObject object, ISourceAppender appender) throws IOException {
        this.resolvesTypes(object);
        IJvmTypeProvider provider = this.getTypeResolutionContext();
        if (provider != null) {
            Map bindings = this.originalInjector.getBindings();
            Injector localInjector = CodeBuilderFactory.createOverridingInjector(this.originalInjector, binder -> binder.bind(AbstractTypeScopeProvider.class).toInstance((Object)this.scopeProvider));
            IScopeProvider oldDelegate = this.typeScopes.getDelegate();
            localInjector.injectMembers((Object)this.typeScopes);
            try {
                AppenderSerializer serializer = (AppenderSerializer)((Object)localInjector.getProvider(AppenderSerializer.class).get());
                serializer.serialize(object, appender, this.isFormatting());
            }
            finally {
                try {
                    Field f = DelegatingScopes.class.getDeclaredField("delegate");
                    f.setAccessible(true);
                    f.set(this.typeScopes, oldDelegate);
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
            }
        }
        AppenderSerializer serializer = (AppenderSerializer)((Object)this.originalInjector.getProvider(AppenderSerializer.class).get());
        serializer.serialize(object, appender, this.isFormatting());
    }

    protected void resolvesTypes(EObject object) {
        Resource resource;
        if (object != null && (resource = object.eResource()) != null) {
            EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
        }
    }

    public abstract JvmTypeReference newTypeRef(String var1);

    public abstract JvmTypeReference newTypeRef(Notifier var1, String var2);

    public abstract JvmTypeReference newTypeRef(JvmType var1, JvmTypeReference ... var2);

    @Singleton
    public static class AppenderSerializer
    extends Serializer {
        public void serialize(EObject object, ISourceAppender appender, boolean isFormatting) throws IOException {
            AppenderBasedTokenStream stream = new AppenderBasedTokenStream(appender);
            SaveOptions options = isFormatting ? SaveOptions.newBuilder().format().getOptions() : SaveOptions.defaultOptions();
            this.serialize(object, (ITokenStream)stream, options);
            stream.flush();
        }
    }

    private static class AppenderBasedTokenStream
    extends AbstractTokenStream {
        private final ISourceAppender appender;

        public AppenderBasedTokenStream(ISourceAppender appender) {
            this.appender = appender;
        }

        public String toString() {
            return this.appender.toString();
        }

        public void writeHidden(EObject grammarElement, String value) throws IOException {
            if (!Strings.isEmpty((String)value)) {
                this.appender.append((CharSequence)value);
            }
        }

        public void writeSemantic(EObject grammarElement, String value) throws IOException {
            if (!Strings.isEmpty((String)value)) {
                this.appender.append((CharSequence)value);
            }
        }
    }
}

