/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.sarl.lang.codebuilder.builders.ExpressionBuilderImpl;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.sarl.SarlAnnotationType;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlInterface;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public abstract class AbstractBuilder {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private JvmModelAssociator associations;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private ImportManager importManager;
    @Inject
    private JvmTypeReferenceBuilder.Factory typeReferenceBuilderFactory;
    private JvmTypeReferenceBuilder typeReferenceBuilder;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private Primitives primitives;
    @Inject
    private IImportsConfiguration importsConfiguration;
    @Inject
    private IResourceFactory resourceFactory;
    private String fileExtension;
    private IJvmTypeProvider typeResolutionContext;

    @Inject
    public void setFileExtensions(@Named(value="file.extensions") String fileExtensions) {
        this.fileExtension = SarlUtils.getMajorFileExtension((String)fileExtensions);
    }

    protected <T> T getAssociatedElement(Class<T> expectedType, EObject dslObject, Resource resource, boolean failIfNotFound) {
        for (EObject obj : this.associations.getJvmElements(dslObject)) {
            if (!expectedType.isInstance(obj)) continue;
            return expectedType.cast(obj);
        }
        if (resource instanceof DerivedStateAwareResource) {
            DerivedStateAwareResource $c$value = (DerivedStateAwareResource)resource;
            $c$value.discardDerivedState();
            $c$value.getContents();
            return this.getAssociatedElement(expectedType, dslObject, null, failIfNotFound);
        }
        if (failIfNotFound) {
            throw new IllegalStateException("No " + expectedType.getSimpleName() + " associated to " + String.valueOf(dslObject) + " in " + String.valueOf(dslObject.eContainer()));
        }
        return null;
    }

    protected void setTypeResolutionContext(IJvmTypeProvider context) {
        this.typeResolutionContext = context;
    }

    public IJvmTypeProvider getTypeResolutionContext() {
        return this.typeResolutionContext;
    }

    @Pure
    public String getScriptFileExtension() {
        return this.fileExtension;
    }

    @Pure
    protected JvmTypeReferenceBuilder getTypeReferenceBuilder() {
        if (this.typeReferenceBuilder == null) {
            this.typeReferenceBuilder = this.typeReferenceBuilderFactory.create(this.eResource().getResourceSet());
        }
        return this.typeReferenceBuilder;
    }

    protected TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    @Pure
    protected Primitives getPrimitiveTypes() {
        return this.primitives;
    }

    private JvmTypeReference innerFindType(Notifier context, String typeName) {
        IJvmTypeProvider provider = this.getTypeResolutionContext();
        JvmType type = null;
        if (provider != null) {
            type = provider.findTypeByName(typeName);
        }
        if (type == null) {
            type = this.getTypeReferences().findDeclaredType(typeName, context);
        }
        if (type == null) {
            return null;
        }
        return this.getTypeReferenceBuilder().typeRef(type, new JvmTypeReference[0]);
    }

    protected JvmTypeReference findType(Notifier context, String typeName) {
        JvmTypeReference type = this.innerFindType(context, typeName);
        if (!this.isTypeReference(type)) {
            XtextResource xtextResource = AbstractBuilder.toResource(context);
            for (String packageName : this.getImportsConfiguration().getImplicitlyImportedPackages(xtextResource)) {
                JvmTypeReference typeReference = this.innerFindType(context, packageName + "." + typeName);
                if (!this.isTypeReference(typeReference)) continue;
                return typeReference;
            }
            throw new TypeNotPresentException(typeName, null);
        }
        return type;
    }

    protected static XtextResource toResource(Notifier context) {
        return (XtextResource)(context instanceof Resource ? context : ((EObject)context).eResource());
    }

    private void addImport(JvmTypeReference reference) {
        JvmType type;
        if (reference != null && (type = reference.getType()) instanceof JvmDeclaredType) {
            this.getImportManager().addImportFor(type);
        }
    }

    public JvmTypeReference newTypeRef(String typeName) {
        return this.newTypeRef((Notifier)this.eResource(), typeName);
    }

    public JvmTypeReference newTypeRef(Notifier context, String typeName) {
        try {
            JvmTypeReference typeReference = this.findType(context, typeName);
            this.addImport(typeReference);
            return typeReference;
        }
        catch (TypeNotPresentException typeNotPresentException) {
            JvmTypeReference result;
            JvmTypeReference pref = ExpressionBuilderImpl.parseType(context, typeName, this);
            JvmTypeReference baseType = this.findType(context, pref.getType().getIdentifier());
            if (pref instanceof JvmParameterizedTypeReference) {
                JvmParameterizedTypeReference ppref = (JvmParameterizedTypeReference)pref;
                int len = ppref.getArguments().size();
                if (len > 0) {
                    JvmTypeReference[] args = new JvmTypeReference[len];
                    for (int i = 0; i < len; ++i) {
                        JvmTypeReference original = (JvmTypeReference)ppref.getArguments().get(i);
                        if (original instanceof JvmAnyTypeReference) {
                            args[i] = (JvmTypeReference)EcoreUtil.copy((EObject)original);
                            continue;
                        }
                        if (original instanceof JvmWildcardTypeReference) {
                            JvmWildcardTypeReference $c$value = (JvmWildcardTypeReference)original;
                            JvmWildcardTypeReference wc = (JvmWildcardTypeReference)EcoreUtil.copy((EObject)$c$value);
                            for (JvmTypeConstraint c : wc.getConstraints()) {
                                c.setTypeReference(this.newTypeRef(context, c.getTypeReference().getIdentifier()));
                            }
                            args[i] = wc;
                            continue;
                        }
                        args[i] = this.newTypeRef(context, original.getIdentifier());
                    }
                    result = this.getTypeReferenceBuilder().typeRef(baseType.getType(), args);
                } else {
                    result = this.getTypeReferenceBuilder().typeRef(baseType.getType(), new JvmTypeReference[0]);
                }
            } else {
                result = this.getTypeReferenceBuilder().typeRef(baseType.getType(), new JvmTypeReference[0]);
            }
            this.addImport(result);
            return result;
        }
    }

    public JvmTypeReference newTypeRef(JvmType typeName, JvmTypeReference ... args) {
        JvmTypeReference ref = args != null && args.length > 0 ? this.getTypeReferenceBuilder().typeRef(typeName, args) : this.getTypeReferenceBuilder().typeRef(typeName, new JvmTypeReference[0]);
        this.addImport(ref);
        return ref;
    }

    public JvmTypeReference newTypeRef(Class type, JvmTypeReference ... args) {
        return this.newTypeRef((Notifier)this.eResource(), type, args);
    }

    public JvmTypeReference newTypeRef(Notifier context, Class type, JvmTypeReference ... args) {
        JvmType type0 = this.getTypeReferences().findDeclaredType(type, context);
        JvmTypeReference ref = args != null && args.length > 0 ? this.getTypeReferenceBuilder().typeRef(type0, args) : this.getTypeReferenceBuilder().typeRef(type0, new JvmTypeReference[0]);
        this.addImport(ref);
        return ref;
    }

    @Pure
    protected boolean isSubTypeOf(EObject context, JvmTypeReference subType, JvmTypeReference superType) {
        if (this.isTypeReference(superType) && this.isTypeReference(subType)) {
            StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, context);
            LightweightTypeReferenceFactory factory = new LightweightTypeReferenceFactory((ITypeReferenceOwner)owner, false);
            LightweightTypeReference reference = factory.toLightweightReference(subType);
            return reference.isSubtypeOf(superType.getType());
        }
        return false;
    }

    @Pure
    protected boolean isTypeReference(JvmTypeReference typeReference) {
        return typeReference != null && !typeReference.eIsProxy() && typeReference.getType() != null && !typeReference.getType().eIsProxy();
    }

    @Pure
    protected IImportsConfiguration getImportsConfiguration() {
        return this.importsConfiguration;
    }

    @Pure
    protected URI computeUnusedUri(ResourceSet resourceSet) {
        String name = "__synthetic";
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            URI syntheticUri = URI.createURI((String)(name + i + "." + this.getScriptFileExtension()));
            if (resourceSet.getResource(syntheticUri, false) != null) continue;
            return syntheticUri;
        }
        throw new IllegalStateException();
    }

    @Pure
    protected IResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    @Pure
    protected boolean isActionBodyAllowed(XtendTypeDeclaration type) {
        return !(type instanceof SarlAnnotationType) && !(type instanceof SarlCapacity) && !(type instanceof SarlEvent) && !(type instanceof SarlInterface);
    }

    @Pure
    protected ImportManager getImportManager() {
        return this.importManager;
    }

    protected String getQualifiedName(EObject object) {
        return this.qualifiedNameProvider.getFullyQualifiedName(object).toString();
    }

    @Pure
    public abstract Resource eResource();

    public void dispose() {
        Resource resource = this.eResource();
        ResourceSet resourceSet = resource.getResourceSet();
        resourceSet.getResources().remove((Object)resource);
    }

    @Pure
    protected JvmTypeReference getTypeReferenceFor(EObject ecoreObject, JvmTypeReference ... args) {
        assert (ecoreObject != null);
        JvmType jvmObject = this.getAssociatedElement(JvmType.class, ecoreObject, ecoreObject.eResource(), false);
        if (jvmObject == null) {
            String qn = this.getQualifiedName(ecoreObject);
            IJvmTypeProvider provider = this.getTypeResolutionContext();
            if (provider != null) {
                jvmObject = provider.findTypeByName(qn);
            }
            if (jvmObject == null) {
                jvmObject = this.getTypeReferences().findDeclaredType(qn, (Notifier)ecoreObject);
            }
            if (jvmObject == null) {
                return null;
            }
        }
        return this.newTypeRef(jvmObject, args);
    }

    @Pure
    protected JvmExecutable getExecutableReferenceFor(EObject ecoreObject) {
        assert (ecoreObject != null);
        return this.getAssociatedElement(JvmExecutable.class, ecoreObject, ecoreObject.eResource(), true);
    }
}

