/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.IBlockExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IExpressionBuilder;
import io.sarl.lang.documentation.InnerBlockDocumentationAdapter;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.tasks.ITaskTagProvider;
import org.eclipse.xtext.tasks.TaskTag;
import org.eclipse.xtext.tasks.TaskTags;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class BlockExpressionBuilderImpl
extends AbstractBuilder
implements IBlockExpressionBuilder {
    @Inject
    private ITaskTagProvider taskTagProvider;
    @Inject
    private Provider<IExpressionBuilder> expressionProvider;
    private XBlockExpression block;

    protected ITaskTagProvider getTaskTagProvider() {
        return this.taskTagProvider;
    }

    @Override
    public void eInit(IJvmTypeProvider context) {
        this.setTypeResolutionContext(context);
        if (this.block == null) {
            this.block = XbaseFactory.eINSTANCE.createXBlockExpression();
        }
    }

    @Override
    @Pure
    public String getAutoGeneratedActionString() {
        return this.getAutoGeneratedActionString(this.getXBlockExpression().eResource());
    }

    @Override
    @Pure
    public String getAutoGeneratedActionString(Resource resource) {
        TaskTags tags = this.getTaskTagProvider().getTaskTags(resource);
        String taskTag = tags != null && tags.getTaskTags() != null && !tags.getTaskTags().isEmpty() ? ((TaskTag)tags.getTaskTags().get(0)).getName() : "TODO";
        return taskTag + " Auto-generated code.";
    }

    @Override
    @Pure
    public XBlockExpression getXBlockExpression() {
        return this.block;
    }

    @Override
    @Pure
    public Resource eResource() {
        return this.getXBlockExpression().eResource();
    }

    @Override
    public IBlockExpressionBuilder setInnerDocumentation(String doc) {
        if (Strings.isEmpty((String)doc)) {
            this.getXBlockExpression().eAdapters().removeIf((Predicate)new Predicate<Adapter>(this){

                @Override
                public boolean test(Adapter adapter) {
                    return adapter.isAdapterForType(InnerBlockDocumentationAdapter.class);
                }
            });
        } else {
            InnerBlockDocumentationAdapter adapter = (InnerBlockDocumentationAdapter)EcoreUtil.getExistingAdapter((Notifier)this.getXBlockExpression(), InnerBlockDocumentationAdapter.class);
            if (adapter == null) {
                adapter = new InnerBlockDocumentationAdapter();
                this.getXBlockExpression().eAdapters().add((Object)adapter);
            }
            adapter.setDocumentation(doc);
        }
        return this;
    }

    @Override
    public IExpressionBuilder addExpression() {
        IExpressionBuilder builder = (IExpressionBuilder)this.expressionProvider.get();
        builder.eInit((EObject)this.getXBlockExpression(), (Procedures.Procedure1<? super XExpression>)new Procedures.Procedure1<XExpression>(){
            private int index = -1;

            public void apply(XExpression it) {
                if (this.index >= 0) {
                    BlockExpressionBuilderImpl.this.getXBlockExpression().getExpressions().set(this.index, (Object)it);
                } else {
                    BlockExpressionBuilderImpl.this.getXBlockExpression().getExpressions().add((Object)it);
                    this.index = BlockExpressionBuilderImpl.this.getXBlockExpression().getExpressions().size() - 1;
                }
            }
        }, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public IBlockExpressionBuilder setDefaultAutoGeneratedContent(String type) {
        this.getXBlockExpression().getExpressions().clear();
        if (Strings.isEmpty((String)type)) {
            this.setInnerDocumentation(this.getAutoGeneratedActionString());
        } else {
            IExpressionBuilder expr = this.addExpression();
            String defaultValue = expr.getDefaultValueForType(type);
            if (Strings.isEmpty((String)defaultValue)) {
                this.setInnerDocumentation(this.getAutoGeneratedActionString());
            } else {
                expr.setExpression(defaultValue);
                expr.setDocumentation(this.getAutoGeneratedActionString());
            }
        }
        return this;
    }

    @Override
    public IBlockExpressionBuilder setDefaultAutoGeneratedContent(JvmTypeReference type) {
        this.getXBlockExpression().getExpressions().clear();
        if (type == null || type.eIsProxy()) {
            this.setInnerDocumentation(this.getAutoGeneratedActionString());
        } else {
            IExpressionBuilder expr = this.addExpression();
            String defaultValue = expr.getDefaultValueForType(type);
            if (Strings.isEmpty((String)defaultValue)) {
                this.setInnerDocumentation(this.getAutoGeneratedActionString());
            } else {
                expr.setExpression(defaultValue);
                expr.setDocumentation(this.getAutoGeneratedActionString());
            }
        }
        return this;
    }

    @Override
    public IBlockExpressionBuilder setDefaultAutoGeneratedContent() {
        this.setDefaultAutoGeneratedContent((JvmTypeReference)null);
        return this;
    }

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.getXBlockExpression(), (EStructuralFeature[])new EStructuralFeature[0]);
    }
}

