/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Inject;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.IExpressionBuilder;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlField;
import io.sarl.lang.sarl.SarlScript;
import io.sarl.lang.services.ITypeDefaultValueProvider;
import java.io.InputStream;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class ExpressionBuilderImpl
extends AbstractBuilder
implements IExpressionBuilder {
    private EObject context;
    private Procedures.Procedure1<? super XExpression> setter;
    private XExpression expr;
    @Inject
    private ITypeDefaultValueProvider defaultValueProvider;

    @Override
    public void eInit(EObject context, Procedures.Procedure1<? super XExpression> setter, IJvmTypeProvider typeContext) {
        this.setTypeResolutionContext(typeContext);
        this.context = context;
        this.setter = setter;
        this.expr = null;
    }

    @Override
    @Pure
    public XExpression getXExpression() {
        return this.expr;
    }

    @Override
    @Pure
    public Resource eResource() {
        XExpression expr = this.getXExpression();
        if (expr != null) {
            return expr.eResource();
        }
        return this.context.eResource();
    }

    @Override
    public IExpressionBuilder setExpression(String expression) {
        this.expr = this.fromString(expression);
        this.setter.apply((Object)this.expr);
        return this;
    }

    @Override
    public IExpressionBuilder setXExpression(XExpression expression) {
        this.expr = expression;
        this.setter.apply((Object)this.expr);
        return this;
    }

    static String generateExpressionCode(String expression) {
        return "event ____synthesis { var ____fakefield = " + expression + " }";
    }

    static String generateTypenameCode(String typeName) {
        return "event ____synthesis { var ____fakefield : " + typeName + " }";
    }

    static JvmTypeReference parseType(Notifier context, String typeName, AbstractBuilder caller) {
        ResourceSet resourceSet = ExpressionBuilderImpl.toResource(context).getResourceSet();
        URI uri = caller.computeUnusedUri(resourceSet);
        Resource resource = caller.getResourceFactory().createResource(uri);
        resourceSet.getResources().add((Object)resource);
        try {
            JvmTypeReference jvmTypeReference;
            StringInputStream is = new StringInputStream(ExpressionBuilderImpl.generateTypenameCode(typeName));
            try {
                JvmParameterizedTypeReference pref;
                resource.load((InputStream)is, null);
                SarlScript script = resource.getContents().isEmpty() ? null : (SarlScript)resource.getContents().get(0);
                SarlEvent topElement = (SarlEvent)script.getXtendTypes().get(0);
                SarlField member = (SarlField)topElement.getMembers().get(0);
                JvmTypeReference reference = member.getType();
                if (reference instanceof JvmParameterizedTypeReference && !(pref = (JvmParameterizedTypeReference)reference).getArguments().isEmpty()) {
                    EcoreUtil2.resolveAll((Resource)resource);
                }
                jvmTypeReference = reference;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new TypeNotPresentException(typeName, exception);
                }
            }
            is.close();
            return jvmTypeReference;
        }
        finally {
            resourceSet.getResources().remove((Object)resource);
        }
    }

    @Pure
    protected XExpression fromString(String expression) {
        if (!Strings.isEmpty((String)expression)) {
            ResourceSet resourceSet = this.context.eResource().getResourceSet();
            URI uri = this.computeUnusedUri(resourceSet);
            Resource resource = this.getResourceFactory().createResource(uri);
            resourceSet.getResources().add((Object)resource);
            try {
                XExpression xExpression;
                StringInputStream is = new StringInputStream(ExpressionBuilderImpl.generateExpressionCode(expression));
                try {
                    resource.load((InputStream)is, null);
                    SarlScript script = resource.getContents().isEmpty() ? null : (SarlScript)resource.getContents().get(0);
                    SarlEvent topElement = (SarlEvent)script.getXtendTypes().get(0);
                    SarlField member = (SarlField)topElement.getMembers().get(0);
                    xExpression = member.getInitialValue();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable exception) {
                        throw new RuntimeException(exception);
                    }
                }
                is.close();
                return xExpression;
            }
            finally {
                resourceSet.getResources().remove((Object)resource);
            }
        }
        throw new IllegalArgumentException("not a valid expression");
    }

    @Override
    @Pure
    public XExpression getDefaultXExpressionForType(String type) {
        return this.defaultValueProvider.getDefaultValueXExpression(type, (Notifier)this.context);
    }

    @Override
    @Pure
    public XExpression getDefaultXExpressionForType(JvmTypeReference type) {
        return this.getDefaultXExpressionForType(type.getType().getIdentifier());
    }

    @Override
    @Pure
    public String getDefaultValueForType(String type) {
        return this.defaultValueProvider.getDefaultValueInSarlSyntax(type);
    }

    @Override
    @Pure
    public String getDefaultValueForType(JvmTypeReference type) {
        return this.getDefaultValueForType(type.getType().getIdentifier());
    }

    @Override
    public IExpressionBuilder setDocumentation(String doc) {
        if (Strings.isEmpty((String)doc)) {
            this.getXExpression().eAdapters().removeIf((Predicate)new Predicate<Adapter>(this){

                @Override
                public boolean test(Adapter adapter) {
                    return adapter.isAdapterForType(DocumentationAdapter.class);
                }
            });
        } else {
            DocumentationAdapter adapter = (DocumentationAdapter)EcoreUtil.getExistingAdapter((Notifier)this.getXExpression(), DocumentationAdapter.class);
            if (adapter == null) {
                adapter = new DocumentationAdapter();
                this.getXExpression().eAdapters().add((Object)adapter);
            }
            adapter.setDocumentation(doc);
        }
        return this;
    }

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.getXExpression(), (EStructuralFeature[])new EStructuralFeature[0]);
    }

    @Override
    public XFeatureCall createReferenceToThis() {
        XExpression expr = this.getXExpression();
        XtendTypeDeclaration type = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)expr, XtendTypeDeclaration.class);
        JvmType jvmObject = this.getAssociatedElement(JvmType.class, (EObject)type, expr.eResource(), true);
        XFeatureCall thisFeature = XbaseFactory.eINSTANCE.createXFeatureCall();
        thisFeature.setFeature((JvmIdentifiableElement)jvmObject);
        return thisFeature;
    }

    @Override
    public XFeatureCall createReferenceToSuper() {
        JvmType feature;
        XExpression expr = this.getXExpression();
        XtendTypeDeclaration type = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)expr, XtendTypeDeclaration.class);
        JvmType jvmObject = this.getAssociatedElement(JvmType.class, (EObject)type, expr.eResource(), true);
        XFeatureCall superFeature = XbaseFactory.eINSTANCE.createXFeatureCall();
        if (jvmObject instanceof JvmDeclaredType) {
            JvmDeclaredType $c$value = (JvmDeclaredType)jvmObject;
            feature = $c$value.getExtendedClass().getType();
        } else {
            feature = this.findType((Notifier)expr, this.getQualifiedName((EObject)type)).getType();
            if (feature instanceof JvmDeclaredType) {
                JvmDeclaredType $c$value = (JvmDeclaredType)feature;
                feature = $c$value.getExtendedClass().getType();
            } else {
                feature = null;
            }
        }
        if (feature == null) {
            return null;
        }
        superFeature.setFeature((JvmIdentifiableElement)feature);
        return superFeature;
    }
}

