/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.IExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IFormalParameterBuilder;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlFormalParameter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class FormalParameterBuilderImpl
extends AbstractBuilder
implements IFormalParameterBuilder {
    @Inject
    private Provider<IExpressionBuilder> expressionProvider;
    private XtendExecutable context;
    private SarlFormalParameter parameter;
    private IExpressionBuilder defaultValue;
    @Inject
    private TypesFactory jvmTypesFactory;
    @Inject
    private IFragmentProvider fragmentProvider;

    @Override
    public void eInit(XtendExecutable context, String name, IJvmTypeProvider typeContext) {
        this.setTypeResolutionContext(typeContext);
        this.context = context;
        this.parameter = SarlFactory.eINSTANCE.createSarlFormalParameter();
        this.parameter.setName(name);
        this.context.getParameters().add((Object)this.parameter);
        this.parameter.setParameterType(this.newTypeRef((Notifier)this.context, Object.class.getName()));
    }

    @Override
    @Pure
    public SarlFormalParameter getSarlFormalParameter() {
        return this.parameter;
    }

    @Override
    public IFormalParameterBuilder setReferenceInto(XFeatureCall container) {
        JvmVoid jvmVoid = this.jvmTypesFactory.createJvmVoid();
        if (jvmVoid instanceof InternalEObject) {
            InternalEObject jvmVoidProxy = (InternalEObject)jvmVoid;
            SarlFormalParameter param = this.getSarlFormalParameter();
            Resource resource = param.eResource();
            SarlFormalParameter jvmParam = this.getAssociatedElement(SarlFormalParameter.class, (EObject)param, resource, true);
            URI uri = EcoreUtil2.getNormalizedURI((EObject)jvmParam);
            jvmVoidProxy.eSetProxyURI(uri);
        }
        container.setFeature((JvmIdentifiableElement)jvmVoid);
        return this;
    }

    @Override
    @Pure
    public Resource eResource() {
        return this.getSarlFormalParameter().eResource();
    }

    @Override
    public IFormalParameterBuilder setParameterType(String type) {
        String typeName = Strings.isEmpty((String)type) ? Object.class.getName() : type;
        this.parameter.setParameterType(this.newTypeRef((Notifier)this.context, typeName));
        return this;
    }

    @Override
    public IFormalParameterBuilder setParameterType(JvmTypeReference type) {
        this.parameter.setParameterType(type);
        return this;
    }

    @Override
    public IFormalParameterBuilder setVarArg(boolean isVariadic) {
        this.parameter.setVarArg(isVariadic);
        return this;
    }

    @Override
    public IFormalParameterBuilder setExtension(boolean isExtension) {
        this.parameter.setExtension(isExtension);
        return this;
    }

    @Override
    @Pure
    public IExpressionBuilder getDefaultValue() {
        if (this.defaultValue == null) {
            this.defaultValue = (IExpressionBuilder)this.expressionProvider.get();
            this.defaultValue.eInit((EObject)this.parameter, (Procedures.Procedure1<? super XExpression>)new Procedures.Procedure1<XExpression>(){

                public void apply(XExpression it) {
                    FormalParameterBuilderImpl.this.getSarlFormalParameter().setDefaultValue(it);
                }
            }, this.getTypeResolutionContext());
        }
        return this.defaultValue;
    }

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.getDefaultValue(), (EStructuralFeature[])new EStructuralFeature[0]);
    }
}

