/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.IBlockExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IFormalParameterBuilder;
import io.sarl.lang.codebuilder.builders.ISarlActionBuilder;
import io.sarl.lang.codebuilder.builders.ITypeParameterBuilder;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlFactory;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsFactory;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

public class SarlActionBuilderImpl
extends AbstractBuilder
implements ISarlActionBuilder {
    @Inject
    private Provider<IFormalParameterBuilder> parameterProvider;
    @Inject
    private Provider<IBlockExpressionBuilder> blockExpressionProvider;
    private EObject container;
    private SarlAction sarlAction;
    private IBlockExpressionBuilder internalBlockExpression;
    @Inject
    private Provider<ITypeParameterBuilder> iTypeParameterBuilderProvider;

    @Override
    public void eInit(EObject container, String name, String modifier, IJvmTypeProvider context) {
        if (this.sarlAction == null) {
            this.sarlAction = SarlFactory.eINSTANCE.createSarlAction();
            this.internalEInit(container, context);
            this.sarlAction.setName(name);
            if (Strings.equal((String)modifier, (String)"def") || Strings.equal((String)modifier, (String)"override")) {
                this.sarlAction.getModifiers().add((Object)modifier);
            } else {
                throw new IllegalStateException("Invalid modifier");
            }
        }
    }

    private void internalEInit(EObject container, IJvmTypeProvider context) {
        assert (this.sarlAction != null);
        this.setTypeResolutionContext(context);
        this.container = container;
        this.sarlAction.setAnnotationInfo((XtendAnnotationTarget)XtendFactory.eINSTANCE.createXtendMember());
        if (container instanceof XtendTypeDeclaration) {
            XtendTypeDeclaration typeDeclaration = (XtendTypeDeclaration)container;
            typeDeclaration.getMembers().add((Object)this.sarlAction);
            this.sarlAction.setDeclaringType(typeDeclaration);
        }
    }

    @Override
    @Pure
    public SarlAction getSarlAction() {
        return this.sarlAction;
    }

    @Override
    @Pure
    public Resource eResource() {
        return this.getSarlAction().eResource();
    }

    @Override
    public ISarlActionBuilder setDocumentation(String doc) {
        if (Strings.isEmpty((String)doc)) {
            this.getSarlAction().eAdapters().removeIf((Predicate)new Predicate<Adapter>(this){

                @Override
                public boolean test(Adapter adapter) {
                    return adapter.isAdapterForType(DocumentationAdapter.class);
                }
            });
        } else {
            DocumentationAdapter adapter = (DocumentationAdapter)EcoreUtil.getExistingAdapter((Notifier)this.getSarlAction(), DocumentationAdapter.class);
            if (adapter == null) {
                adapter = new DocumentationAdapter();
                this.getSarlAction().eAdapters().add((Object)adapter);
            }
            adapter.setDocumentation(doc);
        }
        return this;
    }

    @Override
    public IFormalParameterBuilder addParameter(String name) {
        IFormalParameterBuilder builder = (IFormalParameterBuilder)this.parameterProvider.get();
        builder.eInit((XtendExecutable)this.sarlAction, name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlActionBuilder addException(String type) {
        JvmTypeReference ref = this.newTypeRef((Notifier)this.container, type);
        this.addException(ref);
        return this;
    }

    @Override
    public ISarlActionBuilder addException(JvmTypeReference type) {
        this.sarlAction.getExceptions().add((Object)type);
        return this;
    }

    @Override
    public ISarlActionBuilder addFiredEvent(String type) {
        JvmTypeReference ref = this.newTypeRef((Notifier)this.container, type);
        this.addFiredEvent(ref);
        return this;
    }

    @Override
    public void addFiredEvent(JvmTypeReference type) {
        this.sarlAction.getFiredEvents().add((Object)type);
    }

    @Override
    public ISarlActionBuilder setReturnType(String type) {
        if (!Strings.isEmpty((String)type)) {
            JvmTypeReference ref = this.newTypeRef((Notifier)this.container, type);
            this.setReturnType(ref);
        } else {
            this.setReturnType((JvmTypeReference)null);
        }
        return this;
    }

    @Override
    public ISarlActionBuilder setReturnType(JvmTypeReference type) {
        if (type != null && !Objects.equals("void", type.getType().getIdentifier()) && !Objects.equals(Void.class.getName(), type.getType().getIdentifier())) {
            this.sarlAction.setReturnType(type);
        } else {
            this.sarlAction.setReturnType(null);
        }
        return this;
    }

    @Override
    public IBlockExpressionBuilder getExpression() {
        IBlockExpressionBuilder block = this.internalBlockExpression;
        if (block == null) {
            block = (IBlockExpressionBuilder)this.blockExpressionProvider.get();
            block.eInit(this.getTypeResolutionContext());
            XBlockExpression expr = block.getXBlockExpression();
            this.sarlAction.setExpression((XExpression)expr);
            this.internalBlockExpression = block;
        }
        return block;
    }

    @Override
    public ISarlActionBuilder addAnnotation(String type) {
        if (!Strings.isEmpty((String)type)) {
            JvmTypeReference ref = this.newTypeRef((Notifier)this.getSarlAction(), type);
            this.addAnnotation(ref);
        }
        return this;
    }

    @Override
    public ISarlActionBuilder addAnnotation(JvmTypeReference type) {
        if (type != null) {
            XAnnotation annotation = XAnnotationsFactory.eINSTANCE.createXAnnotation();
            annotation.setAnnotationType(type.getType());
            this.getSarlAction().getAnnotations().add((Object)annotation);
        }
        return this;
    }

    @Override
    public ISarlActionBuilder addModifier(String modifier) {
        if (!Strings.isEmpty((String)modifier)) {
            this.getSarlAction().getModifiers().add((Object)modifier);
        }
        return this;
    }

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.getSarlAction(), (EStructuralFeature[])new EStructuralFeature[0]);
    }

    @Override
    public ITypeParameterBuilder addTypeParameter(String name) {
        ITypeParameterBuilder builder = (ITypeParameterBuilder)this.iTypeParameterBuilderProvider.get();
        SarlAction object = this.getSarlAction();
        builder.eInit((XtendExecutable)object, (JvmTypeParameterDeclarator)this.getExecutableReferenceFor((EObject)object), name, this.getTypeResolutionContext());
        object.getTypeParameters().add((Object)builder.getJvmTypeParameter());
        return builder;
    }
}

