/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.ISarlActionBuilder;
import io.sarl.lang.codebuilder.builders.ISarlAgentBuilder;
import io.sarl.lang.codebuilder.builders.ISarlAnnotationTypeBuilder;
import io.sarl.lang.codebuilder.builders.ISarlBehaviorUnitBuilder;
import io.sarl.lang.codebuilder.builders.ISarlClassBuilder;
import io.sarl.lang.codebuilder.builders.ISarlConstructorBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEnumerationBuilder;
import io.sarl.lang.codebuilder.builders.ISarlFieldBuilder;
import io.sarl.lang.codebuilder.builders.ISarlInterfaceBuilder;
import io.sarl.lang.core.Agent;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlCapacityUses;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlRequiredCapacity;
import io.sarl.lang.sarl.SarlScript;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

public class SarlAgentBuilderImpl
extends AbstractBuilder
implements ISarlAgentBuilder {
    private SarlAgent sarlAgent;
    @Inject
    private Provider<ISarlConstructorBuilder> iSarlConstructorBuilderProvider;
    @Inject
    private Provider<ISarlBehaviorUnitBuilder> iSarlBehaviorUnitBuilderProvider;
    @Inject
    private Provider<ISarlFieldBuilder> iSarlFieldBuilderProvider;
    @Inject
    private Provider<ISarlActionBuilder> iSarlActionBuilderProvider;
    @Inject
    private Provider<ISarlClassBuilder> iSarlClassBuilderProvider;
    @Inject
    private Provider<ISarlInterfaceBuilder> iSarlInterfaceBuilderProvider;
    @Inject
    private Provider<ISarlEnumerationBuilder> iSarlEnumerationBuilderProvider;
    @Inject
    private Provider<ISarlAnnotationTypeBuilder> iSarlAnnotationTypeBuilderProvider;

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.getSarlAgent(), (EStructuralFeature[])new EStructuralFeature[0]);
    }

    @Override
    public void eInit(SarlScript script, String name, IJvmTypeProvider context) {
        this.setTypeResolutionContext(context);
        if (this.sarlAgent == null) {
            this.sarlAgent = SarlFactory.eINSTANCE.createSarlAgent();
            this.sarlAgent.setAnnotationInfo((XtendAnnotationTarget)XtendFactory.eINSTANCE.createXtendTypeDeclaration());
            this.sarlAgent.setName(name);
            script.getXtendTypes().add((Object)this.sarlAgent);
        }
    }

    @Override
    @Pure
    public SarlAgent getSarlAgent() {
        return this.sarlAgent;
    }

    @Override
    @Pure
    public JvmTypeReference getSarlAgentReference() {
        SarlAgent ecoreObject = this.getSarlAgent();
        return this.getTypeReferenceFor((EObject)ecoreObject, new JvmTypeReference[0]);
    }

    @Override
    @Pure
    public JvmDeclaredType getJvmDeclaredType() {
        return this.getAssociatedElement(JvmDeclaredType.class, (EObject)this.getSarlAgent(), this.eResource(), true);
    }

    @Override
    @Pure
    public Resource eResource() {
        return this.getSarlAgent().eResource();
    }

    @Override
    public ISarlAgentBuilder setDocumentation(String doc) {
        if (Strings.isEmpty((String)doc)) {
            this.getSarlAgent().eAdapters().removeIf((Predicate)new Predicate<Adapter>(this){

                @Override
                public boolean test(Adapter adapter) {
                    return adapter.isAdapterForType(DocumentationAdapter.class);
                }
            });
        } else {
            DocumentationAdapter adapter = (DocumentationAdapter)EcoreUtil.getExistingAdapter((Notifier)this.getSarlAgent(), DocumentationAdapter.class);
            if (adapter == null) {
                adapter = new DocumentationAdapter();
                this.getSarlAgent().eAdapters().add((Object)adapter);
            }
            adapter.setDocumentation(doc);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISarlAgentBuilder setExtends(String superType) {
        if (!Strings.isEmpty((String)superType)) {
            JvmTypeReference superTypeRef = this.newTypeRef((Notifier)this.sarlAgent, superType);
            if (!(superTypeRef instanceof JvmParameterizedTypeReference)) throw new IllegalArgumentException();
            JvmParameterizedTypeReference pref = (JvmParameterizedTypeReference)superTypeRef;
            this.setExtends((JvmTypeReference)pref);
            return this;
        } else {
            this.setExtends((JvmTypeReference)((JvmParameterizedTypeReference)null));
        }
        return this;
    }

    @Override
    public ISarlAgentBuilder setExtends(JvmTypeReference superType) {
        if (superType instanceof JvmParameterizedTypeReference) {
            JvmTypeReference baseTypeRef;
            JvmParameterizedTypeReference psuperType = (JvmParameterizedTypeReference)superType;
            if (!Agent.class.getName().equals(superType.getType().getIdentifier()) && this.isSubTypeOf((EObject)this.sarlAgent, superType, baseTypeRef = this.findType((Notifier)this.sarlAgent, Agent.class.getCanonicalName()))) {
                this.sarlAgent.setExtends(psuperType);
                return this;
            }
        }
        this.sarlAgent.setExtends(null);
        return this;
    }

    @Override
    public ISarlAgentBuilder addModifier(String modifier) {
        if (!Strings.isEmpty((String)modifier)) {
            this.sarlAgent.getModifiers().add((Object)modifier);
        }
        return this;
    }

    @Override
    public ISarlConstructorBuilder addSarlConstructor() {
        ISarlConstructorBuilder builder = (ISarlConstructorBuilder)this.iSarlConstructorBuilderProvider.get();
        builder.eInit((EObject)this.getSarlAgent(), this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlBehaviorUnitBuilder addSarlBehaviorUnit(String name) {
        ISarlBehaviorUnitBuilder builder = (ISarlBehaviorUnitBuilder)this.iSarlBehaviorUnitBuilderProvider.get();
        builder.eInit((EObject)this.getSarlAgent(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlBehaviorUnitBuilder addSarlBehaviorUnit(JvmParameterizedTypeReference name) {
        ISarlBehaviorUnitBuilder builder = (ISarlBehaviorUnitBuilder)this.iSarlBehaviorUnitBuilderProvider.get();
        builder.eInit((EObject)this.getSarlAgent(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addVarSarlField(String name) {
        ISarlFieldBuilder builder = (ISarlFieldBuilder)this.iSarlFieldBuilderProvider.get();
        builder.eInit((EObject)this.getSarlAgent(), name, "var", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addValSarlField(String name) {
        ISarlFieldBuilder builder = (ISarlFieldBuilder)this.iSarlFieldBuilderProvider.get();
        builder.eInit((EObject)this.getSarlAgent(), name, "val", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addSarlField(String name) {
        return this.addVarSarlField(name);
    }

    @Override
    public ISarlActionBuilder addDefSarlAction(String name) {
        ISarlActionBuilder builder = (ISarlActionBuilder)this.iSarlActionBuilderProvider.get();
        builder.eInit((EObject)this.getSarlAgent(), name, "def", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlActionBuilder addOverrideSarlAction(String name) {
        ISarlActionBuilder builder = (ISarlActionBuilder)this.iSarlActionBuilderProvider.get();
        builder.eInit((EObject)this.getSarlAgent(), name, "override", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlActionBuilder addSarlAction(String name) {
        return this.addDefSarlAction(name);
    }

    @Override
    public ISarlClassBuilder addSarlClass(String name) {
        ISarlClassBuilder builder = (ISarlClassBuilder)this.iSarlClassBuilderProvider.get();
        builder.eInit(this.getSarlAgent(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlInterfaceBuilder addSarlInterface(String name) {
        ISarlInterfaceBuilder builder = (ISarlInterfaceBuilder)this.iSarlInterfaceBuilderProvider.get();
        builder.eInit(this.getSarlAgent(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlEnumerationBuilder addSarlEnumeration(String name) {
        ISarlEnumerationBuilder builder = (ISarlEnumerationBuilder)this.iSarlEnumerationBuilderProvider.get();
        builder.eInit(this.getSarlAgent(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlAnnotationTypeBuilder addSarlAnnotationType(String name) {
        ISarlAnnotationTypeBuilder builder = (ISarlAnnotationTypeBuilder)this.iSarlAnnotationTypeBuilderProvider.get();
        builder.eInit(this.getSarlAgent(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlAgentBuilder addSarlCapacityUses(String ... name) {
        if (name != null && name.length > 0) {
            SarlCapacityUses member = SarlFactory.eINSTANCE.createSarlCapacityUses();
            this.sarlAgent.getMembers().add((Object)member);
            member.setAnnotationInfo((XtendAnnotationTarget)XtendFactory.eINSTANCE.createXtendMember());
            EList<JvmParameterizedTypeReference> thecollection = member.getCapacities();
            for (String aname : name) {
                if (Strings.isEmpty((String)aname)) continue;
                JvmTypeReference ref = this.newTypeRef((Notifier)this.sarlAgent, aname);
                if (ref instanceof JvmParameterizedTypeReference) {
                    JvmParameterizedTypeReference pref = (JvmParameterizedTypeReference)ref;
                    thecollection.add(pref);
                    continue;
                }
                throw new TypeNotPresentException(aname, null);
            }
        }
        return this;
    }

    @Override
    public ISarlAgentBuilder addSarlCapacityUses(JvmParameterizedTypeReference ... name) {
        if (name != null) {
            SarlCapacityUses member = SarlFactory.eINSTANCE.createSarlCapacityUses();
            this.sarlAgent.getMembers().add((Object)member);
            member.setAnnotationInfo((XtendAnnotationTarget)XtendFactory.eINSTANCE.createXtendMember());
            EList<JvmParameterizedTypeReference> thecollection = member.getCapacities();
            for (JvmParameterizedTypeReference aname : name) {
                if (aname == null) continue;
                thecollection.add(aname);
            }
        }
        return this;
    }

    @Override
    public ISarlAgentBuilder addSarlRequiredCapacity(String ... name) {
        if (name != null && name.length > 0) {
            SarlRequiredCapacity member = SarlFactory.eINSTANCE.createSarlRequiredCapacity();
            this.sarlAgent.getMembers().add((Object)member);
            member.setAnnotationInfo((XtendAnnotationTarget)XtendFactory.eINSTANCE.createXtendMember());
            EList<JvmParameterizedTypeReference> thecollection = member.getCapacities();
            for (String aname : name) {
                if (Strings.isEmpty((String)aname)) continue;
                JvmTypeReference ref = this.newTypeRef((Notifier)this.sarlAgent, aname);
                if (ref instanceof JvmParameterizedTypeReference) {
                    JvmParameterizedTypeReference pref = (JvmParameterizedTypeReference)ref;
                    thecollection.add(pref);
                    continue;
                }
                throw new TypeNotPresentException(aname, null);
            }
        }
        return this;
    }

    @Override
    public ISarlAgentBuilder addSarlRequiredCapacity(JvmParameterizedTypeReference ... name) {
        if (name != null) {
            SarlRequiredCapacity member = SarlFactory.eINSTANCE.createSarlRequiredCapacity();
            this.sarlAgent.getMembers().add((Object)member);
            member.setAnnotationInfo((XtendAnnotationTarget)XtendFactory.eINSTANCE.createXtendMember());
            EList<JvmParameterizedTypeReference> thecollection = member.getCapacities();
            for (JvmParameterizedTypeReference aname : name) {
                if (aname == null) continue;
                thecollection.add(aname);
            }
        }
        return this;
    }
}

