/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.ISarlActionBuilder;
import io.sarl.lang.codebuilder.builders.ISarlAnnotationTypeBuilder;
import io.sarl.lang.codebuilder.builders.ISarlClassBuilder;
import io.sarl.lang.codebuilder.builders.ISarlConstructorBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEnumerationBuilder;
import io.sarl.lang.codebuilder.builders.ISarlFieldBuilder;
import io.sarl.lang.codebuilder.builders.ISarlInterfaceBuilder;
import io.sarl.lang.codebuilder.builders.ITypeParameterBuilder;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlScript;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

public class SarlClassBuilderImpl
extends AbstractBuilder
implements ISarlClassBuilder {
    private SarlClass sarlClass;
    private EObject container;
    @Inject
    private Provider<ITypeParameterBuilder> iTypeParameterBuilderProvider;
    @Inject
    private Provider<ISarlConstructorBuilder> iSarlConstructorBuilderProvider;
    @Inject
    private Provider<ISarlFieldBuilder> iSarlFieldBuilderProvider;
    @Inject
    private Provider<ISarlActionBuilder> iSarlActionBuilderProvider;
    @Inject
    private Provider<ISarlClassBuilder> iSarlClassBuilderProvider;
    @Inject
    private Provider<ISarlInterfaceBuilder> iSarlInterfaceBuilderProvider;
    @Inject
    private Provider<ISarlEnumerationBuilder> iSarlEnumerationBuilderProvider;
    @Inject
    private Provider<ISarlAnnotationTypeBuilder> iSarlAnnotationTypeBuilderProvider;

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.getSarlClass(), (EStructuralFeature[])new EStructuralFeature[0]);
    }

    @Override
    public void eInit(SarlScript script, String name, IJvmTypeProvider context) {
        this.setTypeResolutionContext(context);
        if (this.sarlClass == null) {
            this.container = script;
            this.sarlClass = SarlFactory.eINSTANCE.createSarlClass();
            this.sarlClass.setAnnotationInfo((XtendAnnotationTarget)XtendFactory.eINSTANCE.createXtendTypeDeclaration());
            this.sarlClass.setName(name);
            script.getXtendTypes().add((Object)this.sarlClass);
        }
    }

    @Override
    public void eInit(XtendTypeDeclaration container, String name, IJvmTypeProvider context) {
        this.setTypeResolutionContext(context);
        if (this.sarlClass == null) {
            this.container = container;
            this.sarlClass = SarlFactory.eINSTANCE.createSarlClass();
            this.sarlClass.setName(name);
            container.getMembers().add((Object)this.sarlClass);
        }
    }

    @Override
    @Pure
    public SarlClass getSarlClass() {
        return this.sarlClass;
    }

    @Override
    @Pure
    public JvmTypeReference getSarlClassReference(JvmTypeReference ... args) {
        SarlClass ecoreObject = this.getSarlClass();
        return this.getTypeReferenceFor((EObject)ecoreObject, args);
    }

    @Override
    @Pure
    public JvmDeclaredType getJvmDeclaredType() {
        return this.getAssociatedElement(JvmDeclaredType.class, (EObject)this.getSarlClass(), this.eResource(), true);
    }

    @Override
    @Pure
    public Resource eResource() {
        return this.getSarlClass().eResource();
    }

    @Override
    public ISarlClassBuilder setDocumentation(String doc) {
        if (Strings.isEmpty((String)doc)) {
            this.getSarlClass().eAdapters().removeIf((Predicate)new Predicate<Adapter>(this){

                @Override
                public boolean test(Adapter adapter) {
                    return adapter.isAdapterForType(DocumentationAdapter.class);
                }
            });
        } else {
            DocumentationAdapter adapter = (DocumentationAdapter)EcoreUtil.getExistingAdapter((Notifier)this.getSarlClass(), DocumentationAdapter.class);
            if (adapter == null) {
                adapter = new DocumentationAdapter();
                this.getSarlClass().eAdapters().add((Object)adapter);
            }
            adapter.setDocumentation(doc);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISarlClassBuilder setExtends(String superType) {
        if (!Strings.isEmpty((String)superType)) {
            JvmTypeReference superTypeRef = this.newTypeRef((Notifier)this.container, superType);
            if (!(superTypeRef instanceof JvmParameterizedTypeReference)) throw new IllegalArgumentException();
            JvmParameterizedTypeReference pref = (JvmParameterizedTypeReference)superTypeRef;
            this.setExtends((JvmTypeReference)pref);
            return this;
        } else {
            this.setExtends((JvmTypeReference)((JvmParameterizedTypeReference)null));
        }
        return this;
    }

    @Override
    public ISarlClassBuilder setExtends(JvmTypeReference superType) {
        if (superType instanceof JvmParameterizedTypeReference) {
            JvmParameterizedTypeReference psuperType = (JvmParameterizedTypeReference)superType;
            this.sarlClass.setExtends((JvmTypeReference)psuperType);
            return this;
        }
        this.sarlClass.setExtends(null);
        return this;
    }

    @Override
    public ISarlClassBuilder addImplements(String type) {
        if (!Strings.isEmpty((String)type)) {
            JvmTypeReference superTypeRef = this.newTypeRef((Notifier)this.container, type);
            if (superTypeRef instanceof JvmParameterizedTypeReference) {
                JvmParameterizedTypeReference pref = (JvmParameterizedTypeReference)superTypeRef;
                this.addImplements((JvmTypeReference)pref);
            } else {
                throw new IllegalArgumentException(type);
            }
        }
        return this;
    }

    @Override
    public ISarlClassBuilder addImplements(JvmTypeReference type) {
        if (type instanceof JvmParameterizedTypeReference) {
            JvmParameterizedTypeReference ptype = (JvmParameterizedTypeReference)type;
            this.sarlClass.getImplements().add((Object)ptype);
        }
        return this;
    }

    @Override
    public ISarlClassBuilder addModifier(String modifier) {
        if (!Strings.isEmpty((String)modifier)) {
            this.sarlClass.getModifiers().add((Object)modifier);
        }
        return this;
    }

    @Override
    public ITypeParameterBuilder addTypeParameter(String name) {
        JvmTypeParameterDeclarator declarator;
        ITypeParameterBuilder builder = (ITypeParameterBuilder)this.iTypeParameterBuilderProvider.get();
        SarlClass object = this.getSarlClass();
        JvmType jvmType = this.getSarlClassReference(new JvmTypeReference[0]).getType();
        builder.eInit((XtendTypeDeclaration)object, jvmType instanceof JvmTypeParameterDeclarator ? (declarator = (JvmTypeParameterDeclarator)jvmType) : null, name, this.getTypeResolutionContext());
        object.getTypeParameters().add((Object)builder.getJvmTypeParameter());
        return builder;
    }

    @Override
    public ISarlConstructorBuilder addSarlConstructor() {
        ISarlConstructorBuilder builder = (ISarlConstructorBuilder)this.iSarlConstructorBuilderProvider.get();
        builder.eInit((EObject)this.getSarlClass(), this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addVarSarlField(String name) {
        ISarlFieldBuilder builder = (ISarlFieldBuilder)this.iSarlFieldBuilderProvider.get();
        builder.eInit((EObject)this.getSarlClass(), name, "var", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addValSarlField(String name) {
        ISarlFieldBuilder builder = (ISarlFieldBuilder)this.iSarlFieldBuilderProvider.get();
        builder.eInit((EObject)this.getSarlClass(), name, "val", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addSarlField(String name) {
        return this.addVarSarlField(name);
    }

    @Override
    public ISarlActionBuilder addDefSarlAction(String name) {
        ISarlActionBuilder builder = (ISarlActionBuilder)this.iSarlActionBuilderProvider.get();
        builder.eInit((EObject)this.getSarlClass(), name, "def", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlActionBuilder addOverrideSarlAction(String name) {
        ISarlActionBuilder builder = (ISarlActionBuilder)this.iSarlActionBuilderProvider.get();
        builder.eInit((EObject)this.getSarlClass(), name, "override", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlActionBuilder addSarlAction(String name) {
        return this.addDefSarlAction(name);
    }

    @Override
    public ISarlClassBuilder addSarlClass(String name) {
        ISarlClassBuilder builder = (ISarlClassBuilder)this.iSarlClassBuilderProvider.get();
        builder.eInit((XtendTypeDeclaration)this.getSarlClass(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlInterfaceBuilder addSarlInterface(String name) {
        ISarlInterfaceBuilder builder = (ISarlInterfaceBuilder)this.iSarlInterfaceBuilderProvider.get();
        builder.eInit((XtendTypeDeclaration)this.getSarlClass(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlEnumerationBuilder addSarlEnumeration(String name) {
        ISarlEnumerationBuilder builder = (ISarlEnumerationBuilder)this.iSarlEnumerationBuilderProvider.get();
        builder.eInit((XtendTypeDeclaration)this.getSarlClass(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlAnnotationTypeBuilder addSarlAnnotationType(String name) {
        ISarlAnnotationTypeBuilder builder = (ISarlAnnotationTypeBuilder)this.iSarlAnnotationTypeBuilderProvider.get();
        builder.eInit((XtendTypeDeclaration)this.getSarlClass(), name, this.getTypeResolutionContext());
        return builder;
    }
}

