/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.IBlockExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IFormalParameterBuilder;
import io.sarl.lang.codebuilder.builders.ISarlConstructorBuilder;
import io.sarl.lang.codebuilder.builders.ITypeParameterBuilder;
import io.sarl.lang.sarl.SarlConstructor;
import io.sarl.lang.sarl.SarlFactory;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

public class SarlConstructorBuilderImpl
extends AbstractBuilder
implements ISarlConstructorBuilder {
    @Inject
    private Provider<IFormalParameterBuilder> parameterProvider;
    @Inject
    private Provider<IBlockExpressionBuilder> blockExpressionProvider;
    private EObject container;
    private SarlConstructor sarlConstructor;
    private IBlockExpressionBuilder internalBlockExpression;
    @Inject
    private Provider<ITypeParameterBuilder> iTypeParameterBuilderProvider;

    @Override
    public void eInit(EObject container, IJvmTypeProvider context) {
        if (this.sarlConstructor == null) {
            this.sarlConstructor = SarlFactory.eINSTANCE.createSarlConstructor();
            this.internalEInit(container, context);
        }
    }

    private void internalEInit(EObject container, IJvmTypeProvider context) {
        assert (this.sarlConstructor != null);
        this.setTypeResolutionContext(context);
        this.container = container;
        this.sarlConstructor.setAnnotationInfo((XtendAnnotationTarget)XtendFactory.eINSTANCE.createXtendMember());
        if (container instanceof XtendTypeDeclaration) {
            XtendTypeDeclaration typeDeclaration = (XtendTypeDeclaration)container;
            typeDeclaration.getMembers().add((Object)this.sarlConstructor);
            this.sarlConstructor.setDeclaringType(typeDeclaration);
        }
    }

    @Override
    @Pure
    public SarlConstructor getSarlConstructor() {
        return this.sarlConstructor;
    }

    @Override
    @Pure
    public Resource eResource() {
        return this.getSarlConstructor().eResource();
    }

    @Override
    public ISarlConstructorBuilder setDocumentation(String doc) {
        if (Strings.isEmpty((String)doc)) {
            this.getSarlConstructor().eAdapters().removeIf((Predicate)new Predicate<Adapter>(this){

                @Override
                public boolean test(Adapter adapter) {
                    return adapter.isAdapterForType(DocumentationAdapter.class);
                }
            });
        } else {
            DocumentationAdapter adapter = (DocumentationAdapter)EcoreUtil.getExistingAdapter((Notifier)this.getSarlConstructor(), DocumentationAdapter.class);
            if (adapter == null) {
                adapter = new DocumentationAdapter();
                this.getSarlConstructor().eAdapters().add((Object)adapter);
            }
            adapter.setDocumentation(doc);
        }
        return this;
    }

    @Override
    public IFormalParameterBuilder addParameter(String name) {
        IFormalParameterBuilder builder = (IFormalParameterBuilder)this.parameterProvider.get();
        builder.eInit((XtendExecutable)this.sarlConstructor, name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlConstructorBuilder addException(String type) {
        JvmTypeReference ref = this.newTypeRef((Notifier)this.container, type);
        this.addException(ref);
        return this;
    }

    @Override
    public ISarlConstructorBuilder addException(JvmTypeReference type) {
        this.sarlConstructor.getExceptions().add((Object)type);
        return this;
    }

    @Override
    public IBlockExpressionBuilder getExpression() {
        IBlockExpressionBuilder block = this.internalBlockExpression;
        if (block == null) {
            block = (IBlockExpressionBuilder)this.blockExpressionProvider.get();
            block.eInit(this.getTypeResolutionContext());
            XBlockExpression expr = block.getXBlockExpression();
            this.sarlConstructor.setExpression((XExpression)expr);
            this.internalBlockExpression = block;
        }
        return block;
    }

    @Override
    public ISarlConstructorBuilder addModifier(String modifier) {
        if (!Strings.isEmpty((String)modifier)) {
            this.getSarlConstructor().getModifiers().add((Object)modifier);
        }
        return this;
    }

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.getSarlConstructor(), (EStructuralFeature[])new EStructuralFeature[0]);
    }

    @Override
    public ITypeParameterBuilder addTypeParameter(String name) {
        ITypeParameterBuilder builder = (ITypeParameterBuilder)this.iTypeParameterBuilderProvider.get();
        SarlConstructor object = this.getSarlConstructor();
        builder.eInit((XtendExecutable)object, (JvmTypeParameterDeclarator)this.getExecutableReferenceFor((EObject)object), name, this.getTypeResolutionContext());
        object.getTypeParameters().add((Object)builder.getJvmTypeParameter());
        return builder;
    }
}

