/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.ISarlConstructorBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEventBuilder;
import io.sarl.lang.codebuilder.builders.ISarlFieldBuilder;
import io.sarl.lang.codebuilder.builders.ITypeParameterBuilder;
import io.sarl.lang.core.Event;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlScript;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

public class SarlEventBuilderImpl
extends AbstractBuilder
implements ISarlEventBuilder {
    private SarlEvent sarlEvent;
    @Inject
    private Provider<ITypeParameterBuilder> iTypeParameterBuilderProvider;
    @Inject
    private Provider<ISarlConstructorBuilder> iSarlConstructorBuilderProvider;
    @Inject
    private Provider<ISarlFieldBuilder> iSarlFieldBuilderProvider;

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.getSarlEvent(), (EStructuralFeature[])new EStructuralFeature[0]);
    }

    @Override
    public void eInit(SarlScript script, String name, IJvmTypeProvider context) {
        this.setTypeResolutionContext(context);
        if (this.sarlEvent == null) {
            this.sarlEvent = SarlFactory.eINSTANCE.createSarlEvent();
            this.sarlEvent.setAnnotationInfo((XtendAnnotationTarget)XtendFactory.eINSTANCE.createXtendTypeDeclaration());
            this.sarlEvent.setName(name);
            script.getXtendTypes().add((Object)this.sarlEvent);
        }
    }

    @Override
    @Pure
    public SarlEvent getSarlEvent() {
        return this.sarlEvent;
    }

    @Override
    @Pure
    public JvmTypeReference getSarlEventReference(JvmTypeReference ... args) {
        SarlEvent ecoreObject = this.getSarlEvent();
        return this.getTypeReferenceFor((EObject)ecoreObject, args);
    }

    @Override
    @Pure
    public JvmDeclaredType getJvmDeclaredType() {
        return this.getAssociatedElement(JvmDeclaredType.class, (EObject)this.getSarlEvent(), this.eResource(), true);
    }

    @Override
    @Pure
    public Resource eResource() {
        return this.getSarlEvent().eResource();
    }

    @Override
    public ISarlEventBuilder setDocumentation(String doc) {
        if (Strings.isEmpty((String)doc)) {
            this.getSarlEvent().eAdapters().removeIf((Predicate)new Predicate<Adapter>(this){

                @Override
                public boolean test(Adapter adapter) {
                    return adapter.isAdapterForType(DocumentationAdapter.class);
                }
            });
        } else {
            DocumentationAdapter adapter = (DocumentationAdapter)EcoreUtil.getExistingAdapter((Notifier)this.getSarlEvent(), DocumentationAdapter.class);
            if (adapter == null) {
                adapter = new DocumentationAdapter();
                this.getSarlEvent().eAdapters().add((Object)adapter);
            }
            adapter.setDocumentation(doc);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISarlEventBuilder setExtends(String superType) {
        if (!Strings.isEmpty((String)superType)) {
            JvmTypeReference superTypeRef = this.newTypeRef((Notifier)this.sarlEvent, superType);
            if (!(superTypeRef instanceof JvmParameterizedTypeReference)) throw new IllegalArgumentException();
            JvmParameterizedTypeReference pref = (JvmParameterizedTypeReference)superTypeRef;
            this.setExtends((JvmTypeReference)pref);
            return this;
        } else {
            this.setExtends((JvmTypeReference)((JvmParameterizedTypeReference)null));
        }
        return this;
    }

    @Override
    public ISarlEventBuilder setExtends(JvmTypeReference superType) {
        if (superType instanceof JvmParameterizedTypeReference) {
            JvmTypeReference baseTypeRef;
            JvmParameterizedTypeReference psuperType = (JvmParameterizedTypeReference)superType;
            if (!Event.class.getName().equals(superType.getType().getIdentifier()) && this.isSubTypeOf((EObject)this.sarlEvent, superType, baseTypeRef = this.findType((Notifier)this.sarlEvent, Event.class.getCanonicalName()))) {
                this.sarlEvent.setExtends(psuperType);
                return this;
            }
        }
        this.sarlEvent.setExtends(null);
        return this;
    }

    @Override
    public ISarlEventBuilder addModifier(String modifier) {
        if (!Strings.isEmpty((String)modifier)) {
            this.sarlEvent.getModifiers().add((Object)modifier);
        }
        return this;
    }

    @Override
    public ITypeParameterBuilder addTypeParameter(String name) {
        JvmTypeParameterDeclarator declarator;
        ITypeParameterBuilder builder = (ITypeParameterBuilder)this.iTypeParameterBuilderProvider.get();
        SarlEvent object = this.getSarlEvent();
        JvmType jvmType = this.getSarlEventReference(new JvmTypeReference[0]).getType();
        builder.eInit(object, jvmType instanceof JvmTypeParameterDeclarator ? (declarator = (JvmTypeParameterDeclarator)jvmType) : null, name, this.getTypeResolutionContext());
        object.getTypeParameters().add((Object)builder.getJvmTypeParameter());
        return builder;
    }

    @Override
    public ISarlConstructorBuilder addSarlConstructor() {
        ISarlConstructorBuilder builder = (ISarlConstructorBuilder)this.iSarlConstructorBuilderProvider.get();
        builder.eInit((EObject)this.getSarlEvent(), this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addVarSarlField(String name) {
        ISarlFieldBuilder builder = (ISarlFieldBuilder)this.iSarlFieldBuilderProvider.get();
        builder.eInit((EObject)this.getSarlEvent(), name, "var", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addValSarlField(String name) {
        ISarlFieldBuilder builder = (ISarlFieldBuilder)this.iSarlFieldBuilderProvider.get();
        builder.eInit((EObject)this.getSarlEvent(), name, "val", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addSarlField(String name) {
        return this.addVarSarlField(name);
    }
}

