/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.ISarlActionBuilder;
import io.sarl.lang.codebuilder.builders.ISarlAnnotationTypeBuilder;
import io.sarl.lang.codebuilder.builders.ISarlClassBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEnumerationBuilder;
import io.sarl.lang.codebuilder.builders.ISarlFieldBuilder;
import io.sarl.lang.codebuilder.builders.ISarlInterfaceBuilder;
import io.sarl.lang.codebuilder.builders.ITypeParameterBuilder;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlInterface;
import io.sarl.lang.sarl.SarlScript;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendFactory;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.Pure;

public class SarlInterfaceBuilderImpl
extends AbstractBuilder
implements ISarlInterfaceBuilder {
    private SarlInterface sarlInterface;
    private EObject container;
    @Inject
    private Provider<ITypeParameterBuilder> iTypeParameterBuilderProvider;
    @Inject
    private Provider<ISarlFieldBuilder> iSarlFieldBuilderProvider;
    @Inject
    private Provider<ISarlActionBuilder> iSarlActionBuilderProvider;
    @Inject
    private Provider<ISarlClassBuilder> iSarlClassBuilderProvider;
    @Inject
    private Provider<ISarlInterfaceBuilder> iSarlInterfaceBuilderProvider;
    @Inject
    private Provider<ISarlEnumerationBuilder> iSarlEnumerationBuilderProvider;
    @Inject
    private Provider<ISarlAnnotationTypeBuilder> iSarlAnnotationTypeBuilderProvider;

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.getSarlInterface(), (EStructuralFeature[])new EStructuralFeature[0]);
    }

    @Override
    public void eInit(SarlScript script, String name, IJvmTypeProvider context) {
        this.setTypeResolutionContext(context);
        if (this.sarlInterface == null) {
            this.container = script;
            this.sarlInterface = SarlFactory.eINSTANCE.createSarlInterface();
            this.sarlInterface.setAnnotationInfo((XtendAnnotationTarget)XtendFactory.eINSTANCE.createXtendTypeDeclaration());
            this.sarlInterface.setName(name);
            script.getXtendTypes().add((Object)this.sarlInterface);
        }
    }

    @Override
    public void eInit(XtendTypeDeclaration container, String name, IJvmTypeProvider context) {
        this.setTypeResolutionContext(context);
        if (this.sarlInterface == null) {
            this.container = container;
            this.sarlInterface = SarlFactory.eINSTANCE.createSarlInterface();
            this.sarlInterface.setName(name);
            container.getMembers().add((Object)this.sarlInterface);
        }
    }

    @Override
    @Pure
    public SarlInterface getSarlInterface() {
        return this.sarlInterface;
    }

    @Override
    @Pure
    public JvmTypeReference getSarlInterfaceReference(JvmTypeReference ... args) {
        SarlInterface ecoreObject = this.getSarlInterface();
        return this.getTypeReferenceFor((EObject)ecoreObject, args);
    }

    @Override
    @Pure
    public JvmDeclaredType getJvmDeclaredType() {
        return this.getAssociatedElement(JvmDeclaredType.class, (EObject)this.getSarlInterface(), this.eResource(), true);
    }

    @Override
    @Pure
    public Resource eResource() {
        return this.getSarlInterface().eResource();
    }

    @Override
    public ISarlInterfaceBuilder setDocumentation(String doc) {
        if (Strings.isEmpty((String)doc)) {
            this.getSarlInterface().eAdapters().removeIf((Predicate)new Predicate<Adapter>(this){

                @Override
                public boolean test(Adapter adapter) {
                    return adapter.isAdapterForType(DocumentationAdapter.class);
                }
            });
        } else {
            DocumentationAdapter adapter = (DocumentationAdapter)EcoreUtil.getExistingAdapter((Notifier)this.getSarlInterface(), DocumentationAdapter.class);
            if (adapter == null) {
                adapter = new DocumentationAdapter();
                this.getSarlInterface().eAdapters().add((Object)adapter);
            }
            adapter.setDocumentation(doc);
        }
        return this;
    }

    @Override
    public ISarlInterfaceBuilder addExtends(String superType) {
        if (!Strings.isEmpty((String)superType)) {
            JvmTypeReference superTypeRef = this.newTypeRef((Notifier)this.container, superType);
            if (superTypeRef instanceof JvmParameterizedTypeReference) {
                JvmParameterizedTypeReference pref = (JvmParameterizedTypeReference)superTypeRef;
                this.addExtends(pref);
            } else {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    public ISarlInterfaceBuilder addExtends(JvmParameterizedTypeReference superType) {
        if (superType instanceof JvmParameterizedTypeReference) {
            JvmParameterizedTypeReference psuperType = superType;
            this.sarlInterface.getExtends().add((Object)psuperType);
            return this;
        }
        return this;
    }

    @Override
    public ISarlInterfaceBuilder addModifier(String modifier) {
        if (!Strings.isEmpty((String)modifier)) {
            this.sarlInterface.getModifiers().add((Object)modifier);
        }
        return this;
    }

    @Override
    public ITypeParameterBuilder addTypeParameter(String name) {
        JvmTypeParameterDeclarator declarator;
        ITypeParameterBuilder builder = (ITypeParameterBuilder)this.iTypeParameterBuilderProvider.get();
        SarlInterface object = this.getSarlInterface();
        JvmType jvmType = this.getSarlInterfaceReference(new JvmTypeReference[0]).getType();
        builder.eInit((XtendTypeDeclaration)object, jvmType instanceof JvmTypeParameterDeclarator ? (declarator = (JvmTypeParameterDeclarator)jvmType) : null, name, this.getTypeResolutionContext());
        object.getTypeParameters().add((Object)builder.getJvmTypeParameter());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addVarSarlField(String name) {
        ISarlFieldBuilder builder = (ISarlFieldBuilder)this.iSarlFieldBuilderProvider.get();
        builder.eInit((EObject)this.getSarlInterface(), name, "var", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addValSarlField(String name) {
        ISarlFieldBuilder builder = (ISarlFieldBuilder)this.iSarlFieldBuilderProvider.get();
        builder.eInit((EObject)this.getSarlInterface(), name, "val", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlFieldBuilder addSarlField(String name) {
        return this.addVarSarlField(name);
    }

    @Override
    public ISarlActionBuilder addDefSarlAction(String name) {
        ISarlActionBuilder builder = (ISarlActionBuilder)this.iSarlActionBuilderProvider.get();
        builder.eInit((EObject)this.getSarlInterface(), name, "def", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlActionBuilder addOverrideSarlAction(String name) {
        ISarlActionBuilder builder = (ISarlActionBuilder)this.iSarlActionBuilderProvider.get();
        builder.eInit((EObject)this.getSarlInterface(), name, "override", this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlActionBuilder addSarlAction(String name) {
        return this.addDefSarlAction(name);
    }

    @Override
    public ISarlClassBuilder addSarlClass(String name) {
        ISarlClassBuilder builder = (ISarlClassBuilder)this.iSarlClassBuilderProvider.get();
        builder.eInit((XtendTypeDeclaration)this.getSarlInterface(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlInterfaceBuilder addSarlInterface(String name) {
        ISarlInterfaceBuilder builder = (ISarlInterfaceBuilder)this.iSarlInterfaceBuilderProvider.get();
        builder.eInit((XtendTypeDeclaration)this.getSarlInterface(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlEnumerationBuilder addSarlEnumeration(String name) {
        ISarlEnumerationBuilder builder = (ISarlEnumerationBuilder)this.iSarlEnumerationBuilderProvider.get();
        builder.eInit((XtendTypeDeclaration)this.getSarlInterface(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlAnnotationTypeBuilder addSarlAnnotationType(String name) {
        ISarlAnnotationTypeBuilder builder = (ISarlAnnotationTypeBuilder)this.iSarlAnnotationTypeBuilderProvider.get();
        builder.eInit((XtendTypeDeclaration)this.getSarlInterface(), name, this.getTypeResolutionContext());
        return builder;
    }
}

