/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Provider;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.ISarlAgentBuilder;
import io.sarl.lang.codebuilder.builders.ISarlAnnotationTypeBuilder;
import io.sarl.lang.codebuilder.builders.ISarlArtifactBuilder;
import io.sarl.lang.codebuilder.builders.ISarlBehaviorBuilder;
import io.sarl.lang.codebuilder.builders.ISarlCapacityBuilder;
import io.sarl.lang.codebuilder.builders.ISarlClassBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEnumerationBuilder;
import io.sarl.lang.codebuilder.builders.ISarlEventBuilder;
import io.sarl.lang.codebuilder.builders.ISarlInterfaceBuilder;
import io.sarl.lang.codebuilder.builders.ISarlSkillBuilder;
import io.sarl.lang.codebuilder.builders.ISarlSpaceBuilder;
import io.sarl.lang.codebuilder.builders.IScriptBuilder;
import io.sarl.lang.sarl.SarlFactory;
import io.sarl.lang.sarl.SarlScript;
import jakarta.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypeFactory;

public class ScriptBuilderImpl
extends AbstractBuilder
implements IScriptBuilder {
    private SarlScript script;
    private boolean isFinalized;
    @Inject
    private Provider<ISarlEventBuilder> sarlEventProvider;
    @Inject
    private Provider<ISarlCapacityBuilder> sarlCapacityProvider;
    @Inject
    private Provider<ISarlAgentBuilder> sarlAgentProvider;
    @Inject
    private Provider<ISarlBehaviorBuilder> sarlBehaviorProvider;
    @Inject
    private Provider<ISarlSkillBuilder> sarlSkillProvider;
    @Inject
    private Provider<ISarlSpaceBuilder> sarlSpaceProvider;
    @Inject
    private Provider<ISarlArtifactBuilder> sarlArtifactProvider;
    @Inject
    private Provider<ISarlClassBuilder> sarlClassProvider;
    @Inject
    private Provider<ISarlInterfaceBuilder> sarlInterfaceProvider;
    @Inject
    private Provider<ISarlEnumerationBuilder> sarlEnumerationProvider;
    @Inject
    private Provider<ISarlAnnotationTypeBuilder> sarlAnnotationTypeProvider;

    @Override
    public void eInit(Resource resource, String packageName, IJvmTypeProvider context) {
        this.setTypeResolutionContext(context);
        if (this.script == null) {
            this.script = SarlFactory.eINSTANCE.createSarlScript();
            EList content = resource.getContents();
            if (!content.isEmpty()) {
                content.clear();
            }
            content.add((Object)this.script);
            if (!Strings.isEmpty((String)packageName)) {
                this.script.setPackage(packageName);
            }
        }
    }

    @Override
    @Pure
    public SarlScript getScript() {
        return this.script;
    }

    @Override
    @Pure
    public Resource eResource() {
        return this.getScript().eResource();
    }

    @Override
    public void finalizeScript() {
        if (this.isFinalized) {
            throw new IllegalStateException("already finalized");
        }
        this.isFinalized = true;
        ImportManager concreteImports = new ImportManager(true);
        XImportSection importSection = this.getScript().getImportSection();
        if (importSection != null) {
            for (XImportDeclaration decl : importSection.getImportDeclarations()) {
                concreteImports.addImportFor((JvmType)decl.getImportedType());
            }
        }
        for (String importName : this.getImportManager().getImports()) {
            JvmDeclaredType ctype;
            JvmType type = this.findType((Notifier)this.getScript(), importName).getType();
            if (!(type instanceof JvmDeclaredType) || !concreteImports.addImportFor((JvmType)(ctype = (JvmDeclaredType)type))) continue;
            XImportDeclaration declaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
            declaration.setImportedType(ctype);
            if (importSection == null) {
                importSection = XtypeFactory.eINSTANCE.createXImportSection();
                this.getScript().setImportSection(importSection);
            }
            importSection.getImportDeclarations().add((Object)declaration);
        }
        Resource resource = this.getScript().eResource();
        if (resource instanceof DerivedStateAwareResource) {
            DerivedStateAwareResource cresource = (DerivedStateAwareResource)resource;
            cresource.discardDerivedState();
        }
    }

    @Override
    public boolean isFinalized() {
        return this.isFinalized;
    }

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.script, (EStructuralFeature[])new EStructuralFeature[0]);
    }

    @Override
    public ISarlEventBuilder addSarlEvent(String name) {
        ISarlEventBuilder builder = (ISarlEventBuilder)this.sarlEventProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlCapacityBuilder addSarlCapacity(String name) {
        ISarlCapacityBuilder builder = (ISarlCapacityBuilder)this.sarlCapacityProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlAgentBuilder addSarlAgent(String name) {
        ISarlAgentBuilder builder = (ISarlAgentBuilder)this.sarlAgentProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlBehaviorBuilder addSarlBehavior(String name) {
        ISarlBehaviorBuilder builder = (ISarlBehaviorBuilder)this.sarlBehaviorProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlSkillBuilder addSarlSkill(String name) {
        ISarlSkillBuilder builder = (ISarlSkillBuilder)this.sarlSkillProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlSpaceBuilder addSarlSpace(String name) {
        ISarlSpaceBuilder builder = (ISarlSpaceBuilder)this.sarlSpaceProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlArtifactBuilder addSarlArtifact(String name) {
        ISarlArtifactBuilder builder = (ISarlArtifactBuilder)this.sarlArtifactProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlClassBuilder addSarlClass(String name) {
        ISarlClassBuilder builder = (ISarlClassBuilder)this.sarlClassProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlInterfaceBuilder addSarlInterface(String name) {
        ISarlInterfaceBuilder builder = (ISarlInterfaceBuilder)this.sarlInterfaceProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlEnumerationBuilder addSarlEnumeration(String name) {
        ISarlEnumerationBuilder builder = (ISarlEnumerationBuilder)this.sarlEnumerationProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }

    @Override
    public ISarlAnnotationTypeBuilder addSarlAnnotationType(String name) {
        ISarlAnnotationTypeBuilder builder = (ISarlAnnotationTypeBuilder)this.sarlAnnotationTypeProvider.get();
        builder.eInit(this.getScript(), name, this.getTypeResolutionContext());
        return builder;
    }
}

