/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.codebuilder.builders;

import com.google.inject.Inject;
import io.sarl.lang.codebuilder.builders.AbstractBuilder;
import io.sarl.lang.codebuilder.builders.ITypeParameterBuilder;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.xbase.lib.Pure;

public class TypeParameterBuilderImpl
extends AbstractBuilder
implements ITypeParameterBuilder {
    private EObject context;
    private JvmTypeParameter parameter;
    @Inject
    private TypesFactory jvmTypesFactory;
    private boolean hasDefaultConstraint = true;

    @Override
    public void eInit(XtendTypeDeclaration context, JvmTypeParameterDeclarator declarator, String name, IJvmTypeProvider typeContext) {
        this.internalEInit((EObject)context, declarator, name, typeContext);
    }

    @Override
    public void eInit(XtendExecutable context, JvmTypeParameterDeclarator declarator, String name, IJvmTypeProvider typeContext) {
        this.internalEInit((EObject)context, declarator, name, typeContext);
    }

    protected void internalEInit(EObject context, JvmTypeParameterDeclarator declarator, String name, IJvmTypeProvider typeContext) {
        this.setTypeResolutionContext(typeContext);
        this.context = context;
        this.parameter = this.jvmTypesFactory.createJvmTypeParameter();
        this.parameter.setName(name);
        if (declarator != null) {
            this.parameter.setDeclarator(declarator);
        }
        JvmUpperBound constraint = this.jvmTypesFactory.createJvmUpperBound();
        constraint.setTypeReference(this.newTypeRef(Object.class, new JvmTypeReference[0]));
        this.getJvmTypeParameter().getConstraints().add((Object)constraint);
    }

    @Override
    @Pure
    public JvmTypeParameter getJvmTypeParameter() {
        return this.parameter;
    }

    @Override
    @Pure
    public JvmTypeReference getJvmTypeParameterReference() {
        return this.newTypeRef((JvmType)this.parameter, new JvmTypeReference[0]);
    }

    @Override
    @Pure
    public Resource eResource() {
        return this.getJvmTypeParameter().eResource();
    }

    @Pure
    public String toString() {
        return EmfFormatter.objToStr((Object)this.getJvmTypeParameter(), (EStructuralFeature[])new EStructuralFeature[0]);
    }

    @Override
    public ITypeParameterBuilder addUpperConstraint(String type) {
        this.addUpperConstraint(this.newTypeRef((Notifier)this.context, type));
        return this;
    }

    @Override
    public ITypeParameterBuilder addUpperConstraint(JvmTypeReference type) {
        if (this.hasDefaultConstraint) {
            this.hasDefaultConstraint = false;
            this.getJvmTypeParameter().getConstraints().clear();
        }
        JvmUpperBound constraint = this.jvmTypesFactory.createJvmUpperBound();
        constraint.setTypeReference(type);
        this.getJvmTypeParameter().getConstraints().add((Object)constraint);
        return this;
    }

    @Override
    public ITypeParameterBuilder addLowerConstraint(String type) {
        this.addLowerConstraint(this.newTypeRef((Notifier)this.context, type));
        return this;
    }

    @Override
    public ITypeParameterBuilder addLowerConstraint(JvmTypeReference type) {
        if (this.hasDefaultConstraint) {
            this.hasDefaultConstraint = false;
            this.getJvmTypeParameter().getConstraints().clear();
        }
        JvmLowerBound constraint = this.jvmTypesFactory.createJvmLowerBound();
        constraint.setTypeReference(type);
        this.getJvmTypeParameter().getConstraints().add((Object)constraint);
        return this;
    }
}

