/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.lang.compiler.GeneratorConfig2;
import io.sarl.lang.compiler.GeneratorConfigProvider2;
import io.sarl.lang.compiler.IInlineExpressionCompiler;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.macro.ConstantExpressionsInterpreter;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.ReflectionUtil;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.output.FakeTreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

@Singleton
public class JavaInlineExpressionCompiler
implements IInlineExpressionCompiler {
    @Inject
    private JvmAnnotationReferenceBuilder.Factory annotationRefBuilderFactory;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private JvmTypesBuilder typeBuilder;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private ConstantExpressionsInterpreter expressionInterpreter;
    @Inject
    private GeneratorConfigProvider2 configProvider;
    private final PolymorphicDispatcher<Boolean> generateDispatcher = new PolymorphicDispatcher<Boolean>(this, "_generate", 4, 4, Collections.singletonList(this)){

        protected Boolean handleNoSuchMethod(Object ... params) {
            return Boolean.FALSE;
        }
    };

    private JvmTypeReference getFunctionTypeReference(XtendFunction function) {
        JvmType type;
        JvmTypeReference reference;
        if (function != null && (reference = function.getReturnType()) != null && (type = reference.getType()) != null) {
            return reference;
        }
        return this.typeReferences.getTypeForName(Object.class, (Notifier)function, new JvmTypeReference[0]);
    }

    protected InlineAnnotationTreeAppendable newAppendable(ImportManager imports) {
        return new InlineAnnotationTreeAppendable(imports);
    }

    private static XExpression filterSingleOperation(XExpression expression) {
        XExpression content = expression;
        while (content instanceof XBlockExpression) {
            XBlockExpression blockExpr = (XBlockExpression)content;
            if (blockExpr.getExpressions().size() == 1) {
                content = (XExpression)blockExpr.getExpressions().get(0);
                continue;
            }
            content = null;
        }
        if (content instanceof XReturnExpression) {
            XReturnExpression xre = (XReturnExpression)content;
            content = xre.getExpression();
        }
        return content;
    }

    @Override
    public void appendInlineAnnotation(JvmAnnotationTarget target, ResourceSet resourceSet, String inlineExpression, JvmTypeReference ... types) {
        this.appendInlineAnnotation(target, resourceSet, inlineExpression, false, false, types);
    }

    protected void appendInlineAnnotation(JvmAnnotationTarget target, ResourceSet resourceSet, String inlineExpression, boolean isConstantExpression, boolean isStatementExpression, JvmTypeReference ... types) {
        JvmAnnotationReferenceBuilder annotationTypesBuilder = this.annotationRefBuilderFactory.create(resourceSet);
        JvmAnnotationReference annotationReference = annotationTypesBuilder.annotationRef(Inline.class, new String[0]);
        AnnotationInformation annotationInfo = AnnotationInformation.build(annotationReference);
        JvmStringAnnotationValue annotationValue = this.services.getTypesFactory().createJvmStringAnnotationValue();
        annotationValue.getValues().add((Object)inlineExpression);
        annotationValue.setOperation(annotationInfo.valueOperation);
        annotationReference.getExplicitValues().add((Object)annotationValue);
        for (JvmTypeReference type : types) {
            JvmTypeAnnotationValue annotationImportedType = this.services.getTypesFactory().createJvmTypeAnnotationValue();
            annotationImportedType.getValues().add((Object)this.typeBuilder.cloneWithProxies(type));
            annotationImportedType.setOperation(annotationInfo.importedOperation);
            annotationReference.getExplicitValues().add((Object)annotationImportedType);
        }
        if (isConstantExpression) {
            JvmBooleanAnnotationValue annotationConstant = this.services.getTypesFactory().createJvmBooleanAnnotationValue();
            annotationConstant.getValues().add((Object)isConstantExpression);
            annotationConstant.setOperation(annotationInfo.constantExpressionOperation);
            annotationReference.getExplicitValues().add((Object)annotationConstant);
        }
        if (isStatementExpression) {
            JvmBooleanAnnotationValue annotationStatement = this.services.getTypesFactory().createJvmBooleanAnnotationValue();
            annotationStatement.getValues().add((Object)isStatementExpression);
            annotationStatement.setOperation(annotationInfo.statementExpressionOperation);
            annotationReference.getExplicitValues().add((Object)annotationStatement);
        }
        target.getAnnotations().add((Object)annotationReference);
    }

    @Override
    public void appendInlineAnnotation(JvmAnnotationTarget target, XtendExecutable source) {
        ImportManager imports = new ImportManager();
        InlineAnnotationTreeAppendable result = this.newAppendable(imports);
        this.generate(source.getExpression(), null, source, result);
        String content = result.getContent();
        if (!Strings.isEmpty((String)content)) {
            List importedTypes = imports.getImports();
            JvmTypeReference[] importArray = new JvmTypeReference[importedTypes.size()];
            for (int i = 0; i < importArray.length; ++i) {
                importArray[i] = this.typeReferences.getTypeForName((String)importedTypes.get(i), (Notifier)source, new JvmTypeReference[0]);
            }
            this.appendInlineAnnotation(target, source.eResource().getResourceSet(), content, result.isConstant(), result.isStatement(), importArray);
        }
    }

    protected boolean generate(XExpression expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        XExpression realExpression = JavaInlineExpressionCompiler.filterSingleOperation(expression);
        if (realExpression != null) {
            Boolean res;
            GeneratorConfig2 config = this.configProvider.get((EObject)feature);
            if (config.isUseExpressionInterpreterForInlineAnnotation() && feature instanceof XtendFunction) {
                XtendFunction function = (XtendFunction)feature;
                try {
                    Boolean res2;
                    Object evaluationResult = this.expressionInterpreter.evaluate(realExpression, this.getFunctionTypeReference(function));
                    if (evaluationResult != null && (res2 = (Boolean)this.generateDispatcher.invoke(new Object[]{evaluationResult, parentExpression, feature, output})) != null && res2 == Boolean.TRUE) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (res = (Boolean)this.generateDispatcher.invoke(new Object[]{realExpression, parentExpression, feature, output})) != null && res != false;
        }
        return false;
    }

    protected Boolean _generate(CharSequence expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        output.appendStringConstant(expression.toString());
        return Boolean.TRUE;
    }

    protected Boolean _generate(JvmTypeReference expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        output.appendTypeConstant(expression.getType());
        return Boolean.TRUE;
    }

    protected Boolean _generate(Number expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        Class type = ReflectionUtil.getRawType(expression.getClass());
        if (Byte.class.equals((Object)type) || Byte.TYPE.equals(type)) {
            output.appendConstant("(byte) (" + expression.toString() + ")");
        } else if (Short.class.equals((Object)type) || Short.TYPE.equals(type)) {
            output.appendConstant("(short) (" + expression.toString() + ")");
        } else if (Float.class.equals((Object)type) || Float.TYPE.equals(type)) {
            output.appendConstant(expression.toString() + "f");
        } else {
            output.appendConstant(expression.toString());
        }
        return Boolean.TRUE;
    }

    protected Boolean _generate(XBooleanLiteral expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        output.appendConstant(Boolean.toString(expression.isIsTrue()));
        return Boolean.TRUE;
    }

    protected Boolean _generate(XNullLiteral expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        if (parentExpression == null && feature instanceof XtendFunction) {
            XtendFunction function = (XtendFunction)feature;
            output.append("(");
            JvmTypeReference reference = this.getFunctionTypeReference(function);
            if (reference != null) {
                JvmType type = reference.getType();
                if (type != null) {
                    output.append(type);
                } else {
                    output.append(Object.class);
                }
            } else {
                output.append(Object.class);
            }
            output.append(")");
            output.append(Objects.toString(null));
            output.setConstant(true);
        } else {
            output.appendConstant(Objects.toString(null));
        }
        return Boolean.TRUE;
    }

    protected Boolean _generate(XNumberLiteral expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        output.appendConstant(expression.getValue());
        return Boolean.TRUE;
    }

    protected Boolean _generate(XStringLiteral expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        output.appendStringConstant(expression.getValue());
        return Boolean.TRUE;
    }

    protected Boolean _generate(XTypeLiteral expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        output.appendTypeConstant(expression.getType());
        return Boolean.TRUE;
    }

    protected Boolean _generate(XCastedExpression expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        InlineAnnotationTreeAppendable child = this.newAppendable(output.getImportManager());
        boolean bool = this.generate(expression.getTarget(), (XExpression)expression, feature, child);
        String childContent = child.getContent();
        if (!Strings.isEmpty((String)childContent)) {
            output.append("(");
            output.append(expression.getType().getType());
            output.append(")");
            output.append(childContent);
            output.setConstant(child.isConstant());
            bool = true;
        }
        return bool;
    }

    protected Boolean _generate(XInstanceOfExpression expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        InlineAnnotationTreeAppendable child = this.newAppendable(output.getImportManager());
        boolean bool = this.generate(expression.getExpression(), (XExpression)expression, feature, child);
        String childContent = child.getContent();
        if (!Strings.isEmpty((String)childContent)) {
            output.append("(");
            output.append(childContent);
            output.append(") instanceof ");
            output.append(expression.getType().getType());
            output.setConstant(child.isConstant());
            bool = true;
        }
        return bool;
    }

    protected Boolean _generate(XReturnExpression expression, XExpression parentExpression, XtendExecutable feature, InlineAnnotationTreeAppendable output) {
        return this.generate(expression.getExpression(), parentExpression, feature, output);
    }

    protected static class InlineAnnotationTreeAppendable
    extends FakeTreeAppendable {
        private boolean isConstant;
        private boolean isStatement;

        public InlineAnnotationTreeAppendable(ImportManager imports) {
            super(imports);
        }

        public ImportManager getImportManager() {
            return super.getImportManager();
        }

        public boolean isConstant() {
            return this.isConstant;
        }

        public boolean isStatement() {
            return this.isStatement;
        }

        public void setConstant(boolean isConstant) {
            this.isConstant = isConstant;
        }

        public void setStatement(boolean isStatement) {
            this.isStatement = isStatement;
        }

        public void appendConstant(String constant) {
            this.append(constant);
            this.isConstant = true;
        }

        public void appendTypeConstant(JvmType type) {
            this.append(type);
            this.append(".class");
            this.setConstant(true);
        }

        public void appendStringConstant(String stringValue) {
            this.appendConstant("\"" + Strings.convertToJavaString((String)stringValue) + "\"");
        }
    }

    public record AnnotationInformation(JvmOperation valueOperation, JvmOperation importedOperation, JvmOperation constantExpressionOperation, JvmOperation statementExpressionOperation) {
        static AnnotationInformation build(JvmAnnotationReference annotationReference) {
            JvmOperation value = null;
            JvmOperation imported = null;
            JvmOperation constant = null;
            JvmOperation statement = null;
            Iterator operationIterator = annotationReference.getAnnotation().getDeclaredOperations().iterator();
            while ((value == null || imported == null || constant == null || statement == null) && operationIterator.hasNext()) {
                JvmOperation annotationOperation = (JvmOperation)operationIterator.next();
                if (annotationOperation.getSimpleName().equals("value")) {
                    value = annotationOperation;
                    continue;
                }
                if (annotationOperation.getSimpleName().equals("imported")) {
                    imported = annotationOperation;
                    continue;
                }
                if (annotationOperation.getSimpleName().equals("constantExpression")) {
                    constant = annotationOperation;
                    continue;
                }
                if (!annotationOperation.getSimpleName().equals("statementExpression")) continue;
                statement = annotationOperation;
            }
            assert (value != null);
            assert (imported != null);
            assert (constant != null);
            assert (statement != null);
            return new AnnotationInformation(value, imported, constant, statement);
        }
    }
}

