/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.GeneratorConfigProvider;

public class SARLGeneratorConfigProvider
extends GeneratorConfigProvider {
    @Inject
    @Named(value="languageName")
    private String languageId;
    private JavaVersion defaultVersion;

    public GeneratorConfig get(EObject context) {
        GeneratorConfigProvider.GeneratorConfigAdapter adapter;
        ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)context);
        if (resourceSet != null && (adapter = GeneratorConfigProvider.GeneratorConfigAdapter.findInEmfObject((Notifier)resourceSet)) != null && adapter.getLanguage2GeneratorConfig().containsKey(this.languageId)) {
            return (GeneratorConfig)adapter.getLanguage2GeneratorConfig().get(this.languageId);
        }
        GeneratorConfig config = this.createDefaultGeneratorConfig();
        return config;
    }

    protected GeneratorConfig createDefaultGeneratorConfig() {
        GeneratorConfig config = new GeneratorConfig();
        if (this.defaultVersion == null) {
            this.defaultVersion = JavaVersion.fromQualifier((String)System.getProperty("java.specification.version"));
            if (this.defaultVersion != null) {
                config.setJavaSourceVersion(this.defaultVersion);
            }
        } else {
            config.setJavaSourceVersion(this.defaultVersion);
        }
        return config;
    }
}

