/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler;

import com.google.inject.Inject;
import io.sarl.lang.compiler.IResourceTypeDetector;
import io.sarl.lang.typesystem.IOperationHelper;
import io.sarl.lang.util.Utils;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.compiler.XtendGenerator;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DisableCodeGenerationAdapter;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Pure;

public class SARLJvmGenerator
extends XtendGenerator {
    @Inject
    private IOperationHelper operationHelper;
    @Inject
    private AnnotationLookup annotations;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private IResourceTypeDetector resourceTypeDetector;

    protected ITreeAppendable _generateMember(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        if (Utils.isStaticConstructorName(it.getSimpleName())) {
            return this.generateStaticConstructor(it, appendable, config);
        }
        appendable.newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((Iterable)it.getAnnotations(), tracedAppendable, true, config);
        if (this.operationHelper.isPureOperation(it) && this.annotations.findAnnotation((JvmAnnotationTarget)it, Pure.class) == null) {
            tracedAppendable.append((CharSequence)"@").append(Pure.class).newLine();
        }
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, tracedAppendable, config);
        if (it.getReturnType() == null) {
            tracedAppendable.append((CharSequence)"void");
        } else {
            this._errorSafeExtensions.serializeSafely(it.getReturnType(), Object.class.getSimpleName(), tracedAppendable);
        }
        tracedAppendable.append((CharSequence)" ");
        this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it).append((CharSequence)this.makeJavaIdentifier(it.getSimpleName()));
        tracedAppendable.append((CharSequence)"(");
        this.generateParameters((JvmExecutable)it, tracedAppendable, config);
        tracedAppendable.append((CharSequence)")");
        this.generateThrowsClause((JvmExecutable)it, tracedAppendable, config);
        if (it.isAbstract() || !this.hasBody((JvmExecutable)it)) {
            tracedAppendable.append((CharSequence)";");
        } else {
            tracedAppendable.append((CharSequence)" ");
            this.generateExecutableBody((JvmExecutable)it, tracedAppendable, config);
        }
        appendable.closeScope();
        return appendable;
    }

    protected ITreeAppendable generateStaticConstructor(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        appendable.newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        tracedAppendable.append((CharSequence)"static ");
        this.generateExecutableBody((JvmExecutable)it, tracedAppendable, config);
        return appendable;
    }

    protected void _internalDoGenerate(JvmDeclaredType type, IFileSystemAccess fsa) {
        if (DisableCodeGenerationAdapter.isDisabled((JvmDeclaredType)type)) {
            return;
        }
        String qn = type.getQualifiedName();
        if (!Strings.isEmpty((String)qn)) {
            CharSequence content = this.generateType(type, this.generatorConfigProvider.get((EObject)type));
            Boolean isTest = this.resourceTypeDetector.isTestResource(type.eResource());
            String outputConfigurationName = isTest != null && isTest != false ? "DEFAULT_TEST_OUTPUT" : "DEFAULT_OUTPUT";
            String fn = qn.replace('.', '/') + ".java";
            fsa.generateFile(fn, outputConfigurationName, content);
        }
    }

    protected ImportManager createImportManager(JvmDeclaredType type) {
        return new NoDefaultPackageImportManager(type);
    }

    public static class NoDefaultPackageImportManager
    extends ImportManager {
        private static final String PACKAGE_SEPARATOR = ".";

        public NoDefaultPackageImportManager(JvmDeclaredType type) {
            super(true, type);
        }

        public List<String> getImports() {
            return super.getImports().stream().filter(it -> NoDefaultPackageImportManager.isPackaged(it)).collect(Collectors.toList());
        }

        private static boolean isPackaged(String name) {
            return name.contains(PACKAGE_SEPARATOR);
        }
    }
}

