/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.sarl.lang.controlflow.ISarlEarlyExitComputer;
import io.sarl.lang.core.util.SerializableProxy;
import io.sarl.lang.jvmmodel.Messages;
import io.sarl.lang.sarl.SarlAssertExpression;
import io.sarl.lang.sarl.SarlBreakExpression;
import io.sarl.lang.sarl.SarlCastedExpression;
import io.sarl.lang.sarl.SarlContinueExpression;
import io.sarl.lang.typesystem.SARLExpressionHelper;
import io.sarl.lang.util.ContextAwareTreeAppendable;
import io.sarl.lang.util.Utils;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.compiler.XtendCompiler;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmByteAnnotationValue;
import org.eclipse.xtext.common.types.JvmCharAnnotationValue;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDoubleAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFloatAnnotationValue;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmLongAnnotationValue;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmShortAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

public class SarlCompiler
extends XtendCompiler {
    private static final String INLINE_VARIABLE_PREFIX = "$";
    private static final String INLINE_VALUE_NAME = "value";
    private static final String INLINE_IMPORTED_NAME = "imported";
    private static final String SERIALIZABLE_CLOSURE_LOCAL_REFERENCES = "serializableClosure.localReferences";
    private static final Pattern INLINE_VARIABLE_PATTERN = Pattern.compile("\\$((?:\\$)|(?:\\-?[0-9]+))");
    @Inject
    private Logger log;
    @Inject
    private XExpressionHelper expressionHelper;
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    @Inject
    private SARLExpressionHelper sarlExpressionHelper;
    @Inject
    private ISarlEarlyExitComputer earlyExit;
    @Inject
    private IdentifiableSimpleNameProvider featureNameProvider;
    private volatile boolean isOnJavaEarlyExit;
    @Inject
    private ReflectExtensions reflect;

    private static String getAnnotationStringValue(JvmAnnotationValue value) {
        JvmCustomAnnotationValue cvalue;
        if (value instanceof JvmAnnotationAnnotationValue) {
            JvmAnnotationAnnotationValue cvalue2 = (JvmAnnotationAnnotationValue)value;
            return ((JvmAnnotationReference)cvalue2.getValues().get(0)).getAnnotation().getIdentifier();
        }
        if (value instanceof JvmBooleanAnnotationValue) {
            JvmBooleanAnnotationValue cvalue3 = (JvmBooleanAnnotationValue)value;
            return ((Boolean)cvalue3.getValues().get(0)).toString();
        }
        if (value instanceof JvmByteAnnotationValue) {
            JvmByteAnnotationValue cvalue4 = (JvmByteAnnotationValue)value;
            return ((Byte)cvalue4.getValues().get(0)).toString();
        }
        if (value instanceof JvmCharAnnotationValue) {
            JvmCharAnnotationValue cvalue5 = (JvmCharAnnotationValue)value;
            return ((Character)cvalue5.getValues().get(0)).toString();
        }
        if (value instanceof JvmCustomAnnotationValue) {
            cvalue = (JvmCustomAnnotationValue)value;
            EObject evalue = (EObject)cvalue.getValues().get(0);
            if (evalue instanceof XStringLiteral) {
                XStringLiteral cvalue0 = (XStringLiteral)evalue;
                return cvalue0.getValue();
            }
            if (evalue instanceof XNumberLiteral) {
                XNumberLiteral cvalue0 = (XNumberLiteral)evalue;
                return cvalue0.getValue();
            }
            if (evalue instanceof XBooleanLiteral) {
                XBooleanLiteral cvalue0 = (XBooleanLiteral)evalue;
                return Boolean.toString(cvalue0.isIsTrue());
            }
            if (evalue instanceof XTypeLiteral) {
                XTypeLiteral cvalue0 = (XTypeLiteral)evalue;
                return cvalue0.getType().getIdentifier();
            }
        }
        if (value instanceof JvmDoubleAnnotationValue) {
            cvalue = (JvmDoubleAnnotationValue)value;
            return ((Double)cvalue.getValues().get(0)).toString();
        }
        if (value instanceof JvmEnumAnnotationValue) {
            cvalue = (JvmEnumAnnotationValue)value;
            return ((JvmEnumerationLiteral)cvalue.getValues().get(0)).getSimpleName();
        }
        if (value instanceof JvmFloatAnnotationValue) {
            cvalue = (JvmFloatAnnotationValue)value;
            return ((Float)cvalue.getValues().get(0)).toString();
        }
        if (value instanceof JvmIntAnnotationValue) {
            cvalue = (JvmIntAnnotationValue)value;
            return ((Integer)cvalue.getValues().get(0)).toString();
        }
        if (value instanceof JvmLongAnnotationValue) {
            cvalue = (JvmLongAnnotationValue)value;
            return ((Long)cvalue.getValues().get(0)).toString();
        }
        if (value instanceof JvmShortAnnotationValue) {
            cvalue = (JvmShortAnnotationValue)value;
            return ((Short)cvalue.getValues().get(0)).toString();
        }
        if (value instanceof JvmStringAnnotationValue) {
            cvalue = (JvmStringAnnotationValue)value;
            return (String)cvalue.getValues().get(0);
        }
        if (value instanceof JvmTypeAnnotationValue) {
            cvalue = (JvmTypeAnnotationValue)value;
            return ((JvmTypeReference)cvalue.getValues().get(0)).getIdentifier();
        }
        return null;
    }

    private static Collection<JvmTypeReference> getAnnotationTypeValue(JvmAnnotationValue value) {
        if (value instanceof JvmTypeAnnotationValue) {
            JvmTypeAnnotationValue cvalue = (JvmTypeAnnotationValue)value;
            return cvalue.getValues();
        }
        return Collections.emptyList();
    }

    protected synchronized void appendInlineFeatureCall(XAbstractFeatureCall call, ITreeAppendable target) {
        int numberFormalParameters;
        JvmAnnotationReference inlineAnnotation = this.expressionHelper.findInlineAnnotation(call);
        String formatString = null;
        ArrayList importedTypes = Lists.newArrayListWithCapacity((int)2);
        for (JvmAnnotationValue annotationValue : inlineAnnotation.getValues()) {
            String valueName = annotationValue.getValueName();
            if (Strings.isEmpty((String)valueName)) {
                if (!Strings.isEmpty(formatString)) {
                    throw new IllegalStateException();
                }
                formatString = SarlCompiler.getAnnotationStringValue(annotationValue);
                continue;
            }
            if (INLINE_VALUE_NAME.equals(valueName)) {
                if (!Strings.isEmpty((String)formatString)) {
                    throw new IllegalStateException();
                }
                formatString = SarlCompiler.getAnnotationStringValue(annotationValue);
                continue;
            }
            if (!INLINE_IMPORTED_NAME.equals(valueName)) continue;
            importedTypes.addAll(SarlCompiler.getAnnotationTypeValue(annotationValue));
        }
        if (formatString == null) {
            throw new IllegalStateException();
        }
        IResolvedTypes resolvedTypes = this.batchTypeResolver.resolveTypes((EObject)call);
        List arguments = this.getActualArguments(call);
        JvmIdentifiableElement calledFeature = call.getFeature();
        boolean numberVariadicParameter = false;
        JvmFormalParameter formalVariadicParameter = null;
        if (calledFeature instanceof JvmExecutable) {
            JvmExecutable jvmexec = (JvmExecutable)calledFeature;
            numberFormalParameters = jvmexec.getParameters().size();
            if (numberFormalParameters > 0) {
                formalVariadicParameter = (JvmFormalParameter)jvmexec.getParameters().get(numberFormalParameters - 1);
                if (jvmexec.isVarArgs()) {
                    numberVariadicParameter = true;
                }
            }
        } else {
            numberFormalParameters = arguments.size();
        }
        Matcher matcher = INLINE_VARIABLE_PATTERN.matcher(formatString);
        int prevEnd = 0;
        while (matcher.find()) {
            String indexOrDollar;
            int start = matcher.start();
            if (start != prevEnd) {
                target.append((CharSequence)formatString.substring(prevEnd, start));
            }
            if (INLINE_VARIABLE_PREFIX.equals(indexOrDollar = matcher.group(1))) {
                target.append((CharSequence)INLINE_VARIABLE_PREFIX);
            } else {
                int index = Integer.parseInt(indexOrDollar) - 1;
                if (index < 0) {
                    boolean hasReceiver = this.appendReceiver(call, target, true);
                    if (hasReceiver && index != -2) {
                        target.append((CharSequence)".");
                    }
                } else {
                    int numberImports = importedTypes.size();
                    int numberFormalParametersImports = numberFormalParameters + numberImports;
                    if (numberVariadicParameter && index < arguments.size() && index == numberFormalParameters - 1) {
                        argument = (XExpression)arguments.get(index);
                        this.appendArgument(argument, target, index > 0);
                        for (int i = index + 1; i < arguments.size(); ++i) {
                            target.append((CharSequence)", ");
                            argument = (XExpression)arguments.get(i);
                            this.appendArgument(argument, target, true);
                        }
                    } else if (index > numberFormalParametersImports) {
                        List typeArguments = resolvedTypes.getActualTypeArguments((XExpression)call);
                        LightweightTypeReference typeArgument = (LightweightTypeReference)typeArguments.get(index - numberFormalParametersImports - 1);
                        this.serialize(typeArgument.getRawTypeReference().toTypeReference(), (EObject)call, target);
                    } else if (index >= numberFormalParameters && index < numberFormalParametersImports) {
                        this.serialize((JvmTypeReference)importedTypes.get(index - numberFormalParameters), (EObject)call, target);
                    } else if (index == numberFormalParametersImports) {
                        this.appendTypeArguments(call, target);
                    } else if (index < arguments.size()) {
                        argument = (XExpression)arguments.get(index);
                        this.appendArgument(argument, target, index > 0);
                    } else if (formalVariadicParameter != null) {
                        this.appendNullValue(formalVariadicParameter.getParameterType(), (EObject)calledFeature, target);
                    } else {
                        throw new IllegalStateException();
                    }
                }
            }
            prevEnd = matcher.end();
        }
        if (prevEnd != formatString.length()) {
            target.append((CharSequence)formatString.substring(prevEnd));
        }
    }

    private void appendInlineFeatureCallForCastedExpression(JvmAnnotationReference inlineAnnotation, JvmIdentifiableElement calledFeature, XExpression receiver, List<XExpression> arguments, EObject context, ITreeAppendable appendable) {
        int numberFormalParameters;
        String formatString = null;
        ArrayList importedTypes = Lists.newArrayListWithCapacity((int)2);
        for (JvmAnnotationValue annotationValue : inlineAnnotation.getValues()) {
            String valueName = annotationValue.getValueName();
            if (Strings.isEmpty((String)valueName)) {
                if (!Strings.isEmpty(formatString)) {
                    throw new IllegalStateException();
                }
                formatString = SarlCompiler.getAnnotationStringValue(annotationValue);
                continue;
            }
            if (INLINE_VALUE_NAME.equals(valueName)) {
                if (!Strings.isEmpty((String)formatString)) {
                    throw new IllegalStateException();
                }
                formatString = SarlCompiler.getAnnotationStringValue(annotationValue);
                continue;
            }
            if (!INLINE_IMPORTED_NAME.equals(valueName)) continue;
            importedTypes.addAll(SarlCompiler.getAnnotationTypeValue(annotationValue));
        }
        if (formatString == null) {
            throw new IllegalStateException();
        }
        boolean numberVariadicParameter = false;
        JvmFormalParameter formalVariadicParameter = null;
        if (calledFeature instanceof JvmExecutable) {
            JvmExecutable jvmexec = (JvmExecutable)calledFeature;
            numberFormalParameters = jvmexec.getParameters().size();
            if (numberFormalParameters > 0) {
                formalVariadicParameter = (JvmFormalParameter)jvmexec.getParameters().get(numberFormalParameters - 1);
                if (jvmexec.isVarArgs()) {
                    numberVariadicParameter = true;
                }
            }
        } else {
            numberFormalParameters = arguments.size();
        }
        Matcher matcher = INLINE_VARIABLE_PATTERN.matcher(formatString);
        int prevEnd = 0;
        while (matcher.find()) {
            String indexOrDollar;
            int start = matcher.start();
            if (start != prevEnd) {
                appendable.append((CharSequence)formatString.substring(prevEnd, start));
            }
            if (INLINE_VARIABLE_PREFIX.equals(indexOrDollar = matcher.group(1))) {
                appendable.append((CharSequence)INLINE_VARIABLE_PREFIX);
            } else {
                int index = Integer.parseInt(indexOrDollar) - 1;
                if (index < 0) {
                    boolean hasReceiver = true;
                    if (receiver != null) {
                        String referenceName;
                        XAbstractFeatureCall cvalue;
                        this.internalToJavaExpression(receiver, appendable);
                        if (receiver instanceof XAbstractFeatureCall && (cvalue = (XAbstractFeatureCall)receiver).getFeature() instanceof JvmType && (referenceName = this.getReferenceName(receiver, appendable)) != null && referenceName.length() == 0) {
                            hasReceiver = false;
                        }
                    } else {
                        hasReceiver = false;
                    }
                    if (hasReceiver) {
                        appendable.append((CharSequence)".");
                    }
                } else {
                    int numberImports = importedTypes.size();
                    int numberFormalParametersImports = numberFormalParameters + numberImports;
                    if (numberVariadicParameter && index < arguments.size() && index == numberFormalParameters - 1) {
                        argument = arguments.get(index);
                        this.appendArgument(argument, appendable, index > 0);
                        for (int i = index + 1; i < arguments.size(); ++i) {
                            appendable.append((CharSequence)", ");
                            argument = arguments.get(i);
                            this.appendArgument(argument, appendable, true);
                        }
                    } else {
                        if (index > numberFormalParametersImports) {
                            throw new IllegalStateException();
                        }
                        if (index >= numberFormalParameters && index < numberFormalParametersImports) {
                            this.serialize((JvmTypeReference)importedTypes.get(index - numberFormalParameters), context, appendable);
                        } else {
                            if (index == numberFormalParametersImports) {
                                throw new IllegalStateException();
                            }
                            if (index < arguments.size()) {
                                argument = arguments.get(index);
                                this.appendArgument(argument, appendable, index > 0);
                            } else if (formalVariadicParameter != null) {
                                this.appendNullValue(formalVariadicParameter.getParameterType(), (EObject)calledFeature, appendable);
                            } else {
                                throw new IllegalStateException();
                            }
                        }
                    }
                }
            }
            prevEnd = matcher.end();
        }
        if (prevEnd != formatString.length()) {
            appendable.append((CharSequence)formatString.substring(prevEnd));
        }
    }

    public void doInternalToJavaStatement(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        if (obj instanceof SarlBreakExpression) {
            SarlBreakExpression cvalue = (SarlBreakExpression)obj;
            this._toJavaStatement(cvalue, appendable, isReferenced);
        } else if (obj instanceof SarlContinueExpression) {
            SarlContinueExpression cvalue = (SarlContinueExpression)obj;
            this._toJavaStatement(cvalue, appendable, isReferenced);
        } else if (obj instanceof SarlAssertExpression) {
            SarlAssertExpression cvalue = (SarlAssertExpression)obj;
            this._toJavaStatement(cvalue, appendable, isReferenced);
        } else {
            try {
                super.doInternalToJavaStatement(obj, appendable, isReferenced);
            }
            catch (IllegalStateException exception) {
                this.logInternalError(exception);
            }
        }
    }

    public void internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        if (obj instanceof SarlBreakExpression) {
            SarlBreakExpression cvalue = (SarlBreakExpression)obj;
            this._toJavaExpression(cvalue, appendable);
        } else if (obj instanceof SarlContinueExpression) {
            SarlContinueExpression cvalue = (SarlContinueExpression)obj;
            this._toJavaExpression(cvalue, appendable);
        } else if (obj instanceof SarlAssertExpression) {
            SarlAssertExpression cvalue = (SarlAssertExpression)obj;
            this._toJavaExpression(cvalue, appendable);
        } else {
            try {
                super.internalToConvertedExpression(obj, appendable);
            }
            catch (IllegalStateException exception) {
                this.logInternalError(exception);
            }
        }
    }

    protected void _toJavaStatement(SarlBreakExpression breakExpression, ITreeAppendable appendable, boolean isReferenced) {
        appendable.newLine().append((CharSequence)"break;");
    }

    protected void _toJavaStatement(SarlContinueExpression breakExpression, ITreeAppendable appendable, boolean isReferenced) {
        appendable.newLine().append((CharSequence)"continue;");
    }

    protected void _toJavaStatement(XClosure closure, ITreeAppendable appendable, boolean isReferenced) {
        JvmOperation operation;
        LightweightTypeReference type = this.getLightweightType((XExpression)closure);
        if (!this.canCompileToJavaLambda(closure, type, operation = this.findImplementingOperation(type)) && !this.canBeNotStaticAnonymousClass(closure, type, operation)) {
            this.toSerializableAnonymousClassProxyDefinition(closure, appendable, type, operation);
        }
        super._toJavaStatement(closure, appendable, isReferenced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _toJavaStatement(SarlAssertExpression assertExpression, ITreeAppendable appendable, boolean isReferenced) {
        XExpression condition;
        LightweightTypeReference actualType;
        if (!assertExpression.isIsStatic() && assertExpression.getCondition() != null && (actualType = this.getLightweightType(condition = assertExpression.getCondition())) != null) {
            Boolean booleanConstant = this.sarlExpressionHelper.toBooleanPrimitiveWrapperConstant(condition);
            if (booleanConstant != null) {
                appendable.newLine().append((CharSequence)"assert ");
                appendable.append((CharSequence)booleanConstant.toString());
            } else {
                Map<XVariableDeclaration, XFeatureCall> localVariables = this.getReferencedLocalVariable(condition, true);
                String className = appendable.declareUniqueNameVariable((Object)assertExpression, "$AssertEvaluator$");
                appendable.openScope();
                try {
                    this.reassignThisInClosure(appendable, this.findKnownTopLevelType(Object.class, (Notifier)assertExpression));
                    appendable.newLine().append((CharSequence)"class ").append((CharSequence)className).append((CharSequence)" {");
                    appendable.increaseIndentation().newLine();
                    appendable.append((CharSequence)"final boolean $$result;").newLine();
                    appendable.append((CharSequence)className).append((CharSequence)"(");
                    boolean first = true;
                    for (Map.Entry<XVariableDeclaration, XFeatureCall> localVariable : localVariables.entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            appendable.append((CharSequence)", ");
                        }
                        JvmTypeReference localVariableType = this.getType((XExpression)localVariable.getValue());
                        appendable.append((CharSequence)"final ").append(this.toLightweight(localVariableType, (EObject)assertExpression));
                        String referenceName = this.getReferenceName((XExpression)localVariable.getValue(), appendable);
                        if (Strings.isEmpty((String)referenceName)) {
                            referenceName = localVariable.getKey().getName();
                        }
                        appendable.append((CharSequence)" ").append((CharSequence)referenceName);
                    }
                    appendable.append((CharSequence)") {");
                    appendable.increaseIndentation();
                    this.internalToJavaStatement(condition, appendable, true);
                    appendable.newLine();
                    appendable.append((CharSequence)"this.$$result = ");
                    this.internalToConvertedExpression(condition, appendable, actualType);
                    appendable.append((CharSequence)";");
                    appendable.decreaseIndentation().newLine();
                    appendable.append((CharSequence)"}");
                    appendable.decreaseIndentation().newLine();
                    appendable.append((CharSequence)"}");
                    appendable.newLine();
                    appendable.append((CharSequence)"assert new ").append((CharSequence)className).append((CharSequence)"(");
                    first = true;
                    for (Map.Entry<XVariableDeclaration, XFeatureCall> localVariable : localVariables.entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            appendable.append((CharSequence)", ");
                        }
                        String referenceName = this.getReferenceName((XExpression)localVariable.getValue(), appendable);
                        if (Strings.isEmpty((String)referenceName)) {
                            referenceName = localVariable.getKey().getName();
                        }
                        appendable.append((CharSequence)referenceName);
                    }
                    appendable.append((CharSequence)").$$result");
                }
                finally {
                    appendable.closeScope();
                }
            }
            if (!Strings.isEmpty((String)assertExpression.getMessage())) {
                appendable.append((CharSequence)" : \"");
                appendable.append((CharSequence)Strings.convertToJavaString((String)assertExpression.getMessage()));
                appendable.append((CharSequence)"\"");
            }
            appendable.append((CharSequence)";");
        }
    }

    protected void _toJavaStatement(XCastedExpression expr, ITreeAppendable appendable, boolean isReferenced) {
        this.internalToJavaStatement(expr.getTarget(), appendable, isReferenced);
    }

    protected Map<XVariableDeclaration, XFeatureCall> getReferencedLocalVariable(XExpression expression, boolean onlyWritable) {
        TreeMap<XVariableDeclaration, XFeatureCall> localVariables = new TreeMap<XVariableDeclaration, XFeatureCall>((k1, k2) -> k1.getIdentifier().compareTo(k2.getIdentifier()));
        for (XFeatureCall featureCall : EcoreUtil2.getAllContentsOfType((EObject)expression, XFeatureCall.class)) {
            JvmIdentifiableElement jvmIdentifiableElement = featureCall.getFeature();
            if (!(jvmIdentifiableElement instanceof XVariableDeclaration)) continue;
            XVariableDeclaration localVariable = (XVariableDeclaration)jvmIdentifiableElement;
            if (onlyWritable && !localVariable.isWriteable() || localVariables.containsKey(localVariable)) continue;
            localVariables.put(localVariable, featureCall);
        }
        return localVariables;
    }

    protected void _toJavaExpression(SarlBreakExpression breakExpression, ITreeAppendable appendable) {
        appendable.append((CharSequence)"/* error - couldn't compile nested break */");
    }

    protected void _toJavaExpression(SarlContinueExpression breakExpression, ITreeAppendable appendable) {
        appendable.append((CharSequence)"/* error - couldn't compile nested continue */");
    }

    protected void _toJavaExpression(SarlAssertExpression assertExpression, ITreeAppendable appendable) {
        if (!assertExpression.isIsStatic()) {
            appendable.append((CharSequence)"/* error - couldn't compile nested assert */");
        }
    }

    protected void _toJavaExpression(XCastedExpression expr, ITreeAppendable appendable) {
        SarlCastedExpression cast;
        JvmOperation operation;
        XExpression target = expr.getTarget();
        LightweightTypeReference fromType = this.toLightweight(this.getType(target), (EObject)expr);
        LightweightTypeReference toType = this.toLightweight(expr.getType(), (EObject)expr);
        if (expr instanceof SarlCastedExpression && (operation = (cast = (SarlCastedExpression)expr).getFeature()) != null) {
            boolean hasNullInputTest = !fromType.isPrimitive() && !fromType.isPrimitiveVoid() && !SarlCompiler.isLiteral(target);
            XExpression receiver = cast.getReceiver();
            XExpression argument = cast.getArgument();
            if (hasNullInputTest) {
                appendable.append((CharSequence)"(");
                this.internalToConvertedExpression(target, appendable, fromType);
                appendable.append((CharSequence)" == null ? ");
                this.appendDefaultLiteral(appendable, toType);
                appendable.append((CharSequence)" : ");
            }
            Later callGeneration = it -> {
                JvmAnnotationReference inlineAnnotation = this.expressionHelper.findInlineAnnotation((JvmIdentifiableElement)operation);
                if (inlineAnnotation != null) {
                    XExpression concreteReceiver = operation.isStatic() ? null : (operation.getParameters().isEmpty() ? argument : receiver);
                    this.appendInlineFeatureCallForCastedExpression(inlineAnnotation, (JvmIdentifiableElement)operation, concreteReceiver, Collections.singletonList(argument), (EObject)cast, appendable);
                } else {
                    if (operation.isStatic()) {
                        JvmDeclaredType operationContainer = operation.getDeclaringType();
                        JvmParameterizedTypeReference operationContainerType = this.getTypeComputationServices().getTypeReferences().createTypeRef((JvmType)operationContainer, new JvmTypeReference[0]);
                        this.serialize((JvmTypeReference)operationContainerType, (EObject)expr, it);
                        it.append((CharSequence)".");
                    } else if (receiver != null) {
                        LightweightTypeReference receiverType = receiver == target ? fromType : this.toLightweight(this.getType(receiver), (EObject)expr);
                        if (receiverType.isPrimitive() || receiverType.isPrimitiveVoid()) {
                            this.internalToConvertedExpression(receiver, it, receiverType.getWrapperTypeIfPrimitive());
                        } else {
                            this.internalToJavaExpression(receiver, it);
                        }
                        it.append((CharSequence)".");
                    }
                    String name = null;
                    name = it.hasName((Object)operation) ? it.getName((Object)operation) : this.featureNameProvider.getSimpleName((JvmIdentifiableElement)operation);
                    if (name == null) {
                        name = "/* name is null */";
                    }
                    it.trace((EObject)expr, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0).append((CharSequence)name);
                    it.append((CharSequence)"(");
                    if (argument != null) {
                        if (argument == target) {
                            this.internalToConvertedExpression(target, it, fromType);
                        } else {
                            this.appendArgument(argument, it, false);
                        }
                    }
                    it.append((CharSequence)")");
                }
            };
            LightweightTypeReference concreteType = this.toLightweight(operation.getReturnType(), (EObject)expr);
            this.doConversion(toType, concreteType, appendable, (XExpression)expr, callGeneration);
            if (hasNullInputTest) {
                appendable.append((CharSequence)")");
            }
            return;
        }
        if (toType.getType().equals((Object)fromType.getType()) && fromType.isRawType() && !toType.isRawType()) {
            super._toJavaExpression(expr, appendable);
        } else if (toType.isAssignableFrom(fromType)) {
            if (fromType.isAny()) {
                this.doCastConversion(toType, appendable, it -> {
                    ITreeAppendable it1 = it.trace((EObject)expr, true);
                    this.internalToConvertedExpression(target, it1);
                });
            } else {
                IResolvedTypes resolvedTypes = this.getResolvedTypes((EObject)expr);
                boolean refined = resolvedTypes.isRefinedType(target);
                if (refined) {
                    this.doCastConversion(toType, appendable, it -> {
                        ITreeAppendable it1 = it.trace((EObject)expr, true);
                        this.internalToConvertedExpression(target, it1);
                    });
                } else {
                    this.internalToConvertedExpression(target, appendable, toType);
                }
            }
        } else {
            super._toJavaExpression(expr, appendable);
        }
    }

    private static boolean isLiteral(XExpression expr) {
        return expr instanceof XBooleanLiteral || expr instanceof XStringLiteral || expr instanceof XNumberLiteral || expr instanceof XCollectionLiteral || expr instanceof XSetLiteral || expr instanceof XNullLiteral || expr instanceof XTypeLiteral;
    }

    protected void jvmOperationCallToJavaExpression(XExpression sourceObject, JvmOperation operation, XExpression receiver, List<XExpression> arguments, ITreeAppendable appendable) {
        String name = null;
        assert (operation != null);
        name = appendable.hasName((Object)operation) ? appendable.getName((Object)operation) : this.featureNameProvider.getSimpleName((JvmIdentifiableElement)operation);
        if (name == null) {
            name = "/* name is null */";
        }
        if (operation.isStatic()) {
            JvmDeclaredType operationContainer = operation.getDeclaringType();
            JvmIdentifiableElement container = this.getLogicalContainerProvider().getNearestLogicalContainer((EObject)sourceObject);
            JvmType containerType = (JvmType)EcoreUtil2.getContainerOfType((EObject)container, JvmType.class);
            LightweightTypeReference reference = this.newTypeReferenceOwner((EObject)sourceObject).toLightweightTypeReference((JvmType)operationContainer);
            if (!reference.isAssignableFrom(containerType)) {
                appendable.append((JvmType)operationContainer);
                appendable.append((CharSequence)".");
            }
        } else if (receiver != null) {
            this.internalToJavaExpression(receiver, appendable);
            appendable.append((CharSequence)".");
        } else {
            appendable.append((CharSequence)"this.");
        }
        appendable.trace((EObject)sourceObject, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0).append((CharSequence)name);
        appendable.append((CharSequence)"(");
        if (arguments != null && !arguments.isEmpty()) {
            this.appendArguments(arguments, appendable, true);
        }
        appendable.append((CharSequence)")");
    }

    protected boolean internalCanCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        if (expression instanceof SarlBreakExpression) {
            return true;
        }
        if (expression instanceof SarlContinueExpression) {
            return true;
        }
        if (expression instanceof SarlAssertExpression) {
            return true;
        }
        return super.internalCanCompileToJavaExpression(expression, appendable);
    }

    protected boolean isVariableDeclarationRequired(XExpression expression, ITreeAppendable appendable, boolean recursive) {
        String refName = this.getReferenceName(expression, appendable);
        if (!Strings.isEmpty((String)refName)) {
            return false;
        }
        if (expression instanceof SarlBreakExpression) {
            return false;
        }
        if (expression instanceof SarlContinueExpression) {
            return false;
        }
        EObject container = expression.eContainer();
        if (container instanceof SarlAssertExpression) {
            return false;
        }
        return super.isVariableDeclarationRequired(expression, appendable, recursive);
    }

    protected void logInternalError(Throwable exception) {
        if (exception != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, Messages.SARLJvmModelInferrer_0, exception);
        }
    }

    protected boolean isEarlyExit(XExpression expr) {
        if (this.isOnJavaEarlyExit) {
            this.isOnJavaEarlyExit = false;
            return this.earlyExit.isEarlyExitInJava(expr);
        }
        return this.earlyExit.isEarlyExit(expr);
    }

    public ITreeAppendable compile(XExpression expr, ITreeAppendable parentAppendable, LightweightTypeReference expectedReturnType, Set<JvmTypeReference> declaredExceptions) {
        boolean isPrimitiveVoidExpected = expectedReturnType.isPrimitiveVoid();
        if (!isPrimitiveVoidExpected && expr instanceof XBlockExpression) {
            this.isOnJavaEarlyExit = true;
        }
        return super.compile(expr, parentAppendable, expectedReturnType, declaredExceptions);
    }

    private List<XAbstractFeatureCall> getReferencedExternalCalls(XExpression expression, List<JvmFormalParameter> exclusion, boolean enableExpressionNaming, ITreeAppendable appendable) {
        ArrayList<XAbstractFeatureCall> references = new ArrayList<XAbstractFeatureCall>();
        TreeSet<String> identifiers = new TreeSet<String>();
        for (XAbstractFeatureCall featureCall : EcoreUtil2.getAllContentsOfType((EObject)expression, XAbstractFeatureCall.class)) {
            if (!(featureCall instanceof XMemberFeatureCall) && !(featureCall instanceof XFeatureCall)) continue;
            JvmIdentifiableElement feature = featureCall.getFeature();
            XAbstractFeatureCall selected = null;
            boolean forceNaming = false;
            XAbstractFeatureCall root = null;
            JvmOperation operationToTest = null;
            if (feature instanceof JvmFormalParameter) {
                if (!exclusion.contains(feature)) {
                    selected = featureCall;
                    forceNaming = true;
                }
            } else if (feature instanceof XVariableDeclaration) {
                if (!EcoreUtil.isAncestor((EObject)expression, (EObject)feature)) {
                    selected = featureCall;
                    forceNaming = true;
                }
            } else if (feature instanceof JvmField) {
                selected = featureCall;
                forceNaming = true;
            } else if (featureCall instanceof XFeatureCall) {
                XFeatureCall cvalue = (XFeatureCall)featureCall;
                if (this.isReferenceToIt(cvalue)) {
                    if (feature instanceof JvmOperation) {
                        JvmOperation cvalue0;
                        operationToTest = cvalue0 = (JvmOperation)feature;
                    }
                } else {
                    selected = featureCall;
                }
            } else if (featureCall instanceof XMemberFeatureCall && feature instanceof JvmOperation) {
                JvmOperation cvalue;
                operationToTest = cvalue = (JvmOperation)feature;
            }
            if (operationToTest != null && operationToTest.isStatic() && (root = Utils.getRootFeatureCall(featureCall, expression, exclusion)) != null && root != featureCall) {
                selected = featureCall;
            }
            if (selected == null) continue;
            if (root == null) {
                root = Utils.getRootFeatureCall(selected, expression, exclusion);
            }
            if (root == null) continue;
            if (enableExpressionNaming) {
                String refName = this.getReferenceName((XExpression)root, appendable);
                if (!forceNaming || Strings.isEmpty((String)refName)) {
                    String proposedName = INLINE_VARIABLE_PREFIX + this.makeJavaIdentifier(this.getFavoriteVariableName((EObject)root));
                    appendable.declareSyntheticVariable((Object)root, proposedName);
                }
            }
            SarlCompiler.updateReferenceList(references, identifiers, root);
        }
        return references;
    }

    protected boolean isReferenceToIt(XFeatureCall featureCall) {
        assert (featureCall != null);
        if (!featureCall.isTypeLiteral() && !featureCall.isPackageFragment()) {
            XFeatureCall cvalue;
            XExpression expr;
            String itKeyword = IFeatureNames.IT.getFirstSegment();
            Object theFeatureCall = featureCall;
            do {
                String name;
                if (!Strings.equal((String)itKeyword, (String)(name = theFeatureCall.getFeature().getSimpleName()))) continue;
                return true;
            } while ((theFeatureCall = (expr = theFeatureCall.getImplicitReceiver()) instanceof XFeatureCall ? (cvalue = (XFeatureCall)expr) : null) != null);
        }
        return false;
    }

    private static void updateReferenceList(List<XAbstractFeatureCall> references, Set<String> identifiers, XAbstractFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature instanceof JvmFormalParameter || feature instanceof XVariableDeclaration || feature instanceof JvmField) {
            if (identifiers.add(feature.getIdentifier())) {
                references.add(featureCall);
            }
        } else if (!references.contains(featureCall)) {
            references.add(featureCall);
        }
    }

    protected void prepareExpression(XExpression arg, ITreeAppendable appendable) {
        if (arg instanceof XAbstractFeatureCall) {
            XAbstractFeatureCall root;
            ContextAwareTreeAppendable cappendable;
            List localReferences;
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)arg;
            if (appendable instanceof ContextAwareTreeAppendable && (localReferences = (List)(cappendable = (ContextAwareTreeAppendable)appendable).getContextualValue(SERIALIZABLE_CLOSURE_LOCAL_REFERENCES)) != null && localReferences.contains(root = Utils.getRootFeatureCall(featureCall))) {
                return;
            }
        }
        super.prepareExpression(arg, appendable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITreeAppendable toSerializableAnonymousClassProxyDefinition(XClosure closure, ITreeAppendable appendable, LightweightTypeReference type, JvmOperation operation) {
        String implementationType = appendable.declareUniqueNameVariable((Object)type, "$SerializableClosureProxy");
        appendable.newLine().append((CharSequence)"class ");
        appendable.append((CharSequence)implementationType);
        if (type.isInterfaceType()) {
            appendable.append((CharSequence)" implements ");
        } else {
            appendable.append((CharSequence)" extends ");
        }
        appendable.append(type);
        appendable.append((CharSequence)" {");
        appendable.increaseIndentation();
        appendable.openPseudoScope();
        try {
            EList closureParams = closure.getFormalParameters();
            List<XAbstractFeatureCall> localReferences = this.getReferencedExternalCalls(closure.getExpression(), (List<JvmFormalParameter>)closureParams, true, appendable);
            try {
                int i;
                appendable.openScope();
                for (XAbstractFeatureCall xAbstractFeatureCall : localReferences) {
                    LightweightTypeReference exprType = this.toLightweight(this.getType((XExpression)xAbstractFeatureCall), (EObject)closure);
                    String paramName = this.getReferenceName((XExpression)xAbstractFeatureCall, appendable);
                    appendable.newLine().newLine().append((CharSequence)"private final ").append(exprType);
                    appendable.append((CharSequence)" ").append((CharSequence)paramName).append((CharSequence)";");
                }
                appendable.newLine().newLine().append((CharSequence)"public ").append((CharSequence)implementationType).append((CharSequence)"(");
                boolean first = true;
                for (XAbstractFeatureCall call : localReferences) {
                    if (first) {
                        first = false;
                    } else {
                        appendable.append((CharSequence)", ");
                    }
                    LightweightTypeReference exprType = this.toLightweight(this.getType((XExpression)call), (EObject)closure);
                    String paramName = this.getReferenceName((XExpression)call, appendable);
                    appendable.append((CharSequence)"final ").append(exprType).append((CharSequence)" ").append((CharSequence)paramName);
                }
                appendable.append((CharSequence)") {").increaseIndentation();
                for (XAbstractFeatureCall call : localReferences) {
                    String varName = this.getReferenceName((XExpression)call, appendable);
                    appendable.newLine().append((CharSequence)"this.").append((CharSequence)varName).append((CharSequence)" = ");
                    appendable.append((CharSequence)varName).append((CharSequence)";");
                }
                appendable.decreaseIndentation().newLine().append((CharSequence)"}").newLine();
                LightweightTypeReference lightweightTypeReference = this.getClosureOperationReturnType(type, operation);
                this.appendOperationVisibility(appendable, operation);
                if (!operation.getTypeParameters().isEmpty()) {
                    this.appendTypeParameters(appendable, operation, type);
                }
                appendable.append(lightweightTypeReference);
                appendable.append((CharSequence)" ").append((CharSequence)operation.getSimpleName());
                appendable.append((CharSequence)"(");
                boolean isVarArgs = operation.isVarArgs();
                for (i = 0; i < closureParams.size(); ++i) {
                    JvmFormalParameter closureParam = (JvmFormalParameter)closureParams.get(i);
                    LightweightTypeReference parameterType = this.getClosureOperationParameterType(type, operation, i);
                    if (isVarArgs && i == closureParams.size() - 1 && parameterType.isArray()) {
                        this.appendClosureParameterVarArgs(closureParam, parameterType.getComponentType(), appendable);
                    } else {
                        this.appendClosureParameter(closureParam, parameterType, appendable);
                    }
                    if (i == closureParams.size() - 1) continue;
                    appendable.append((CharSequence)", ");
                }
                appendable.append((CharSequence)")");
                if (!operation.getExceptions().isEmpty()) {
                    appendable.append((CharSequence)" throws ");
                    for (i = 0; i < operation.getExceptions().size(); ++i) {
                        this.serialize((JvmTypeReference)operation.getExceptions().get(i), (EObject)closure, appendable, false, false, false, false);
                        if (i == operation.getExceptions().size() - 1) continue;
                        appendable.append((CharSequence)", ");
                    }
                }
                appendable.append((CharSequence)" {");
                appendable.increaseIndentation();
                this.reassignThisInClosure(appendable, null);
                ContextAwareTreeAppendable contextAppendable = new ContextAwareTreeAppendable(appendable);
                contextAppendable.defineContextualValue(SERIALIZABLE_CLOSURE_LOCAL_REFERENCES, localReferences);
                this.compile(closure.getExpression(), contextAppendable, lightweightTypeReference, Sets.newHashSet((Iterable)operation.getExceptions()));
                this.closeBlock(appendable);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            finally {
                appendable.closeScope();
            }
            appendable.decreaseIndentation().newLine().append((CharSequence)"}");
        }
        finally {
            appendable.closeScope();
        }
        return appendable;
    }

    protected ITreeAppendable toAnonymousClass(XClosure closure, ITreeAppendable appendable, LightweightTypeReference type, JvmOperation operation) {
        if (this.canBeNotStaticAnonymousClass(closure, type, operation) || Strings.isEmpty((String)this.getVarName(type, appendable))) {
            return super.toAnonymousClass(closure, appendable, type, operation);
        }
        return this.toSerializableAnonymousClass(closure, appendable, type, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITreeAppendable toSerializableAnonymousClass(XClosure closure, ITreeAppendable appendable, LightweightTypeReference type, JvmOperation operation) {
        EList closureParams = closure.getFormalParameters();
        appendable.openPseudoScope();
        try {
            List<XAbstractFeatureCall> localReferences = this.getReferencedExternalCalls(closure.getExpression(), (List<JvmFormalParameter>)closureParams, false, appendable);
            LightweightTypeReference returnType = this.getClosureOperationReturnType(type, operation);
            appendable.append((CharSequence)"new ").append(type).append((CharSequence)"() {");
            appendable.increaseIndentation();
            String selfVariable = null;
            try {
                int i;
                appendable.openScope();
                if (this.needSyntheticSelfVariable(closure, type)) {
                    appendable.newLine().append((CharSequence)"final ");
                    appendable.append(type).append((CharSequence)" ");
                    selfVariable = appendable.declareVariable((Object)type.getType(), "_self");
                    appendable.append((CharSequence)selfVariable);
                    appendable.append((CharSequence)" = this;");
                }
                this.appendOperationVisibility(appendable, operation);
                if (!operation.getTypeParameters().isEmpty()) {
                    this.appendTypeParameters(appendable, operation, type);
                }
                appendable.append(returnType);
                appendable.append((CharSequence)" ").append((CharSequence)operation.getSimpleName());
                appendable.append((CharSequence)"(");
                boolean isVarArgs = operation.isVarArgs();
                for (i = 0; i < closureParams.size(); ++i) {
                    JvmFormalParameter closureParam = (JvmFormalParameter)closureParams.get(i);
                    LightweightTypeReference parameterType = this.getClosureOperationParameterType(type, operation, i);
                    if (isVarArgs && i == closureParams.size() - 1 && parameterType.isArray()) {
                        this.appendClosureParameterVarArgs(closureParam, parameterType.getComponentType(), appendable);
                    } else {
                        this.appendClosureParameter(closureParam, parameterType, appendable);
                    }
                    if (i == closureParams.size() - 1) continue;
                    appendable.append((CharSequence)", ");
                }
                appendable.append((CharSequence)")");
                if (!operation.getExceptions().isEmpty()) {
                    appendable.append((CharSequence)" throws ");
                    for (i = 0; i < operation.getExceptions().size(); ++i) {
                        this.serialize((JvmTypeReference)operation.getExceptions().get(i), (EObject)closure, appendable, false, false, false, false);
                        if (i == operation.getExceptions().size() - 1) continue;
                        appendable.append((CharSequence)", ");
                    }
                }
                appendable.append((CharSequence)" {");
                appendable.increaseIndentation();
                if (selfVariable == null) {
                    this.reassignThisInClosure(appendable, type.getType());
                } else {
                    this.reassignThisInClosure(appendable, null);
                }
                this.compile(closure.getExpression(), appendable, returnType, Sets.newHashSet((Iterable)operation.getExceptions()));
                this.closeBlock(appendable);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            finally {
                appendable.closeScope();
            }
            appendable.newLine().append((CharSequence)"private ").append(Object.class).append((CharSequence)" writeReplace() throws ");
            appendable.append(ObjectStreamException.class).append((CharSequence)" {").increaseIndentation().newLine();
            if (selfVariable == null) {
                this.reassignThisInClosure(appendable, type.getType());
            } else {
                this.reassignThisInClosure(appendable, null);
            }
            appendable.append((CharSequence)"return new ").append(SerializableProxy.class);
            appendable.append((CharSequence)"(").append((CharSequence)appendable.getName((Object)type)).append((CharSequence)".class");
            for (XAbstractFeatureCall call : localReferences) {
                appendable.append((CharSequence)", ");
                this.compileAsJavaExpression((XExpression)call, appendable, returnType);
            }
            appendable.append((CharSequence)");").decreaseIndentation().newLine().append((CharSequence)"}");
            appendable.decreaseIndentation().newLine().append((CharSequence)"}");
        }
        finally {
            appendable.closeScope();
        }
        return appendable;
    }

    protected boolean canBeNotStaticAnonymousClass(XClosure closure, LightweightTypeReference typeRef, JvmOperation operation) {
        return !typeRef.isSubtypeOf(Serializable.class);
    }

    protected boolean canCompileToJavaLambda(XClosure closure, LightweightTypeReference typeRef, JvmOperation operation) {
        return !typeRef.isSubtypeOf(Serializable.class) && super.canCompileToJavaLambda(closure, typeRef, operation);
    }

    protected void doConversion(LightweightTypeReference left, LightweightTypeReference right, ITreeAppendable appendable, XExpression context, Later expression) {
        if (left.isPrimitive() && !right.isPrimitive()) {
            if (right.isAny()) {
                this.convertNullSafeWrapperToPrimitive(left, left, context, appendable, expression);
            } else {
                this.convertNullSafeWrapperToPrimitive(right, right.getPrimitiveIfWrapperType(), context, appendable, expression);
            }
            return;
        }
        super.doConversion(left, right, appendable, context, expression);
    }

    private void convertNullSafeWrapperToPrimitive(LightweightTypeReference wrapper, LightweightTypeReference primitive, XExpression context, ITreeAppendable appendable, Later expression) {
        boolean mustInsertTypeCast;
        String defaultValue = primitive.isType(Boolean.TYPE) ? "false" : "0";
        XExpression normalized = this.normalizeBlockExpression(context);
        if (normalized instanceof XAbstractFeatureCall) {
            JvmOperation cvalue;
            JvmIdentifiableElement feature;
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)normalized;
            if (!(context.eContainer() instanceof XAbstractFeatureCall) && featureCall.isStatic() && (feature = featureCall.getFeature()) instanceof JvmOperation && !(cvalue = (JvmOperation)feature).getTypeParameters().isEmpty()) {
                appendable.append((CharSequence)"((");
                expression.exec(appendable);
                appendable.append((CharSequence)") == null ? ");
                appendable.append((CharSequence)defaultValue);
                appendable.append((CharSequence)" : ");
                appendable.append((CharSequence)"(");
                appendable.append(primitive);
                appendable.append((CharSequence)") ");
                expression.exec(appendable);
                appendable.append((CharSequence)") ");
                return;
            }
        }
        appendable.append((CharSequence)"((");
        expression.exec(appendable);
        appendable.append((CharSequence)") == null ? ");
        appendable.append((CharSequence)defaultValue);
        appendable.append((CharSequence)" : ");
        try {
            mustInsertTypeCast = (Boolean)this.reflect.invoke((Object)this, "mustInsertTypeCast", new Object[]{context, wrapper});
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        if (mustInsertTypeCast) {
            appendable.append((CharSequence)"(");
            appendable.append(wrapper);
            appendable.append((CharSequence)") ");
        }
        appendable.append((CharSequence)"(");
        expression.exec(appendable);
        appendable.append((CharSequence)")");
        appendable.append((CharSequence)".");
        appendable.append(primitive);
        appendable.append((CharSequence)"Value())");
    }
}

